/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { useCallback, useContext } from 'react';
import { i18n } from '@kbn/i18n';
import { EuiButtonIcon } from '@elastic/eui';
import { ValueMaxIcon } from '../assets/value_max';
import { ValueMinIcon } from '../assets/value_min';
import { isLastItem } from './utils';
import { TooltipWrapper } from '../tooltip_wrapper';
import { ColorRangesContext } from './color_ranges_context';
import { jsx as ___EmotionJSX } from "@emotion/react";

var switchContinuity = function switchContinuity(isLast, continuity) {
  switch (continuity) {
    case 'none':
      return isLast ? 'above' : 'below';

    case 'above':
      return isLast ? 'none' : 'all';

    case 'below':
      return isLast ? 'all' : 'none';

    case 'all':
      return isLast ? 'below' : 'above';
  }
};

export function ColorRangeDeleteButton(_ref) {
  var index = _ref.index,
      dispatch = _ref.dispatch;

  var _useContext = useContext(ColorRangesContext),
      dataBounds = _useContext.dataBounds,
      palettes = _useContext.palettes;

  var onExecuteAction = useCallback(function () {
    dispatch({
      type: 'deleteColorRange',
      payload: {
        index: index,
        dataBounds: dataBounds,
        palettes: palettes
      }
    });
  }, [dispatch, index, dataBounds, palettes]);
  var title = i18n.translate('coloring.dynamicColoring.customPalette.deleteButtonAriaLabel', {
    defaultMessage: 'Delete'
  });
  return ___EmotionJSX(EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    "aria-label": title,
    title: title,
    onClick: onExecuteAction,
    "data-test-subj": "lnsPalettePanel_dynamicColoring_removeColorRange_".concat(index)
  });
}
export function ColorRangeEditButton(_ref2) {
  var index = _ref2.index,
      continuity = _ref2.continuity,
      dispatch = _ref2.dispatch,
      accessor = _ref2.accessor;

  var _useContext2 = useContext(ColorRangesContext),
      dataBounds = _useContext2.dataBounds,
      palettes = _useContext2.palettes,
      disableSwitchingContinuity = _useContext2.disableSwitchingContinuity;

  var isLast = isLastItem(accessor);
  var onExecuteAction = useCallback(function () {
    var newContinuity = switchContinuity(isLast, continuity);
    dispatch({
      type: 'updateContinuity',
      payload: {
        isLast: isLast,
        continuity: newContinuity,
        dataBounds: dataBounds,
        palettes: palettes
      }
    });
  }, [isLast, dispatch, continuity, dataBounds, palettes]);
  var tooltipContent = isLast ? i18n.translate('coloring.dynamicColoring.customPalette.setCustomMinValue', {
    defaultMessage: "Set custom maximum value"
  }) : i18n.translate('coloring.dynamicColoring.customPalette.setCustomMaxValue', {
    defaultMessage: "Set custom minimum value"
  });

  if (disableSwitchingContinuity) {
    tooltipContent = i18n.translate('coloring.dynamicColoring.customPalette.disallowedEditMinMaxValues', {
      defaultMessage: "You cannot set custom value for current configuration"
    });
  }

  return ___EmotionJSX(TooltipWrapper, {
    tooltipContent: tooltipContent,
    condition: true,
    position: "top",
    delay: "regular"
  }, ___EmotionJSX(EuiButtonIcon, {
    iconType: "pencil",
    "aria-label": tooltipContent,
    disabled: disableSwitchingContinuity,
    onClick: onExecuteAction,
    "data-test-subj": "lnsPalettePanel_dynamicColoring_editValue_".concat(index)
  }));
}
export function ColorRangeAutoDetectButton(_ref3) {
  var continuity = _ref3.continuity,
      dispatch = _ref3.dispatch,
      accessor = _ref3.accessor;

  var _useContext3 = useContext(ColorRangesContext),
      dataBounds = _useContext3.dataBounds,
      palettes = _useContext3.palettes;

  var isLast = isLastItem(accessor);
  var onExecuteAction = useCallback(function () {
    var newContinuity = switchContinuity(isLast, continuity);
    dispatch({
      type: 'updateContinuity',
      payload: {
        isLast: isLast,
        continuity: newContinuity,
        dataBounds: dataBounds,
        palettes: palettes
      }
    });
  }, [continuity, dataBounds, dispatch, isLast, palettes]);
  var tooltipContent = isLast ? i18n.translate('coloring.dynamicColoring.customPalette.useAutoMaxValue', {
    defaultMessage: "Use maximum data value"
  }) : i18n.translate('coloring.dynamicColoring.customPalette.useAutoMinValue', {
    defaultMessage: "Use minimum data value"
  });
  return ___EmotionJSX(TooltipWrapper, {
    tooltipContent: tooltipContent,
    condition: true,
    position: "top",
    delay: "regular"
  }, ___EmotionJSX(EuiButtonIcon, {
    iconType: isLast ? ValueMaxIcon : ValueMinIcon,
    "aria-label": tooltipContent,
    onClick: onExecuteAction,
    "data-test-subj": "lnsPalettePanel_dynamicColoring_autoDetect_".concat(isLast ? 'maximum' : 'minimum')
  }));
}