"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPaletteRegistry = void 0;

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const getPaletteRegistry = () => {
  const mockPalette1 = {
    id: 'default',
    title: 'My Palette',
    getCategoricalColor: jest.fn(_ => 'black'),
    getCategoricalColors: jest.fn(num => ['red', 'black']),
    toExpression: jest.fn(() => ({
      type: 'expression',
      chain: [{
        type: 'function',
        function: 'system_palette',
        arguments: {
          name: ['default']
        }
      }]
    }))
  };
  const mockPalette2 = {
    id: 'mocked',
    title: 'Mocked Palette',
    getCategoricalColor: jest.fn(_ => 'blue'),
    getCategoricalColors: jest.fn(num => ['blue', 'yellow']),
    toExpression: jest.fn(() => ({
      type: 'expression',
      chain: [{
        type: 'function',
        function: 'system_palette',
        arguments: {
          name: ['mocked']
        }
      }]
    }))
  };
  const mockPalette3 = {
    id: 'custom',
    title: 'Custom Mocked Palette',
    getCategoricalColor: jest.fn(_ => 'blue'),
    getCategoricalColors: jest.fn(num => ['blue', 'yellow']),
    getColorForValue: jest.fn((num, state, minMax) => num == null || num < 1 ? undefined : 'blue'),
    canDynamicColoring: true,
    toExpression: jest.fn(() => ({
      type: 'expression',
      chain: [{
        type: 'function',
        function: 'system_palette',
        arguments: {
          name: ['mocked']
        }
      }]
    }))
  };
  return {
    get: name => name === 'custom' ? mockPalette3 : name !== 'default' ? mockPalette2 : mockPalette1,
    getAll: () => [mockPalette1, mockPalette2, mockPalette3]
  };
};

exports.getPaletteRegistry = getPaletteRegistry;