import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Holds the map of the { [shipperName]: shipperInstance }
 */
export var ShippersRegistry = /*#__PURE__*/function () {
  function ShippersRegistry() {
    _classCallCheck(this, ShippersRegistry);

    _defineProperty(this, "allShippers", new Map());

    _defineProperty(this, "globalShippers", new Map());

    _defineProperty(this, "eventTypeExclusiveShippers", new Map());
  }

  _createClass(ShippersRegistry, [{
    key: "addGlobalShipper",
    value:
    /**
     * Adds shipper to the registry.
     * @param shipperName The unique name of the shipper.
     * @param shipper The initialized shipper.
     */
    function addGlobalShipper(shipperName, shipper) {
      if (this.globalShippers.get(shipperName)) {
        throw new Error("Shipper \"".concat(shipperName, "\" is already registered"));
      }

      this.globalShippers.set(shipperName, shipper);
      this.allShippers.set(shipperName, shipper);
    }
    /**
     * Adds an event-type exclusive shipper.
     * @param eventType The name of the event type
     * @param shipperName The unique name for the shipper.
     * @param shipper The initialized shipper.
     */

  }, {
    key: "addEventExclusiveShipper",
    value: function addEventExclusiveShipper(eventType, shipperName, shipper) {
      var eventExclusiveMap = this.eventTypeExclusiveShippers.get(eventType) || new Map();

      if (eventExclusiveMap.get(shipperName)) {
        throw new Error("".concat(shipperName, " is already registered for event-type ").concat(eventType));
      }

      eventExclusiveMap.set(shipperName, shipper);
      this.eventTypeExclusiveShippers.set(eventType, eventExclusiveMap);
      this.allShippers.set(shipperName, shipper);
    }
    /**
     * Returns the shippers that must be used for the specified event type.
     * @param eventType The name of the event type.
     */

  }, {
    key: "getShippersForEventType",
    value: function getShippersForEventType(eventType) {
      return this.eventTypeExclusiveShippers.get(eventType) || this.globalShippers;
    }
  }]);

  return ShippersRegistry;
}();