import _objectSpread from "@babel/runtime/helpers/objectSpread2";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { filter } from 'rxjs';
import { schemaToIoTs, validateSchema } from '../schema/validation';
export var ContextService = /*#__PURE__*/function () {
  function ContextService(context$, isDevMode, logger) {
    _classCallCheck(this, ContextService);

    _defineProperty(this, "contextProvidersRegistry", new Map());

    _defineProperty(this, "contextProvidersSubscriptions", new Map());

    this.context$ = context$;
    this.isDevMode = isDevMode;
    this.logger = logger;
  }
  /**
   * Registers a context provider, and subscribes to any updates from it.
   * @param contextProviderOpts The options to register the context provider {@link ContextProviderOpts}
   */


  _createClass(ContextService, [{
    key: "registerContextProvider",
    value: function registerContextProvider(_ref) {
      var _this = this;

      var name = _ref.name,
          context$ = _ref.context$,
          schema = _ref.schema;

      if (this.contextProvidersSubscriptions.has(name)) {
        throw new Error("Context provider with name '".concat(name, "' already registered"));
      } // Declare the validator only in dev-mode


      var validator = this.isDevMode ? schemaToIoTs(schema) : undefined;
      var subscription = context$.pipe(filter(function (context) {
        if (validator) {
          try {
            validateSchema("Context Provider '".concat(name, "'"), validator, context);
          } catch (validationError) {
            _this.logger.error(validationError);

            return false;
          }
        }

        return true;
      })).subscribe(function (context) {
        // We store each context linked to the context provider so they can increase and reduce
        // the number of fields they report without having left-overs in the global context.
        _this.contextProvidersRegistry.set(name, context); // For every context change, we rebuild the global context.
        // It's better to do it here than to rebuild it for every reportEvent.


        _this.updateGlobalContext();
      });
      this.contextProvidersSubscriptions.set(name, subscription);
    }
    /**
     * Removes the context provider from the registry, unsubscribes from it, and rebuilds the global context.
     * @param name The name of the context provider to remove.
     */

  }, {
    key: "removeContextProvider",
    value: function removeContextProvider(name) {
      var _this$contextProvider;

      (_this$contextProvider = this.contextProvidersSubscriptions.get(name)) === null || _this$contextProvider === void 0 ? void 0 : _this$contextProvider.unsubscribe();
      this.contextProvidersRegistry["delete"](name);
      this.updateGlobalContext();
    }
    /**
     * Loops through all the context providers and sets the global context
     * @private
     */

  }, {
    key: "updateGlobalContext",
    value: function updateGlobalContext() {
      var _this2 = this;

      this.context$.next(_toConsumableArray(this.contextProvidersRegistry.values()).reduce(function (acc, context) {
        return _objectSpread(_objectSpread({}, acc), _this2.removeEmptyValues(context));
      }, {}));
    }
  }, {
    key: "removeEmptyValues",
    value: function removeEmptyValues(context) {
      if (!context) {
        return {};
      }

      return Object.keys(context).reduce(function (acc, key) {
        if (context[key] !== undefined) {
          acc[key] = context[key];
        }

        return acc;
      }, {});
    }
  }]);

  return ContextService;
}();