import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _regeneratorRuntime from "@babel/runtime/regenerator";

function _asyncIterator(iterable) { var method, async, sync, retry = 2; for ("undefined" != typeof Symbol && (async = Symbol.asyncIterator, sync = Symbol.iterator); retry--;) { if (async && null != (method = iterable[async])) return method.call(iterable); if (sync && null != (method = iterable[sync])) return new AsyncFromSyncIterator(method.call(iterable)); async = "@@asyncIterator", sync = "@@iterator"; } throw new TypeError("Object is not async iterable"); }

function AsyncFromSyncIterator(s) { function AsyncFromSyncIteratorContinuation(r) { if (Object(r) !== r) return Promise.reject(new TypeError(r + " is not an object.")); var done = r.done; return Promise.resolve(r.value).then(function (value) { return { value: value, done: done }; }); } return AsyncFromSyncIterator = function AsyncFromSyncIterator(s) { this.s = s, this.n = s.next; }, AsyncFromSyncIterator.prototype = { s: null, n: null, next: function next() { return AsyncFromSyncIteratorContinuation(this.n.apply(this.s, arguments)); }, "return": function _return(value) { var ret = this.s["return"]; return void 0 === ret ? Promise.resolve({ value: value, done: !0 }) : AsyncFromSyncIteratorContinuation(ret.apply(this.s, arguments)); }, "throw": function _throw(value) { var thr = this.s["return"]; return void 0 === thr ? Promise.reject(value) : AsyncFromSyncIteratorContinuation(thr.apply(this.s, arguments)); } }, new AsyncFromSyncIterator(s); }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
import { useEffect, useReducer, useRef, useState } from 'react';
import { fetchStream } from './fetch_stream';
import { stringReducer } from './string_reducer';
/**
 * Custom hook type definition of the base params for an NDJSON stream with custom reducer.
 */

/**
 * Custom hook to receive streaming data.
 *
 * @param endpoint - API endpoint including Kibana base path.
 * @param body - API request body.
 * @param options - Optional custom reducer and initial state.
 * @returns An object with streaming data and methods act on the stream.
 */
export function useFetchStream(endpoint, body, options) {
  var _options$reducer, _options$initialState;

  var _useState = useState([]),
      _useState2 = _slicedToArray(_useState, 2),
      errors = _useState2[0],
      setErrors = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      isCancelled = _useState4[0],
      setIsCancelled = _useState4[1];

  var _useState5 = useState(false),
      _useState6 = _slicedToArray(_useState5, 2),
      isRunning = _useState6[0],
      setIsRunning = _useState6[1];

  var reducer = (_options$reducer = options === null || options === void 0 ? void 0 : options.reducer) !== null && _options$reducer !== void 0 ? _options$reducer : stringReducer;
  var initialState = (_options$initialState = options === null || options === void 0 ? void 0 : options.initialState) !== null && _options$initialState !== void 0 ? _options$initialState : '';

  var _useReducer = useReducer(reducer, initialState),
      _useReducer2 = _slicedToArray(_useReducer, 2),
      data = _useReducer2[0],
      dispatch = _useReducer2[1];

  var abortCtrl = useRef(new AbortController());

  var addError = function addError(error) {
    setErrors(function (prevErrors) {
      return [].concat(_toConsumableArray(prevErrors), [error]);
    });
  };

  var start = /*#__PURE__*/function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var _iteratorAbruptCompletion, _didIteratorError, _iteratorError, _iterator, _step, _step$value, fetchStreamError, actions;

      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (!isRunning) {
                _context.next = 3;
                break;
              }

              addError('Restart not supported yet.');
              return _context.abrupt("return");

            case 3:
              setErrors([]);
              setIsRunning(true);
              setIsCancelled(false);
              abortCtrl.current = new AbortController();
              _iteratorAbruptCompletion = false;
              _didIteratorError = false;
              _context.prev = 9;
              _iterator = _asyncIterator(fetchStream(endpoint, abortCtrl, body, options !== undefined));

            case 11:
              _context.next = 13;
              return _iterator.next();

            case 13:
              if (!(_iteratorAbruptCompletion = !(_step = _context.sent).done)) {
                _context.next = 19;
                break;
              }

              _step$value = _slicedToArray(_step.value, 2), fetchStreamError = _step$value[0], actions = _step$value[1];

              if (fetchStreamError !== null) {
                addError(fetchStreamError);
              } else if (actions.length > 0) {
                dispatch(actions);
              }

            case 16:
              _iteratorAbruptCompletion = false;
              _context.next = 11;
              break;

            case 19:
              _context.next = 25;
              break;

            case 21:
              _context.prev = 21;
              _context.t0 = _context["catch"](9);
              _didIteratorError = true;
              _iteratorError = _context.t0;

            case 25:
              _context.prev = 25;
              _context.prev = 26;

              if (!(_iteratorAbruptCompletion && _iterator["return"] != null)) {
                _context.next = 30;
                break;
              }

              _context.next = 30;
              return _iterator["return"]();

            case 30:
              _context.prev = 30;

              if (!_didIteratorError) {
                _context.next = 33;
                break;
              }

              throw _iteratorError;

            case 33:
              return _context.finish(30);

            case 34:
              return _context.finish(25);

            case 35:
              setIsRunning(false);

            case 36:
            case "end":
              return _context.stop();
          }
        }
      }, _callee, null, [[9, 21, 25, 35], [26,, 30, 34]]);
    }));

    return function start() {
      return _ref.apply(this, arguments);
    };
  }();

  var cancel = function cancel() {
    abortCtrl.current.abort();
    setIsCancelled(true);
    setIsRunning(false);
  }; // If components using this custom hook get unmounted, cancel any ongoing request.


  useEffect(function () {
    return function () {
      return abortCtrl.current.abort();
    };
  }, []);
  return {
    cancel: cancel,
    data: data,
    dispatch: dispatch,
    errors: errors,
    isCancelled: isCancelled,
    isRunning: isRunning,
    start: start
  };
}