"use strict";
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.events = void 0;
const events_1 = require("events");
const errors_1 = require("./errors");
var events;
(function (events) {
    events["RESPONSE"] = "response";
    events["REQUEST"] = "request";
    events["SNIFF"] = "sniff";
    events["RESURRECT"] = "resurrect";
    events["SERIALIZATION"] = "serialization";
    events["DESERIALIZATION"] = "deserialization";
})(events = exports.events || (exports.events = {}));
class Diagnostic extends events_1.EventEmitter {
    on(event, listener) {
        assertSupportedEvent(event);
        super.on(event, listener);
        return this;
    }
    once(event, listener) {
        assertSupportedEvent(event);
        super.once(event, listener);
        return this;
    }
    off(event, listener) {
        assertSupportedEvent(event);
        super.off(event, listener);
        return this;
    }
}
exports.default = Diagnostic;
function assertSupportedEvent(event) {
    if (!supportedEvents.includes(event)) {
        throw new errors_1.ConfigurationError(`The event '${event}' is not supported.`);
    }
}
// @ts-expect-error
const supportedEvents = Object.keys(events).map(key => events[key]);
//# sourceMappingURL=Diagnostic.js.map