"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiTitle = exports.euiTitleStyles = exports.euiTitle = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("@emotion/react");

var _services = require("../../services");

var _global_styling = require("../../global_styling");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

var euiTitle = function euiTitle(euiThemeContext) {
  var scale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'm';
  var options = arguments.length > 2 ? arguments[2] : undefined;
  var euiTheme = euiThemeContext.euiTheme;
  var titleScaleToFontSizeScaleMap = {
    xxxs: 'xs',
    xxs: 's',
    xs: 'm',
    s: 'l',
    m: 'xl',
    l: 'xxl'
  };
  return _objectSpread(_objectSpread({}, (0, _global_styling.euiFontSize)(euiThemeContext, titleScaleToFontSizeScaleMap[scale], options)), {}, {
    fontWeight: euiTheme.font.weight[euiTheme.font.title.weight],
    color: euiTheme.colors.title
  });
}; // Hook version


exports.euiTitle = euiTitle;

var useEuiTitle = function useEuiTitle(scale, options) {
  var euiTheme = (0, _services.useEuiTheme)();
  return euiTitle(euiTheme, scale, options);
};
/**
 * Styles
 */


exports.useEuiTitle = useEuiTitle;

var _ref = process.env.NODE_ENV === "production" ? {
  name: "1x2qsb1-uppercase",
  styles: "text-transform:uppercase;label:uppercase;"
} : {
  name: "1x2qsb1-uppercase",
  styles: "text-transform:uppercase;label:uppercase;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var euiTitleStyles = function euiTitleStyles(euiThemeContext) {
  return {
    euiTitle: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextBreakWord)(), " &+&{margin-top:", euiThemeContext.euiTheme.size.l, ";};label:euiTitle;"),
    uppercase: _ref,
    // Sizes
    xxxs: /*#__PURE__*/(0, _react.css)(euiTitle(euiThemeContext, 'xxxs'), ";;label:xxxs;"),
    xxs: /*#__PURE__*/(0, _react.css)(euiTitle(euiThemeContext, 'xxs'), ";;label:xxs;"),
    xs: /*#__PURE__*/(0, _react.css)(euiTitle(euiThemeContext, 'xs'), ";;label:xs;"),
    s: /*#__PURE__*/(0, _react.css)(euiTitle(euiThemeContext, 's'), ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)(euiTitle(euiThemeContext, 'm'), ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)(euiTitle(euiThemeContext, 'l'), ";;label:l;")
  };
};

exports.euiTitleStyles = euiTitleStyles;