"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERTICAL_ALIGN = exports.EuiTimelineItem = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _timeline_item_event = require("./timeline_item_event");

var _timeline_item_icon = require("./timeline_item_icon");

var _timeline_item = require("./timeline_item.styles");

var _react2 = require("@emotion/react");

var _excluded = ["children", "verticalAlign", "icon", "iconAriaLabel", "className"];
var VERTICAL_ALIGN = ['top', 'center'];
exports.VERTICAL_ALIGN = VERTICAL_ALIGN;

var EuiTimelineItem = function EuiTimelineItem(_ref) {
  var children = _ref.children,
      _ref$verticalAlign = _ref.verticalAlign,
      verticalAlign = _ref$verticalAlign === void 0 ? 'center' : _ref$verticalAlign,
      icon = _ref.icon,
      iconAriaLabel = _ref.iconAriaLabel,
      className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var styles = (0, _timeline_item.euiTimelineItemStyles)();
  var cssStyles = [styles.euiTimelineItem, styles[verticalAlign]];
  return (0, _react2.jsx)("li", (0, _extends2.default)({
    css: cssStyles
  }, rest), (0, _react2.jsx)(_timeline_item_icon.EuiTimelineItemIcon, {
    icon: icon,
    iconAriaLabel: iconAriaLabel,
    verticalAlign: verticalAlign
  }), (0, _react2.jsx)(_timeline_item_event.EuiTimelineItemEvent, {
    verticalAlign: verticalAlign
  }, children));
};

exports.EuiTimelineItem = EuiTimelineItem;
EuiTimelineItem.propTypes = {
  /**
     * Vertical alignment of the event with the icon
     */
  verticalAlign: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};