"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTablePagination = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _button = require("../../button");

var _context_menu = require("../../context_menu");

var _flex = require("../../flex");

var _pagination = require("../../pagination");

var _popover = require("../../popover");

var _i18n = require("../../i18n");

var _react2 = require("@emotion/react");

var _excluded = ["activePage", "itemsPerPage", "itemsPerPageOptions", "showPerPageOptions", "onChangeItemsPerPage", "onChangePage", "pageCount"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var EuiTablePagination = function EuiTablePagination(_ref) {
  var activePage = _ref.activePage,
      _ref$itemsPerPage = _ref.itemsPerPage,
      itemsPerPage = _ref$itemsPerPage === void 0 ? 50 : _ref$itemsPerPage,
      _ref$itemsPerPageOpti = _ref.itemsPerPageOptions,
      itemsPerPageOptions = _ref$itemsPerPageOpti === void 0 ? [10, 20, 50, 100] : _ref$itemsPerPageOpti,
      _ref$showPerPageOptio = _ref.showPerPageOptions,
      showPerPageOptions = _ref$showPerPageOptio === void 0 ? true : _ref$showPerPageOptio,
      _ref$onChangeItemsPer = _ref.onChangeItemsPerPage,
      onChangeItemsPerPage = _ref$onChangeItemsPer === void 0 ? function () {} : _ref$onChangeItemsPer,
      onChangePage = _ref.onChangePage,
      pageCount = _ref.pageCount,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      isPopoverOpen = _useState2[0],
      setIsPopoverOpen = _useState2[1];

  var togglePopover = (0, _react.useCallback)(function () {
    setIsPopoverOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var closePopover = (0, _react.useCallback)(function () {
    setIsPopoverOpen(false);
  }, []);
  var button = (0, _react2.jsx)(_button.EuiButtonEmpty, {
    size: "xs",
    color: "text",
    iconType: "arrowDown",
    iconSide: "right",
    "data-test-subj": "tablePaginationPopoverButton",
    onClick: togglePopover
  }, itemsPerPage === 0 ? (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiTablePagination.allRows",
    default: "Showing all rows"
  }) : (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiTablePagination.rowsPerPage",
    default: "Rows per page"
  }), ": ", itemsPerPage));
  var items = (0, _react.useMemo)(function () {
    return itemsPerPageOptions.map(function (itemsPerPageOption) {
      return (0, _react2.jsx)(_context_menu.EuiContextMenuItem, {
        key: itemsPerPageOption,
        icon: itemsPerPageOption === itemsPerPage ? 'check' : 'empty',
        onClick: function onClick() {
          closePopover();
          onChangeItemsPerPage(itemsPerPageOption);
        },
        "data-test-subj": "tablePagination-".concat(itemsPerPageOption, "-rows")
      }, itemsPerPageOption === 0 ? (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiTablePagination.rowsPerPageOptionShowAllRows",
        default: "Show all rows"
      }) : (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiTablePagination.rowsPerPageOption",
        values: {
          rowsPerPage: itemsPerPageOption
        },
        default: "{rowsPerPage} rows"
      }));
    });
  }, [itemsPerPageOptions, itemsPerPage, onChangeItemsPerPage, closePopover]);
  var itemsPerPagePopover = (0, _react2.jsx)(_popover.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "upRight"
  }, (0, _react2.jsx)(_context_menu.EuiContextMenuPanel, {
    items: items
  }));
  return (0, _react2.jsx)(_flex.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false,
    wrap: true,
    gutterSize: "s",
    className: "eui-xScroll"
  }, (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, showPerPageOptions && itemsPerPagePopover), (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, itemsPerPage > 0 && (0, _react2.jsx)(_pagination.EuiPagination, (0, _extends2.default)({
    pageCount: pageCount,
    activePage: activePage,
    onPageClick: onChangePage
  }, rest))));
};

exports.EuiTablePagination = EuiTablePagination;
EuiTablePagination.propTypes = {
  /**
     * Option to completely hide the "Rows per page" selector.
     */
  showPerPageOptions: _propTypes.default.bool,

  /**
     * Current selection for "Rows per page".
     * Pass `0` to display the selected "Show all" option and hide the pagination.
     */
  itemsPerPage: _propTypes.default.number,

  /**
     * Custom array of options for "Rows per page".
     * Pass `0` as one of the options to create a "Show all" option.
     */
  itemsPerPageOptions: _propTypes.default.arrayOf(_propTypes.default.number.isRequired),

  /**
     * Click handler that passes back selected `pageSize` number
     */
  onChangeItemsPerPage: _propTypes.default.func,
  onChangePage: _propTypes.default.func,

  /**
     * Requires the `id` of the table being controlled
     */
  "aria-controls": _propTypes.default.string,
  "aria-label": _propTypes.default.string
};