"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTableHeader = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react2 = require("@emotion/react");

var _excluded = ["children", "className", "wrapWithTableRow"];

var EuiTableHeader = function EuiTableHeader(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$wrapWithTableRow = _ref.wrapWithTableRow,
      wrapWithTableRow = _ref$wrapWithTableRow === void 0 ? true : _ref$wrapWithTableRow,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return (0, _react2.jsx)("thead", (0, _extends2.default)({
    className: className
  }, rest), wrapWithTableRow ? (0, _react2.jsx)("tr", null, children) : children);
};

exports.EuiTableHeader = EuiTableHeader;
EuiTableHeader.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * Children must be valid DOM structure residing within `<thead>`.
       * Use `<td> | <th>` by default, or `<tr><th/></tr>` when `wrapWithTableRow=false`
       */
  children: _propTypes.default.node,

  /**
       * Automatically adds a wrapping `<tr>` element around the children
       */
  wrapWithTableRow: _propTypes.default.bool
};