"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiStep = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _title = require("../title");

var _step_number = require("./step_number");

var _react2 = require("@emotion/react");

var _excluded = ["className", "children", "headingElement", "step", "title", "titleSize", "status"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var EuiStep = function EuiStep(_ref) {
  var className = _ref.className,
      children = _ref.children,
      _ref$headingElement = _ref.headingElement,
      headingElement = _ref$headingElement === void 0 ? 'p' : _ref$headingElement,
      _ref$step = _ref.step,
      step = _ref$step === void 0 ? 1 : _ref$step,
      title = _ref.title,
      _ref$titleSize = _ref.titleSize,
      titleSize = _ref$titleSize === void 0 ? 's' : _ref$titleSize,
      status = _ref.status,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiStep', {
    'euiStep--small': titleSize === 'xs',
    'euiStep-isDisabled': status === 'disabled'
  }, className);
  var numberClasses = (0, _classnames.default)('euiStep__circle', {
    'euiStepNumber--small': titleSize === 'xs'
  });
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    className: classes
  }, rest), (0, _react2.jsx)("div", {
    className: "euiStep__titleWrapper"
  }, (0, _react2.jsx)(_step_number.EuiStepNumber, {
    className: numberClasses,
    number: step,
    status: status,
    titleSize: titleSize
  }), (0, _react2.jsx)(_title.EuiTitle, {
    size: titleSize,
    className: "euiStep__title"
  }, /*#__PURE__*/(0, _react.createElement)(headingElement, null, title))), (0, _react2.jsx)("div", {
    className: "euiStep__content"
  }, children));
};

exports.EuiStep = EuiStep;
EuiStep.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.node.isRequired,

  /**
     * The HTML tag used for the title
     */
  headingElement: _propTypes.default.string,

  /**
     * The number of the step in the list of steps
     */
  step: _propTypes.default.number,
  title: _propTypes.default.string.isRequired,

  /**
     * May replace the number provided in props.step with alternate styling.
     */
  status: _propTypes.default.any,

  /**
     * Title sizing equivalent to EuiTitle, but only `m`, `s` and `xs`. Defaults to `s`
     */
  titleSize: _propTypes.default.any
};