"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiMark = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _i18n = require("../i18n");

var _services = require("../../services");

var _mark = require("./mark.styles");

var _react2 = require("@emotion/react");

var _excluded = ["children", "className", "hasScreenReaderHelpText"];

var EuiMark = function EuiMark(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$hasScreenReaderH = _ref.hasScreenReaderHelpText,
      hasScreenReaderHelpText = _ref$hasScreenReaderH === void 0 ? true : _ref$hasScreenReaderH,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var useTheme = (0, _services.useEuiTheme)();
  var highlightStart = (0, _i18n.useEuiI18n)('euiMark.highlightStart', 'highlight start');
  var highlightEnd = (0, _i18n.useEuiI18n)('euiMark.highlightEnd', 'highlight end');
  var styles = (0, _mark.euiMarkStyles)(useTheme, {
    hasScreenReaderHelpText: hasScreenReaderHelpText,
    highlightStart: highlightStart,
    highlightEnd: highlightEnd
  });
  var classes = (0, _classnames.default)('euiMark', className);
  return (0, _react2.jsx)("mark", (0, _extends2.default)({
    css: [styles, ";label:EuiMark;"],
    className: classes
  }, rest), children);
};

exports.EuiMark = EuiMark;
EuiMark.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * Set to `false` to remove the CSS :before and :after
       * screen reader helper text
       */
  hasScreenReaderHelpText: _propTypes.default.bool,

  /**
       * ReactNode to render as this component's content
       */
  children: _propTypes.default.node.isRequired
};