"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiLoadingContentStyles = void 0;

var _taggedTemplateLiteral2 = _interopRequireDefault(require("@babel/runtime/helpers/taggedTemplateLiteral"));

var _react = require("@emotion/react");

var _global_styling = require("../../global_styling");

var _services = require("../../services");

var _templateObject;

var loadingContentGradient = (0, _react.keyframes)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n  0% {\n    transform: translateX(-53%);\n  }\n\n  100% {\n    transform: translateX(0);\n  }\n"])));

var euiLoadingContentStyles = function euiLoadingContentStyles(_ref) {
  var euiTheme = _ref.euiTheme,
      colorMode = _ref.colorMode;
  var gradientStartStop = colorMode === _services.COLOR_MODES_STANDARD.dark ? (0, _services.shade)(euiTheme.colors.lightShade, 0.12) : (0, _services.tint)(euiTheme.colors.lightShade, 0.65);
  var gradientMiddle = colorMode === _services.COLOR_MODES_STANDARD.dark ? (0, _services.shade)(euiTheme.colors.lightShade, 0.24) : (0, _services.tint)(euiTheme.colors.lightShade, 0.8);
  return {
    euiLoadingContent__singleLine: /*#__PURE__*/(0, _react.css)("display:block;width:100%;height:", euiTheme.size.base, ";border-radius:", euiTheme.border.radius.medium, ";background:", gradientStartStop, ";overflow:hidden;&:not(:last-child){margin-block-end:", euiTheme.size.s, ";}&:last-child:not(:only-child){width:75%;}&::after{content:'';display:block;width:220%;height:100%;background:linear-gradient(\n          137deg,\n          ", gradientStartStop, " 45%,\n          ", gradientMiddle, " 50%,\n          ", gradientStartStop, " 55%\n        );", _global_styling.euiCanAnimate, "{animation:", loadingContentGradient, " 1.5s ", euiTheme.animation.resistance, " infinite;}};label:euiLoadingContent__singleLine;")
  };
};

exports.euiLoadingContentStyles = euiLoadingContentStyles;