"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiLoadingChartStyles = exports.euiLoadingChartBarStyles = exports._barIndex = void 0;

var _taggedTemplateLiteral2 = _interopRequireDefault(require("@babel/runtime/helpers/taggedTemplateLiteral"));

var _react = require("@emotion/react");

var _services = require("../../services");

var _global_styling = require("../../global_styling");

var _templateObject;

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "yovxj7-euiLoadingChart",
  styles: "overflow:hidden;display:inline-flex;label:euiLoadingChart;"
} : {
  name: "yovxj7-euiLoadingChart",
  styles: "overflow:hidden;display:inline-flex;label:euiLoadingChart;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var euiLoadingChartStyles = function euiLoadingChartStyles(_ref3) {
  var euiTheme = _ref3.euiTheme;
  return {
    euiLoadingChart: _ref2,
    m: /*#__PURE__*/(0, _react.css)("height:", euiTheme.size.base, ";gap:", euiTheme.size.xxs, ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)("height:", euiTheme.size.l, ";gap:", euiTheme.size.xxs, ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)("height:", euiTheme.size.xl, ";gap:", euiTheme.size.xs, ";;label:xl;")
  };
};

exports.euiLoadingChartStyles = euiLoadingChartStyles;

var _ref = process.env.NODE_ENV === "production" ? {
  name: "decz5u-euiLoadingChart__bar",
  styles: "height:100%;display:inline-block;label:euiLoadingChart__bar;"
} : {
  name: "decz5u-euiLoadingChart__bar",
  styles: "height:100%;display:inline-block;label:euiLoadingChart__bar;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var euiLoadingChartBarStyles = function euiLoadingChartBarStyles(_ref4) {
  var euiTheme = _ref4.euiTheme;
  return {
    euiLoadingChart__bar: _ref,
    m: /*#__PURE__*/(0, _react.css)("width:", euiTheme.size.xxs, ";", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.s), ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)("width:", euiTheme.size.xs, ";", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.m), ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)("width:", euiTheme.size.s, ";", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.base), ";;label:xl;")
  };
};

exports.euiLoadingChartBarStyles = euiLoadingChartBarStyles;
var barAnimation = (0, _react.keyframes)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n  0% {\n    transform: translateY(0);\n  }\n\n  50% {\n    transform: translateY(66%);\n  }\n\n  100% {\n    transform: translateY(0);\n  }\n"])));

var _barIndex = function _barIndex(index, mono, _ref5) {
  var euiTheme = _ref5.euiTheme,
      colorMode = _ref5.colorMode;
  var backgroundColor = mono ? (0, _services.shadeOrTint)(euiTheme.colors.lightShade, index * 0.04, colorMode) : (0, _services.euiPaletteColorBlind)()[index];
  return /*#__PURE__*/(0, _react.css)("background-color:", backgroundColor, ";transform:translateY(", 22 * index, "%);", _global_styling.euiCanAnimate, "{animation:", barAnimation, " 1s ", ".".concat(index, "s"), " infinite;}");
};

exports._barIndex = _barIndex;