"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFilterGroup = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _react2 = require("@emotion/react");

var _excluded = ["children", "className", "fullWidth", "compressed"];

var EuiFilterGroup = function EuiFilterGroup(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$fullWidth = _ref.fullWidth,
      fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
      compressed = _ref.compressed,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiFilterGroup', {
    'euiFilterGroup--fullWidth': fullWidth,
    'euiFilterGroup--compressed': compressed
  }, className);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    className: classes
  }, rest), children);
};

exports.EuiFilterGroup = EuiFilterGroup;
EuiFilterGroup.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  children: _propTypes.default.node,

  /**
       * Expand the whole bar to fill its parent's width
       */
  fullWidth: _propTypes.default.bool,

  /**
       *  When `true`, creates a shorter height filter group matching that of `compressed` form controls
       */
  compressed: _propTypes.default.bool
};