"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiBottomBarStyles = void 0;

var _taggedTemplateLiteral2 = _interopRequireDefault(require("@babel/runtime/helpers/taggedTemplateLiteral"));

var _react = require("@emotion/react");

var _global_styling = require("../../global_styling");

var _services = require("../../services");

var _mixins = require("../../themes/amsterdam/global_styling/mixins");

var _templateObject;

var euiBottomBarAppear = (0, _react.keyframes)(_templateObject || (_templateObject = (0, _taggedTemplateLiteral2.default)(["\n  0% {\n    transform: translateY(100%);\n    opacity: 0;\n  }\n\n  100% {\n    transform: translateY(0%);\n    opacity: 1;\n  }\n"])));

var euiBottomBarStyles = function euiBottomBarStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    // Text color needs to be reapplied to properly scope the forced `colorMode`
    euiBottomBar: /*#__PURE__*/(0, _react.css)((0, _mixins.euiShadowFlat)(euiThemeContext), ";background:", (0, _services.shade)(euiTheme.colors.lightestShade, 0.5), ";color:", euiTheme.colors.text, ";", _global_styling.euiCanAnimate, "{animation:", euiBottomBarAppear, " ", euiTheme.animation.slow, " ", euiTheme.animation.resistance, ";};label:euiBottomBar;"),
    static: /*#__PURE__*/(0, _react.css)(";label:static;"),
    fixed: /*#__PURE__*/(0, _react.css)("z-index:", Number(euiTheme.levels.header) - 2, ";;label:fixed;"),
    sticky: /*#__PURE__*/(0, _react.css)("z-index:", Number(euiTheme.levels.header) - 2, ";;label:sticky;"),
    // Padding
    s: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.s, ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.base, ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.l, ";;label:l;"),
    none: ''
  };
};

exports.euiBottomBarStyles = euiBottomBarStyles;