"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSuggestItem = exports.COLORS = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _common = require("../common");

var _classnames = _interopRequireDefault(require("classnames"));

var _icon = require("../icon");

var _react2 = require("@emotion/react");

var _excluded = ["className", "label", "type", "labelWidth", "description", "truncate", "onClick"];
var colorToClassNameMap = {
  tint0: 'euiSuggestItem__type--tint0',
  tint1: 'euiSuggestItem__type--tint1',
  tint2: 'euiSuggestItem__type--tint2',
  tint3: 'euiSuggestItem__type--tint3',
  tint4: 'euiSuggestItem__type--tint4',
  tint5: 'euiSuggestItem__type--tint5',
  tint6: 'euiSuggestItem__type--tint6',
  tint7: 'euiSuggestItem__type--tint7',
  tint8: 'euiSuggestItem__type--tint8',
  tint9: 'euiSuggestItem__type--tint9',
  tint10: 'euiSuggestItem__type--tint10'
};
var COLORS = (0, _common.keysOf)(colorToClassNameMap);
exports.COLORS = COLORS;

var EuiSuggestItem = function EuiSuggestItem(_ref) {
  var className = _ref.className,
      label = _ref.label,
      type = _ref.type,
      _ref$labelWidth = _ref.labelWidth,
      labelWidth = _ref$labelWidth === void 0 ? '50' : _ref$labelWidth,
      description = _ref.description,
      _ref$truncate = _ref.truncate,
      truncate = _ref$truncate === void 0 ? true : _ref$truncate,
      onClick = _ref.onClick,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiSuggestItem', {
    'euiSuggestItem--truncate': truncate
  }, className);
  var labelClassNames = (0, _classnames.default)('euiSuggestItem__label', "euiSuggestItem__label--width".concat(labelWidth));
  var descriptionClassNames = (0, _classnames.default)('euiSuggestItem__description', {
    'euiSuggestItem__description--wrap': !truncate
  });
  var typeColorClass = '';

  if (type && type.color) {
    if (COLORS.indexOf(type.color) > -1) {
      typeColorClass = colorToClassNameMap[type.color];
    }
  }

  var innerContent = (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("span", {
    className: "euiSuggestItem__type ".concat(typeColorClass)
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: type.iconType,
    color: "inherit" // forces the icon to inherit its parent color

  })), (0, _react2.jsx)("span", {
    className: labelClassNames,
    title: label
  }, label), description && (0, _react2.jsx)("span", {
    className: descriptionClassNames,
    title: description
  }, description));

  if (onClick) {
    return (0, _react2.jsx)("button", (0, _extends2.default)({
      onClick: onClick,
      className: classes
    }, rest), innerContent);
  } else {
    return (0, _react2.jsx)("span", (0, _extends2.default)({
      className: classes
    }, rest), innerContent);
  }
};

exports.EuiSuggestItem = EuiSuggestItem;