"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiStat = exports.COLORS = exports.ALIGNMENTS = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _text = require("../text");

var _title = require("../title/title");

var _accessibility = require("../accessibility");

var _i18n = require("../i18n");

var _services = require("../../services");

var _stat = require("./stat.styles");

var _react2 = require("@emotion/react");

var _excluded = ["children", "className", "description", "isLoading", "reverse", "textAlign", "title", "titleColor", "titleSize", "titleElement", "descriptionElement"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var COLORS = ['default', 'subdued', 'primary', 'success', 'danger', 'accent'];
exports.COLORS = COLORS;
var ALIGNMENTS = ['left', 'center', 'right'];
exports.ALIGNMENTS = ALIGNMENTS;

var EuiStat = function EuiStat(_ref) {
  var children = _ref.children,
      className = _ref.className,
      description = _ref.description,
      _ref$isLoading = _ref.isLoading,
      isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
      _ref$reverse = _ref.reverse,
      reverse = _ref$reverse === void 0 ? false : _ref$reverse,
      _ref$textAlign = _ref.textAlign,
      textAlign = _ref$textAlign === void 0 ? 'left' : _ref$textAlign,
      title = _ref.title,
      _ref$titleColor = _ref.titleColor,
      titleColor = _ref$titleColor === void 0 ? 'default' : _ref$titleColor,
      _ref$titleSize = _ref.titleSize,
      titleSize = _ref$titleSize === void 0 ? 'l' : _ref$titleSize,
      _ref$titleElement = _ref.titleElement,
      titleElement = _ref$titleElement === void 0 ? 'p' : _ref$titleElement,
      _ref$descriptionEleme = _ref.descriptionElement,
      descriptionElement = _ref$descriptionEleme === void 0 ? 'p' : _ref$descriptionEleme,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _stat.euiStatStyles)();
  var cssStyles = [styles.euiStat, styles[textAlign]];
  var classes = (0, _classnames.default)('euiStat', className);
  var commonProps = {
    'aria-hidden': true
  };
  var descriptionDisplay = (0, _react2.jsx)(_text.EuiText, {
    size: "s",
    className: "euiStat__description"
  }, /*#__PURE__*/(0, _react.createElement)(descriptionElement, commonProps, description));
  var isNamedTitleColor = COLORS.includes(titleColor);
  var titleStyles = (0, _stat.euiStatTitleStyles)(euiTheme);
  var titleCssStyles = [titleStyles.euiStat__title, isNamedTitleColor && titleStyles[titleColor], isLoading && titleStyles.isLoading];
  var titleProps = isNamedTitleColor ? commonProps : _objectSpread(_objectSpread({}, commonProps), {}, {
    style: {
      color: titleColor
    }
  });
  var titleChildren = isLoading ? '--' : title;
  var titleDisplay = (0, _react2.jsx)(_title.EuiTitle, {
    size: titleSize,
    className: "euiStat__title",
    css: titleCssStyles
  }, /*#__PURE__*/(0, _react.createElement)(titleElement, titleProps, titleChildren));
  var screenReader = (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", null, isLoading ? (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiStat.loadingText",
    default: "Statistic is loading"
  }) : (0, _react2.jsx)(_react.Fragment, null, reverse ? "".concat(title, " ").concat(description) : "".concat(description, " ").concat(title))));
  var statDisplay = (0, _react2.jsx)(_react.Fragment, null, !reverse && descriptionDisplay, titleDisplay, reverse && descriptionDisplay, typeof title === 'string' && typeof description === 'string' && screenReader);
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    css: cssStyles,
    className: classes
  }, rest), statDisplay, children);
};

exports.EuiStat = EuiStat;