"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiProvider = void 0;

var _react = _interopRequireDefault(require("react"));

var _global_styles = require("../../global_styling/reset/global_styles");

var _utility = require("../../global_styling/utility/utility");

var _services = require("../../services");

var _themes = require("../../themes");

var _cache = require("./cache");

var _react2 = require("@emotion/react");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var isEmotionCacheObject = function isEmotionCacheObject(obj) {
  return obj.hasOwnProperty('key');
};

var EuiProvider = function EuiProvider(_ref) {
  var cache = _ref.cache,
      _ref$theme = _ref.theme,
      theme = _ref$theme === void 0 ? _themes.EuiThemeAmsterdam : _ref$theme,
      _ref$globalStyles = _ref.globalStyles,
      Globals = _ref$globalStyles === void 0 ? _global_styles.EuiGlobalStyles : _ref$globalStyles,
      _ref$utilityClasses = _ref.utilityClasses,
      Utilities = _ref$utilityClasses === void 0 ? _utility.EuiUtilityClasses : _ref$utilityClasses,
      colorMode = _ref.colorMode,
      modify = _ref.modify,
      children = _ref.children;
  var defaultCache;
  var globalCache;
  var utilityCache;

  if (cache) {
    if (isEmotionCacheObject(cache)) {
      defaultCache = cache;
    } else {
      defaultCache = cache.default;
      globalCache = cache.global;
      utilityCache = cache.utility;
    }
  }

  return (0, _react2.jsx)(_cache.EuiCacheProvider, {
    cache: defaultCache
  }, (0, _react2.jsx)(_services.EuiThemeProvider, {
    theme: theme !== null && theme !== void 0 ? theme : undefined,
    colorMode: colorMode,
    modify: modify
  }, theme && (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_cache.EuiCacheProvider, {
    cache: globalCache,
    children: Globals && (0, _react2.jsx)(Globals, null)
  }), (0, _react2.jsx)(_cache.EuiCacheProvider, {
    cache: utilityCache,
    children: Utilities && (0, _react2.jsx)(Utilities, null)
  })), children));
};

exports.EuiProvider = EuiProvider;