"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.POSITIONS = exports.EuiProgress = exports.COLORS = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _i18n = require("../i18n");

var _inner_text = require("../inner_text");

var _predicate = require("../../services/predicate");

var _services = require("../../services");

var _progress = require("./progress.styles");

var _react2 = require("@emotion/react");

var _excluded = ["className", "color", "size", "position", "max", "valueText", "label", "value", "labelProps"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var SIZES = ['xs', 's', 'm', 'l'];
exports.SIZES = SIZES;
var COLORS = ['primary', 'success', 'warning', 'danger', 'subdued', 'accent', 'vis0', 'vis1', 'vis2', 'vis3', 'vis4', 'vis5', 'vis6', 'vis7', 'vis8', 'vis9'];
exports.COLORS = COLORS;
var POSITIONS = ['fixed', 'absolute', 'static'];
exports.POSITIONS = POSITIONS;

var EuiProgress = function EuiProgress(_ref) {
  var className = _ref.className,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'success' : _ref$color,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      _ref$position = _ref.position,
      position = _ref$position === void 0 ? 'static' : _ref$position,
      max = _ref.max,
      _ref$valueText = _ref.valueText,
      valueText = _ref$valueText === void 0 ? false : _ref$valueText,
      label = _ref.label,
      value = _ref.value,
      labelProps = _ref.labelProps,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var determinate = !(0, _predicate.isNil)(max);
  var isNamedColor = COLORS.includes(color);
  var euiTheme = (0, _services.useEuiTheme)();
  var customColorStyles = !isNamedColor ? {
    color: color
  } : {};
  var customTextColorStyles = !isNamedColor ? {
    color: (0, _services.makeHighContrastColor)(color)(euiTheme.euiTheme)
  } : {};
  var styles = (0, _progress.euiProgressStyles)(euiTheme, determinate);
  var cssStyles = [styles.euiProgress, determinate && styles.native, !determinate && styles.indeterminate, styles[size], styles[position], isNamedColor ? styles[color] : styles.customColor];
  var dataStyles = (0, _progress.euiProgressDataStyles)(euiTheme);
  var dataCssStyles = [dataStyles.euiProgress__data, size === 'l' && dataStyles[size]];
  var labelCssStyles = [_progress.euiProgressLabelStyles.euiProgress__label];
  var valueTextStyles = (0, _progress.euiProgressValueTextStyles)(euiTheme);
  var valueTextCssStyles = [valueTextStyles.euiProgress__valueText, isNamedColor ? valueTextStyles[color] : styles.customColor];
  var classes = (0, _classnames.default)('euiProgress', className);
  var labelClasses = (0, _classnames.default)('euiProgress__label', labelProps === null || labelProps === void 0 ? void 0 : labelProps.className);
  var valueRender;

  if (valueText === true) {
    // valueText is true
    valueRender = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiProgress.valueText",
      default: "{value}%",
      values: {
        value: value
      }
    });
  } else if (valueText) {
    // valueText exists
    valueRender = valueText;
  } // Because of a Firefox animation issue, indeterminate progress needs to not use <progress />.
  // See https://css-tricks.com/html5-progress-element/


  if (determinate) {
    return (0, _react2.jsx)(_react.Fragment, null, label || valueText ? (0, _react2.jsx)("div", {
      css: dataCssStyles,
      className: "euiProgress__data"
    }, label && (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
      return (0, _react2.jsx)("span", (0, _extends2.default)({
        title: innerText,
        ref: ref
      }, labelProps, {
        css: labelCssStyles,
        className: labelClasses
      }), label);
    }), valueRender && (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
      return (0, _react2.jsx)("span", {
        title: innerText,
        ref: ref,
        style: customTextColorStyles,
        css: valueTextCssStyles,
        className: "euiProgress__valueText"
      }, valueRender);
    })) : undefined, (0, _react2.jsx)("progress", (0, _extends2.default)({
      css: cssStyles,
      className: classes,
      style: customColorStyles,
      max: max,
      value: value,
      "aria-hidden": label && valueText ? true : false
    }, rest)));
  } else {
    return (0, _react2.jsx)("div", (0, _extends2.default)({
      css: cssStyles,
      style: customColorStyles,
      className: classes
    }, rest));
  }
};

exports.EuiProgress = EuiProgress;