"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiMarkdownEditorTextArea = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _markdown_context = require("./markdown_context");

var _react2 = require("@emotion/react");

var _excluded = ["children", "compressed", "id", "isInvalid", "name", "placeholder", "rows", "height", "maxHeight"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var EuiMarkdownEditorTextArea = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var children = _ref.children,
      compressed = _ref.compressed,
      id = _ref.id,
      isInvalid = _ref.isInvalid,
      name = _ref.name,
      placeholder = _ref.placeholder,
      rows = _ref.rows,
      height = _ref.height,
      maxHeight = _ref.maxHeight,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  var _useContext = (0, _react.useContext)(_markdown_context.EuiMarkdownContext),
      readOnly = _useContext.readOnly;

  var classes = (0, _classnames.default)('euiMarkdownEditorTextArea', {
    'euiMarkdownEditorTextArea-isReadOnly': readOnly
  });
  return (0, _react2.jsx)("textarea", (0, _extends2.default)({
    ref: ref,
    "data-test-subj": "euiMarkdownEditorTextArea",
    style: {
      height: height,
      maxHeight: maxHeight
    },
    className: classes
  }, rest, {
    rows: 6,
    name: name,
    id: id,
    placeholder: placeholder,
    readOnly: readOnly
  }), children);
});
exports.EuiMarkdownEditorTextArea = EuiMarkdownEditorTextArea;
EuiMarkdownEditorTextArea.displayName = 'EuiMarkdownEditorTextArea';