"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDatePickerRange = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _icon = require("../icon");

var _react2 = require("@emotion/react");

var _excluded = ["children", "className", "startDateControl", "endDateControl", "iconType", "fullWidth", "isCustom", "readOnly", "isInvalid", "disabled"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var EuiDatePickerRange = function EuiDatePickerRange(_ref) {
  var children = _ref.children,
      className = _ref.className,
      startDateControl = _ref.startDateControl,
      endDateControl = _ref.endDateControl,
      _ref$iconType = _ref.iconType,
      iconType = _ref$iconType === void 0 ? true : _ref$iconType,
      fullWidth = _ref.fullWidth,
      isCustom = _ref.isCustom,
      readOnly = _ref.readOnly,
      isInvalid = _ref.isInvalid,
      disabled = _ref.disabled,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classes = (0, _classnames.default)('euiDatePickerRange', {
    'euiDatePickerRange--fullWidth': fullWidth,
    'euiDatePickerRange--readOnly': readOnly,
    'euiDatePickerRange--isInvalid': isInvalid,
    'euiDatePickerRange--isDisabled': disabled
  }, className);
  var startControl = startDateControl;
  var endControl = endDateControl;

  if (!isCustom) {
    startControl = /*#__PURE__*/(0, _react.cloneElement)(startDateControl, {
      iconType: typeof iconType === 'boolean' ? undefined : iconType,
      showIcon: !!iconType,
      fullWidth: fullWidth,
      readOnly: readOnly,
      disabled: disabled || startDateControl.props.disabled,
      isInvalid: isInvalid || startDateControl.props.isInvalid,
      className: (0, _classnames.default)('euiDatePickerRange__start', startDateControl.props.className)
    });
    endControl = /*#__PURE__*/(0, _react.cloneElement)(endDateControl, {
      showIcon: false,
      fullWidth: fullWidth,
      readOnly: readOnly,
      disabled: disabled || endDateControl.props.disabled,
      isInvalid: isInvalid || endDateControl.props.isInvalid,
      popoverPlacement: 'downRight',
      className: (0, _classnames.default)('euiDatePickerRange__end', endDateControl.props.className)
    });
  }

  var delimiter = (0, _react2.jsx)("span", {
    className: "euiDatePickerRange__delimeter"
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    color: isInvalid ? 'danger' : 'subdued',
    type: isInvalid ? 'alert' : 'sortRight'
  }));
  return (0, _react2.jsx)("div", (0, _extends2.default)({
    className: classes
  }, rest), children ? children : (0, _react2.jsx)(_react.Fragment, null, startControl, delimiter, endControl));
};

exports.EuiDatePickerRange = EuiDatePickerRange;