"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiButtonDisplayContent = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _services = require("../../../services");

var _loading = require("../../loading");

var _icon = require("../../icon");

var _button_display_content = require("./_button_display_content.styles");

var _react2 = require("@emotion/react");

var _excluded = ["children", "textProps", "isLoading", "isDisabled", "iconType", "iconSize", "iconSide"];

var EuiButtonDisplayContent = function EuiButtonDisplayContent(_ref) {
  var children = _ref.children,
      textProps = _ref.textProps,
      _ref$isLoading = _ref.isLoading,
      isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
      _ref$isDisabled = _ref.isDisabled,
      isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
      iconType = _ref.iconType,
      _ref$iconSize = _ref.iconSize,
      iconSize = _ref$iconSize === void 0 ? 'm' : _ref$iconSize,
      iconSide = _ref.iconSide,
      contentProps = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var theme = (0, _services.useEuiTheme)();
  var styles = (0, _button_display_content.euiButtonDisplayContentStyles)(theme);
  var cssStyles = [styles.euiButtonDisplayContent, iconSide && styles[iconSide], isDisabled && styles.isDisabled];
  var cssSpinnerStyles = [styles.euiButtonDisplayContent__spinner];
  var cssIconStyles = [styles.euiButtonDisplayContent__icon]; // Add an icon to the button if one exists.

  var icon; // When the button is disabled the text gets gray
  // and in some buttons the background gets a light gray
  // for better contrast we want to change the border of the spinner
  // to have the same color of the text. This way we ensure the borders
  // are always visible. The default spinner color could be very light.

  var loadingSpinnerColor = isDisabled ? {
    border: 'currentColor'
  } : undefined;

  if (isLoading) {
    icon = (0, _react2.jsx)(_loading.EuiLoadingSpinner, {
      css: cssSpinnerStyles,
      size: iconSize,
      color: loadingSpinnerColor
    });
  } else if (iconType) {
    icon = (0, _react2.jsx)(_icon.EuiIcon, {
      css: cssIconStyles,
      type: iconType,
      size: iconSize,
      color: "inherit" // forces the icon to inherit its parent color

    });
  }

  var isText = typeof children === 'string';
  return (0, _react2.jsx)("span", (0, _extends2.default)({}, contentProps, {
    css: cssStyles
  }), icon, isText ? (0, _react2.jsx)("span", textProps, children) : children);
};

exports.EuiButtonDisplayContent = EuiButtonDisplayContent;