"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POSITIONS = exports.EuiSkipLink = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _tabbable = require("tabbable");

var _services = require("../../../services");

var _button = require("../../button/button");

var _screen_reader_only = require("../screen_reader_only");

var _skip_link = require("./skip_link.styles");

var _react2 = require("@emotion/react");

var _excluded = ["destinationId", "overrideLinkBehavior", "tabIndex", "position", "children", "className"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var POSITIONS = ['static', 'fixed', 'absolute'];
exports.POSITIONS = POSITIONS;

var EuiSkipLink = function EuiSkipLink(_ref) {
  var destinationId = _ref.destinationId,
      overrideLinkBehavior = _ref.overrideLinkBehavior,
      tabIndex = _ref.tabIndex,
      _ref$position = _ref.position,
      position = _ref$position === void 0 ? 'static' : _ref$position,
      children = _ref.children,
      className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _skip_link.euiSkipLinkStyles)(euiTheme);
  var classes = (0, _classnames.default)('euiSkipLink', className);
  var cssStyles = [styles.euiSkipLink, position !== 'static' ? styles[position] : undefined]; // Create the `href` from `destinationId`

  var optionalProps = {};

  if (destinationId) {
    optionalProps = {
      href: "#".concat(destinationId)
    };
  }

  if (overrideLinkBehavior) {
    optionalProps = _objectSpread(_objectSpread({}, optionalProps), {}, {
      onClick: function onClick(e) {
        e.preventDefault();
        var destinationEl = document.getElementById(destinationId);
        if (!destinationEl) return; // Scroll to the top of the destination content only if it's ~mostly out of view

        var destinationY = destinationEl.getBoundingClientRect().top;
        var halfOfViewportHeight = window.innerHeight / 2;

        if (destinationY >= halfOfViewportHeight || window.scrollY >= destinationY + halfOfViewportHeight) {
          destinationEl.scrollIntoView();
        } // Ensure the destination content is focusable


        if (!(0, _tabbable.isTabbable)(destinationEl)) {
          destinationEl.tabIndex = -1;
          destinationEl.addEventListener('blur', function () {
            return destinationEl.removeAttribute('tabindex');
          }, {
            once: true
          });
        }

        destinationEl.focus({
          preventScroll: true
        }); // Scrolling is already handled above, and focus autoscroll behaves oddly on Chrome around fixed headers
      }
    });
  }

  return (0, _react2.jsx)(_screen_reader_only.EuiScreenReaderOnly, {
    showOnFocus: true
  }, (0, _react2.jsx)(_button.EuiButton, (0, _extends2.default)({
    css: cssStyles,
    className: classes,
    tabIndex: position === 'fixed' ? 0 : tabIndex,
    size: "s",
    fill: true
  }, optionalProps, rest), children));
};

exports.EuiSkipLink = EuiSkipLink;