/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css } from '@emotion/react';
import { useEuiTheme } from '../../services/theme';
import { logicalSide } from '../functions';
export var PADDING_SIZES = ['none', 'xs', 's', 'm', 'l', 'xl'];
export var euiPaddingSize = function euiPaddingSize(_ref, size) {
  var euiTheme = _ref.euiTheme;

  switch (size) {
    case 'none':
      return null;

    case 'm':
      return euiTheme.size.base;

    default:
      return euiTheme.size[size];
  }
};
export var useEuiPaddingSize = function useEuiPaddingSize(size) {
  var euiTheme = useEuiTheme();
  return euiPaddingSize(euiTheme, size);
};
export var useEuiPaddingCSS = function useEuiPaddingCSS(side) {
  var property = side ? "padding-".concat(logicalSide[side]) : 'padding';
  return {
    none: null,
    xs: /*#__PURE__*/css(property, ":", useEuiPaddingSize('xs'), ";;label:xs;"),
    s: /*#__PURE__*/css(property, ":", useEuiPaddingSize('s'), ";;label:s;"),
    m: /*#__PURE__*/css(property, ":", useEuiPaddingSize('m'), ";;label:m;"),
    l: /*#__PURE__*/css(property, ":", useEuiPaddingSize('l'), ";;label:l;"),
    xl: /*#__PURE__*/css(property, ":", useEuiPaddingSize('xl'), ";;label:xl;")
  };
};