import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css } from '@emotion/react';
import { useEuiTheme } from '../../services';
import { euiTextBreakWord, euiFontSize } from '../../global_styling';
export var euiTitle = function euiTitle(euiThemeContext) {
  var scale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'm';
  var options = arguments.length > 2 ? arguments[2] : undefined;
  var euiTheme = euiThemeContext.euiTheme;
  var titleScaleToFontSizeScaleMap = {
    xxxs: 'xs',
    xxs: 's',
    xs: 'm',
    s: 'l',
    m: 'xl',
    l: 'xxl'
  };
  return _objectSpread(_objectSpread({}, euiFontSize(euiThemeContext, titleScaleToFontSizeScaleMap[scale], options)), {}, {
    fontWeight: euiTheme.font.weight[euiTheme.font.title.weight],
    color: euiTheme.colors.title
  });
}; // Hook version

export var useEuiTitle = function useEuiTitle(scale, options) {
  var euiTheme = useEuiTheme();
  return euiTitle(euiTheme, scale, options);
};
/**
 * Styles
 */

var _ref = process.env.NODE_ENV === "production" ? {
  name: "1x2qsb1-uppercase",
  styles: "text-transform:uppercase;label:uppercase;"
} : {
  name: "1x2qsb1-uppercase",
  styles: "text-transform:uppercase;label:uppercase;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

export var euiTitleStyles = function euiTitleStyles(euiThemeContext) {
  return {
    euiTitle: /*#__PURE__*/css(euiTextBreakWord(), " &+&{margin-top:", euiThemeContext.euiTheme.size.l, ";};label:euiTitle;"),
    uppercase: _ref,
    // Sizes
    xxxs: /*#__PURE__*/css(euiTitle(euiThemeContext, 'xxxs'), ";;label:xxxs;"),
    xxs: /*#__PURE__*/css(euiTitle(euiThemeContext, 'xxs'), ";;label:xxs;"),
    xs: /*#__PURE__*/css(euiTitle(euiThemeContext, 'xs'), ";;label:xs;"),
    s: /*#__PURE__*/css(euiTitle(euiThemeContext, 's'), ";;label:s;"),
    m: /*#__PURE__*/css(euiTitle(euiThemeContext, 'm'), ";;label:m;"),
    l: /*#__PURE__*/css(euiTitle(euiThemeContext, 'l'), ";;label:l;")
  };
};