/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React from 'react';
import { EuiAvatar } from '../avatar';
import { useEuiTheme } from '../../services';
import { euiTimelineItemIconStyles } from './timeline_item_icon.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTimelineItemIcon = function EuiTimelineItemIcon(_ref) {
  var icon = _ref.icon,
      _ref$verticalAlign = _ref.verticalAlign,
      verticalAlign = _ref$verticalAlign === void 0 ? 'center' : _ref$verticalAlign,
      iconAriaLabel = _ref.iconAriaLabel;
  var euiTheme = useEuiTheme();
  var styles = euiTimelineItemIconStyles(euiTheme);
  var cssStyles = [styles.euiTimelineItemIcon, styles[verticalAlign]];
  var cssContentStyles = styles.euiTimelineItemIcon__content;
  var ariaLabel = iconAriaLabel ? iconAriaLabel : '';
  var iconRender = typeof icon === 'string' ? ___EmotionJSX(EuiAvatar, {
    color: "subdued",
    name: ariaLabel,
    iconType: icon
  }) : icon;
  return ___EmotionJSX("div", {
    css: cssStyles
  }, ___EmotionJSX("div", {
    css: cssContentStyles
  }, iconRender));
};