import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["size", "color", "grow", "textAlign", "children", "className"];

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../services';
import { euiTextStyles } from './text.styles';
import { EuiTextColor } from './text_color';
import { EuiTextAlign } from './text_align';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var TEXT_SIZES = ['xs', 's', 'm', 'relative'];
export var EuiText = function EuiText(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      color = _ref.color,
      _ref$grow = _ref.grow,
      grow = _ref$grow === void 0 ? true : _ref$grow,
      textAlign = _ref.textAlign,
      children = _ref.children,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  var euiTheme = useEuiTheme();
  var styles = euiTextStyles(euiTheme);
  var cssStyles = [styles.euiText, !grow ? styles.constrainedWidth : undefined, styles[size]];
  var classes = classNames('euiText', className);

  var text = ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), children);

  if (color) {
    text = ___EmotionJSX(EuiTextColor, {
      color: color,
      className: classes,
      cloneElement: true
    }, text);
  }

  if (textAlign) {
    text = ___EmotionJSX(EuiTextAlign, {
      textAlign: textAlign,
      className: classes,
      cloneElement: true
    }, text);
  }

  return text;
};