import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["onItemClick", "onBlur", "onFocus", "onInput", "onSearch", "status", "append", "tooltipContent", "suggestions", "id", "aria-label", "aria-labelledby", "isVirtualized", "fullWidth", "maxHeight"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { useState, useCallback } from 'react';
import classNames from 'classnames';
import { useGeneratedHtmlId } from '../../services';
import { EuiScreenReaderOnly } from '../accessibility';
import { EuiIcon } from '../icon';
import { useEuiI18n } from '../i18n';
import { EuiInputPopover } from '../popover';
import { EuiSelectable } from '../selectable';
import { EuiToolTip } from '../tool_tip';
import { EuiSuggestItem } from './suggest_item';
import { jsx as ___EmotionJSX } from "@emotion/react";
var statusMap = {
  unsaved: {
    icon: 'dot',
    color: 'accent'
  },
  saved: {
    icon: 'checkInCircleFilled',
    color: 'success'
  },
  unchanged: {
    icon: '',
    color: 'success'
  },
  loading: {}
}; // keys of _EuiSuggestItemPropsBase

var suggestItemPropsKeys = ['label', 'type', 'description', 'labelDisplay', 'labelWidth', 'descriptionDisplay'];
export var EuiSuggest = function EuiSuggest(_ref) {
  var onItemClick = _ref.onItemClick,
      onBlur = _ref.onBlur,
      onFocus = _ref.onFocus,
      onInput = _ref.onInput,
      onSearch = _ref.onSearch,
      _ref$status = _ref.status,
      status = _ref$status === void 0 ? 'unchanged' : _ref$status,
      append = _ref.append,
      tooltipContent = _ref.tooltipContent,
      suggestions = _ref.suggestions,
      id = _ref.id,
      ariaLabel = _ref['aria-label'],
      labelId = _ref['aria-labelledby'],
      _ref$isVirtualized = _ref.isVirtualized,
      isVirtualized = _ref$isVirtualized === void 0 ? false : _ref$isVirtualized,
      _ref$fullWidth = _ref.fullWidth,
      fullWidth = _ref$fullWidth === void 0 ? true : _ref$fullWidth,
      _ref$maxHeight = _ref.maxHeight,
      maxHeight = _ref$maxHeight === void 0 ? '60vh' : _ref$maxHeight,
      rest = _objectWithoutProperties(_ref, _excluded);

  /**
   * Popover helpers
   */
  var _useState = useState(null),
      _useState2 = _slicedToArray(_useState, 2),
      popoverRef = _useState2[0],
      setPopoverRef = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      isPopoverOpen = _useState4[0],
      setIsPopoverOpen = _useState4[1];

  var openPopover = function openPopover() {
    return setIsPopoverOpen(true);
  };

  var closePopover = function closePopover() {
    return setIsPopoverOpen(false);
  };
  /**
   * Search helpers
   */


  var searchOnFocus = function searchOnFocus(e) {
    onFocus === null || onFocus === void 0 ? void 0 : onFocus(e);
    openPopover();
  };

  var searchOnBlur = function searchOnBlur(e) {
    onBlur === null || onBlur === void 0 ? void 0 : onBlur(e);

    if (!(popoverRef !== null && popoverRef !== void 0 && popoverRef.contains(e.relatedTarget))) {
      closePopover();
    }
  };

  var searchOnInput = function searchOnInput(e) {
    onInput === null || onInput === void 0 ? void 0 : onInput(e.target);
    openPopover();
  };

  var searchOnChange = function searchOnChange(value) {
    onSearch === null || onSearch === void 0 ? void 0 : onSearch(value);
  };

  var inputDescribedbyId = useGeneratedHtmlId({
    prefix: id
  });
  /**
   * Status
   */

  var icon = '';
  var color = '';

  if (statusMap[status]) {
    icon = statusMap[status].icon || '';
    color = statusMap[status].color || '';
  } // EuiFieldText's append accepts an array of elements so start by creating an empty array


  var appendArray = [];

  var _useEuiI18n = useEuiI18n(['euiSuggest.stateSavedTooltip', 'euiSuggest.stateUnsavedTooltip'], ['Saved.', 'Changes have not been saved.']),
      _useEuiI18n2 = _slicedToArray(_useEuiI18n, 2),
      statusSaved = _useEuiI18n2[0],
      statusUnsaved = _useEuiI18n2[1];

  statusMap.saved.tooltip = statusSaved;
  statusMap.unsaved.tooltip = statusUnsaved;

  var statusElement = (status === 'saved' || status === 'unsaved') && ___EmotionJSX(EuiToolTip, {
    position: "left",
    content: tooltipContent || statusMap[status].tooltip
  }, ___EmotionJSX(EuiIcon, {
    className: "euiSuggestInput__statusIcon",
    color: color,
    type: icon
  })); // Push the status element to the array if it is not undefined


  if (statusElement) appendArray.push(statusElement); // Check to see if consumer passed an append item and if so, add it to the array

  if (append) appendArray.push(append);

  var _useEuiI18n3 = useEuiI18n(['euiSuggest.stateLoading', 'euiSuggest.stateSaved', 'euiSuggest.stateUnsaved', 'euiSuggest.stateUnchanged'], ['State: loading.', 'State: saved.', 'State: unsaved.', 'State: unchanged.']),
      _useEuiI18n4 = _slicedToArray(_useEuiI18n3, 4),
      stateLoading = _useEuiI18n4[0],
      stateSaved = _useEuiI18n4[1],
      stateUnsaved = _useEuiI18n4[2],
      stateUnchanged = _useEuiI18n4[3];

  var stateMessageMap = {
    loading: stateLoading,
    saved: stateSaved,
    unsaved: stateUnsaved,
    unchanged: stateUnchanged
  };
  var stateMessage = stateMessageMap[status];
  /**
   * Options list
   */

  var suggestionList = suggestions.map(function (props) {
    // Omit props destined for the EuiSuggestItem so that they don't
    // cause warnings or render in the DOM of the EuiSelectableItem
    var data = {};
    var liProps = {
      label: props.label
    };
    Object.keys(props).forEach(function (key) {
      if (suggestItemPropsKeys.includes(key)) {
        // @ts-ignore string index type
        data[key] = props[key];
      } else {
        // @ts-ignore string index type
        liProps[key] = props[key];
      }
    });
    return _objectSpread(_objectSpread({}, liProps), {}, {
      data: data,
      className: classNames(props.className, 'euiSuggestItemOption'),
      // Force truncation if `isVirtualized` is true
      truncate: isVirtualized ? true : props.truncate
    });
  });
  var renderOption = useCallback(function (props) {
    return ___EmotionJSX(EuiSuggestItem, props);
  }, []);
  var onItemSelect = useCallback(function (options) {
    if (onItemClick) {
      var selectedIndex = options.findIndex(function (option) {
        return option.checked === 'on';
      });

      if (selectedIndex >= 0) {
        var selectedSuggestion = suggestions[selectedIndex];
        onItemClick(selectedSuggestion);
      }
    }
  }, [onItemClick, suggestions]);
  var classes = classNames('euiInputPopover', {
    'euiInputPopover--fullWidth': fullWidth
  });
  return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiSelectable, {
    singleSelection: true,
    height: isVirtualized ? undefined : 'full',
    options: suggestionList,
    renderOption: renderOption,
    onChange: onItemSelect,
    listProps: {
      bordered: false,
      showIcons: false,
      onFocusBadge: false,
      paddingSize: 'none',
      textWrap: isVirtualized ? 'truncate' : 'wrap',
      isVirtualized: isVirtualized
    },
    searchable: true,
    searchProps: _objectSpread({
      id: id,
      append: appendArray.length ? appendArray : undefined,
      fullWidth: fullWidth,
      isLoading: status === 'loading' ? true : false,
      onFocus: searchOnFocus,
      onBlur: searchOnBlur,
      onInput: searchOnInput,
      onChange: searchOnChange,
      'aria-describedby': inputDescribedbyId,
      'aria-label': ariaLabel,
      'aria-labelledby': labelId
    }, rest)
  }, function (list, search) {
    return ___EmotionJSX(EuiInputPopover, {
      disableFocusTrap: true,
      className: classes,
      input: ___EmotionJSX(React.Fragment, null, search),
      isOpen: isPopoverOpen,
      panelPaddingSize: "none",
      fullWidth: fullWidth,
      closePopover: closePopover,
      panelRef: setPopoverRef,
      panelProps: {
        'aria-live': undefined,
        'aria-modal': false,
        role: undefined
      }
    }, ___EmotionJSX("div", {
      style: {
        maxHeight: maxHeight
      },
      className: "eui-yScroll"
    }, list));
  }), ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("p", {
    id: inputDescribedbyId
  }, stateMessage)));
};