import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "description", "isLoading", "reverse", "textAlign", "title", "titleColor", "titleSize", "titleElement", "descriptionElement"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { Fragment, createElement } from 'react';
import classNames from 'classnames';
import { EuiText } from '../text';
import { EuiTitle } from '../title/title';
import { EuiScreenReaderOnly } from '../accessibility';
import { EuiI18n } from '../i18n';
import { useEuiTheme } from '../../services';
import { euiStatStyles, euiStatTitleStyles } from './stat.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var COLORS = ['default', 'subdued', 'primary', 'success', 'danger', 'accent'];
export var ALIGNMENTS = ['left', 'center', 'right'];
export var EuiStat = function EuiStat(_ref) {
  var children = _ref.children,
      className = _ref.className,
      description = _ref.description,
      _ref$isLoading = _ref.isLoading,
      isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
      _ref$reverse = _ref.reverse,
      reverse = _ref$reverse === void 0 ? false : _ref$reverse,
      _ref$textAlign = _ref.textAlign,
      textAlign = _ref$textAlign === void 0 ? 'left' : _ref$textAlign,
      title = _ref.title,
      _ref$titleColor = _ref.titleColor,
      titleColor = _ref$titleColor === void 0 ? 'default' : _ref$titleColor,
      _ref$titleSize = _ref.titleSize,
      titleSize = _ref$titleSize === void 0 ? 'l' : _ref$titleSize,
      _ref$titleElement = _ref.titleElement,
      titleElement = _ref$titleElement === void 0 ? 'p' : _ref$titleElement,
      _ref$descriptionEleme = _ref.descriptionElement,
      descriptionElement = _ref$descriptionEleme === void 0 ? 'p' : _ref$descriptionEleme,
      rest = _objectWithoutProperties(_ref, _excluded);

  var euiTheme = useEuiTheme();
  var styles = euiStatStyles();
  var cssStyles = [styles.euiStat, styles[textAlign]];
  var classes = classNames('euiStat', className);
  var commonProps = {
    'aria-hidden': true
  };

  var descriptionDisplay = ___EmotionJSX(EuiText, {
    size: "s",
    className: "euiStat__description"
  }, /*#__PURE__*/createElement(descriptionElement, commonProps, description));

  var isNamedTitleColor = COLORS.includes(titleColor);
  var titleStyles = euiStatTitleStyles(euiTheme);
  var titleCssStyles = [titleStyles.euiStat__title, isNamedTitleColor && titleStyles[titleColor], isLoading && titleStyles.isLoading];
  var titleProps = isNamedTitleColor ? commonProps : _objectSpread(_objectSpread({}, commonProps), {}, {
    style: {
      color: titleColor
    }
  });
  var titleChildren = isLoading ? '--' : title;

  var titleDisplay = ___EmotionJSX(EuiTitle, {
    size: titleSize,
    className: "euiStat__title",
    css: titleCssStyles
  }, /*#__PURE__*/createElement(titleElement, titleProps, titleChildren));

  var screenReader = ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("p", null, isLoading ? ___EmotionJSX(EuiI18n, {
    token: "euiStat.loadingText",
    default: "Statistic is loading"
  }) : ___EmotionJSX(Fragment, null, reverse ? "".concat(title, " ").concat(description) : "".concat(description, " ").concat(title))));

  var statDisplay = ___EmotionJSX(Fragment, null, !reverse && descriptionDisplay, titleDisplay, reverse && descriptionDisplay, typeof title === 'string' && typeof description === 'string' && screenReader);

  return ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), statDisplay, children);
};