/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css } from '@emotion/react';
import { logicalCSS, euiFontSize } from '../../global_styling';
/**
 * Mixins
 */
// Internal utility for text scales/sizes

var euiScaleMarkdownFormatText = function euiScaleMarkdownFormatText(euiTheme, options) {
  var _euiFontSize = euiFontSize(euiTheme, 'm', options),
      fontSize = _euiFontSize.fontSize,
      lineHeight = _euiFontSize.lineHeight;

  var measurement = options.measurement;
  var lineHeightSize = measurement === 'em' ? "".concat(lineHeight, "em") : lineHeight; // Custom scales

  var fontSizeNumeric = parseFloat(String(fontSize));
  var blockQuoteBorderWidth = fontSizeNumeric / 4;
  var tablePaddingVertical = fontSizeNumeric / 4;
  var tablePaddingHorizontal = fontSizeNumeric / 2;
  return "\n    .euiMarkdownFormat__blockquote {\n      padding: 0 ".concat(fontSize, ";\n      ").concat(logicalCSS('border-left-width', "".concat(blockQuoteBorderWidth).concat(measurement)), "\n      ").concat(logicalCSS('margin-bottom', fontSize), "\n    }\n\n    .euiCheckbox .euiCheckbox__input ~ .euiCheckbox__label { // Extra specificity necessary to override default checkbox CSS\n      font-size: ").concat(fontSize, ";\n      ").concat(logicalCSS('padding-left', lineHeightSize), "\n      line-height: ").concat(lineHeight, ";\n    }\n\n    .euiCheckbox + *:not(.euiCheckbox) {\n      ").concat(logicalCSS('margin-top', fontSize), "\n    }\n\n    .euiMarkdownFormat__codeblockWrapper {\n      ").concat(logicalCSS('margin-bottom', fontSize), "\n    }\n\n    .euiMarkdownFormat__table {\n      ").concat(logicalCSS('margin-bottom', fontSize), "\n    }\n\n    .euiMarkdownFormat__table th,\n    .euiMarkdownFormat__table td {\n      ").concat(logicalCSS('padding-vertical', "".concat(tablePaddingVertical).concat(measurement)), "\n      ").concat(logicalCSS('padding-horizontal', "".concat(tablePaddingHorizontal).concat(measurement)), "\n    }\n  ");
};
/**
 * Styles
 */


export var euiMarkdownFormatStyles = function euiMarkdownFormatStyles(euiTheme) {
  return {
    // TODO: Remaining _markdown_format.scss styles
    euiMarkdownFormat: /*#__PURE__*/css(";label:euiMarkdownFormat;"),
    // Text sizes
    m: /*#__PURE__*/css(euiScaleMarkdownFormatText(euiTheme, {
      measurement: 'rem',
      customScale: 'm'
    }), ";;label:m;"),
    s: /*#__PURE__*/css(euiScaleMarkdownFormatText(euiTheme, {
      measurement: 'rem',
      customScale: 's'
    }), ";;label:s;"),
    xs: /*#__PURE__*/css(euiScaleMarkdownFormatText(euiTheme, {
      measurement: 'rem',
      customScale: 'xs'
    }), ";;label:xs;"),
    relative: /*#__PURE__*/css(euiScaleMarkdownFormatText(euiTheme, {
      measurement: 'em'
    }), ";;label:relative;")
  };
};