import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "size", "margin"];

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../services';
import { euiHorizontalRuleStyles } from './horizontal_rule.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['full', 'half', 'quarter'];
export var MARGINS = ['none', 'xs', 's', 'm', 'l', 'xl', 'xxl'];
var marginToClassNameMap = {
  none: null,
  xs: 'marginXSmall',
  s: 'marginSmall',
  m: 'marginMedium',
  l: 'marginLarge',
  xl: 'marginXLarge',
  xxl: 'marginXXLarge'
};
export var EuiHorizontalRule = function EuiHorizontalRule(_ref) {
  var _classNames;

  var className = _ref.className,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'full' : _ref$size,
      _ref$margin = _ref.margin,
      margin = _ref$margin === void 0 ? 'l' : _ref$margin,
      rest = _objectWithoutProperties(_ref, _excluded);

  var euiTheme = useEuiTheme();
  var styles = euiHorizontalRuleStyles(euiTheme);
  var classes = classNames('euiHorizontalRule', (_classNames = {}, _defineProperty(_classNames, "euiHorizontalRule--".concat(size), size), _defineProperty(_classNames, "euiHorizontalRule--".concat(marginToClassNameMap[margin]), margin && margin !== 'none'), _classNames), className);
  var cssStyles = [styles.euiHorizontalRule, styles[size], styles[margin]];
  return ___EmotionJSX("hr", _extends({
    css: cssStyles,
    className: classes
  }, rest));
};