function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css } from '@emotion/react';
import { useEuiTheme } from '../../services';

var _facetGroupGutterSize = function _facetGroupGutterSize(_ref4) {
  var gutterSize = _ref4.gutterSize,
      layout = _ref4.layout;

  var _useEuiTheme = useEuiTheme(),
      euiTheme = _useEuiTheme.euiTheme;

  var isHorizontalLayout = layout === 'horizontal';
  var gutterHorizontal = "calc(".concat(euiTheme.size.m, " + ").concat(gutterSize, ")");
  var gutterVertical = gutterSize;
  return isHorizontalLayout ? "gap: ".concat(gutterVertical, " ").concat(gutterHorizontal, ";") : "gap: ".concat(gutterVertical, " 0;");
};

var _ref = process.env.NODE_ENV === "production" ? {
  name: "omnk2l-vertical",
  styles: "flex-direction:column;label:vertical;"
} : {
  name: "omnk2l-vertical",
  styles: "flex-direction:column;label:vertical;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "envaaw-horizontal",
  styles: "flex-direction:row;flex-wrap:wrap;label:horizontal;"
} : {
  name: "envaaw-horizontal",
  styles: "flex-direction:row;flex-wrap:wrap;label:horizontal;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "1g68sie-euiFacetGroup",
  styles: "display:flex;flex-grow:1;label:euiFacetGroup;"
} : {
  name: "1g68sie-euiFacetGroup",
  styles: "display:flex;flex-grow:1;label:euiFacetGroup;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

export var euiFacetGroupStyles = function euiFacetGroupStyles(_ref5, layout) {
  var euiTheme = _ref5.euiTheme;
  return {
    // Base
    euiFacetGroup: _ref3,
    // Gutter sizes
    none: /*#__PURE__*/css(_facetGroupGutterSize({
      gutterSize: '0',
      layout: layout
    }), ";label:none;"),
    s: /*#__PURE__*/css(_facetGroupGutterSize({
      gutterSize: euiTheme.size.xs,
      layout: layout
    }), ";label:s;"),
    m: /*#__PURE__*/css(_facetGroupGutterSize({
      gutterSize: euiTheme.size.s,
      layout: layout
    }), ";label:m;"),
    l: /*#__PURE__*/css(_facetGroupGutterSize({
      gutterSize: euiTheme.size.m,
      layout: layout
    }), ";label:l;"),
    // layouts
    horizontal: _ref2,
    vertical: _ref
  };
};