/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css } from '@emotion/react';
import { logicalCSS } from '../../global_styling';
export var euiCallOutStyles = function euiCallOutStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiCallOut: /*#__PURE__*/css(";label:euiCallOut;"),
    euiCallOut__icon: /*#__PURE__*/css("position:relative;", logicalCSS('top', '-1px'), ";", logicalCSS('margin-right', euiTheme.size.s), ";;label:euiCallOut__icon;"),
    euiCallOut__description: /*#__PURE__*/css(":not(:only-child){", logicalCSS('margin-top', euiTheme.size.s), ";};label:euiCallOut__description;")
  };
};
export var euiCallOutHeadingStyles = function euiCallOutHeadingStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    euiCallOutHeader: /*#__PURE__*/css("font-weight:", euiTheme.font.weight.medium, ";margin-bottom:0!important;;label:euiCallOutHeader;"),
    primary: /*#__PURE__*/css("color:", euiTheme.colors.primaryText, ";;label:primary;"),
    success: /*#__PURE__*/css("color:", euiTheme.colors.successText, ";;label:success;"),
    warning: /*#__PURE__*/css("color:", euiTheme.colors.warningText, ";;label:warning;"),
    danger: /*#__PURE__*/css("color:", euiTheme.colors.dangerText, ";;label:danger;")
  };
};