"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERTICAL_ALIGN = exports.EuiTimelineItem = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _timeline_item_event = require("./timeline_item_event");

var _timeline_item_icon = require("./timeline_item_icon");

var _timeline_item = require("./timeline_item.styles");

var _react2 = require("@emotion/react");

var _excluded = ["children", "verticalAlign", "icon", "iconAriaLabel", "className"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var VERTICAL_ALIGN = ['top', 'center'];
exports.VERTICAL_ALIGN = VERTICAL_ALIGN;

var EuiTimelineItem = function EuiTimelineItem(_ref) {
  var children = _ref.children,
      _ref$verticalAlign = _ref.verticalAlign,
      verticalAlign = _ref$verticalAlign === void 0 ? 'center' : _ref$verticalAlign,
      icon = _ref.icon,
      iconAriaLabel = _ref.iconAriaLabel,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  var styles = (0, _timeline_item.euiTimelineItemStyles)();
  var cssStyles = [styles.euiTimelineItem, styles[verticalAlign]];
  return (0, _react2.jsx)("li", _extends({
    css: cssStyles
  }, rest), (0, _react2.jsx)(_timeline_item_icon.EuiTimelineItemIcon, {
    icon: icon,
    iconAriaLabel: iconAriaLabel,
    verticalAlign: verticalAlign
  }), (0, _react2.jsx)(_timeline_item_event.EuiTimelineItemEvent, {
    verticalAlign: verticalAlign
  }, children));
};

exports.EuiTimelineItem = EuiTimelineItem;
EuiTimelineItem.propTypes = {
  /**
     * Vertical alignment of the event with the icon
     */
  verticalAlign: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};