"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrettyDuration = exports.useFormatTimeString = exports.showPrettyDuration = exports.PrettyDuration = void 0;

var _react = _interopRequireDefault(require("react"));

var _datemath = _interopRequireDefault(require("@elastic/datemath"));

var _moment = _interopRequireDefault(require("moment"));

var _i18n = require("../../i18n");

var _date_modes = require("./date_modes");

var _relative_utils = require("./relative_utils");

var _time_options = require("./time_options");

var _react2 = require("@emotion/react");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// eslint-disable-line import/named

/**
 * Pretty duration i18n strings
 * Units should not be simply concatenated because different languages
 * will have different grammar/positions for time than English
 */
var useRelativeDurationI18n = function useRelativeDurationI18n(duration) {
  return {
    s: (0, _i18n.useEuiI18n)('euiPrettyDuration.lastDurationSeconds', function (_ref) {
      var duration = _ref.duration;
      return "Last ".concat(duration, " second").concat(duration === 1 ? '' : 's');
    }, {
      duration: duration
    }),
    's+': (0, _i18n.useEuiI18n)('euiPrettyDuration.nextDurationSeconds', function (_ref2) {
      var duration = _ref2.duration;
      return "Next ".concat(duration, " second").concat(duration === 1 ? '' : 's');
    }, {
      duration: duration
    }),
    m: (0, _i18n.useEuiI18n)('euiPrettyDuration.lastDurationMinutes', function (_ref3) {
      var duration = _ref3.duration;
      return "Last ".concat(duration, " minute").concat(duration === 1 ? '' : 's');
    }, {
      duration: duration
    }),
    'm+': (0, _i18n.useEuiI18n)('euiPrettyDuration.nextDurationMinutes', function (_ref4) {
      var duration = _ref4.duration;
      return "Next ".concat(duration, " minute").concat(duration === 1 ? '' : 's');
    }, {
      duration: duration
    }),
    h: (0, _i18n.useEuiI18n)('euiPrettyDuration.lastDurationHours', function (_ref5) {
      var duration = _ref5.duration;
      return "Last ".concat(duration, " hour").concat(duration === 1 ? '' : 's');
    }, {
      duration: duration
    }),
    'h+': (0, _i18n.useEuiI18n)('euiPrettyDuration.nextDurationHours', function (_ref6) {
      var duration = _ref6.duration;
      return "Next ".concat(duration, " hour").concat(duration === 1 ? '' : 's');
    }, {
      duration: duration
    }),
    d: (0, _i18n.useEuiI18n)('euiPrettyDuration.lastDurationDays', function (_ref7) {
      var duration = _ref7.duration;
      return "Last ".concat(duration, " day").concat(duration === 1 ? '' : 's');
    }, {
      duration: duration
    }),
    'd+': (0, _i18n.useEuiI18n)('euiPrettyDuration.nexttDurationDays', function (_ref8) {
      var duration = _ref8.duration;
      return "Next ".concat(duration, " day").concat(duration === 1 ? '' : 's');
    }, {
      duration: duration
    }),
    w: (0, _i18n.useEuiI18n)('euiPrettyDuration.lastDurationWeeks', function (_ref9) {
      var duration = _ref9.duration;
      return "Last ".concat(duration, " week").concat(duration === 1 ? '' : 's');
    }, {
      duration: duration
    }),
    'w+': (0, _i18n.useEuiI18n)('euiPrettyDuration.nextDurationWeeks', function (_ref10) {
      var duration = _ref10.duration;
      return "Next ".concat(duration, " week").concat(duration === 1 ? '' : 's');
    }, {
      duration: duration
    }),
    M: (0, _i18n.useEuiI18n)('euiPrettyDuration.lastDurationMonths', function (_ref11) {
      var duration = _ref11.duration;
      return "Last ".concat(duration, " month").concat(duration === 1 ? '' : 's');
    }, {
      duration: duration
    }),
    'M+': (0, _i18n.useEuiI18n)('euiPrettyDuration.nextDurationMonths', function (_ref12) {
      var duration = _ref12.duration;
      return "Next ".concat(duration, " month").concat(duration === 1 ? '' : 's');
    }, {
      duration: duration
    }),
    y: (0, _i18n.useEuiI18n)('euiPrettyDuration.lastDurationYears', function (_ref13) {
      var duration = _ref13.duration;
      return "Last ".concat(duration, " year").concat(duration === 1 ? '' : 's');
    }, {
      duration: duration
    }),
    'y+': (0, _i18n.useEuiI18n)('euiPrettyDuration.nextDurationYears', function (_ref14) {
      var duration = _ref14.duration;
      return "Next ".concat(duration, " year").concat(duration === 1 ? '' : 's');
    }, {
      duration: duration
    })
  };
};

var useRelativeDurationRoundedI18n = function useRelativeDurationRoundedI18n(prettyDuration) {
  return {
    s: (0, _i18n.useEuiI18n)('euiPrettyDuration.durationRoundedToSecond', '{prettyDuration} rounded to the second', {
      prettyDuration: prettyDuration
    }),
    m: (0, _i18n.useEuiI18n)('euiPrettyDuration.durationRoundedToMinute', '{prettyDuration} rounded to the minute', {
      prettyDuration: prettyDuration
    }),
    h: (0, _i18n.useEuiI18n)('euiPrettyDuration.durationRoundedToHour', '{prettyDuration} rounded to the hour', {
      prettyDuration: prettyDuration
    }),
    d: (0, _i18n.useEuiI18n)('euiPrettyDuration.durationRoundedToDay', '{prettyDuration} rounded to the day', {
      prettyDuration: prettyDuration
    }),
    w: (0, _i18n.useEuiI18n)('euiPrettyDuration.durationRoundedToWeek', '{prettyDuration} rounded to the week', {
      prettyDuration: prettyDuration
    }),
    M: (0, _i18n.useEuiI18n)('euiPrettyDuration.durationRoundedToMonth', '{prettyDuration} rounded to the month', {
      prettyDuration: prettyDuration
    }),
    y: (0, _i18n.useEuiI18n)('euiPrettyDuration.durationRoundedToYear', '{prettyDuration} rounded to the year', {
      prettyDuration: prettyDuration
    })
  };
};
/**
 * Reusable format time string util
 */


var ISO_FORMAT = 'YYYY-MM-DDTHH:mm:ss.SSSZ';

var useFormatTimeString = function useFormatTimeString(timeString, dateFormat) {
  var roundUp = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  var locale = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'en';
  // i18n'd strings
  var nowDisplay = (0, _i18n.useEuiI18n)('euiPrettyDuration.now', 'now');
  var invalidDateDisplay = (0, _i18n.useEuiI18n)('euiPrettyDuration.invalid', 'Invalid date');
  var timeAsMoment = (0, _moment.default)(timeString, ISO_FORMAT, true);

  if (timeAsMoment.isValid()) {
    return timeAsMoment.locale(locale).format(dateFormat);
  }

  if (timeString === 'now') {
    return nowDisplay;
  }

  var tryParse = _datemath.default.parse(timeString, {
    roundUp: roundUp
  });

  if (!(0, _moment.default)(tryParse).isValid()) {
    return invalidDateDisplay;
  }

  if (_moment.default.isMoment(tryParse)) {
    return "~ ".concat(tryParse.locale(locale).fromNow());
  }

  return timeString;
};
/**
 * Pretty duration hook+component
 */


exports.useFormatTimeString = useFormatTimeString;

var usePrettyDuration = function usePrettyDuration(_ref15) {
  var timeFrom = _ref15.timeFrom,
      timeTo = _ref15.timeTo,
      quickRanges = _ref15.quickRanges,
      dateFormat = _ref15.dateFormat;
  var prettyDuration = '';
  /**
   * If it's a quick range, use the quick range label
   */

  var _useI18nTimeOptions = (0, _time_options.useI18nTimeOptions)(),
      commonDurationRanges = _useI18nTimeOptions.commonDurationRanges;

  var matchingQuickRange = hasRangeMatch(timeFrom, timeTo, quickRanges || commonDurationRanges);

  if (matchingQuickRange && matchingQuickRange.label) {
    prettyDuration = matchingQuickRange.label;
  }
  /**
   * Otherwise if it's a relative (possibly rounded) duration, figure out
   * a pretty i18n'd duration to display
   */


  var relativeDuration = 0;
  var relativeParts = {};

  if (isRelativeToNow(timeFrom, timeTo)) {
    if ((0, _date_modes.getDateMode)(timeTo) === _date_modes.DATE_MODES.NOW) {
      relativeParts = (0, _relative_utils.parseRelativeParts)(timeFrom);
    } else {
      relativeParts = (0, _relative_utils.parseRelativeParts)(timeTo);
    }

    relativeDuration = relativeParts.count;
  }

  var relativeDurationI18n = useRelativeDurationI18n(relativeDuration);
  var relativeDurationString = relativeParts.unit ? relativeDurationI18n[relativeParts.unit] : '';
  var roundedDurationI18n = useRelativeDurationRoundedI18n(relativeDurationString);
  var roundedDurationString = relativeParts.round && relativeParts.roundUnit ? roundedDurationI18n[relativeParts.roundUnit] : '';

  if (!prettyDuration) {
    prettyDuration = roundedDurationString || relativeDurationString;
  }
  /**
   * If it's none of the above, display basic fallback copy
   */


  var displayFrom = useFormatTimeString(timeFrom, dateFormat);
  var displayTo = useFormatTimeString(timeTo, dateFormat, true);
  var fallbackDuration = (0, _i18n.useEuiI18n)('euiPrettyDuration.fallbackDuration', '{displayFrom} to {displayTo}', {
    displayFrom: displayFrom,
    displayTo: displayTo
  });

  if (!prettyDuration) {
    prettyDuration = fallbackDuration;
  }

  return prettyDuration;
};

exports.usePrettyDuration = usePrettyDuration;

var PrettyDuration = function PrettyDuration(_ref16) {
  var timeFrom = _ref16.timeFrom,
      timeTo = _ref16.timeTo,
      quickRanges = _ref16.quickRanges,
      dateFormat = _ref16.dateFormat;
  var prettyDuration = usePrettyDuration({
    timeFrom: timeFrom,
    timeTo: timeTo,
    quickRanges: quickRanges,
    dateFormat: dateFormat
  });
  return (0, _react2.jsx)(_react.default.Fragment, null, prettyDuration);
};
/**
 * Non-hook utils
 */


exports.PrettyDuration = PrettyDuration;

var hasRangeMatch = function hasRangeMatch(timeFrom, timeTo, ranges) {
  return ranges.find(function (_ref17) {
    var start = _ref17.start,
        end = _ref17.end;
    return timeFrom === start && timeTo === end;
  });
};

var isRelativeToNow = function isRelativeToNow(timeFrom, timeTo) {
  var fromDateMode = (0, _date_modes.getDateMode)(timeFrom);
  var toDateMode = (0, _date_modes.getDateMode)(timeTo);
  var isLast = fromDateMode === _date_modes.DATE_MODES.RELATIVE && toDateMode === _date_modes.DATE_MODES.NOW;
  var isNext = fromDateMode === _date_modes.DATE_MODES.NOW && toDateMode === _date_modes.DATE_MODES.RELATIVE;
  return isLast || isNext;
};

var showPrettyDuration = function showPrettyDuration(timeFrom, timeTo, quickRanges) {
  if (hasRangeMatch(timeFrom, timeTo, quickRanges)) {
    return true;
  }

  return isRelativeToNow(timeFrom, timeTo);
};

exports.showPrettyDuration = showPrettyDuration;