/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css } from '@emotion/react';
import { shade, tint, transparentize, useEuiTheme } from '../../../../services';
export var BUTTON_COLORS = ['text', 'accent', 'primary', 'success', 'warning', 'danger', 'disabled'];
export var euiButtonColor = function euiButtonColor(color, _ref) {
  var euiTheme = _ref.euiTheme,
      colorMode = _ref.colorMode;

  function tintOrShade(color) {
    return colorMode === 'DARK' ? shade(color, 0.7) : tint(color, 0.8);
  }

  switch (color) {
    case 'disabled':
      return transparentize(euiTheme.colors.lightShade, 0.15);

    case 'text':
      return colorMode === 'DARK' ? shade(euiTheme.colors.lightShade, 0.2) : tint(euiTheme.colors.lightShade, 0.5);

    default:
      return tintOrShade(euiTheme.colors[color]);
  }
};
export var useEuiButtonColorCSS = function useEuiButtonColorCSS() {
  var euiTheme = useEuiTheme();
  return {
    text: /*#__PURE__*/css("background-color:", euiButtonColor('text', euiTheme), ";;label:text;"),
    accent: /*#__PURE__*/css("background-color:", euiButtonColor('accent', euiTheme), ";;label:accent;"),
    primary: /*#__PURE__*/css("background-color:", euiButtonColor('primary', euiTheme), ";;label:primary;"),
    success: /*#__PURE__*/css("background-color:", euiButtonColor('success', euiTheme), ";;label:success;"),
    warning: /*#__PURE__*/css("background-color:", euiButtonColor('warning', euiTheme), ";;label:warning;"),
    danger: /*#__PURE__*/css("background-color:", euiButtonColor('danger', euiTheme), ";;label:danger;"),
    disabled: /*#__PURE__*/css("background-color:", euiButtonColor('disabled', euiTheme), ";;label:disabled;")
  };
};