function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { useEuiTour } from './useEuiTour';
import PropTypes from "prop-types";
export var EuiTour = function EuiTour(_ref) {
  var children = _ref.children,
      steps = _ref.steps,
      initialState = _ref.initialState;

  var _useEuiTour = useEuiTour(steps, initialState),
      _useEuiTour2 = _slicedToArray(_useEuiTour, 3),
      stepProps = _useEuiTour2[0],
      actions = _useEuiTour2[1],
      state = _useEuiTour2[2];

  return children(stepProps, actions, state);
};
EuiTour.propTypes = {
  children: PropTypes.func.isRequired,
  steps: PropTypes.arrayOf(PropTypes.shape({
    className: PropTypes.string,

    /**
       * Provide a name to the popover panel
       */
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,

    /**
       * Class name passed to the direct parent of the button
       */
    anchorClassName: PropTypes.string,

    /**
       * Alignment of the popover and arrow relative to the button
       */
    anchorPosition: PropTypes.any,

    /**
       * Style and position alteration for arrow-less, left-aligned
       * attachment. Intended for use with inputs as anchors, e.g.
       * EuiInputPopover
       */
    attachToAnchor: PropTypes.bool,
    buttonRef: PropTypes.any,

    /**
       * Restrict the popover's position within this element
       */
    container: PropTypes.any,

    /**
       * CSS display type for both the popover and anchor
       */
    display: PropTypes.oneOf(["inlineBlock", "block"]),

    /**
       * Object of props passed to EuiFocusTrap
       */
    focusTrapProps: PropTypes.any,

    /**
       * Show arrow indicating to originating button
       */
    hasArrow: PropTypes.bool,

    /**
       * Specifies what element should initially have focus; Can be a DOM
       * node, or a selector string (which will be passed to
       * document.querySelector() to find the DOM node), or a function that
       * returns a DOM node
       * Set to `false` to prevent initial auto-focus. Use only
       * when your app handles setting initial focus state.
       */
    initialFocus: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.oneOf([false])]),

    /**
       * Passed directly to EuiPortal for DOM positioning. Both properties are
       * required if prop is specified
       */
    insert: PropTypes.shape({
      sibling: PropTypes.any.isRequired,
      position: PropTypes.oneOf(["before", "after"]).isRequired
    }),

    /**
       * Visibility state of the popover
       */
    isOpen: PropTypes.bool,

    /**
       * Traps tab focus within the popover contents
       */
    ownFocus: PropTypes.bool,

    /**
       * Custom class added to the EuiPanel containing the popover contents
       */
    panelClassName: PropTypes.string,

    /**
       * EuiPanel padding on all sides
       */
    panelPaddingSize: PropTypes.any,

    /**
       * Standard DOM `style` attribute. Passed to the EuiPanel
       */
    panelStyle: PropTypes.any,

    /**
       * Object of props passed to EuiPanel
       */
    panelProps: PropTypes.any,
    panelRef: PropTypes.any,

    /**
       * Optional screen reader instructions to announce upon popover open,
       * in addition to EUI's default popover instructions for Escape on close.
       * Useful for popovers that may have additional keyboard capabilities such as
       * arrow navigation.
       */
    popoverScreenReaderText: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.node.isRequired]),
    popoverRef: PropTypes.any,

    /**
       * When `true`, the popover's position is re-calculated when the user
       * scrolls, this supports having fixed-position popover anchors. When nesting
       * an `EuiPopover` in a scrollable container, `repositionOnScroll` should be `true`
       */
    repositionOnScroll: PropTypes.bool,

    /**
       * By default, popover content inherits the z-index of the anchor
       * component; pass `zIndex` to override
       */
    zIndex: PropTypes.number,

    /**
       * Function callback for when the focus trap is deactivated
       */
    onTrapDeactivation: PropTypes.any,

    /**
       * Distance away from the anchor that the popover will render
       */
    offset: PropTypes.number,

    /**
       * Minimum distance between the popover and the bounding container;
       * Pass an array of 4 values to adjust each side differently: `[top, right, bottom, left]`
       * Default is 16
       */
    buffer: PropTypes.oneOfType([PropTypes.number.isRequired, PropTypes.any.isRequired]),

    /**
       * Element to pass as the child element of the arrow;
       * Use case is typically limited to an accompanying `EuiBeacon`
       */
    arrowChildren: PropTypes.node,

    /**
       * Alternative option to `aria-label` that takes an `id`.
       * Usually takes the `id` of the popover title
       */
    "aria-labelledby": PropTypes.string,

    /**
         * Element to which the tour step popover attaches when open
         */
    children: PropTypes.element,
    anchor: PropTypes.any,

    /**
         * Contents of the tour step popover
         */
    content: PropTypes.node.isRequired,

    /**
         * Step will display if set to `true`
         */
    isStepOpen: PropTypes.bool,

    /**
         * Change the default min width of the popover panel
         */
    minWidth: PropTypes.any,

    /**
         * Change the default max width of the popover panel
         */
    maxWidth: PropTypes.any,

    /**
         * Function to call for 'Skip tour' and 'End tour' actions
         */
    onFinish: PropTypes.func.isRequired,

    /**
         * The number of the step within the parent tour. 1-based indexing.
         */
    step: PropTypes.number.isRequired,

    /**
         * The total number of steps in the tour
         */
    stepsTotal: PropTypes.number.isRequired,

    /**
         * Optional, standard DOM `style` attribute. Passed to the EuiPopover panel.
         */
    style: PropTypes.any,

    /**
         * Smaller title text that appears atop each step in the tour. The subtitle gets wrapped in the appropriate heading level.
         */
    subtitle: PropTypes.node,

    /**
         * Larger title text specific to this step. The title gets wrapped in the appropriate heading level.
         */
    title: PropTypes.node.isRequired,

    /**
         * Extra visual indication of step location
         */
    decoration: PropTypes.oneOf(["none", "beacon"]),

    /**
         * Element to replace the 'Skip tour' link in the footer
         */
    footerAction: PropTypes.element
  }).isRequired).isRequired,
  initialState: PropTypes.shape({
    currentTourStep: PropTypes.number.isRequired,
    isTourActive: PropTypes.bool.isRequired,
    tourPopoverWidth: PropTypes.number.isRequired,
    tourSubtitle: PropTypes.string.isRequired
  }).isRequired
};