var _excluded = ["children", "className", "gutterSize", "fullWidth", "ratio", "titleSize", "title", "description", "descriptionFlexItemProps", "fieldFlexItemProps"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiTitle } from '../../title';
import { EuiText } from '../../text';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDescribedFormGroup = function EuiDescribedFormGroup(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$gutterSize = _ref.gutterSize,
      gutterSize = _ref$gutterSize === void 0 ? 'l' : _ref$gutterSize,
      _ref$fullWidth = _ref.fullWidth,
      fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
      _ref$ratio = _ref.ratio,
      ratio = _ref$ratio === void 0 ? 'half' : _ref$ratio,
      _ref$titleSize = _ref.titleSize,
      titleSize = _ref$titleSize === void 0 ? 'xs' : _ref$titleSize,
      title = _ref.title,
      description = _ref.description,
      descriptionFlexItemProps = _ref.descriptionFlexItemProps,
      fieldFlexItemProps = _ref.fieldFlexItemProps,
      rest = _objectWithoutProperties(_ref, _excluded);

  var classes = classNames('euiDescribedFormGroup', {
    'euiDescribedFormGroup--fullWidth': fullWidth
  }, className);
  var fieldClasses = classNames('euiDescribedFormGroup__fields', fieldFlexItemProps && fieldFlexItemProps.className);
  var renderedDescription;

  if (description) {
    // If the description is just a string, wrap it in a paragraph element
    if (typeof description === 'string') {
      description = ___EmotionJSX("p", null, description);
    }

    renderedDescription = ___EmotionJSX(EuiText, {
      size: "s",
      color: "subdued",
      className: "euiDescribedFormGroup__description"
    }, description);
  }

  var fieldGrowth;

  switch (ratio) {
    case 'half':
      fieldGrowth = 1;
      break;

    case 'third':
      fieldGrowth = 2;
      break;

    case 'quarter':
      fieldGrowth = 3;
      break;

    default:
      console.warn('Please provide an allowed ratio to EuiDescribedFromRow');
      break;
  }

  return ___EmotionJSX("div", _extends({
    role: "group",
    className: classes
  }, rest), ___EmotionJSX(EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: gutterSize
  }, ___EmotionJSX(EuiFlexItem, _extends({
    grow: 1
  }, descriptionFlexItemProps, {
    className: classNames('euiDescribedFormGroup__descriptionColumn', descriptionFlexItemProps === null || descriptionFlexItemProps === void 0 ? void 0 : descriptionFlexItemProps.className)
  }), ___EmotionJSX(EuiTitle, {
    size: titleSize,
    className: "euiDescribedFormGroup__title"
  }, title), renderedDescription), ___EmotionJSX(EuiFlexItem, _extends({
    grow: fieldGrowth
  }, fieldFlexItemProps, {
    className: fieldClasses
  }), children)));
};
EuiDescribedFormGroup.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,

  /**
       * One or more `EuiFormRow`s.
       */
  children: PropTypes.node,

  /**
       * Passed to `EuiFlexGroup`.
       */
  gutterSize: PropTypes.oneOf(["none", "xs", "s", "m", "l", "xl"]),

  /**
       * Expand to fill 100% of the parent.
       * Default max-width is 800px.
       */
  fullWidth: PropTypes.bool,

  /**
       * Width ratio of description column compared to field column.
       * Can be used in conjunction with `fullWidth` and
       * may require `fullWidth` to be applied to child elements.
       */
  ratio: PropTypes.oneOf(["half", "third", "quarter"]),

  /**
       * For better accessibility, it's recommended to use an HTML heading.
       */
  title: PropTypes.element.isRequired,

  /**
       * Adjust the visual `size` of the EuiTitle that wraps `title`.
       */
  titleSize: PropTypes.any,

  /**
       * Added as a child of `EuiText`.
       */
  description: PropTypes.node,

  /**
       * For customizing the field container. Extended from `EuiFlexItem`.
       */
  descriptionFlexItemProps: PropTypes.any,
  fieldFlexItemProps: PropTypes.any
};