var _templateObject;

function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import { css, keyframes } from '@emotion/react';
import { euiCanAnimate } from '../../global_styling';
import { shade } from '../../services';
import { euiShadowFlat } from '../../themes/amsterdam/global_styling/mixins';
var euiBottomBarAppear = keyframes(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  0% {\n    transform: translateY(100%);\n    opacity: 0;\n  }\n\n  100% {\n    transform: translateY(0%);\n    opacity: 1;\n  }\n"])));
export var euiBottomBarStyles = function euiBottomBarStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    // Text color needs to be reapplied to properly scope the forced `colorMode`
    euiBottomBar: /*#__PURE__*/css(euiShadowFlat(euiThemeContext), ";background:", shade(euiTheme.colors.lightestShade, 0.5), ";color:", euiTheme.colors.text, ";", euiCanAnimate, "{animation:", euiBottomBarAppear, " ", euiTheme.animation.slow, " ", euiTheme.animation.resistance, ";};label:euiBottomBar;"),
    static: /*#__PURE__*/css(";label:static;"),
    fixed: /*#__PURE__*/css("z-index:", Number(euiTheme.levels.header) - 2, ";;label:fixed;"),
    sticky: /*#__PURE__*/css("z-index:", Number(euiTheme.levels.header) - 2, ";;label:sticky;"),
    // Padding
    s: /*#__PURE__*/css("padding:", euiTheme.size.s, ";;label:s;"),
    m: /*#__PURE__*/css("padding:", euiTheme.size.base, ";;label:m;"),
    l: /*#__PURE__*/css("padding:", euiTheme.size.l, ";;label:l;"),
    none: ''
  };
};