"use strict";

var _synthetics = require("@elastic/synthetics");

var _date_picker = require("../page_objects/date_picker");

var _utils = require("./utils");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const longestMetric = 'uxLongestTask';
const countMetric = 'uxLongTaskCount';
const sumMetric = 'uxSumLongTask';
const longestMetricValue = `Longest long task duration

237 ms`;
const countMetricValue = `No. of long tasks

3`;
const sumMetricValue = `Total long tasks duration

428 ms`;
(0, _synthetics.journey)('UX LongTaskMetrics', async ({
  page,
  params
}) => {
  (0, _synthetics.before)(async () => {
    await (0, _utils.waitForLoadingToFinish)({
      page
    });
  });
  const queryParams = {
    percentile: '50',
    rangeFrom: '2020-05-18T11:51:00.000Z',
    rangeTo: '2021-10-30T06:37:15.536Z'
  };
  const queryString = new URLSearchParams(queryParams).toString();
  const baseUrl = `${params.kibanaUrl}/app/ux`;
  (0, _synthetics.step)('Go to UX Dashboard', async () => {
    await page.goto(`${baseUrl}?${queryString}`, {
      waitUntil: 'networkidle'
    });
    await (0, _utils.loginToKibana)({
      page,
      user: {
        username: 'viewer',
        password: 'changeme'
      }
    });
  });
  (0, _synthetics.step)('Set date range', async () => {
    const datePickerPage = new _date_picker.UXDashboardDatePicker(page);
    await datePickerPage.setDefaultE2eRange();
  });
  (0, _synthetics.step)('Confirm metrics values', async () => {
    // Wait until chart data is loaded
    page.waitForLoadState('networkidle'); // wait for first metric to be shown

    page.waitForSelector(`text="237 ms"`);
    let metric = await (await page.waitForSelector((0, _utils.byTestId)(longestMetric))).innerText();
    (0, _synthetics.expect)(metric).toBe(longestMetricValue);
    metric = await (await page.waitForSelector((0, _utils.byTestId)(countMetric))).innerText();
    (0, _synthetics.expect)(metric).toBe(countMetricValue);
    metric = await (await page.waitForSelector((0, _utils.byTestId)(sumMetric))).innerText();
    (0, _synthetics.expect)(metric).toBe(sumMetricValue);
  });
});