"use strict";

var _synthetics = require("@elastic/synthetics");

var _date_picker = require("../page_objects/date_picker");

var _utils = require("./utils");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const totalPageLoadValue = '4.24 s';
const totalPageLoadLabel = `Total

${totalPageLoadValue}`;
const backendLabel = `Backend

359 ms`;
const frontendLabel = `Frontend

3.88 s`;
const pageViewsLabel = `Total page views

524`;
(0, _synthetics.journey)('UX ClientMetrics', async ({
  page,
  params
}) => {
  (0, _synthetics.before)(async () => {
    await (0, _utils.waitForLoadingToFinish)({
      page
    });
  });
  const queryParams = {
    percentile: '50',
    rangeFrom: '2020-05-18T11:51:00.000Z',
    rangeTo: '2021-10-30T06:37:15.536Z'
  };
  const queryString = new URLSearchParams(queryParams).toString();
  const baseUrl = `${params.kibanaUrl}/app/ux`;
  (0, _synthetics.step)('Go to UX Dashboard', async () => {
    await page.goto(`${baseUrl}?${queryString}`, {
      waitUntil: 'networkidle'
    });
    await (0, _utils.loginToKibana)({
      page,
      user: {
        username: 'viewer',
        password: 'changeme'
      }
    });
  });
  (0, _synthetics.step)('Set date range', async () => {
    const datePickerPage = new _date_picker.UXDashboardDatePicker(page);
    await datePickerPage.setDefaultE2eRange();
  });
  (0, _synthetics.step)('Confirm metrics values', async () => {
    // Wait until chart data is loaded
    page.waitForLoadState('networkidle');
    await page.waitForSelector(`text=${totalPageLoadValue}`);
    const totalPageLoad = await (await page.waitForSelector((0, _utils.byTestId)('uxClientMetrics-totalPageLoad'))).innerText();
    const backend = await (await page.waitForSelector((0, _utils.byTestId)('uxClientMetrics-backend'))).innerText();
    const frontend = await (await page.waitForSelector((0, _utils.byTestId)('uxClientMetrics-frontend'))).innerText();
    const pageViews = await (await page.waitForSelector((0, _utils.byTestId)('uxClientMetrics-pageViews'))).innerText();
    (0, _synthetics.expect)(totalPageLoad).toBe(totalPageLoadLabel);
    (0, _synthetics.expect)(backend).toBe(backendLabel);
    (0, _synthetics.expect)(frontend).toBe(frontendLabel);
    (0, _synthetics.expect)(pageViews).toBe(pageViewsLabel);
  });
});