"use strict";

var _synthetics = require("@elastic/synthetics");

var _date_picker = require("../page_objects/date_picker");

var _utils = require("./utils");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
(0, _synthetics.journey)('Page Views Chart', async ({
  page,
  params
}) => {
  (0, _synthetics.before)(async () => {
    await (0, _utils.waitForLoadingToFinish)({
      page
    });
  });
  const queryParams = {
    percentile: '50',
    rangeFrom: '2020-05-18T11:51:00.000Z',
    rangeTo: '2021-10-30T06:37:15.536Z'
  };
  const queryString = new URLSearchParams(queryParams).toString();
  const baseUrl = `${params.kibanaUrl}/app/ux`;
  (0, _synthetics.step)('Go to UX Dashboard', async () => {
    await page.goto(`${baseUrl}?${queryString}`, {
      waitUntil: 'networkidle'
    });
    await (0, _utils.loginToKibana)({
      page,
      user: {
        username: 'elastic',
        password: 'changeme'
      }
    });
  });
  (0, _synthetics.step)('Set date range', async () => {
    const datePickerPage = new _date_picker.UXDashboardDatePicker(page);
    await datePickerPage.setDefaultE2eRange();
  });
  (0, _synthetics.step)('Check Page Views charts', async () => {
    await page.waitForLoadState('networkidle');
    await page.click('text=Total page viewsSelect an option: No breakdown, is selectedNo breakdown >> button');
    await page.click('button[role="option"]:has-text("Browser")');
    (0, _synthetics.expect)(await page.waitForSelector('text=Chrome'));
    (0, _synthetics.expect)(await page.waitForSelector('text=Chrome Mobile iOS'));
    (0, _synthetics.expect)(await page.waitForSelector('text=Edge'));
    (0, _synthetics.expect)(await page.waitForSelector('text=Safari'));
    (0, _synthetics.expect)(await page.waitForSelector('text=Firefox'));
  });
  (0, _synthetics.step)('can click through to exploratory view', async () => {
    (0, _synthetics.expect)(await page.hover('text=Firefox'));
    await page.click(`.pageViewsChart  ${(0, _utils.byTestId)('embeddablePanelToggleMenuIcon')}`);
    await page.click((0, _utils.byTestId)('embeddablePanelAction-expViewExplore'));
    await page.waitForNavigation();
  });
  (0, _synthetics.step)('renders the chart in exploratory view', async () => {
    await page.waitForLoadState('networkidle');
    (0, _synthetics.expect)(await page.waitForSelector('text=User experience (RUM)'));
    (0, _synthetics.expect)(await page.waitForSelector('text=Page views'));
    (0, _synthetics.expect)(await page.waitForSelector('text=Chrome'));
    (0, _synthetics.expect)(await page.waitForSelector('text=Chrome Mobile iOS'));
    (0, _synthetics.expect)(await page.waitForSelector('text=Edge'));
    (0, _synthetics.expect)(await page.waitForSelector('text=Safari'));
    (0, _synthetics.expect)(await page.waitForSelector('text=Firefox'));
  });
});