"use strict";

var _synthetics = require("@elastic/synthetics");

var _utils = require("../../../../observability/e2e/utils");

var _monitor_management = require("../../page_objects/monitor_management");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
(0, _synthetics.journey)('ManagePrivateLocation', async ({
  page,
  params: {
    kibanaUrl
  }
}) => {
  const uptime = (0, _monitor_management.monitorManagementPageProvider)({
    page,
    kibanaUrl
  });
  (0, _synthetics.before)(async () => {
    await uptime.waitForLoadingToFinish();
  });
  (0, _synthetics.step)('Go to monitor-management', async () => {
    await uptime.navigateToMonitorManagement();
  });
  (0, _synthetics.step)('login to Kibana', async () => {
    await uptime.loginToKibana();
    const invalid = await page.locator(`text=Username or password is incorrect. Please try again.`);
    (0, _synthetics.expect)(await invalid.isVisible()).toBeFalsy();
  });
  (0, _synthetics.step)('enable management', async () => {
    await uptime.enableMonitorManagement();
  });
  (0, _synthetics.step)('Open manage location', async () => {
    await page.click('button:has-text("Private locations")');
  });
  (0, _synthetics.step)('Add two agent policies', async () => {
    await page.click('text=Create agent policy');
    await addAgentPolicy('Fleet test policy');
    await page.click('text=Create agent policy');
    await addAgentPolicy('Fleet test policy 2');
    await page.goBack({
      waitUntil: 'networkidle'
    });
    await page.goBack({
      waitUntil: 'networkidle'
    });
    await page.goBack({
      waitUntil: 'networkidle'
    });
  });
  (0, _synthetics.step)('Add new private location', async () => {
    await page.waitForTimeout(30 * 1000);
    await page.click('button:has-text("Close")');
    await page.click('button:has-text("Private locations")');
    await page.click((0, _utils.byTestId)('addPrivateLocationButton'));
    await addPrivateLocation('Test private location', 'Fleet test policy');
  });
  (0, _synthetics.step)('Add another location', async () => {
    await page.click((0, _utils.byTestId)('addPrivateLocationButton'), _utils.TIMEOUT_60_SEC);
    await page.click('[aria-label="Select agent policy"]');
    await page.isDisabled(`button[role="option"]:has-text("Fleet test policyAgents: 0")`);
    await addPrivateLocation('Test private location 2', 'Fleet test policy 2');
  });

  const addPrivateLocation = async (name, policy) => {
    await page.click('[aria-label="Location name"]');
    await page.fill('[aria-label="Location name"]', name);
    await page.click('[aria-label="Select agent policy"]');
    await page.click(`button[role="option"]:has-text("${policy}Agents: 0")`);
    await page.click('button:has-text("Save")');
  };

  const addAgentPolicy = async name => {
    await page.click('[placeholder="Choose a name"]');
    await page.fill('[placeholder="Choose a name"]', name);
    await page.click('div[role="dialog"] button:has-text("Create agent policy")');
  };
});