"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKibanaPrivilegesFeaturePrivileges = exports.getCasesKibanaFeature = void 0;

var _i18n = require("@kbn/i18n");

var _server = require("../../../../src/core/server");

var _common = require("../../../../src/plugins/data_views/common");

var _common2 = require("../../cases/common");

var _constants = require("../common/constants");

var _saved_objects = require("./saved_objects");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getCasesKibanaFeature = () => {
  const casesCapabilities = (0, _common2.createUICapabilities)();
  return {
    id: _constants.CASES_FEATURE_ID,
    name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.linkSecuritySolutionCaseTitle', {
      defaultMessage: 'Cases'
    }),
    order: 1100,
    category: _server.DEFAULT_APP_CATEGORIES.security,
    app: [_constants.CASES_FEATURE_ID, 'kibana'],
    catalogue: [_constants.APP_ID],
    cases: [_constants.APP_ID],
    privileges: {
      all: {
        app: [_constants.CASES_FEATURE_ID, 'kibana'],
        catalogue: [_constants.APP_ID],
        cases: {
          create: [_constants.APP_ID],
          read: [_constants.APP_ID],
          update: [_constants.APP_ID],
          push: [_constants.APP_ID]
        },
        api: [],
        savedObject: {
          all: [],
          read: []
        },
        ui: casesCapabilities.all
      },
      read: {
        app: [_constants.CASES_FEATURE_ID, 'kibana'],
        catalogue: [_constants.APP_ID],
        cases: {
          read: [_constants.APP_ID]
        },
        api: [],
        savedObject: {
          all: [],
          read: []
        },
        ui: casesCapabilities.read
      }
    },
    subFeatures: [{
      name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.deleteSubFeatureName', {
        defaultMessage: 'Delete'
      }),
      privilegeGroups: [{
        groupType: 'independent',
        privileges: [{
          api: [],
          id: 'cases_delete',
          name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.deleteSubFeatureDetails', {
            defaultMessage: 'Delete cases and comments'
          }),
          includeIn: 'all',
          savedObject: {
            all: [],
            read: []
          },
          cases: {
            delete: [_constants.APP_ID]
          },
          ui: casesCapabilities.delete
        }]
      }]
    }]
  };
}; // Same as the plugin id defined by Cloud Security Posture


exports.getCasesKibanaFeature = getCasesKibanaFeature;
const CLOUD_POSTURE_APP_ID = 'csp'; // Same as the saved-object type for rules defined by Cloud Security Posture

const CLOUD_POSTURE_SAVED_OBJECT_RULE_TYPE = 'csp_rule';

const getKibanaPrivilegesFeaturePrivileges = ruleTypes => ({
  id: _constants.SERVER_APP_ID,
  name: _i18n.i18n.translate('xpack.securitySolution.featureRegistry.linkSecuritySolutionTitle', {
    defaultMessage: 'Security'
  }),
  order: 1100,
  category: _server.DEFAULT_APP_CATEGORIES.security,
  app: [_constants.APP_ID, CLOUD_POSTURE_APP_ID, 'kibana'],
  catalogue: [_constants.APP_ID],
  management: {
    insightsAndAlerting: ['triggersActions']
  },
  alerting: ruleTypes,
  subFeatures: [],
  privileges: {
    all: {
      app: [_constants.APP_ID, CLOUD_POSTURE_APP_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      api: [_constants.APP_ID, 'lists-all', 'lists-read', 'lists-summary', 'rac', 'cloud-security-posture-all', 'cloud-security-posture-read'],
      savedObject: {
        all: ['alert', 'exception-list', 'exception-list-agnostic', _common.DATA_VIEW_SAVED_OBJECT_TYPE, ..._saved_objects.savedObjectTypes, CLOUD_POSTURE_SAVED_OBJECT_RULE_TYPE],
        read: []
      },
      alerting: {
        rule: {
          all: ruleTypes
        },
        alert: {
          all: ruleTypes
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show', 'crud']
    },
    read: {
      app: [_constants.APP_ID, CLOUD_POSTURE_APP_ID, 'kibana'],
      catalogue: [_constants.APP_ID],
      api: [_constants.APP_ID, 'lists-read', 'rac', 'cloud-security-posture-read'],
      savedObject: {
        all: [],
        read: ['exception-list', 'exception-list-agnostic', _common.DATA_VIEW_SAVED_OBJECT_TYPE, ..._saved_objects.savedObjectTypes, CLOUD_POSTURE_SAVED_OBJECT_RULE_TYPE]
      },
      alerting: {
        rule: {
          read: ruleTypes
        },
        alert: {
          all: ruleTypes
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show']
    }
  }
});

exports.getKibanaPrivilegesFeaturePrivileges = getKibanaPrivilegesFeaturePrivileges;