"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.importRulesSchema = exports.importRulesPayloadSchema = void 0;

var t = _interopRequireWildcard(require("io-ts"));

var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");

var _common = require("../common");

var _rule_schemas = require("./rule_schemas");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Differences from this and the createRulesSchema are
 *   - rule_id is required
 *   - id is optional (but ignored in the import code - rule_id is exclusively used for imports)
 *   - immutable is optional but if it is any value other than false it will be rejected
 *   - created_at is optional (but ignored in the import code)
 *   - updated_at is optional (but ignored in the import code)
 *   - created_by is optional (but ignored in the import code)
 *   - updated_by is optional (but ignored in the import code)
 */
const importRulesSchema = t.intersection([_rule_schemas.baseCreateParams, _rule_schemas.createTypeSpecific, t.exact(t.type({
  rule_id: _common.rule_id
})), t.exact(t.partial({
  id: _common.id,
  immutable: _securitysolutionIoTsTypes.OnlyFalseAllowed,
  updated_at: _common.updated_at,
  updated_by: _common.updated_by,
  created_at: _common.created_at,
  created_by: _common.created_by,
  related_integrations: _common.RelatedIntegrationArray,
  required_fields: _common.RequiredFieldArray,
  setup: _common.SetupGuide
}))]);
exports.importRulesSchema = importRulesSchema;
const importRulesPayloadSchema = t.exact(t.type({
  file: t.object
}));
exports.importRulesPayloadSchema = importRulesPayloadSchema;