"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsRunner = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _url = _interopRequireDefault(require("url"));

var _synthetics = require("@elastic/synthetics");

var _create_apm_users = require("../../apm/scripts/create_apm_users/create_apm_users");

var _es_archiver = require("./tasks/es_archiver");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable no-console */
class SyntheticsRunner {
  constructor(getService, params) {
    (0, _defineProperty2.default)(this, "getService", void 0);
    (0, _defineProperty2.default)(this, "kibanaUrl", void 0);
    (0, _defineProperty2.default)(this, "testFilesLoaded", false);
    (0, _defineProperty2.default)(this, "params", void 0);
    this.getService = getService;
    this.kibanaUrl = this.getKibanaUrl();
    this.params = params;
  }

  async setup() {
    await this.createTestUsers();
  }

  async createTestUsers() {
    await (0, _create_apm_users.createApmUsers)({
      elasticsearch: {
        username: 'elastic',
        password: 'changeme'
      },
      kibana: {
        hostname: this.kibanaUrl
      }
    });
  }

  async loadTestFiles(callback) {
    console.log('Loading test files');
    await callback();
    this.testFilesLoaded = true;
    console.log('Successfully loaded test files');
  }

  async loadTestData(e2eDir, dataArchives) {
    try {
      console.log('Loading esArchiver...');
      const esArchiver = this.getService('esArchiver');
      const promises = dataArchives.map(archive => esArchiver.loadIfNeeded(e2eDir + archive));
      await Promise.all([...promises, esArchiver.loadIfNeeded('x-pack/test/functional/es_archives/ml/farequote')]);
    } catch (e) {
      console.log(e);
    }
  }

  getKibanaUrl() {
    const config = this.getService('config');
    return _url.default.format({
      protocol: config.get('servers.kibana.protocol'),
      hostname: config.get('servers.kibana.hostname'),
      port: config.get('servers.kibana.port')
    });
  }

  async run() {
    if (!this.testFilesLoaded) {
      throw new Error('Test files not loaded');
    }

    const {
      headless,
      match,
      pauseOnError
    } = this.params;
    const results = await (0, _synthetics.run)({
      params: {
        kibanaUrl: this.kibanaUrl,
        getService: this.getService
      },
      playwrightOptions: {
        headless,
        chromiumSandbox: false,
        timeout: 60 * 1000
      },
      match: match === 'undefined' ? '' : match,
      pauseOnError
    });
    await this.assertResults(results);
  }

  assertResults(results) {
    Object.entries(results).forEach(([_journey, result]) => {
      if (result.status !== 'succeeded') {
        throw new Error('Tests failed');
      }
    });
  }

  cleanUp() {
    console.log('Removing esArchiver...');
    (0, _es_archiver.esArchiverUnload)('full_heartbeat');
    (0, _es_archiver.esArchiverUnload)('browser');
  }

}

exports.SyntheticsRunner = SyntheticsRunner;