"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _path = _interopRequireDefault(require("path"));

var _synthetics_runner = require("./synthetics_runner");

var _parse_args_params = require("./parse_args_params");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  headless,
  grep,
  bail: pauseOnError
} = _parse_args_params.argv;

async function runE2ETests({
  readConfigFile
}) {
  const kibanaConfig = await readConfigFile(require.resolve("../../synthetics/e2e/config"));
  return { ...kibanaConfig.getAll(),
    testRunner: async ({
      getService
    }) => {
      const syntheticsRunner = new _synthetics_runner.SyntheticsRunner(getService, {
        headless,
        match: grep,
        pauseOnError
      });
      await syntheticsRunner.setup();
      await syntheticsRunner.loadTestData(_path.default.join(__dirname, '../../ux/e2e/fixtures/'), ['rum_8.0.0', 'rum_test_data']);
      await syntheticsRunner.loadTestData(_path.default.join(__dirname, '../../synthetics/e2e/fixtures/es_archiver/'), ['full_heartbeat', 'browser']);
      await syntheticsRunner.loadTestFiles(async () => {
        require('./journeys');
      });
      await syntheticsRunner.run();
    }
  };
} // eslint-disable-next-line import/no-default-export


var _default = runE2ETests;
exports.default = _default;
module.exports = exports.default;