/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window.infra_bundle_jsonpfunction=window.infra_bundle_jsonpfunction||[]).push([[10],{119:function(e,t,a){"use strict";a.d(t,"a",(function(){return l}));var n=a(1),r=a(23);const i={CPUUsage:n.i18n.translate("xpack.infra.waffle.metricOptions.cpuUsageText",{defaultMessage:"CPU usage"}),MemoryUsage:n.i18n.translate("xpack.infra.waffle.metricOptions.memoryUsageText",{defaultMessage:"memory usage"}),InboundTraffic:n.i18n.translate("xpack.infra.waffle.metricOptions.inboundTrafficText",{defaultMessage:"inbound traffic"}),OutboundTraffic:n.i18n.translate("xpack.infra.waffle.metricOptions.outboundTrafficText",{defaultMessage:"outbound traffic"}),LogRate:n.i18n.translate("xpack.infra.waffle.metricOptions.hostLogRateText",{defaultMessage:"log rate"}),Load:n.i18n.translate("xpack.infra.waffle.metricOptions.loadText",{defaultMessage:"load"}),Count:n.i18n.translate("xpack.infra.waffle.metricOptions.countText",{defaultMessage:"count"}),DiskIOReadBytes:n.i18n.translate("xpack.infra.waffle.metricOptions.diskIOReadBytes",{defaultMessage:"disk reads"}),DiskIOWriteBytes:n.i18n.translate("xpack.infra.waffle.metricOptions.diskIOWriteBytes",{defaultMessage:"disk writes"}),s3BucketSize:n.i18n.translate("xpack.infra.waffle.metricOptions.s3BucketSize",{defaultMessage:"bucket size"}),s3TotalRequests:n.i18n.translate("xpack.infra.waffle.metricOptions.s3TotalRequests",{defaultMessage:"total requests"}),s3NumberOfObjects:n.i18n.translate("xpack.infra.waffle.metricOptions.s3NumberOfObjects",{defaultMessage:"number of objects"}),s3DownloadBytes:n.i18n.translate("xpack.infra.waffle.metricOptions.s3DownloadBytes",{defaultMessage:"downloads (bytes)"}),s3UploadBytes:n.i18n.translate("xpack.infra.waffle.metricOptions.s3UploadBytes",{defaultMessage:"uploads (bytes)"}),rdsConnections:n.i18n.translate("xpack.infra.waffle.metricOptions.rdsConnections",{defaultMessage:"connections"}),rdsQueriesExecuted:n.i18n.translate("xpack.infra.waffle.metricOptions.rdsQueriesExecuted",{defaultMessage:"queries executed"}),rdsActiveTransactions:n.i18n.translate("xpack.infra.waffle.metricOptions.rdsActiveTransactions",{defaultMessage:"active transactions"}),rdsLatency:n.i18n.translate("xpack.infra.waffle.metricOptions.rdsLatency",{defaultMessage:"latency"}),sqsMessagesVisible:n.i18n.translate("xpack.infra.waffle.metricOptions.sqsMessagesVisible",{defaultMessage:"messages available"}),sqsMessagesDelayed:n.i18n.translate("xpack.infra.waffle.metricOptions.sqsMessagesDelayed",{defaultMessage:"messages delayed"}),sqsMessagesSent:n.i18n.translate("xpack.infra.waffle.metricOptions.sqsMessagesSent",{defaultMessage:"messages added"}),sqsMessagesEmpty:n.i18n.translate("xpack.infra.waffle.metricOptions.sqsMessagesEmpty",{defaultMessage:"messages returned empty"}),sqsOldestMessage:n.i18n.translate("xpack.infra.waffle.metricOptions.sqsOldestMessage",{defaultMessage:"oldest message"})},s=Object(r.mapValues)(i,(e=>`${e[0].toUpperCase()}${e.slice(1)}`)),l=e=>{switch(e){case"cpu":return{text:s.CPUUsage,textLC:i.CPUUsage,value:"cpu"};case"memory":return{text:s.MemoryUsage,textLC:i.MemoryUsage,value:"memory"};case"rx":return{text:s.InboundTraffic,textLC:i.InboundTraffic,value:"rx"};case"tx":return{text:s.OutboundTraffic,textLC:i.OutboundTraffic,value:"tx"};case"logRate":return{text:s.LogRate,textLC:i.LogRate,value:"logRate"};case"load":return{text:s.Load,textLC:i.Load,value:"load"};case"count":return{text:s.Count,textLC:i.Count,value:"count"};case"diskIOReadBytes":return{text:s.DiskIOReadBytes,textLC:i.DiskIOReadBytes,value:"diskIOReadBytes"};case"diskIOWriteBytes":return{text:s.DiskIOWriteBytes,textLC:i.DiskIOWriteBytes,value:"diskIOWriteBytes"};case"s3BucketSize":return{text:s.s3BucketSize,textLC:i.s3BucketSize,value:"s3BucketSize"};case"s3TotalRequests":return{text:s.s3TotalRequests,textLC:i.s3TotalRequests,value:"s3TotalRequests"};case"s3NumberOfObjects":return{text:s.s3NumberOfObjects,textLC:i.s3NumberOfObjects,value:"s3NumberOfObjects"};case"s3DownloadBytes":return{text:s.s3DownloadBytes,textLC:i.s3DownloadBytes,value:"s3DownloadBytes"};case"s3UploadBytes":return{text:s.s3UploadBytes,textLC:i.s3UploadBytes,value:"s3UploadBytes"};case"rdsConnections":return{text:s.rdsConnections,textLC:i.rdsConnections,value:"rdsConnections"};case"rdsQueriesExecuted":return{text:s.rdsQueriesExecuted,textLC:i.rdsQueriesExecuted,value:"rdsQueriesExecuted"};case"rdsActiveTransactions":return{text:s.rdsActiveTransactions,textLC:i.rdsActiveTransactions,value:"rdsActiveTransactions"};case"rdsLatency":return{text:s.rdsLatency,textLC:i.rdsLatency,value:"rdsLatency"};case"sqsMessagesVisible":return{text:s.sqsMessagesVisible,textLC:i.sqsMessagesVisible,value:"sqsMessagesVisible"};case"sqsMessagesDelayed":return{text:s.sqsMessagesDelayed,textLC:i.sqsMessagesDelayed,value:"sqsMessagesDelayed"};case"sqsMessagesSent":return{text:s.sqsMessagesSent,textLC:i.sqsMessagesSent,value:"sqsMessagesSent"};case"sqsMessagesEmpty":return{text:s.sqsMessagesEmpty,textLC:i.sqsMessagesEmpty,value:"sqsMessagesEmpty"};case"sqsOldestMessage":return{text:s.sqsOldestMessage,textLC:i.sqsOldestMessage,value:"sqsOldestMessage"}}}},134:function(e,t,a){"use strict";a.d(t,"a",(function(){return u}));var n=a(18),r=a(19),i=a(24),s=a(2),l=a(17),o=a(79),c=a(72);function u(e,t,a,u,d,m,p,g,f=!0,b){b=b||{interval:"1m",to:m,from:m-12e5,lookbackSize:5};const{error:h,loading:y,response:E,makeRequest:v}=Object(o.a)("/api/metrics/snapshot","POST",JSON.stringify({metrics:t,groupBy:a,nodeType:u,timerange:b,filterQuery:e,sourceId:d,accountId:p,region:g,includeTimeseries:!0}),(e=>Object(i.pipe)(c.g.decode(e),Object(n.fold)(Object(l.c)(l.a),r.identity))));return Object(s.useEffect)((()=>{(async()=>{f&&await v()})()}),[v,f]),{error:h&&h.message||null,loading:y,nodes:E?E.nodes:[],interval:E?E.interval:"60s",reload:v}}},135:function(e,t,a){"use strict";a.d(t,"a",(function(){return c}));var n=a(23),r=a(31),i=a(72),s=a(116),l=a(33);const o={count:{formatter:r.b.number,template:"{{value}}"},cpu:{formatter:r.b.percent,template:"{{value}}"},memory:{formatter:r.b.percent,template:"{{value}}"},rx:{formatter:r.b.bits,template:"{{value}}/s"},tx:{formatter:r.b.bits,template:"{{value}}/s"},logRate:{formatter:r.b.abbreviatedNumber,template:"{{value}}/s"},diskIOReadBytes:{formatter:r.b.bytes,template:"{{value}}/s"},diskIOWriteBytes:{formatter:r.b.bytes,template:"{{value}}/s"},s3BucketSize:{formatter:r.b.bytes,template:"{{value}}"},s3TotalRequests:{formatter:r.b.abbreviatedNumber,template:"{{value}}"},s3NumberOfObjects:{formatter:r.b.abbreviatedNumber,template:"{{value}}"},s3UploadBytes:{formatter:r.b.bytes,template:"{{value}}"},s3DownloadBytes:{formatter:r.b.bytes,template:"{{value}}"},sqsOldestMessage:{formatter:r.b.number,template:"{{value}} seconds"},rdsLatency:{formatter:r.b.number,template:"{{value}} ms"}},c=e=>t=>{if(i.d.is(e))return Object(s.a)(e)(t);const a=Object(n.get)(o,e.type,o.count);return null==t?"":Object(l.b)(a.formatter,a.template)(t)}},151:function(e,t,a){"use strict";a.d(t,"a",(function(){return s}));var n=a(1);const r=n.i18n.translate("xpack.infra.groupByDisplayNames.availabilityZone",{defaultMessage:"Availability zone"}),i=n.i18n.translate("xpack.infra.groupByDisplayNames.machineType",{defaultMessage:"Machine type"}),s=e=>({"kubernetes.namespace":n.i18n.translate("xpack.infra.groupByDisplayNames.kubernetesNamespace",{defaultMessage:"Namespace"}),"kubernetes.node.name":n.i18n.translate("xpack.infra.groupByDisplayNames.kubernetesNodeName",{defaultMessage:"Node"}),"host.name":n.i18n.translate("xpack.infra.groupByDisplayNames.hostName",{defaultMessage:"Host"}),"cloud.availability_zone":r,"cloud.machine.type":i,"cloud.project.id":n.i18n.translate("xpack.infra.groupByDisplayNames.projectID",{defaultMessage:"Project ID"}),"cloud.provider":n.i18n.translate("xpack.infra.groupByDisplayNames.provider",{defaultMessage:"Cloud provider"}),"service.type":n.i18n.translate("xpack.infra.groupByDisplayNames.serviceType",{defaultMessage:"Service type"}),"aws.cloud.availability_zone":r,"aws.cloud.machine.type":i,"aws.tags":n.i18n.translate("xpack.infra.groupByDisplayNames.tags",{defaultMessage:"Tags"}),"aws.ec2.instance.image.id":n.i18n.translate("xpack.infra.groupByDisplayNames.image",{defaultMessage:"Image"}),"aws.ec2.instance.state.name":n.i18n.translate("xpack.infra.groupByDisplayNames.state.name",{defaultMessage:"State"}),"cloud.region":n.i18n.translate("xpack.infra.groupByDisplayNames.cloud.region",{defaultMessage:"Region"}),"aws.rds.db_instance.class":n.i18n.translate("xpack.infra.groupByDisplayNames.rds.db_instance.class",{defaultMessage:"Instance Class"}),"aws.rds.db_instance.status":n.i18n.translate("xpack.infra.groupByDisplayNames.rds.db_instance.status",{defaultMessage:"Status"})}[e]||e)},158:function(e,t,a){"use strict";a.d(t,"a",(function(){return g})),a.d(t,"b",(function(){return f}));var n=a(2),r=a.n(n),i=a(12),s=a(151),l=a(70),o=a(76),c=a(1),u=a(74),d=a(80);const m=e=>Object(u.b)(e).displayName,p=()=>{const{changeNodeType:e,changeGroupBy:t,changeMetric:a,changeAccount:s,changeRegion:l,changeCustomMetrics:p,nodeType:g}=Object(o.d)(),[f,b]=Object(n.useState)(!1),h=Object(n.useCallback)((()=>b(!1)),[]),y=Object(n.useCallback)((()=>b(!0)),[]),E=Object(n.useCallback)((n=>{h(),e(n),t([]),p([]),s(""),l("");const r=Object(u.b)(n);a({type:r.metrics.defaultSnapshot})}),[h,e,t,p,s,l,a]),v=Object(n.useCallback)((()=>E("host")),[E]),x=Object(n.useCallback)((()=>E("pod")),[E]),k=Object(n.useCallback)((()=>E("container")),[E]),M=Object(n.useCallback)((()=>E("awsEC2")),[E]),O=Object(n.useCallback)((()=>E("awsS3")),[E]),w=Object(n.useCallback)((()=>E("awsRDS")),[E]),j=Object(n.useCallback)((()=>E("awsSQS")),[E]),S=Object(n.useMemo)((()=>[{id:"firstPanel",items:[{"data-test-subj":"goToHost",name:m("host"),onClick:v},{"data-test-subj":"goToPods",name:m("pod"),onClick:x},{"data-test-subj":"goToDocker",name:m("container"),onClick:k},{name:"AWS",panel:"awsPanel"}]},{id:"awsPanel",title:"AWS",items:[{name:m("awsEC2"),onClick:M},{name:m("awsS3"),onClick:O},{name:m("awsRDS"),onClick:w},{name:m("awsSQS"),onClick:j}]}]),[M,w,O,j,k,v,x]),C=Object(n.useMemo)((()=>m(g)),[g]),T=r.a.createElement(d.a,{"data-test-subj":"openInventorySwitcher",onClick:y,label:c.i18n.translate("xpack.infra.waffle.showLabel",{defaultMessage:"Show"})},C);return r.a.createElement(i.EuiPopover,{id:"contextMenu",button:T,isOpen:f,closePopover:h,panelPaddingSize:"none",anchorPosition:"downLeft"},r.a.createElement(i.EuiContextMenu,{initialPanelId:"firstPanel",panels:S}))},g=e=>{const{changeMetric:t,changeGroupBy:a,changeCustomOptions:n,changeAccount:s,changeRegion:c,changeSort:u,customOptions:d,groupBy:m,metric:g,nodeType:f,accountId:b,view:h,region:y,legend:E,sort:v,customMetrics:x,changeCustomMetrics:k}=Object(o.d)(),{createDerivedIndexPattern:M}=Object(l.c)();return r.a.createElement(i.EuiFlexGroup,{responsive:!1,wrap:!0,gutterSize:"m"},r.a.createElement(i.EuiFlexItem,{grow:!1},r.a.createElement(p,null)),e.children({createDerivedIndexPattern:M,changeMetric:t,changeGroupBy:a,changeAccount:s,changeRegion:c,changeCustomOptions:n,changeSort:u,customOptions:d,groupBy:m,sort:v,view:h,metric:g,nodeType:f,region:y,accountId:b,legend:E,customMetrics:x,changeCustomMetrics:k}))},f=e=>({text:Object(s.a)(e),field:e})},175:function(e,t,a){"use strict";a.d(t,"a",(function(){return l}));var n=a(12),r=a(1),i=a(2),s=a.n(i);const l=({options:e,onChange:t,fields:a,errorOptions:l})=>{const o=Object(i.useCallback)((e=>{const a=e.map((e=>e.label));t(a)}),[t]),c=Array.isArray(e.groupBy)?e.groupBy.map((e=>({label:e,color:null!=l&&l.includes(e)?"danger":void 0}))):e.groupBy?[{label:e.groupBy,color:null!=l&&l.includes(e.groupBy)?"danger":void 0}]:[];return s.a.createElement(n.EuiComboBox,{"data-test-subj":"metricsExplorer-groupBy",placeholder:r.i18n.translate("xpack.infra.metricsExplorer.groupByLabel",{defaultMessage:"Everything"}),"aria-label":r.i18n.translate("xpack.infra.metricsExplorer.groupByAriaLabel",{defaultMessage:"Graph per"}),fullWidth:!0,singleSelection:!1,selectedOptions:c,options:a.filter((e=>e.aggregatable&&"string"===e.type)).map((e=>({label:e.name}))),onChange:o,isClearable:!0})}},176:function(e,t,a){"use strict";a.d(t,"a",(function(){return m}));var n=a(10),r=a.n(n),i=a(2),s=a(23),l=a(9),o=a(86),c=a(106),u=a(17),d=a(68);function m(e,t,a,n,m,p,g=!0){var f;const b=null===(f=Object(l.useKibana)().services.http)||void 0===f?void 0:f.fetch,[h,y]=Object(i.useState)(null),[E,v]=Object(i.useState)(!0),[x,k]=Object(i.useState)(null),[M,O]=Object(i.useState)(null),[w,j]=Object(i.useState)(null),S=r.a.parse(n.from),C=r.a.parse(n.to,{roundUp:!0}),[,T]=Object(d.c)({cancelPreviousOn:"creation",createPromise:()=>(v(!0),S&&C?b?t?b?b("/api/infra/metrics_explorer",{method:"POST",body:JSON.stringify({forceInterval:e.forceInterval,dropLastBucket:null==e.dropLastBucket||e.dropLastBucket,metrics:"count"===e.aggregation?[{aggregation:"count"}]:e.metrics.map((e=>({aggregation:e.aggregation,field:e.field}))),groupBy:e.groupBy,afterKey:m,limit:e.limit,indexPattern:t.metricAlias,filterQuery:e.filterQuery&&Object(c.a)(e.filterQuery,a)||void 0,timerange:{...n,from:S.valueOf(),to:C.valueOf()}})}):Promise.reject(new Error("HTTP service is unavailable")):Promise.reject(new Error("Source is unavailable")):Promise.reject(new Error("HTTP service is unavailable")):Promise.reject(new Error("Unalble to parse timerange"))),onResolve:t=>{v(!1);const a=Object(u.b)(o.e)(t);if(a){if(x&&M&&x.pageInfo.afterKey!==a.pageInfo.afterKey&&(r=M,i=e,Object(s.isEqual)(r,i))&&Object(s.isEqual)(n,w)&&m){const{series:e}=x;k({...a,series:[...e,...a.series]})}else k(a);O(e),j(n),y(null)}var r,i},onReject:e=>{y(e),v(!1)}},[t,n,e,p,m]);return Object(i.useEffect)((()=>{g&&T()}),[T,g]),{error:h,loading:E,data:x,loadData:T}}},177:function(e,t,a){"use strict";a.d(t,"b",(function(){return o})),a.d(t,"a",(function(){return u}));var n=a(29),r=a.n(n),i=a(2),s=a.n(i),l=a(77);const o=["cpu","memory","load","rx","tx","logRate"],c=["cloud.availability_zone","cloud.machine.type","cloud.project.id","cloud.provider","service.type"],u=e=>s.a.createElement(l.a,r()({},e,{metricTypes:o,groupByFields:c}))},178:function(e,t,a){"use strict";a.d(t,"b",(function(){return o})),a.d(t,"a",(function(){return u}));var n=a(29),r=a.n(n),i=a(2),s=a.n(i),l=a(77);const o=["cpu","memory","rx","tx"],c=["host.name","cloud.availability_zone","cloud.machine.type","cloud.project.id","cloud.provider","service.type"],u=e=>s.a.createElement(l.a,r()({},e,{metricTypes:o,groupByFields:c}))},179:function(e,t,a){"use strict";a.d(t,"b",(function(){return o})),a.d(t,"a",(function(){return u}));var n=a(29),r=a.n(n),i=a(2),s=a.n(i),l=a(77);const o=["cpu","memory","rx","tx"],c=["kubernetes.namespace","kubernetes.node.name","service.type"],u=e=>s.a.createElement(l.a,r()({},e,{metricTypes:o,groupByFields:c}))},180:function(e,t,a){"use strict";a.d(t,"b",(function(){return c})),a.d(t,"a",(function(){return d}));var n=a(29),r=a.n(n),i=a(2),s=a.n(i),l=a(77),o=a(93);const c=["cpu","rx","tx","diskIOReadBytes","diskIOWriteBytes"],u=["cloud.availability_zone","cloud.machine.type","aws.ec2.instance.image.id","aws.ec2.instance.state.name"],d=e=>s.a.createElement(s.a.Fragment,null,s.a.createElement(o.a,e),s.a.createElement(l.a,r()({},e,{metricTypes:c,groupByFields:u})))},181:function(e,t,a){"use strict";a.d(t,"b",(function(){return c})),a.d(t,"a",(function(){return d}));var n=a(29),r=a.n(n),i=a(2),s=a.n(i),l=a(77),o=a(93);const c=["s3BucketSize","s3NumberOfObjects","s3TotalRequests","s3DownloadBytes","s3UploadBytes"],u=["cloud.region"],d=e=>s.a.createElement(s.a.Fragment,null,s.a.createElement(o.a,e),s.a.createElement(l.a,r()({},e,{metricTypes:c,groupByFields:u})))},182:function(e,t,a){"use strict";a.d(t,"b",(function(){return c})),a.d(t,"a",(function(){return d}));var n=a(29),r=a.n(n),i=a(2),s=a.n(i),l=a(77),o=a(93);const c=["cpu","rdsConnections","rdsQueriesExecuted","rdsActiveTransactions","rdsLatency"],u=["cloud.availability_zone","aws.rds.db_instance.class","aws.rds.db_instance.status"],d=e=>s.a.createElement(s.a.Fragment,null,s.a.createElement(o.a,e),s.a.createElement(l.a,r()({},e,{metricTypes:c,groupByFields:u})))},183:function(e,t,a){"use strict";a.d(t,"b",(function(){return c})),a.d(t,"a",(function(){return d}));var n=a(29),r=a.n(n),i=a(2),s=a.n(i),l=a(77),o=a(93);const c=["sqsMessagesVisible","sqsMessagesDelayed","sqsMessagesSent","sqsMessagesEmpty","sqsOldestMessage"],u=["cloud.region"],d=e=>s.a.createElement(s.a.Fragment,null,s.a.createElement(o.a,e),s.a.createElement(l.a,r()({},e,{metricTypes:c,groupByFields:u})))},223:function(e,t,a){"use strict";e.exports={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]}},224:function(e,t,a){const n=a(223),r={};for(const e of Object.keys(n))r[n[e]]=e;const i={rgb:{channels:3,labels:"rgb"},hsl:{channels:3,labels:"hsl"},hsv:{channels:3,labels:"hsv"},hwb:{channels:3,labels:"hwb"},cmyk:{channels:4,labels:"cmyk"},xyz:{channels:3,labels:"xyz"},lab:{channels:3,labels:"lab"},lch:{channels:3,labels:"lch"},hex:{channels:1,labels:["hex"]},keyword:{channels:1,labels:["keyword"]},ansi16:{channels:1,labels:["ansi16"]},ansi256:{channels:1,labels:["ansi256"]},hcg:{channels:3,labels:["h","c","g"]},apple:{channels:3,labels:["r16","g16","b16"]},gray:{channels:1,labels:["gray"]}};e.exports=i;for(const e of Object.keys(i)){if(!("channels"in i[e]))throw new Error("missing channels property: "+e);if(!("labels"in i[e]))throw new Error("missing channel labels property: "+e);if(i[e].labels.length!==i[e].channels)throw new Error("channel and label counts mismatch: "+e);const{channels:t,labels:a}=i[e];delete i[e].channels,delete i[e].labels,Object.defineProperty(i[e],"channels",{value:t}),Object.defineProperty(i[e],"labels",{value:a})}i.rgb.hsl=function(e){const t=e[0]/255,a=e[1]/255,n=e[2]/255,r=Math.min(t,a,n),i=Math.max(t,a,n),s=i-r;let l,o;i===r?l=0:t===i?l=(a-n)/s:a===i?l=2+(n-t)/s:n===i&&(l=4+(t-a)/s),l=Math.min(60*l,360),l<0&&(l+=360);const c=(r+i)/2;return o=i===r?0:c<=.5?s/(i+r):s/(2-i-r),[l,100*o,100*c]},i.rgb.hsv=function(e){let t,a,n,r,i;const s=e[0]/255,l=e[1]/255,o=e[2]/255,c=Math.max(s,l,o),u=c-Math.min(s,l,o),d=function(e){return(c-e)/6/u+.5};return 0===u?(r=0,i=0):(i=u/c,t=d(s),a=d(l),n=d(o),s===c?r=n-a:l===c?r=1/3+t-n:o===c&&(r=2/3+a-t),r<0?r+=1:r>1&&(r-=1)),[360*r,100*i,100*c]},i.rgb.hwb=function(e){const t=e[0],a=e[1];let n=e[2];const r=i.rgb.hsl(e)[0],s=1/255*Math.min(t,Math.min(a,n));return n=1-1/255*Math.max(t,Math.max(a,n)),[r,100*s,100*n]},i.rgb.cmyk=function(e){const t=e[0]/255,a=e[1]/255,n=e[2]/255,r=Math.min(1-t,1-a,1-n);return[100*((1-t-r)/(1-r)||0),100*((1-a-r)/(1-r)||0),100*((1-n-r)/(1-r)||0),100*r]},i.rgb.keyword=function(e){const t=r[e];if(t)return t;let a,i=1/0;for(const t of Object.keys(n)){const r=(l=n[t],((s=e)[0]-l[0])**2+(s[1]-l[1])**2+(s[2]-l[2])**2);r<i&&(i=r,a=t)}var s,l;return a},i.keyword.rgb=function(e){return n[e]},i.rgb.xyz=function(e){let t=e[0]/255,a=e[1]/255,n=e[2]/255;return t=t>.04045?((t+.055)/1.055)**2.4:t/12.92,a=a>.04045?((a+.055)/1.055)**2.4:a/12.92,n=n>.04045?((n+.055)/1.055)**2.4:n/12.92,[100*(.4124*t+.3576*a+.1805*n),100*(.2126*t+.7152*a+.0722*n),100*(.0193*t+.1192*a+.9505*n)]},i.rgb.lab=function(e){const t=i.rgb.xyz(e);let a=t[0],n=t[1],r=t[2];return a/=95.047,n/=100,r/=108.883,a=a>.008856?a**(1/3):7.787*a+16/116,n=n>.008856?n**(1/3):7.787*n+16/116,r=r>.008856?r**(1/3):7.787*r+16/116,[116*n-16,500*(a-n),200*(n-r)]},i.hsl.rgb=function(e){const t=e[0]/360,a=e[1]/100,n=e[2]/100;let r,i,s;if(0===a)return s=255*n,[s,s,s];r=n<.5?n*(1+a):n+a-n*a;const l=2*n-r,o=[0,0,0];for(let e=0;e<3;e++)i=t+1/3*-(e-1),i<0&&i++,i>1&&i--,s=6*i<1?l+6*(r-l)*i:2*i<1?r:3*i<2?l+(r-l)*(2/3-i)*6:l,o[e]=255*s;return o},i.hsl.hsv=function(e){const t=e[0];let a=e[1]/100,n=e[2]/100,r=a;const i=Math.max(n,.01);return n*=2,a*=n<=1?n:2-n,r*=i<=1?i:2-i,[t,100*(0===n?2*r/(i+r):2*a/(n+a)),(n+a)/2*100]},i.hsv.rgb=function(e){const t=e[0]/60,a=e[1]/100;let n=e[2]/100;const r=Math.floor(t)%6,i=t-Math.floor(t),s=255*n*(1-a),l=255*n*(1-a*i),o=255*n*(1-a*(1-i));switch(n*=255,r){case 0:return[n,o,s];case 1:return[l,n,s];case 2:return[s,n,o];case 3:return[s,l,n];case 4:return[o,s,n];case 5:return[n,s,l]}},i.hsv.hsl=function(e){const t=e[0],a=e[1]/100,n=e[2]/100,r=Math.max(n,.01);let i,s;s=(2-a)*n;const l=(2-a)*r;return i=a*r,i/=l<=1?l:2-l,i=i||0,s/=2,[t,100*i,100*s]},i.hwb.rgb=function(e){const t=e[0]/360;let a=e[1]/100,n=e[2]/100;const r=a+n;let i;r>1&&(a/=r,n/=r);const s=Math.floor(6*t),l=1-n;i=6*t-s,0!=(1&s)&&(i=1-i);const o=a+i*(l-a);let c,u,d;switch(s){default:case 6:case 0:c=l,u=o,d=a;break;case 1:c=o,u=l,d=a;break;case 2:c=a,u=l,d=o;break;case 3:c=a,u=o,d=l;break;case 4:c=o,u=a,d=l;break;case 5:c=l,u=a,d=o}return[255*c,255*u,255*d]},i.cmyk.rgb=function(e){const t=e[0]/100,a=e[1]/100,n=e[2]/100,r=e[3]/100;return[255*(1-Math.min(1,t*(1-r)+r)),255*(1-Math.min(1,a*(1-r)+r)),255*(1-Math.min(1,n*(1-r)+r))]},i.xyz.rgb=function(e){const t=e[0]/100,a=e[1]/100,n=e[2]/100;let r,i,s;return r=3.2406*t+-1.5372*a+-.4986*n,i=-.9689*t+1.8758*a+.0415*n,s=.0557*t+-.204*a+1.057*n,r=r>.0031308?1.055*r**(1/2.4)-.055:12.92*r,i=i>.0031308?1.055*i**(1/2.4)-.055:12.92*i,s=s>.0031308?1.055*s**(1/2.4)-.055:12.92*s,r=Math.min(Math.max(0,r),1),i=Math.min(Math.max(0,i),1),s=Math.min(Math.max(0,s),1),[255*r,255*i,255*s]},i.xyz.lab=function(e){let t=e[0],a=e[1],n=e[2];return t/=95.047,a/=100,n/=108.883,t=t>.008856?t**(1/3):7.787*t+16/116,a=a>.008856?a**(1/3):7.787*a+16/116,n=n>.008856?n**(1/3):7.787*n+16/116,[116*a-16,500*(t-a),200*(a-n)]},i.lab.xyz=function(e){let t,a,n;a=(e[0]+16)/116,t=e[1]/500+a,n=a-e[2]/200;const r=a**3,i=t**3,s=n**3;return a=r>.008856?r:(a-16/116)/7.787,t=i>.008856?i:(t-16/116)/7.787,n=s>.008856?s:(n-16/116)/7.787,t*=95.047,a*=100,n*=108.883,[t,a,n]},i.lab.lch=function(e){const t=e[0],a=e[1],n=e[2];let r;return r=360*Math.atan2(n,a)/2/Math.PI,r<0&&(r+=360),[t,Math.sqrt(a*a+n*n),r]},i.lch.lab=function(e){const t=e[0],a=e[1],n=e[2]/360*2*Math.PI;return[t,a*Math.cos(n),a*Math.sin(n)]},i.rgb.ansi16=function(e,t=null){const[a,n,r]=e;let s=null===t?i.rgb.hsv(e)[2]:t;if(s=Math.round(s/50),0===s)return 30;let l=30+(Math.round(r/255)<<2|Math.round(n/255)<<1|Math.round(a/255));return 2===s&&(l+=60),l},i.hsv.ansi16=function(e){return i.rgb.ansi16(i.hsv.rgb(e),e[2])},i.rgb.ansi256=function(e){const t=e[0],a=e[1],n=e[2];return t===a&&a===n?t<8?16:t>248?231:Math.round((t-8)/247*24)+232:16+36*Math.round(t/255*5)+6*Math.round(a/255*5)+Math.round(n/255*5)},i.ansi16.rgb=function(e){let t=e%10;if(0===t||7===t)return e>50&&(t+=3.5),t=t/10.5*255,[t,t,t];const a=.5*(1+~~(e>50));return[(1&t)*a*255,(t>>1&1)*a*255,(t>>2&1)*a*255]},i.ansi256.rgb=function(e){if(e>=232){const t=10*(e-232)+8;return[t,t,t]}let t;return e-=16,[Math.floor(e/36)/5*255,Math.floor((t=e%36)/6)/5*255,t%6/5*255]},i.rgb.hex=function(e){const t=(((255&Math.round(e[0]))<<16)+((255&Math.round(e[1]))<<8)+(255&Math.round(e[2]))).toString(16).toUpperCase();return"000000".substring(t.length)+t},i.hex.rgb=function(e){const t=e.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);if(!t)return[0,0,0];let a=t[0];3===t[0].length&&(a=a.split("").map((e=>e+e)).join(""));const n=parseInt(a,16);return[n>>16&255,n>>8&255,255&n]},i.rgb.hcg=function(e){const t=e[0]/255,a=e[1]/255,n=e[2]/255,r=Math.max(Math.max(t,a),n),i=Math.min(Math.min(t,a),n),s=r-i;let l,o;return l=s<1?i/(1-s):0,o=s<=0?0:r===t?(a-n)/s%6:r===a?2+(n-t)/s:4+(t-a)/s,o/=6,o%=1,[360*o,100*s,100*l]},i.hsl.hcg=function(e){const t=e[1]/100,a=e[2]/100,n=a<.5?2*t*a:2*t*(1-a);let r=0;return n<1&&(r=(a-.5*n)/(1-n)),[e[0],100*n,100*r]},i.hsv.hcg=function(e){const t=e[1]/100,a=e[2]/100,n=t*a;let r=0;return n<1&&(r=(a-n)/(1-n)),[e[0],100*n,100*r]},i.hcg.rgb=function(e){const t=e[0]/360,a=e[1]/100,n=e[2]/100;if(0===a)return[255*n,255*n,255*n];const r=[0,0,0],i=t%1*6,s=i%1,l=1-s;let o=0;switch(Math.floor(i)){case 0:r[0]=1,r[1]=s,r[2]=0;break;case 1:r[0]=l,r[1]=1,r[2]=0;break;case 2:r[0]=0,r[1]=1,r[2]=s;break;case 3:r[0]=0,r[1]=l,r[2]=1;break;case 4:r[0]=s,r[1]=0,r[2]=1;break;default:r[0]=1,r[1]=0,r[2]=l}return o=(1-a)*n,[255*(a*r[0]+o),255*(a*r[1]+o),255*(a*r[2]+o)]},i.hcg.hsv=function(e){const t=e[1]/100,a=t+e[2]/100*(1-t);let n=0;return a>0&&(n=t/a),[e[0],100*n,100*a]},i.hcg.hsl=function(e){const t=e[1]/100,a=e[2]/100*(1-t)+.5*t;let n=0;return a>0&&a<.5?n=t/(2*a):a>=.5&&a<1&&(n=t/(2*(1-a))),[e[0],100*n,100*a]},i.hcg.hwb=function(e){const t=e[1]/100,a=t+e[2]/100*(1-t);return[e[0],100*(a-t),100*(1-a)]},i.hwb.hcg=function(e){const t=e[1]/100,a=1-e[2]/100,n=a-t;let r=0;return n<1&&(r=(a-n)/(1-n)),[e[0],100*n,100*r]},i.apple.rgb=function(e){return[e[0]/65535*255,e[1]/65535*255,e[2]/65535*255]},i.rgb.apple=function(e){return[e[0]/255*65535,e[1]/255*65535,e[2]/255*65535]},i.gray.rgb=function(e){return[e[0]/100*255,e[0]/100*255,e[0]/100*255]},i.gray.hsl=function(e){return[0,0,e[0]]},i.gray.hsv=i.gray.hsl,i.gray.hwb=function(e){return[0,100,e[0]]},i.gray.cmyk=function(e){return[0,0,0,e[0]]},i.gray.lab=function(e){return[e[0],0,0]},i.gray.hex=function(e){const t=255&Math.round(e[0]/100*255),a=((t<<16)+(t<<8)+t).toString(16).toUpperCase();return"000000".substring(a.length)+a},i.rgb.gray=function(e){return[(e[0]+e[1]+e[2])/3/255*100]}},266:function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var n=a(267),r=a(18);t.ThrowReporter={report:function(e){if(r.isLeft(e))throw new Error(n.PathReporter.report(e).join("\n"))}}},267:function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var n=a(0),r=a(18);function i(e){return void 0!==e.message?e.message:"Invalid value "+("function"==typeof(t=e.value)?n.getFunctionName(t):"number"!=typeof t||isFinite(t)?JSON.stringify(t):isNaN(t)?"NaN":t>0?"Infinity":"-Infinity")+" supplied to "+e.context.map((function(e){return e.key+": "+e.type.name})).join("/");var t}function s(e){return e.map(i)}function l(){return["No errors!"]}t.failure=s,t.success=l,t.PathReporter={report:r.fold(s,l)}},268:function(e){e.exports=JSON.parse('{"job_type":"anomaly_detector","groups":["hosts","metrics"],"description":"Metrics: Hosts - Identify unusual spikes in memory usage across hosts.","analysis_config":{"bucket_span":"15m","detectors":[{"detector_description":"max(\'system.memory.actual.used.pct\')","function":"max","field_name":"system.memory.actual.used.pct","custom_rules":[{"actions":["skip_result"],"conditions":[{"applies_to":"actual","operator":"lt","value":0.1}]}]}],"influencers":["host.name"]},"data_description":{"time_field":"@timestamp"},"analysis_limits":{"model_memory_limit":"64mb"},"custom_settings":{"managed":true,"created_by":"ml-module-metrics-ui-hosts","custom_urls":[{"url_name":"Host Metrics","url_value":"metrics/detail/host/$host.name$?metricTime=(autoReload:!f,refreshInterval:5000,time:(from:%27$earliest$%27,interval:%3E%3D1m,to:%27$latest$%27))"}]}}')},269:function(e){e.exports=JSON.parse('{"job_id":"JOB_ID","indices":["INDEX_PATTERN_NAME"],"indices_options":{"allow_no_indices":true},"query":{"bool":{"must":[{"exists":{"field":"system.memory"}}]}}}')},270:function(e){e.exports=JSON.parse('{"job_type":"anomaly_detector","description":"Metrics: Hosts - Identify unusual spikes in inbound traffic across hosts.","groups":["hosts","metrics"],"analysis_config":{"bucket_span":"15m","detectors":[{"detector_description":"max(bytes_in_derivative)","function":"max","field_name":"bytes_in_derivative"}],"influencers":["host.name"],"summary_count_field_name":"doc_count"},"data_description":{"time_field":"@timestamp"},"analysis_limits":{"model_memory_limit":"32mb"},"custom_settings":{"managed":true,"created_by":"ml-module-metrics-ui-hosts","custom_urls":[{"url_name":"Host Metrics","url_value":"metrics/detail/host/$host.name$?metricTime=(autoReload:!f,refreshInterval:5000,time:(from:%27$earliest$%27,interval:%3E%3D1m,to:%27$latest$%27))"}]}}')},271:function(e){e.exports=JSON.parse('{"job_id":"JOB_ID","indices":["INDEX_PATTERN_NAME"],"indices_options":{"allow_no_indices":true},"query":{"bool":{"must":[{"exists":{"field":"system.network"}}]}},"chunking_config":{"mode":"manual","time_span":"900s"},"aggregations":{"host.name":{"terms":{"field":"host.name","size":100},"aggregations":{"buckets":{"date_histogram":{"field":"@timestamp","fixed_interval":"5m"},"aggregations":{"@timestamp":{"max":{"field":"@timestamp"}},"bytes_in_max":{"max":{"field":"system.network.in.bytes"}},"bytes_in_derivative":{"derivative":{"buckets_path":"bytes_in_max"}},"positive_only":{"bucket_script":{"buckets_path":{"in_derivative":"bytes_in_derivative.value"},"script":"params.in_derivative > 0.0 ? params.in_derivative : 0.0"}}}}}}}}')},272:function(e){e.exports=JSON.parse('{"job_type":"anomaly_detector","description":"Metrics: Hosts - Identify unusual spikes in outbound traffic across hosts.","groups":["hosts","metrics"],"analysis_config":{"bucket_span":"15m","detectors":[{"detector_description":"max(bytes_out_derivative)","function":"max","field_name":"bytes_out_derivative"}],"influencers":["host.name"],"summary_count_field_name":"doc_count"},"data_description":{"time_field":"@timestamp"},"analysis_limits":{"model_memory_limit":"32mb"},"custom_settings":{"managed":true,"created_by":"ml-module-metrics-ui-hosts","custom_urls":[{"url_name":"Host Metrics","url_value":"metrics/detail/host/$host.name$?metricTime=(autoReload:!f,refreshInterval:5000,time:(from:%27$earliest$%27,interval:%3E%3D1m,to:%27$latest$%27))"}]}}')},273:function(e){e.exports=JSON.parse('{"job_id":"JOB_ID","indices":["INDEX_PATTERN_NAME"],"indices_options":{"allow_no_indices":true},"query":{"bool":{"must":[{"exists":{"field":"system.network"}}]}},"chunking_config":{"mode":"manual","time_span":"900s"},"aggregations":{"host.name":{"terms":{"field":"host.name","size":100},"aggregations":{"buckets":{"date_histogram":{"field":"@timestamp","fixed_interval":"5m"},"aggregations":{"@timestamp":{"max":{"field":"@timestamp"}},"bytes_out_max":{"max":{"field":"system.network.out.bytes"}},"bytes_out_derivative":{"derivative":{"buckets_path":"bytes_out_max"}},"positive_only":{"bucket_script":{"buckets_path":{"out_derivative":"bytes_out_derivative.value"},"script":"params.out_derivative > 0.0 ? params.out_derivative : 0.0"}}}}}}}}')},274:function(e){e.exports=JSON.parse('{"job_type":"anomaly_detector","groups":["k8s","metrics"],"description":"Metrics: Kubernetes - Identify unusual spikes in memory usage across Kubernetes pods.","analysis_config":{"bucket_span":"15m","detectors":[{"detector_description":"max(\'kubernetes.pod.memory.usage.node.pct\')","function":"max","field_name":"kubernetes.pod.memory.usage.node.pct","partition_field_name":"kubernetes.namespace","custom_rules":[{"actions":["skip_result"],"conditions":[{"applies_to":"actual","operator":"lt","value":0.1}]}]}],"influencers":["kubernetes.namespace","kubernetes.node.name","kubernetes.pod.uid"]},"data_description":{"time_field":"@timestamp"},"analysis_limits":{"model_memory_limit":"64mb"},"custom_settings":{"managed":true,"created_by":"ml-module-metrics-ui-k8s","custom_urls":[{"url_name":"Pod Metrics","url_value":"metrics/detail/pod/$kubernetes.pod.uid$?metricTime=(autoReload:!f,refreshInterval:5000,time:(from:%27$earliest$%27,interval:%3E%3D1m,to:%27$latest$%27))"}]}}')},275:function(e){e.exports=JSON.parse('{"job_id":"JOB_ID","indices":["INDEX_PATTERN_NAME"],"indices_options":{"allow_no_indices":true},"query":{"bool":{"must":[{"exists":{"field":"kubernetes.pod.uid"}},{"exists":{"field":"kubernetes.pod.memory"}}]}}}')},276:function(e){e.exports=JSON.parse('{"job_type":"anomaly_detector","description":"Metrics: Kubernetes - Identify unusual spikes in inbound traffic across Kubernetes pods.","groups":["k8s","metrics"],"analysis_config":{"bucket_span":"15m","detectors":[{"detector_description":"max(bytes_in_derivative)","function":"max","field_name":"bytes_in_derivative","partition_field_name":"kubernetes.namespace"}],"influencers":["kubernetes.namespace","kubernetes.pod.uid"],"summary_count_field_name":"doc_count"},"data_description":{"time_field":"@timestamp"},"analysis_limits":{"model_memory_limit":"32mb"},"custom_settings":{"managed":true,"created_by":"ml-module-metrics-ui-k8s","custom_urls":[{"url_name":"Pod Metrics","url_value":"metrics/detail/pod/$kubernetes.pod.uid$?metricTime=(autoReload:!f,refreshInterval:5000,time:(from:%27$earliest$%27,interval:%3E%3D1m,to:%27$latest$%27))"}]}}')},277:function(e){e.exports=JSON.parse('{"job_id":"JOB_ID","indices":["INDEX_PATTERN_NAME"],"indices_options":{"allow_no_indices":true},"query":{"bool":{"must":[{"exists":{"field":"kubernetes.pod.network"}}]}},"chunking_config":{"mode":"manual","time_span":"900s"},"aggregations":{"kubernetes.namespace":{"terms":{"field":"kubernetes.namespace","size":25},"aggregations":{"kubernetes.pod.uid":{"terms":{"field":"kubernetes.pod.uid","size":100},"aggregations":{"buckets":{"date_histogram":{"field":"@timestamp","fixed_interval":"5m"},"aggregations":{"@timestamp":{"max":{"field":"@timestamp"}},"bytes_in_max":{"max":{"field":"kubernetes.pod.network.rx.bytes"}},"bytes_in_derivative":{"derivative":{"buckets_path":"bytes_in_max"}},"positive_only":{"bucket_script":{"buckets_path":{"in_derivative":"bytes_in_derivative.value"},"script":"params.in_derivative > 0.0 ? params.in_derivative : 0.0"}}}}}}}}}}')},278:function(e){e.exports=JSON.parse('{"job_type":"anomaly_detector","description":"Metrics: Kubernetes - Identify unusual spikes in outbound traffic across Kubernetes pods.","groups":["k8s","metrics"],"analysis_config":{"bucket_span":"15m","detectors":[{"detector_description":"max(bytes_out_derivative)","function":"max","field_name":"bytes_out_derivative","partition_field_name":"kubernetes.namespace"}],"influencers":["kubernetes.namespace","kubernetes.pod.uid"],"summary_count_field_name":"doc_count"},"data_description":{"time_field":"@timestamp"},"analysis_limits":{"model_memory_limit":"32mb"},"custom_settings":{"managed":true,"created_by":"ml-module-metrics-ui-k8s","custom_urls":[{"url_name":"Pod Metrics","url_value":"metrics/detail/pod/$kubernetes.pod.uid$?metricTime=(autoReload:!f,refreshInterval:5000,time:(from:%27$earliest$%27,interval:%3E%3D1m,to:%27$latest$%27))"}]}}')},279:function(e){e.exports=JSON.parse('{"job_id":"JOB_ID","indices":["INDEX_PATTERN_NAME"],"indices_options":{"allow_no_indices":true},"query":{"bool":{"must":[{"exists":{"field":"kubernetes.pod.network"}}]}},"chunking_config":{"mode":"manual","time_span":"900s"},"aggregations":{"kubernetes.namespace":{"terms":{"field":"kubernetes.namespace","size":25},"aggregations":{"kubernetes.pod.uid":{"terms":{"field":"kubernetes.pod.uid","size":100},"aggregations":{"buckets":{"date_histogram":{"field":"@timestamp","fixed_interval":"5m"},"aggregations":{"@timestamp":{"max":{"field":"@timestamp"}},"bytes_out_max":{"max":{"field":"kubernetes.pod.network.tx.bytes"}},"bytes_out_derivative":{"derivative":{"buckets_path":"bytes_out_max"}},"positive_only":{"bucket_script":{"buckets_path":{"pos_derivative":"bytes_out_derivative.value"},"script":"params.pos_derivative > 0.0 ? params.pos_derivative : 0.0"}}}}}}}}}}')},280:function(e,t,a){const n=a(281),r=a(284),i=["keyword","gray","hex"],s={};for(const e of Object.keys(r))s[[...r[e].labels].sort().join("")]=e;const l={};function o(e,t){if(!(this instanceof o))return new o(e,t);if(t&&t in i&&(t=null),t&&!(t in r))throw new Error("Unknown model: "+t);let a,c;if(null==e)this.model="rgb",this.color=[0,0,0],this.valpha=1;else if(e instanceof o)this.model=e.model,this.color=[...e.color],this.valpha=e.valpha;else if("string"==typeof e){const t=n.get(e);if(null===t)throw new Error("Unable to parse color from string: "+e);this.model=t.model,c=r[this.model].channels,this.color=t.value.slice(0,c),this.valpha="number"==typeof t.value[c]?t.value[c]:1}else if(e.length>0){this.model=t||"rgb",c=r[this.model].channels;const a=Array.prototype.slice.call(e,0,c);this.color=m(a,c),this.valpha="number"==typeof e[c]?e[c]:1}else if("number"==typeof e)this.model="rgb",this.color=[e>>16&255,e>>8&255,255&e],this.valpha=1;else{this.valpha=1;const t=Object.keys(e);"alpha"in e&&(t.splice(t.indexOf("alpha"),1),this.valpha="number"==typeof e.alpha?e.alpha:0);const n=t.sort().join("");if(!(n in s))throw new Error("Unable to parse color from object: "+JSON.stringify(e));this.model=s[n];const{labels:i}=r[this.model],l=[];for(a=0;a<i.length;a++)l.push(e[i[a]]);this.color=m(l)}if(l[this.model])for(c=r[this.model].channels,a=0;a<c;a++){const e=l[this.model][a];e&&(this.color[a]=e(this.color[a]))}this.valpha=Math.max(0,Math.min(1,this.valpha)),Object.freeze&&Object.freeze(this)}o.prototype={toString(){return this.string()},toJSON(){return this[this.model]()},string(e){let t=this.model in n.to?this:this.rgb();t=t.round("number"==typeof e?e:1);const a=1===t.valpha?t.color:[...t.color,this.valpha];return n.to[t.model](a)},percentString(e){const t=this.rgb().round("number"==typeof e?e:1),a=1===t.valpha?t.color:[...t.color,this.valpha];return n.to.rgb.percent(a)},array(){return 1===this.valpha?[...this.color]:[...this.color,this.valpha]},object(){const e={},{channels:t}=r[this.model],{labels:a}=r[this.model];for(let n=0;n<t;n++)e[a[n]]=this.color[n];return 1!==this.valpha&&(e.alpha=this.valpha),e},unitArray(){const e=this.rgb().color;return e[0]/=255,e[1]/=255,e[2]/=255,1!==this.valpha&&e.push(this.valpha),e},unitObject(){const e=this.rgb().object();return e.r/=255,e.g/=255,e.b/=255,1!==this.valpha&&(e.alpha=this.valpha),e},round(e){return e=Math.max(e||0,0),new o([...this.color.map(c(e)),this.valpha],this.model)},alpha(e){return void 0!==e?new o([...this.color,Math.max(0,Math.min(1,e))],this.model):this.valpha},red:u("rgb",0,d(255)),green:u("rgb",1,d(255)),blue:u("rgb",2,d(255)),hue:u(["hsl","hsv","hsl","hwb","hcg"],0,(e=>(e%360+360)%360)),saturationl:u("hsl",1,d(100)),lightness:u("hsl",2,d(100)),saturationv:u("hsv",1,d(100)),value:u("hsv",2,d(100)),chroma:u("hcg",1,d(100)),gray:u("hcg",2,d(100)),white:u("hwb",1,d(100)),wblack:u("hwb",2,d(100)),cyan:u("cmyk",0,d(100)),magenta:u("cmyk",1,d(100)),yellow:u("cmyk",2,d(100)),black:u("cmyk",3,d(100)),x:u("xyz",0,d(95.047)),y:u("xyz",1,d(100)),z:u("xyz",2,d(108.833)),l:u("lab",0,d(100)),a:u("lab",1),b:u("lab",2),keyword(e){return void 0!==e?new o(e):r[this.model].keyword(this.color)},hex(e){return void 0!==e?new o(e):n.to.hex(this.rgb().round().color)},hexa(e){if(void 0!==e)return new o(e);const t=this.rgb().round().color;let a=Math.round(255*this.valpha).toString(16).toUpperCase();return 1===a.length&&(a="0"+a),n.to.hex(t)+a},rgbNumber(){const e=this.rgb().color;return(255&e[0])<<16|(255&e[1])<<8|255&e[2]},luminosity(){const e=this.rgb().color,t=[];for(const[a,n]of e.entries()){const e=n/255;t[a]=e<=.04045?e/12.92:((e+.055)/1.055)**2.4}return.2126*t[0]+.7152*t[1]+.0722*t[2]},contrast(e){const t=this.luminosity(),a=e.luminosity();return t>a?(t+.05)/(a+.05):(a+.05)/(t+.05)},level(e){const t=this.contrast(e);return t>=7?"AAA":t>=4.5?"AA":""},isDark(){const e=this.rgb().color;return(2126*e[0]+7152*e[1]+722*e[2])/1e4<128},isLight(){return!this.isDark()},negate(){const e=this.rgb();for(let t=0;t<3;t++)e.color[t]=255-e.color[t];return e},lighten(e){const t=this.hsl();return t.color[2]+=t.color[2]*e,t},darken(e){const t=this.hsl();return t.color[2]-=t.color[2]*e,t},saturate(e){const t=this.hsl();return t.color[1]+=t.color[1]*e,t},desaturate(e){const t=this.hsl();return t.color[1]-=t.color[1]*e,t},whiten(e){const t=this.hwb();return t.color[1]+=t.color[1]*e,t},blacken(e){const t=this.hwb();return t.color[2]+=t.color[2]*e,t},grayscale(){const e=this.rgb().color,t=.3*e[0]+.59*e[1]+.11*e[2];return o.rgb(t,t,t)},fade(e){return this.alpha(this.valpha-this.valpha*e)},opaquer(e){return this.alpha(this.valpha+this.valpha*e)},rotate(e){const t=this.hsl();let a=t.color[0];return a=(a+e)%360,a=a<0?360+a:a,t.color[0]=a,t},mix(e,t){if(!e||!e.rgb)throw new Error('Argument to "mix" was not a Color instance, but rather an instance of '+typeof e);const a=e.rgb(),n=this.rgb(),r=void 0===t?.5:t,i=2*r-1,s=a.alpha()-n.alpha(),l=((i*s==-1?i:(i+s)/(1+i*s))+1)/2,c=1-l;return o.rgb(l*a.red()+c*n.red(),l*a.green()+c*n.green(),l*a.blue()+c*n.blue(),a.alpha()*r+n.alpha()*(1-r))}};for(const e of Object.keys(r)){if(i.includes(e))continue;const{channels:t}=r[e];o.prototype[e]=function(...t){return this.model===e?new o(this):t.length>0?new o(t,e):new o([...(a=r[this.model][e].raw(this.color),Array.isArray(a)?a:[a]),this.valpha],e);var a},o[e]=function(...a){let n=a[0];return"number"==typeof n&&(n=m(a,t)),new o(n,e)}}function c(e){return function(t){return function(e,t){return Number(e.toFixed(t))}(t,e)}}function u(e,t,a){e=Array.isArray(e)?e:[e];for(const n of e)(l[n]||(l[n]=[]))[t]=a;return e=e[0],function(n){let r;return void 0!==n?(a&&(n=a(n)),r=this[e](),r.color[t]=n,r):(r=this[e]().color[t],a&&(r=a(r)),r)}}function d(e){return function(t){return Math.max(0,Math.min(e,t))}}function m(e,t){for(let a=0;a<t;a++)"number"!=typeof e[a]&&(e[a]=0);return e}e.exports=o},281:function(e,t,a){var n=a(223),r=a(282),i=Object.hasOwnProperty,s={};for(var l in n)i.call(n,l)&&(s[n[l]]=l);var o=e.exports={to:{},get:{}};function c(e,t,a){return Math.min(Math.max(t,e),a)}function u(e){var t=Math.round(e).toString(16).toUpperCase();return t.length<2?"0"+t:t}o.get=function(e){var t,a;switch(e.substring(0,3).toLowerCase()){case"hsl":t=o.get.hsl(e),a="hsl";break;case"hwb":t=o.get.hwb(e),a="hwb";break;default:t=o.get.rgb(e),a="rgb"}return t?{model:a,value:t}:null},o.get.rgb=function(e){if(!e)return null;var t,a,r,s=[0,0,0,1];if(t=e.match(/^#([a-f0-9]{6})([a-f0-9]{2})?$/i)){for(r=t[2],t=t[1],a=0;a<3;a++){var l=2*a;s[a]=parseInt(t.slice(l,l+2),16)}r&&(s[3]=parseInt(r,16)/255)}else if(t=e.match(/^#([a-f0-9]{3,4})$/i)){for(r=(t=t[1])[3],a=0;a<3;a++)s[a]=parseInt(t[a]+t[a],16);r&&(s[3]=parseInt(r+r,16)/255)}else if(t=e.match(/^rgba?\(\s*([+-]?\d+)(?=[\s,])\s*(?:,\s*)?([+-]?\d+)(?=[\s,])\s*(?:,\s*)?([+-]?\d+)\s*(?:[,|\/]\s*([+-]?[\d\.]+)(%?)\s*)?\)$/)){for(a=0;a<3;a++)s[a]=parseInt(t[a+1],0);t[4]&&(t[5]?s[3]=.01*parseFloat(t[4]):s[3]=parseFloat(t[4]))}else{if(!(t=e.match(/^rgba?\(\s*([+-]?[\d\.]+)\%\s*,?\s*([+-]?[\d\.]+)\%\s*,?\s*([+-]?[\d\.]+)\%\s*(?:[,|\/]\s*([+-]?[\d\.]+)(%?)\s*)?\)$/)))return(t=e.match(/^(\w+)$/))?"transparent"===t[1]?[0,0,0,0]:i.call(n,t[1])?((s=n[t[1]])[3]=1,s):null:null;for(a=0;a<3;a++)s[a]=Math.round(2.55*parseFloat(t[a+1]));t[4]&&(t[5]?s[3]=.01*parseFloat(t[4]):s[3]=parseFloat(t[4]))}for(a=0;a<3;a++)s[a]=c(s[a],0,255);return s[3]=c(s[3],0,1),s},o.get.hsl=function(e){if(!e)return null;var t=e.match(/^hsla?\(\s*([+-]?(?:\d{0,3}\.)?\d+)(?:deg)?\s*,?\s*([+-]?[\d\.]+)%\s*,?\s*([+-]?[\d\.]+)%\s*(?:[,|\/]\s*([+-]?(?=\.\d|\d)(?:0|[1-9]\d*)?(?:\.\d*)?(?:[eE][+-]?\d+)?)\s*)?\)$/);if(t){var a=parseFloat(t[4]);return[(parseFloat(t[1])%360+360)%360,c(parseFloat(t[2]),0,100),c(parseFloat(t[3]),0,100),c(isNaN(a)?1:a,0,1)]}return null},o.get.hwb=function(e){if(!e)return null;var t=e.match(/^hwb\(\s*([+-]?\d{0,3}(?:\.\d+)?)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?(?=\.\d|\d)(?:0|[1-9]\d*)?(?:\.\d*)?(?:[eE][+-]?\d+)?)\s*)?\)$/);if(t){var a=parseFloat(t[4]);return[(parseFloat(t[1])%360+360)%360,c(parseFloat(t[2]),0,100),c(parseFloat(t[3]),0,100),c(isNaN(a)?1:a,0,1)]}return null},o.to.hex=function(){var e=r(arguments);return"#"+u(e[0])+u(e[1])+u(e[2])+(e[3]<1?u(Math.round(255*e[3])):"")},o.to.rgb=function(){var e=r(arguments);return e.length<4||1===e[3]?"rgb("+Math.round(e[0])+", "+Math.round(e[1])+", "+Math.round(e[2])+")":"rgba("+Math.round(e[0])+", "+Math.round(e[1])+", "+Math.round(e[2])+", "+e[3]+")"},o.to.rgb.percent=function(){var e=r(arguments),t=Math.round(e[0]/255*100),a=Math.round(e[1]/255*100),n=Math.round(e[2]/255*100);return e.length<4||1===e[3]?"rgb("+t+"%, "+a+"%, "+n+"%)":"rgba("+t+"%, "+a+"%, "+n+"%, "+e[3]+")"},o.to.hsl=function(){var e=r(arguments);return e.length<4||1===e[3]?"hsl("+e[0]+", "+e[1]+"%, "+e[2]+"%)":"hsla("+e[0]+", "+e[1]+"%, "+e[2]+"%, "+e[3]+")"},o.to.hwb=function(){var e=r(arguments),t="";return e.length>=4&&1!==e[3]&&(t=", "+e[3]),"hwb("+e[0]+", "+e[1]+"%, "+e[2]+"%"+t+")"},o.to.keyword=function(e){return s[e.slice(0,3)]}},282:function(e,t,a){"use strict";var n=a(283),r=Array.prototype.concat,i=Array.prototype.slice,s=e.exports=function(e){for(var t=[],a=0,s=e.length;a<s;a++){var l=e[a];n(l)?t=r.call(t,i.call(l)):t.push(l)}return t};s.wrap=function(e){return function(){return e(s(arguments))}}},283:function(e,t){e.exports=function(e){return!(!e||"string"==typeof e)&&(e instanceof Array||Array.isArray(e)||e.length>=0&&(e.splice instanceof Function||Object.getOwnPropertyDescriptor(e,e.length-1)&&"String"!==e.constructor.name))}},284:function(e,t,a){const n=a(224),r=a(285),i={};Object.keys(n).forEach((e=>{i[e]={},Object.defineProperty(i[e],"channels",{value:n[e].channels}),Object.defineProperty(i[e],"labels",{value:n[e].labels});const t=r(e);Object.keys(t).forEach((a=>{const n=t[a];i[e][a]=function(e){const t=function(...t){const a=t[0];if(null==a)return a;a.length>1&&(t=a);const n=e(t);if("object"==typeof n)for(let e=n.length,t=0;t<e;t++)n[t]=Math.round(n[t]);return n};return"conversion"in e&&(t.conversion=e.conversion),t}(n),i[e][a].raw=function(e){const t=function(...t){const a=t[0];return null==a?a:(a.length>1&&(t=a),e(t))};return"conversion"in e&&(t.conversion=e.conversion),t}(n)}))})),e.exports=i},285:function(e,t,a){const n=a(224);function r(e,t){return function(a){return t(e(a))}}function i(e,t){const a=[t[e].parent,e];let i=n[t[e].parent][e],s=t[e].parent;for(;t[s].parent;)a.unshift(t[s].parent),i=r(n[t[s].parent][s],i),s=t[s].parent;return i.conversion=a,i}e.exports=function(e){const t=function(e){const t=function(){const e={},t=Object.keys(n);for(let a=t.length,n=0;n<a;n++)e[t[n]]={distance:-1,parent:null};return e}(),a=[e];for(t[e].distance=0;a.length;){const e=a.pop(),r=Object.keys(n[e]);for(let n=r.length,i=0;i<n;i++){const n=r[i],s=t[n];-1===s.distance&&(s.distance=t[e].distance+1,s.parent=e,a.unshift(n))}}return t}(e),a={},r=Object.keys(t);for(let e=r.length,n=0;n<e;n++){const e=r[n];null!==t[e].parent&&(a[e]=i(e,t))}return a}},287:function(e,t,a){"use strict";a.r(t),a.d(t,"renderApp",(function(){return nc}));var n=a(2),r=a.n(n),i=a(22),s=a.n(i),l=a(51),o=a(55),c=(a(195),a(198)),u=a(189),d=a(29),m=a.n(d),p=a(1),g=a(12),f=a(9),b=a(30),h=a(101),y=a(205),E=a(206),v=a(82),x=a(60),k=a(266),M=a(89);const O=()=>{const{options:e,chartOptions:t,setChartOptions:a,currentTimerange:i,setOptions:s,setTimeRange:l}=Object(n.useContext)(v.c.Context),o=Object(n.useMemo)((()=>({options:e,chartOptions:t,timerange:i})),[e,t,i]),c=e=>{var t;e&&e.options&&(t=e.options,s(t)),e&&e.timerange&&l(e.timerange),e&&e.chartOptions&&a(e.chartOptions)};return r.a.createElement(M.a,{urlState:o,urlStateKey:"metricsExplorer",mapToUrlState:w,onChange:c,onInitialize:c,populateWithInitialState:!0})},w=e=>{const t={};if(e)return e.options&&function(e){const t=v.e.decode(e);try{return k.ThrowReporter.report(t),!0}catch(e){return!1}}(e.options)&&(e.options.source="url",Object(x.set)(t,"options",e.options)),e.timerange&&function(e){const t=v.g.decode(e);try{return k.ThrowReporter.report(t),!0}catch(e){return!1}}(e.timerange)&&Object(x.set)(t,"timerange",e.timerange),e.chartOptions&&function(e){const t=v.f.decode(e);try{return k.ThrowReporter.report(t),!0}catch(e){return!1}}(e.chartOptions)&&Object(x.set)(t,"chartOptions",e.chartOptions),t};var j=a(70);const S=({children:e})=>{const{createSourceConfiguration:t,createDerivedIndexPattern:a,source:r,sourceExists:i,sourceId:s,metricIndicesExist:l,isLoading:o,loadSource:c,hasFailedLoadingSource:u,loadSourceFailureMessage:d,updateSourceConfiguration:m,version:p}=Object(n.useContext)(j.a.Context);return e({create:t,configuration:r&&r.configuration,createDerivedIndexPattern:a,exists:i,hasFailed:u,isLoading:o,lastFailureMessage:d,load:c,metricIndicesExist:l,sourceId:s,update:m,version:p})};var C=a(208),T=a(5),L=a(83);const F=e=>{Object(C.a)(T.f,L.f,e)};var P=a(98),I=a(16),D=a(132),_=a(169),B=a(50),R=a(23),A=a(49),N=a.n(A),V=a(15),z=a(116),$=a(117),U=a(10),q=a.n(U),H=a(21),G=a(7),J=a(109);const W=e=>{const{visible:t,setVisible:a}=e,{triggersActionsUI:i}=Object(n.useContext)(H.a),s=Object(n.useCallback)((()=>a(!1)),[a]),l=Object(n.useMemo)((()=>i&&i.getAddAlertFlyout({consumer:"infrastructure",onClose:s,canChangeTrigger:!1,ruleTypeId:G.e,metadata:{currentOptions:e.options,series:e.series}})),[i,s]);return r.a.createElement(r.a.Fragment,null,t&&l)},K=({onClose:e})=>{const{metricThresholdPrefill:t}=Object(J.b)(),{groupBy:a,filterQuery:n,metrics:i}=t;return r.a.createElement(W,{options:{groupBy:a,filterQuery:n,metrics:i},visible:!0,setVisible:e})};var Q=a(14),X=a(112),Y=a.n(X),Z=a(78),ee=a(220),te=a(31),ae=a(221);const ne="metric*",re=e=>{if("rate"===e.aggregation){const t=Y.a.v1(),a=Y.a.v1(),n=Y.a.v1();return[{id:t,type:"max",field:e.field||void 0},{id:n,type:"derivative",field:t,unit:"1s"},{id:a,type:"positive_only",field:n}]}if("p95"===e.aggregation||"p99"===e.aggregation){const t="p95"===e.aggregation?"95":"99";return[{id:Y.a.v1(),type:"percentile",field:e.field,percentiles:[{id:Y.a.v1(),value:t,mode:"line",percentile:"",shade:.2}]}]}return[{id:Y.a.v1(),type:e.aggregation,field:e.field||void 0}]},ie=e=>t=>{const a=Object(ee.a)(t);return{label:Object(ae.a)(t),axis_position:"right",chart_type:"line",color:t.color&&Object(Z.b)(t.color)||Object(Z.b)(Z.a.color0),fill:e.type===v.b.area?.5:0,formatter:a===te.b.bits?te.b.bytes:a,value_template:"rate"===t.aggregation?"{{value}}/s":"{{value}}",id:Y.a.v1(),line_width:2,metrics:re(t),point_size:0,separate_axis:0,split_mode:"everything",stacked:e.stack?"stacked":"none"}},se=(e,t)=>{const a=[];if(e.filterQuery&&a.push(e.filterQuery),e.groupBy){const n=t.id.replace('"','\\"'),r=Array.isArray(e.groupBy)?e.groupBy.map(((e,a)=>{if(!t.keys)return null;const n=t.keys[a];return n?`${e}: "${n.replace('"','\\"')}"`:null})).join(" and "):`${e.groupBy} : "${n}"`;a.push(r)}return{language:"kuery",query:a.join(" and ")}},le=(e,t,a,n,r)=>{const i=(s=e&&e.metricAlias||ne).split(",").length>1?ne:s;var s;const l={filters:[],linked:!1,query:{language:"kuery",query:""},uiState:{},vis:{aggs:[],params:{axis_formatter:"number",axis_position:"left",axis_scale:"normal",id:Y.a.v1(),default_index_pattern:i,index_pattern:i,interval:"auto",series:t.metrics.map(ie(r)),show_grid:1,show_legend:1,time_field:T.j,type:"timeseries",filter:se(t,a)},title:a.id,type:"metrics"}};r.yAxisMode===v.d.fromZero&&Object(x.set)(l,"vis.params.axis_min",0);const o={refreshInterval:{pause:!0,value:0},time:{from:n.from,to:n.to}};return{app:"visualize",hash:"/create",search:{type:"metrics",_g:Object(Q.encode)(o),_a:Object(Q.encode)(l)}}};var oe=a(133);const ce=(e,t=!1)=>{const a=q.a.parse(e,{roundUp:t});if(!a)throw new Error(`"${e}" is not a valid time string`);return a.valueOf()},ue=(e,t,a,n)=>Object(oe.b)({nodeType:e,nodeId:t,from:ce(a),to:ce(n,!0)}),de=({onFilter:e,options:t,series:a,source:i,timeRange:s,uiCapabilities:l,chartOptions:o})=>{var c,u;const[d,m]=Object(n.useState)(!1),[f,h]=Object(n.useState)(!1),y=null!=t.groupBy&&null!=e,E=Object(n.useCallback)((()=>{y&&e&&(Array.isArray(t.groupBy)?e(t.groupBy.map(((e,t)=>{var n;return`${e}: "${null===(n=a.keys)||void 0===n?void 0:n[t]}"`})).join(" and ")):e(`${t.groupBy}: "${a.id}"`)),m(!1)}),[y,e,t,a.keys,a.id]),v=y?[{name:p.i18n.translate("xpack.infra.metricsExplorer.filterByLabel",{defaultMessage:"Add filter"}),icon:"metricsApp",onClick:E,"data-test-subj":"metricsExplorerAction-AddFilter"}]:[],x=i&&t.groupBy&&((e,t)=>{const a=Array.isArray(t)?t:[t];return a.includes(T.c)?"host":a.includes(T.h)?"pod":a.includes(T.a)?"container":void 0})(0,t.groupBy),k=Object(b.useLinkProps)({app:"metrics",...x?ue(x,a.id,s.from,s.to):{}}),M=Object(b.useLinkProps)({...le(i,t,a,s,o)}),O=x?[{name:p.i18n.translate("xpack.infra.metricsExplorer.viewNodeDetail",{defaultMessage:"View metrics for {name}",values:{name:x}}),icon:"metricsApp",...x?k:{},"data-test-subj":"metricsExplorerAction-ViewNodeMetrics"}]:[],w=[...v,...null!=l&&null!==(c=l.visualize)&&void 0!==c&&c.show?[{name:p.i18n.translate("xpack.infra.metricsExplorer.openInTSVB",{defaultMessage:"Open in Visualize"}),...M,icon:"visualizeApp",disabled:0===t.metrics.length,"data-test-subj":"metricsExplorerAction-OpenInTSVB"}]:[],...O,...null!=l&&null!==(u=l.infrastructure)&&void 0!==u&&u.save?[{name:p.i18n.translate("xpack.infra.metricsExplorer.alerts.createRuleButton",{defaultMessage:"Create threshold rule"}),icon:"bell",onClick(){h(!0)}}]:[]];if(0===w.length)return null;const j=[{id:0,title:"Actions",items:w}],S=p.i18n.translate("xpack.infra.metricsExplorer.actionsLabel.aria",{defaultMessage:"Actions for {grouping}",values:{grouping:a.id}}),C=p.i18n.translate("xpack.infra.metricsExplorer.actionsLabel.button",{defaultMessage:"Actions"}),L=r.a.createElement(g.EuiButtonEmpty,{contentProps:{"aria-label":S},onClick:()=>m(!0),size:"s",iconType:"arrowDown",iconSide:"right"},C);return r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiPopover,{closePopover:()=>m(!1),id:`${a.id}-popover`,button:L,isOpen:d,panelPaddingSize:"none"},r.a.createElement(g.EuiContextMenu,{initialPanelId:0,panels:j}),r.a.createElement(W,{series:a,options:t,setVisible:h,visible:f})))},me=()=>r.a.createElement(g.EuiEmptyPrompt,{iconType:"stats",title:r.a.createElement("h3",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.metricsExplorer.emptyChart.title",defaultMessage:"Chart Data Missing"})),body:r.a.createElement("p",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.metricsExplorer.emptyChart.body",defaultMessage:"Unable to render chart."}))}),pe=()=>r.a.createElement(g.EuiEmptyPrompt,{"data-test-subj":"metricsExplorer-missingMetricMessage",iconType:"stats",title:r.a.createElement("h3",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.metricsExplorer.noMetrics.title",defaultMessage:"Missing Metric"})),body:r.a.createElement("p",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.metricsExplorer.noMetrics.body",defaultMessage:"Please choose a metric above."}))});function ge(e){return e?B.DARK_THEME:B.LIGHT_THEME}function fe(e){return e?B.DARK_THEME:Object(B.mergeWithDefaultTheme)(be,B.LIGHT_THEME)}const be={crosshair:{band:{fill:"#D3DAE6"}},axes:{gridLine:{horizontal:{stroke:"#eaeaea"}}}};var he=a(104),ye=a(118);const Ee=p.i18n.translate("xpack.infra.metricsExplorer.everything",{defaultMessage:"Everything"}),ve=({series:e})=>{if(null!=e.keys){const{keys:t}=e;return r.a.createElement(g.EuiFlexGroup,{gutterSize:"xs"},t.map(((e,a)=>r.a.createElement(n.Fragment,{key:e},r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiText,{size:"m",color:t.length-1>a?"subdued":"default"},r.a.createElement("strong",null,"*"===e?Ee:e))),t.length-1>a&&r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiText,{size:"m",color:"subdued"},r.a.createElement("span",null,"/")))))))}return r.a.createElement("span",null,e.id)},xe=({source:e,options:t,chartOptions:a,series:i,title:s,onFilter:l,height:o=200,width:c="100%",timeRange:u,onTimeChange:d})=>{var m;const p=null===(m=Object(f.useKibana)().services.application)||void 0===m?void 0:m.capabilities,b=Object(f.useUiSetting)("theme:darkMode"),{metrics:h}=t,[y]=Object(he.a)("dateFormat"),E=Object(n.useMemo)((()=>{const e=Object(R.first)(i.rows),t=Object(R.last)(i.rows);return e&&t?Object(B.niceTimeFormatter)([e.timestamp,t.timestamp]):e=>`${e}`}),[i.rows]),x={headerFormatter:Object(n.useCallback)((e=>N()(e.value).format(y||"Y-MM-DD HH:mm:ss.SSS")),[y])},k=Object(n.useCallback)(Object(z.a)(Object(R.first)(h)),[t]),M=Object(ye.a)(i,h,a.stack),O=a.yAxisMode===v.d.fromZero?{...M,min:0}:M;return r.a.createElement("div",{style:{padding:24},"data-test-subj":"metricsExplorer-chart"},t.groupBy?r.a.createElement(g.EuiTitle,{size:"xs"},r.a.createElement(g.EuiFlexGroup,{alignItems:"center"},r.a.createElement(ke,null,r.a.createElement(g.EuiToolTip,{content:s,anchorClassName:"metricsExplorerTitleAnchor"},r.a.createElement(ve,{series:i}))),r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(de,{timeRange:u,options:t,chartOptions:a,series:i,onFilter:l,source:e,uiCapabilities:p})))):r.a.createElement(g.EuiFlexGroup,{justifyContent:"flexEnd"},r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(de,{options:t,chartOptions:a,series:i,source:e,timeRange:u,uiCapabilities:p}))),r.a.createElement("div",{className:"metricsExplorerChart",style:{height:o,width:c}},h.length&&i.rows.length>0?r.a.createElement(B.Chart,null,h.map(((e,t)=>r.a.createElement($.a,{type:a.type,key:t,metric:e,id:t,series:i,stack:a.stack}))),r.a.createElement(B.Axis,{id:"timestamp",position:B.Position.Bottom,showOverlappingTicks:!0,tickFormat:E}),r.a.createElement(B.Axis,{id:"values",position:B.Position.Left,tickFormat:k,domain:O}),r.a.createElement(B.Settings,{tooltip:x,onBrushEnd:({x:e})=>{if(!e)return;const[t,a]=e;d(N()(t).toISOString(),N()(a).toISOString())},theme:ge(b)})):t.metrics.length>0?r.a.createElement(me,null):r.a.createElement(pe,null)))},ke=V.euiStyled.div`
  width: 100%;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
  text-align: left;
  flex: 1 1 auto;
  margin: 12px;
`,Me=({loading:e,data:t,onLoadMore:a,options:n,chartOptions:i,onRefetch:s,onFilter:l,source:o,timeRange:c,onTimeChange:u})=>{if(e)return r.a.createElement(D.a,{height:800,width:"100%",text:p.i18n.translate("xpack.infra.metricsExplorer.loadingCharts",{defaultMessage:"Loading charts"})});if(!t||0===t.series.length)return r.a.createElement(_.a,{titleText:p.i18n.translate("xpack.infra.metricsExplorer.noDataTitle",{defaultMessage:"There is no data to display."}),bodyText:p.i18n.translate("xpack.infra.metricsExplorer.noDataBodyText",{defaultMessage:"Try adjusting your time, filters or group by settings."}),refetchText:p.i18n.translate("xpack.infra.metricsExplorer.noDataRefetchText",{defaultMessage:"Check for new data"}),testString:"metrics-explorer-no-data",onRefetch:s});const d=p.i18n.translate("xpack.infra.metricsExplorer.andLabel",{defaultMessage:'" and "'});return r.a.createElement("div",{style:{width:"100%"}},r.a.createElement(g.EuiFlexGrid,{gutterSize:"s",columns:1===t.series.length?1:3},t.series.map((e=>r.a.createElement(g.EuiFlexItem,{key:e.id,style:{minWidth:0}},r.a.createElement(xe,{key:`chart-${e.id}`,onFilter:l,options:n,chartOptions:i,title:n.groupBy?e.id:null,height:t.series.length>1?200:400,series:e,source:o,timeRange:c,onTimeChange:u}))))),t.series.length>1?r.a.createElement("div",{style:{textAlign:"center",marginBottom:16}},r.a.createElement(g.EuiHorizontalRule,null),r.a.createElement(g.EuiText,{color:"subdued"},r.a.createElement("p",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.metricsExplorer.footerPaginationMessage",defaultMessage:'Displaying {length} of {total} charts grouped by "{groupBy}".',values:{length:t.series.length,total:t.pageInfo.total,groupBy:Array.isArray(n.groupBy)?n.groupBy.join(d):n.groupBy}}))),t.pageInfo.afterKey?r.a.createElement("div",{style:{margin:"16px 0"}},r.a.createElement(g.EuiButton,{isLoading:e,size:"s",onClick:()=>a(t.pageInfo.afterKey||null)},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.metricsExplorer.loadMoreChartsButton",defaultMessage:"Load More Charts"}))):null):null)};var Oe=a(54),we=a(150);const je=({options:e,onChange:t,fields:a,autoFocus:i=!1})=>{const s=Object.keys(Z.a),[l,o]=Object(n.useState)(i),c=Object(n.useCallback)((e=>{e&&l&&(e.focus(),o(!1))}),[l]),u=Object(n.useCallback)((a=>{t(a.map(((t,a)=>({aggregation:e.aggregation,field:t.value,color:s[a]}))))}),[t,e.aggregation,s]),d=a.map((e=>({label:e.name,value:e.name}))),m=e.metrics.filter((e=>"count"!==e.aggregation)).map((e=>({label:e.field||"",value:e.field||"",color:Object(Z.b)(e.color||Z.a.color0)}))),f=p.i18n.translate("xpack.infra.metricsExplorer.metricComboBoxPlaceholder",{defaultMessage:"choose a metric to plot"});return r.a.createElement(g.EuiComboBox,{"data-test-subj":"metricsExplorer-metrics","aria-label":f,isDisabled:"count"===e.aggregation,placeholder:f,fullWidth:!0,options:d,selectedOptions:m,onChange:u,isClearable:!0,inputRef:c})};var Se=a(175),Ce=a(86);const Te=({options:e,onChange:t})=>{const a={avg:p.i18n.translate("xpack.infra.metricsExplorer.aggregationLables.avg",{defaultMessage:"Average"}),sum:p.i18n.translate("xpack.infra.metricsExplorer.aggregationLables.sum",{defaultMessage:"Sum"}),max:p.i18n.translate("xpack.infra.metricsExplorer.aggregationLables.max",{defaultMessage:"Max"}),min:p.i18n.translate("xpack.infra.metricsExplorer.aggregationLables.min",{defaultMessage:"Min"}),cardinality:p.i18n.translate("xpack.infra.metricsExplorer.aggregationLables.cardinality",{defaultMessage:"Cardinality"}),rate:p.i18n.translate("xpack.infra.metricsExplorer.aggregationLables.rate",{defaultMessage:"Rate"}),p95:p.i18n.translate("xpack.infra.metricsExplorer.aggregationLables.p95",{defaultMessage:"95th Percentile"}),p99:p.i18n.translate("xpack.infra.metricsExplorer.aggregationLables.p99",{defaultMessage:"99th Percentile"}),count:p.i18n.translate("xpack.infra.metricsExplorer.aggregationLables.count",{defaultMessage:"Document count"})},i=Object(n.useCallback)((e=>{const a=Ce.c.is(e.target.value)&&e.target.value||"avg";t(a)}),[t]),s=p.i18n.translate("xpack.infra.metricsExplorer.aggregationSelectLabel",{defaultMessage:"Select an aggregation"});return r.a.createElement(g.EuiSelect,{"aria-label":s,placeholder:s,fullWidth:!0,value:e.aggregation,options:Ce.a.map((e=>({text:a[e],value:e}))),onChange:i})},Le=({chartOptions:e,onChange:t})=>{const[a,i]=Object(n.useState)(!1),s=Object(n.useCallback)((()=>{i(!1)}),[]),l=Object(n.useCallback)((()=>{i(!0)}),[]),o=r.a.createElement(g.EuiButtonEmpty,{iconSide:"left",iconType:"eye",onClick:l,"data-test-subj":"metricsExplorer-customize"},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.metricsExplorer.customizeChartOptions",defaultMessage:"Customize"})),c=[{id:v.d.auto,label:p.i18n.translate("xpack.infra.metricsExplorer.chartOptions.autoLabel",{defaultMessage:"Automatic (min to max)"})},{id:v.d.fromZero,label:p.i18n.translate("xpack.infra.metricsExplorer.chartOptions.fromZeroLabel",{defaultMessage:"From zero (0 to max)"})}],u=[{"data-test-subj":"metricsExplorer-chartRadio-line",id:v.b.line,label:p.i18n.translate("xpack.infra.metricsExplorer.chartOptions.lineLabel",{defaultMessage:"Line"})},{"data-test-subj":"metricsExplorer-chartRadio-area",id:v.b.area,label:p.i18n.translate("xpack.infra.metricsExplorer.chartOptions.areaLabel",{defaultMessage:"Area"})},{"data-test-subj":"metricsExplorer-chartRadio-bar",id:v.b.bar,label:p.i18n.translate("xpack.infra.metricsExplorer.chartOptions.barLabel",{defaultMessage:"Bar"})}],d=Object(n.useCallback)((a=>{t({...e,yAxisMode:a})}),[e,t]),m=Object(n.useCallback)((a=>{t({...e,type:a})}),[e,t]),f=Object(n.useCallback)((a=>{t({...e,stack:a.target.checked})}),[e,t]);return r.a.createElement(g.EuiPopover,{id:"MetricExplorerChartOptionsPopover",button:o,isOpen:a,closePopover:s},r.a.createElement(g.EuiForm,null,r.a.createElement(g.EuiFormRow,{display:"rowCompressed",label:p.i18n.translate("xpack.infra.metricsExplorer.chartOptions.typeLabel",{defaultMessage:"Chart style"})},r.a.createElement(g.EuiRadioGroup,{compressed:!0,options:u,idSelected:e.type,onChange:m})),r.a.createElement(g.EuiFormRow,{display:"rowCompressed",label:p.i18n.translate("xpack.infra.metricsExplorer.chartOptions.stackLabel",{defaultMessage:"Stack series"})},r.a.createElement(g.EuiSwitch,{label:p.i18n.translate("xpack.infra.metricsExplorer.chartOptions.stackSwitchLabel",{defaultMessage:"Stack"}),checked:e.stack,onChange:f})),r.a.createElement(g.EuiFormRow,{display:"rowCompressed",label:p.i18n.translate("xpack.infra.metricsExplorer.chartOptions.yAxisDomainLabel",{defaultMessage:"Y Axis Domain"})},r.a.createElement(g.EuiRadioGroup,{compressed:!0,options:c,idSelected:e.yAxisMode,onChange:d}))))},Fe=e=>e?e.map((e=>({start:e.from,end:e.to,label:e.display}))):[],Pe=({timeRange:e,derivedIndexPattern:t,options:a,onTimeChange:n,onRefresh:i,onGroupByChange:s,onFilterQuerySubmit:l,onMetricsChange:o,onAggregationChange:c,chartOptions:u,onChartOptionsChange:d})=>{const m="avg"===a.aggregation&&0===a.metrics.length,[p]=Object(he.a)(Oe.UI_SETTINGS.TIMEPICKER_QUICK_RANGES),f=Fe(p);return r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiFlexGroup,{alignItems:"center"},r.a.createElement(g.EuiFlexItem,{grow:"count"===a.aggregation&&2},r.a.createElement(Te,{fullWidth:!0,options:a,onChange:c})),"count"!==a.aggregation&&r.a.createElement(g.EuiText,{size:"s",color:"subdued"},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.metricsExplorer.aggregationLabel",defaultMessage:"of"})),"count"!==a.aggregation&&r.a.createElement(g.EuiFlexItem,{grow:2},r.a.createElement(je,{autoFocus:m,fields:t.fields,options:a,onChange:o})),r.a.createElement(g.EuiText,{size:"s",color:"subdued"},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.metricsExplorer.groupByToolbarLabel",defaultMessage:"graph per"})),r.a.createElement(g.EuiFlexItem,{grow:1},r.a.createElement(Se.a,{onChange:s,fields:t.fields,options:a}))),r.a.createElement(g.EuiFlexGroup,{alignItems:"center"},r.a.createElement(g.EuiFlexItem,null,r.a.createElement(we.a,{derivedIndexPattern:t,onSubmit:l,value:a.filterQuery})),r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(Le,{onChange:d,chartOptions:u})),r.a.createElement(g.EuiFlexItem,{grow:!1,style:{marginRight:5}},r.a.createElement(g.EuiSuperDatePicker,{start:e.from,end:e.to,onTimeChange:({start:e,end:t})=>n(e,t),onRefresh:i,commonlyUsedRanges:f}))))};var Ie=a(176),De=a(67),_e=a.n(De),Be=a(0),Re=a(24),Ae=a(18),Ne=a(19),Ve=a(81);const ze=({errors:e,name:t,onChange:a,value:n})=>({error:e,isInvalid:e.length>0,name:t,onChange:e=>a(e.currentTarget.value),value:n}),$e=e=>""===e?[r.a.createElement(I.FormattedMessage,{id:"xpack.infra.sourceConfiguration.fieldEmptyErrorMessage",defaultMessage:"The field must not be empty"})]:[],Ue={name:"",description:"",metricAlias:"",anomalyThreshold:0},qe=e=>{const t=(({initialFormState:e=Ue})=>{const[t,a]=Object(n.useState)({}),r=Object(n.useCallback)((()=>a({})),[]),i=Object(n.useMemo)((()=>({...e,...t})),[e,t]),s=Object(n.useMemo)((()=>ze({errors:$e(i.name),name:"name",onChange:e=>a((t=>({...t,name:e}))),value:i.name})),[i.name]),l=Object(n.useMemo)((()=>ze({errors:$e(i.metricAlias),name:"metricAlias",onChange:e=>a((t=>({...t,metricAlias:e}))),value:i.metricAlias})),[i.metricAlias]),o=Object(n.useMemo)((()=>(({errors:e,name:t,onChange:a,value:n})=>({error:e,isInvalid:e.length>0,name:t,onChange:(e,t)=>a(+e.currentTarget.value,t),value:n}))({errors:$e(i.anomalyThreshold),name:"anomalyThreshold",onChange:e=>a((t=>({...t,anomalyThreshold:e}))),value:i.anomalyThreshold})),[i.anomalyThreshold]),c=Object(n.useMemo)((()=>({name:s,metricAlias:l,anomalyThreshold:o})),[s,l,o]),u=Object(n.useMemo)((()=>Object.values(c).reduce(((e,{error:t})=>[...e,...t]),[])),[c]),d=Object(n.useMemo)((()=>u.length<=0),[u]),m=Object(n.useMemo)((()=>Object.keys(t).length>0),[t]);return{errors:u,fieldProps:c,formState:i,formStateChanges:t,isFormDirty:m,isFormValid:d,resetForm:r}})({initialFormState:Object(n.useMemo)((()=>e?{name:e.name,description:e.description,metricAlias:e.metricAlias,anomalyThreshold:e.anomalyThreshold}:void 0),[e])}),a=Object(n.useMemo)((()=>[...t.errors]),[t.errors]),r=Object(n.useCallback)((()=>{t.resetForm()}),[t]),i=Object(n.useMemo)((()=>t.isFormDirty),[t.isFormDirty]),s=Object(n.useMemo)((()=>t.isFormValid),[t.isFormValid]);return{errors:a,formState:Object(n.useMemo)((()=>({name:t.formState.name,description:t.formState.description,metricAlias:t.formState.metricAlias,anomalyThreshold:t.formState.anomalyThreshold})),[t.formState]),formStateChanges:Object(n.useMemo)((()=>({name:t.formStateChanges.name,description:t.formStateChanges.description,metricAlias:t.formStateChanges.metricAlias,anomalyThreshold:t.formStateChanges.anomalyThreshold})),[t.formStateChanges]),isFormDirty:i,isFormValid:s,indicesConfigurationProps:t.fieldProps,resetForm:r}},He=Be.type({viewId:Be.string}),Ge={viewId:"0"},Je=_e()((e=>{const{source:t,isLoading:a,sourceExists:r,createSourceConfiguration:i,updateSourceConfiguration:s}=Object(n.useContext)(j.a.Context),{viewType:l,defaultViewState:o}=e,{data:c,loading:u,find:d,error:m,hasView:g}=(e=>{const t=Object(b.useUiTracker)({app:"infra_metrics"}),a=Object(f.useKibana)(),[r,i]=Object(n.useState)(null),[s,l]=Object(n.useState)(null),[o,c]=Object(n.useState)(!1);return{hasView:async t=>{var n;const r=null===(n=a.services.savedObjects)||void 0===n?void 0:n.client;if(!r)throw new Error("Saved objects client is unavailable");return(await r.find({type:e})).savedObjects.find((e=>e.attributes.name===t))},data:r,loading:o,error:s,find:Object(n.useCallback)(((n,r=[])=>{c(!0),(async()=>{try{var s;const o=null===(s=a.services.savedObjects)||void 0===s?void 0:s.client;if(!o)throw new Error("Saved objects client is unavailable");const u=await o.find({type:e,search:n,searchFields:r,page:1,perPage:1e3});l(null),c(!1),i(u),u.total>1e3?t({metric:`over_1000_saved_objects_for_${e}`}):t({metric:`under_1000_saved_objects_for_${e}`})}catch(e){c(!1),l(e)}})()}),[e,a.services.savedObjects,t])}})(l),[h,y]=Object(Ve.b)({defaultState:Ge,decodeUrlState:Xe,encodeUrlState:Qe,urlStateKey:"savedView"}),[E]=Object(n.useState)(e.shouldLoadDefault),[v,x]=Object(n.useState)(null),[k,M]=Object(n.useState)(null),{create:O,error:w,data:S,createdId:C}=(e=>{const t=Object(f.useKibana)(),[a,r]=Object(n.useState)(null),[i,s]=Object(n.useState)(null),[l,o]=Object(n.useState)(null),[c,u]=Object(n.useState)(!1);return{data:a,loading:c,error:l,create:Object(n.useCallback)(((a,n)=>{u(!0),(async()=>{try{var i;const l=null===(i=t.services.savedObjects)||void 0===i?void 0:i.client;if(!l)throw new Error("Saved objects client is unavailable");const c=await l.create(e,a,n);s(c.id),o(null),r(c),u(!1)}catch(e){u(!1),o(e)}})()}),[e,t.services.savedObjects]),createdId:i}})(l),{update:T,error:L,data:F,updatedId:P}=(e=>{const t=Object(f.useKibana)(),[a,r]=Object(n.useState)(null),[i,s]=Object(n.useState)(null),[l,o]=Object(n.useState)(null),[c,u]=Object(n.useState)(!1);return{data:a,loading:c,error:l,update:Object(n.useCallback)(((a,n,i)=>{u(!0),(async()=>{try{var l;const c=null===(l=t.services.savedObjects)||void 0===l?void 0:l.client;if(!c)throw new Error("Saved objects client is unavailable");const d=await c.update(e,a,n,i);s(d.id),o(null),r(d),u(!1)}catch(e){u(!1),o(e)}})()}),[e,t.services.savedObjects]),updatedId:i}})(l),{deleteObject:I,deletedId:D}=(e=>{const t=Object(f.useKibana)(),[a,r]=Object(n.useState)(null),[i,s]=Object(n.useState)(!1),[l,o]=Object(n.useState)(null);return{loading:i,error:a,deleteObject:Object(n.useCallback)((a=>{s(!0),(async()=>{try{var n;await(null===(n=t.services.savedObjects)||void 0===n?void 0:n.client.delete(e,a)),r(null),o(a),s(!1)}catch(e){s(!1),r(e)}})()}),[e,t.services.savedObjects]),deletedId:l}})(l),{getObject:_,data:B}=(e=>{const t=Object(f.useKibana)(),[a,r]=Object(n.useState)(null),[i,s]=Object(n.useState)(null),[l,o]=Object(n.useState)(!1);return{data:a,loading:l,error:i,getObject:Object(n.useCallback)((a=>{o(!0),(async()=>{try{var n;const i=null===(n=t.services.savedObjects)||void 0===n?void 0:n.client;if(!i)throw new Error("Saved objects client is unavailable");const l=await i.get(e,a);s(null),o(!1),r(l)}catch(e){o(!1),s(e)}})()}),[e,t.services.savedObjects])}})(l),[R,A]=Object(n.useState)(null);Object(n.useEffect)((()=>A(w)),[w]);const N=Object(n.useCallback)((e=>I(e)),[I]),V=qe(t&&t.configuration),z=Object(n.useMemo)((()=>"inventory-view"===l?"inventoryDefaultView":"metricsExplorerDefaultView"),[l]),$=Object(n.useCallback)((async e=>{r?await s({...V.formStateChanges,[z]:e}):await i({...V.formState,[z]:e})}),[V.formState,V.formStateChanges,r,z,i,s]),U=Object(n.useCallback)((e=>{A(null),(async()=>{await g(e.name)?A(p.i18n.translate("xpack.infra.savedView.errorOnCreate.duplicateViewName",{defaultMessage:"A view with that name already exists."})):O(e)})()}),[O,g]),q=Object(n.useCallback)(((e,t)=>{A(null),(async()=>{const a=await g(t.name);a&&a.id!==e?A(p.i18n.translate("xpack.infra.savedView.errorOnCreate.duplicateViewName",{defaultMessage:"A view with that name already exists."})):T(e,t)})()}),[T,g]),H=Object(n.useMemo)((()=>t&&t.configuration?"inventoryDefaultView"===z?t.configuration.inventoryDefaultView:"metricsExplorerDefaultView"===z?t.configuration.metricsExplorerDefaultView:"":""),[t,z]),G=Object(n.useCallback)((e=>({...e.attributes,id:e.id,isDefault:H===e.id})),[H]),J=Object(n.useMemo)((()=>c?c.savedObjects:[]),[c]),W=Object(n.useMemo)((()=>{const e=[{name:p.i18n.translate("xpack.infra.savedView.defaultViewNameHosts",{defaultMessage:"Default view"}),id:"0",isDefault:!H||"0"===H,...o}];return J.forEach((t=>t.type===l&&e.push(G(t)))),e}),[o,J,l,H,G]),K=Object(n.useMemo)((()=>S?G(S):null),[S,G]),Q=Object(n.useMemo)((()=>F?G(F):null),[F,G]),X=Object(n.useCallback)((()=>{M(!0),_(H)}),[M,_,H]);Object(n.useEffect)((()=>{B&&(x(G(B)),M(!1))}),[B,H,G]);const Y=Object(n.useCallback)((()=>{x({name:p.i18n.translate("xpack.infra.savedView.defaultViewNameHosts",{defaultMessage:"Default view"}),id:"0",isDefault:!H||"0"===H,...o})}),[x,H,o]),Z=Object(n.useCallback)((()=>{"0"!==H?X():(Y(),M(!1))}),[H,X,Y,M]);return Object(n.useEffect)((()=>{k||v||!E||Z()}),[Z,k,v,E]),Object(n.useEffect)((()=>{v&&h.viewId!==v.id&&c&&y({viewId:v.id})}),[h,y,v,H,c]),Object(n.useEffect)((()=>{if(!v&&!u&&c&&E){const e=W.find((e=>e.id===h.viewId));e?x(e):Z()}}),[u,v,c,W,x,Z,h.viewId,E]),{views:W,saveView:U,defaultViewId:H,loading:u,updateView:q,updatedView:Q,updatedId:P,deletedId:D,createdId:C,createdView:K,errorOnUpdate:L,errorOnFind:m,errorOnCreate:R,shouldLoadDefault:E,makeDefault:$,sourceIsLoading:a,deleteView:N,loadingDefaultView:k,setCurrentView:x,currentView:v,loadDefaultView:X,find:d}})),[We,Ke]=Je,Qe=e=>He.encode(e),Xe=e=>Object(Re.pipe)(He.decode(e),Object(Ae.fold)(Object(Ne.constant)(void 0),Ne.identity));var Ye=a(13);const Ze=({hasData:e=!0,"data-test-subj":t,...a})=>{const{services:{observability:{navigation:{PageTemplate:n}},docLinks:i}}=Object(Ye.b)(),s=e?void 0:{solution:p.i18n.translate("xpack.infra.metrics.noDataConfig.solutionName",{defaultMessage:"Observability"}),action:{beats:{title:P.c,description:P.b}},docsLink:i.links.observability.guide};return r.a.createElement(n,m()({"data-test-subj":e?t:"noDataPage",noDataConfig:s},a))},et=({close:e,save:t,isInvalid:a})=>{const[i,s]=Object(n.useState)(""),[l,o]=Object(n.useState)(!1),c=Object(n.useCallback)((e=>o(e.target.checked)),[]),u=Object(n.useCallback)((e=>s(e.target.value)),[]),d=Object(n.useCallback)((()=>{t(i,l)}),[l,t,i]);return r.a.createElement(g.EuiModal,{onClose:e,"data-test-subj":"savedViews-createModal"},r.a.createElement(g.EuiModalHeader,null,r.a.createElement(g.EuiModalHeaderTitle,null,r.a.createElement(I.FormattedMessage,{defaultMessage:"Save View",id:"xpack.infra.waffle.savedView.createHeader"}))),r.a.createElement(g.EuiModalBody,null,r.a.createElement(g.EuiFieldText,{isInvalid:a,placeholder:p.i18n.translate("xpack.infra.waffle.savedViews.viewNamePlaceholder",{defaultMessage:"Name"}),"data-test-subj":"savedViewViweName",value:i,onChange:u,"aria-label":p.i18n.translate("xpack.infra.waffle.savedViews.viewNamePlaceholder",{defaultMessage:"Name"})}),r.a.createElement(g.EuiSpacer,{size:"xl"}),r.a.createElement(g.EuiSwitch,{id:"saved-view-save-time-checkbox",label:r.a.createElement(I.FormattedMessage,{defaultMessage:"Store time with view",id:"xpack.infra.waffle.savedViews.includeTimeFilterLabel"}),checked:l,onChange:c}),r.a.createElement(g.EuiSpacer,{size:"s"}),r.a.createElement(g.EuiText,{size:"xs",grow:!1,style:{maxWidth:400}},r.a.createElement(I.FormattedMessage,{defaultMessage:"This changes the time filter to the currently selected time each time the view is loaded",id:"xpack.infra.waffle.savedViews.includeTimeHelpText"}))),r.a.createElement(g.EuiModalFooter,null,r.a.createElement(g.EuiButtonEmpty,{onClick:e},r.a.createElement(I.FormattedMessage,{defaultMessage:"Cancel",id:"xpack.infra.waffle.savedViews.cancelButton"})),r.a.createElement(g.EuiButton,{color:"primary",disabled:!i,fill:!0,onClick:d,"data-test-subj":"createSavedViewButton"},r.a.createElement(I.FormattedMessage,{defaultMessage:"Save",id:"xpack.infra.waffle.savedViews.saveButton"}))))};function tt({close:e,save:t,isInvalid:a,currentView:i}){const[s,l]=Object(n.useState)(i.name),[o,c]=Object(n.useState)(!1),u=Object(n.useCallback)((e=>c(e.target.checked)),[]),d=Object(n.useCallback)((e=>l(e.target.value)),[]),m=Object(n.useCallback)((()=>{t(s,o)}),[o,t,s]);return r.a.createElement(g.EuiModal,{onClose:e},r.a.createElement(g.EuiModalHeader,null,r.a.createElement(g.EuiModalHeaderTitle,null,r.a.createElement(I.FormattedMessage,{defaultMessage:"Update View",id:"xpack.infra.waffle.savedView.updateHeader"}))),r.a.createElement(g.EuiModalBody,null,r.a.createElement(g.EuiFieldText,{isInvalid:a,placeholder:p.i18n.translate("xpack.infra.waffle.savedViews.viewNamePlaceholder",{defaultMessage:"Name"}),"data-test-subj":"savedViewViweName",value:s,onChange:d,"aria-label":p.i18n.translate("xpack.infra.waffle.savedViews.viewNamePlaceholder",{defaultMessage:"Name"})}),r.a.createElement(g.EuiSpacer,{size:"xl"}),r.a.createElement(g.EuiSwitch,{id:"saved-view-save-time-checkbox",label:r.a.createElement(I.FormattedMessage,{defaultMessage:"Store time with view",id:"xpack.infra.waffle.savedViews.includeTimeFilterLabel"}),checked:o,onChange:u}),r.a.createElement(g.EuiSpacer,{size:"s"}),r.a.createElement(g.EuiText,{size:"xs",grow:!1,style:{maxWidth:400}},r.a.createElement(I.FormattedMessage,{defaultMessage:"This changes the time filter to the currently selected time each time the view is loaded",id:"xpack.infra.waffle.savedViews.includeTimeHelpText"}))),r.a.createElement(g.EuiModalFooter,null,r.a.createElement(g.EuiButtonEmpty,{onClick:e},r.a.createElement(I.FormattedMessage,{defaultMessage:"Cancel",id:"xpack.infra.waffle.savedViews.cancelButton"})),r.a.createElement(g.EuiButton,{color:"primary",disabled:!s,fill:!0,onClick:m,"data-test-subj":"updateSavedViewButton"},r.a.createElement(I.FormattedMessage,{defaultMessage:"Save",id:"xpack.infra.waffle.savedViews.saveButton"}))))}const at=e=>{const[t,a]=Object(n.useState)(!1),i=Object(n.useCallback)((()=>a(!0)),[]),s=Object(n.useCallback)((()=>a(!1)),[]);return r.a.createElement(r.a.Fragment,null,t&&r.a.createElement(g.EuiFlexGroup,null,r.a.createElement(g.EuiButtonEmpty,{onClick:s,"data-test-subj":"hideConfirm"},r.a.createElement(I.FormattedMessage,{defaultMessage:"cancel",id:"xpack.infra.waffle.savedViews.cancel"})),r.a.createElement(g.EuiButton,{disabled:e.isDisabled,fill:!0,iconType:"trash",color:"danger",onClick:e.confirmedAction,"data-test-subj":"showConfirm"},r.a.createElement(I.FormattedMessage,{defaultMessage:"Delete view?",id:"xpack.infra.openView.actionNames.deleteConfirmation"}))),!t&&r.a.createElement(g.EuiButtonEmpty,{iconType:"trash",color:"danger",onClick:i}))};function nt({close:e,views:t,defaultViewId:a,setView:i,makeDefault:s,deleteView:l,loading:o,sourceIsLoading:c}){const[u,d]=Object(n.useState)(null),m=Object(n.useCallback)(((t,a)=>r.a.createElement(g.EuiButtonEmpty,{onClick:()=>{i(a),e()}},t)),[i,e]),f=Object(n.useCallback)((e=>"0"===e.id?r.a.createElement(r.a.Fragment,null):r.a.createElement(at,{isDisabled:e.isDefault,confirmedAction:()=>{l(e.id)}})),[l]),b=Object(n.useCallback)((e=>{const t=e.id===a;return r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiButtonEmpty,{isLoading:u===e.id&&c,iconType:t?"starFilled":"starEmpty",onClick:()=>{d(e.id),s(e.id)}}))}),[s,a,c,u]),h=[{field:"name",name:p.i18n.translate("xpack.infra.openView.columnNames.name",{defaultMessage:"Name"}),sortable:!0,truncateText:!0,render:m},{name:p.i18n.translate("xpack.infra.openView.columnNames.actions",{defaultMessage:"Actions"}),actions:[{available:()=>!0,render:b},{available:e=>!0,render:f}]}];return r.a.createElement(g.EuiPortal,null,r.a.createElement(g.EuiFlyout,{onClose:e,"data-test-subj":"loadViewsFlyout"},r.a.createElement(g.EuiFlyoutHeader,null,r.a.createElement(g.EuiTitle,{size:"m"},r.a.createElement("h2",null,r.a.createElement(I.FormattedMessage,{defaultMessage:"Manage saved views",id:"xpack.infra.openView.flyoutHeader"})))),r.a.createElement(g.EuiFlyoutBody,null,r.a.createElement(g.EuiInMemoryTable,{items:t,columns:h,loading:o,search:!0,pagination:!0,sorting:!0})),r.a.createElement(g.EuiModalFooter,null,r.a.createElement(g.EuiButtonEmpty,{"data-test-subj":"cancelSavedViewModal",onClick:e},r.a.createElement(I.FormattedMessage,{defaultMessage:"Cancel",id:"xpack.infra.openView.cancelButton"})))))}function rt({close:e,views:t,setView:a,currentView:i}){const[s,l]=Object(n.useState)(null),o=Object(n.useCallback)((e=>{l(e)}),[]),c=Object(n.useCallback)((()=>{if(!s)return void e();const n=s.find((e=>e.checked));n?(a(t.find((e=>e.id===n.key))),e()):e()}),[s,t,a,e]),u=Object(n.useMemo)((()=>t.map((e=>({label:e.name,key:e.id,checked:(null==i?void 0:i.id)===e.id?"on":void 0})))),[t,i]);return r.a.createElement(g.EuiModal,{onClose:e,"data-test-subj":"savedViews-loadModal"},r.a.createElement(g.EuiModalHeader,null,r.a.createElement(g.EuiModalHeaderTitle,null,r.a.createElement(I.FormattedMessage,{defaultMessage:"Select a view to load",id:"xpack.infra.waffle.savedView.selectViewHeader"}))),r.a.createElement(g.EuiModalBody,null,r.a.createElement(g.EuiSelectable,{singleSelection:!0,searchable:!0,options:s||u,onChange:o,searchProps:{placeholder:p.i18n.translate("xpack.infra.savedView.searchPlaceholder",{defaultMessage:"Search for saved views"})},listProps:{bordered:!0}},((e,t)=>r.a.createElement(r.a.Fragment,null,t,r.a.createElement("div",{style:{marginTop:20},"data-test-subj":"savedViews-loadList"},e))))),r.a.createElement(g.EuiModalFooter,null,r.a.createElement(g.EuiButtonEmpty,{"data-test-subj":"cancelSavedViewModal",onClick:e},r.a.createElement(I.FormattedMessage,{defaultMessage:"Cancel",id:"xpack.infra.openView.cancelButton"})),r.a.createElement(g.EuiButton,{fill:!0,color:"primary","data-test-subj":"loadSavedViewModal",onClick:c},r.a.createElement(I.FormattedMessage,{defaultMessage:"Load view",id:"xpack.infra.openView.loadButton"}))))}function it(e){const t=Object(f.useKibana)(),{views:a,saveView:i,loading:s,updateView:l,deletedId:o,deleteView:c,defaultViewId:u,makeDefault:d,sourceIsLoading:m,find:b,errorOnFind:h,errorOnCreate:y,createdView:E,updatedView:v,currentView:x,setCurrentView:k}=Ke(),[M,O]=Object(n.useState)(!1),[w,j]=Object(n.useState)(!1),[S,C]=Object(n.useState)(!1),[T,L]=Object(n.useState)(!1),[F,P]=Object(n.useState)(!1),[I,D]=Object(n.useState)(!1),_=Object(n.useCallback)((()=>{L(!1)}),[L]),B=Object(n.useCallback)((()=>{_(),b(),j(!0)}),[j,b,_]),R=Object(n.useCallback)((()=>{j(!1)}),[j]),A=Object(n.useCallback)((()=>{_(),C(!1),P(!0)}),[_]),N=Object(n.useCallback)((()=>{_(),C(!1),D(!0)}),[_]),V=Object(n.useCallback)((()=>O(!1)),[]),z=Object(n.useCallback)((()=>P(!1)),[]),$=Object(n.useCallback)((()=>D(!1)),[]),U=Object(n.useCallback)((()=>{_(),b(),O(!0)}),[b,_]),q=Object(n.useCallback)((()=>{L(!T)}),[L,T]),H=Object(n.useCallback)(((t,a=!1)=>{const n={...e.viewState,...a?{}:{time:void 0}};i({...n,name:t})}),[e.viewState,i]),G=Object(n.useCallback)(((t,a=!1)=>{const n={...e.viewState,...a?{}:{time:void 0}};l(x.id,{...n,name:t})}),[e.viewState,l,x]);return Object(n.useEffect)((()=>{y&&C(!0)}),[y]),Object(n.useEffect)((()=>{void 0!==v&&(k(v),$())}),[v,k,$]),Object(n.useEffect)((()=>{void 0!==E&&(k(E),z())}),[E,k,z]),Object(n.useEffect)((()=>{void 0!==o&&b()}),[o,b]),Object(n.useEffect)((()=>{y?t.notifications.toasts.warning(st("create",y)):h&&t.notifications.toasts.warning(st("find",h))}),[y,h,t]),r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiPopover,{"data-test-subj":"savedViews-popover",button:r.a.createElement(g.EuiButton,{onClick:q,"data-test-subj":"savedViews-openPopover",iconType:"arrowDown",iconSide:"right",color:"text"},x?x.name:p.i18n.translate("xpack.infra.savedView.unknownView",{defaultMessage:"No view selected"})),isOpen:T,closePopover:_,anchorPosition:"leftCenter"},r.a.createElement(g.EuiListGroup,{flush:!0},r.a.createElement(g.EuiListGroupItem,{"data-test-subj":"savedViews-manageViews",iconType:"indexSettings",onClick:U,label:p.i18n.translate("xpack.infra.savedView.manageViews",{defaultMessage:"Manage views"})}),r.a.createElement(g.EuiListGroupItem,{"data-test-subj":"savedViews-updateView",iconType:"refresh",onClick:N,isDisabled:!x||"0"===x.id,label:p.i18n.translate("xpack.infra.savedView.updateView",{defaultMessage:"Update view"})}),r.a.createElement(g.EuiListGroupItem,{"data-test-subj":"savedViews-loadView",iconType:"importAction",onClick:B,label:p.i18n.translate("xpack.infra.savedView.loadView",{defaultMessage:"Load view"})}),r.a.createElement(g.EuiListGroupItem,{"data-test-subj":"savedViews-saveNewView",iconType:"save",onClick:A,label:p.i18n.translate("xpack.infra.savedView.saveNewView",{defaultMessage:"Save new view"})}))),F&&r.a.createElement(et,{isInvalid:S,close:z,save:H}),I&&r.a.createElement(tt,{currentView:x,isInvalid:S,close:$,save:G}),w&&r.a.createElement(rt,{currentView:x,views:a,close:R,setView:k}),M&&r.a.createElement(nt,{sourceIsLoading:m,loading:s,views:a,defaultViewId:u,makeDefault:d,deleteView:c,close:V,setView:k}))}const st=(e,t)=>"create"===e?{toastLifeTimeMs:3e3,title:t||p.i18n.translate("xpack.infra.savedView.errorOnCreate.title",{defaultMessage:"An error occured saving view."})}:"find"===e?{toastLifeTimeMs:3e3,title:t||p.i18n.translate("xpack.infra.savedView.findError.title",{defaultMessage:"An error occurred while loading views."})}:void 0,lt=({source:e,derivedIndexPattern:t})=>{const{loading:a,error:i,data:s,currentTimerange:l,options:o,chartOptions:c,setChartOptions:u,handleAggregationChange:d,handleMetricsChange:m,handleFilterQuerySubmit:f,handleGroupByChange:y,handleTimeChange:E,handleRefresh:x,handleLoadMore:k,onViewStateChange:M,loadData:O}=((e,t,a=!0)=>{const[r,i]=Object(n.useState)(0),[s,l]=Object(n.useState)(null),{defaultViewState:o,options:c,currentTimerange:u,chartOptions:d,setChartOptions:m,setTimeRange:p,setOptions:g}=Object(n.useContext)(v.c.Context),{loading:f,error:b,data:h,loadData:y}=Object(Ie.a)(c,e,t,u,s,r,a),E=Object(n.useCallback)((()=>{l(null),i(r+1)}),[r]),x=Object(n.useCallback)(((e,t)=>{l(null),p({...u,from:e,to:t})}),[u,p]),k=Object(n.useCallback)((e=>{l(null),g({...c,groupBy:e||void 0})}),[c,g]),M=Object(n.useCallback)((e=>{l(null),g({...c,filterQuery:e})}),[c,g]),O=Object(n.useCallback)((e=>{l(null),g({...c,metrics:e})}),[c,g]),w=Object(n.useCallback)((e=>{l(null);const t="count"===e?[{aggregation:e}]:c.metrics.filter((e=>"count"!==e.aggregation)).map((t=>({...t,aggregation:e})));g({...c,aggregation:e,metrics:t})}),[c,g]),j=Object(n.useCallback)((e=>{e.chartOptions&&m(e.chartOptions),e.currentTimerange&&"0"!==e.id&&p(e.currentTimerange),e.options&&g(e.options)}),[m,g,p]);return{loading:f,error:b,data:h,currentTimerange:u,options:c,chartOptions:d,setChartOptions:m,handleAggregationChange:w,handleMetricsChange:O,handleFilterQuerySubmit:M,handleGroupByChange:k,handleTimeChange:x,handleRefresh:E,handleLoadMore:l,defaultViewState:o,onViewStateChange:j,loadData:y,refreshSignal:r,afterKey:s}})(e,t,!1),{currentView:w,shouldLoadDefault:S}=Ke();Object(b.useTrackPageview)({app:"infra_metrics",path:"metrics_explorer"}),Object(b.useTrackPageview)({app:"infra_metrics",path:"metrics_explorer",delay:15e3});const{metricIndicesExist:C}=Object(n.useContext)(j.a.Context);return Object(n.useEffect)((()=>{w&&M(w)}),[w,M]),Object(n.useEffect)((()=>{null==w&&S||O()}),[O,S]),F([{text:L.e}]),r.a.createElement(g.EuiErrorBoundary,null,r.a.createElement(h.a,{title:e=>p.i18n.translate("xpack.infra.infrastructureMetricsExplorerPage.documentTitle",{defaultMessage:"{previousTitle} | Metrics Explorer",values:{previousTitle:e}})}),r.a.createElement(Ze,{hasData:C,pageHeader:{pageTitle:L.e,rightSideItems:[r.a.createElement(it,{viewState:{options:o,chartOptions:c,currentTimerange:l}})]}},r.a.createElement(Pe,{derivedIndexPattern:t,timeRange:l,options:o,chartOptions:c,onRefresh:x,onTimeChange:E,onGroupByChange:y,onFilterQuerySubmit:f,onMetricsChange:m,onAggregationChange:d,onChartOptionsChange:u}),i?r.a.createElement(P.a,{titleText:"Whoops!",bodyText:p.i18n.translate("xpack.infra.metricsExplorer.errorMessage",{defaultMessage:'It looks like the request failed with "{message}"',values:{message:i.message}}),onRefetch:x,refetchText:"Try Again"}):r.a.createElement(Me,{timeRange:l,loading:a,data:s,source:e,options:o,chartOptions:c,onLoadMore:k,onFilter:f,onRefetch:x,onTimeChange:E})))};var ot=a(28);const ct=new RegExp(`^([\\d\\.]+)\\s*(${q.a.units.join("|")})$`),ut=(Be.keyof({seconds:null,minutes:null,hours:null,days:null,weeks:null,months:null,years:null}),["seconds","minutes","hours","days","weeks","months","years"]),dt={seconds:p.i18n.translate("xpack.infra.durationUnits.seconds.plural",{defaultMessage:"seconds"}),minutes:p.i18n.translate("xpack.infra.durationUnits.minutes.plural",{defaultMessage:"minutes"}),hours:p.i18n.translate("xpack.infra.durationUnits.hours.plural",{defaultMessage:"hours"}),days:p.i18n.translate("xpack.infra.durationUnits.days.plural",{defaultMessage:"days"}),weeks:p.i18n.translate("xpack.infra.durationUnits.weeks.plural",{defaultMessage:"weeks"}),months:p.i18n.translate("xpack.infra.durationUnits.months.plural",{defaultMessage:"months"}),years:p.i18n.translate("xpack.infra.durationUnits.years.plural",{defaultMessage:"years"})},mt={seconds:p.i18n.translate("xpack.infra.durationUnits.seconds.singular",{defaultMessage:"second"}),minutes:p.i18n.translate("xpack.infra.durationUnits.minutes.singular",{defaultMessage:"minute"}),hours:p.i18n.translate("xpack.infra.durationUnits.hours.singular",{defaultMessage:"hour"}),days:p.i18n.translate("xpack.infra.durationUnits.days.singular",{defaultMessage:"day"}),weeks:p.i18n.translate("xpack.infra.durationUnits.weeks.singular",{defaultMessage:"week"}),months:p.i18n.translate("xpack.infra.durationUnits.months.singular",{defaultMessage:"month"}),years:p.i18n.translate("xpack.infra.durationUnits.years.singular",{defaultMessage:"year"})};var pt=a(124);const gt={currentTime:Date.now(),isAutoReloading:!1},ft=Be.type({currentTime:Be.number,isAutoReloading:Be.boolean}),bt=ft.encode,ht=e=>Object(Re.pipe)(ft.decode(e),Object(Ae.fold)(Object(Ne.constant)(void 0),Ne.identity)),yt=_e()((()=>{const[e]=Object(pt.a)({from:"now",to:"now"}),t=q.a.parse(e().to),[a,r]=Object(Ve.b)({defaultState:{...gt,currentTime:t?t.toDate().getTime():Date.now()},decodeUrlState:ht,encodeUrlState:bt,urlStateKey:"waffleTime"}),[i,s]=Object(n.useState)(a);Object(n.useEffect)((()=>{r(i)}),[r,i]);const{currentTime:l,isAutoReloading:o}=a;return{currentTime:l,currentTimeRange:{from:l-3e5,interval:"1m",to:l},isAutoReloading:o,startAutoReload:Object(n.useCallback)((()=>{s((e=>({...e,isAutoReloading:!0})))}),[s]),stopAutoReload:Object(n.useCallback)((()=>{s((e=>({...e,isAutoReloading:!1})))}),[s]),jumpToTime:Object(n.useCallback)((e=>{s((t=>({...t,currentTime:e})))}),[s]),setWaffleTimeState:s}})),[Et,vt]=yt,xt=Object(V.withTheme)((({interval:e})=>{const{currentTime:t,isAutoReloading:a,startAutoReload:i,stopAutoReload:s,jumpToTime:l}=vt(),o=N()(t),c=(e=>{const t=(e=>{if(e){const t=e.match(ct);if(t)return{value:Number(t[1]),unit:t[2]}}throw new Error(p.i18n.translate("xpack.infra.parseInterval.errorMessage",{defaultMessage:"{value} is not an interval string",values:{value:e}}))})(e);if("s"===(null==t?void 0:t.unit)){const e=N.a.duration(t.value,t.unit),r=ut.reduce(((t,a)=>e.as(a)>=1?a:t),"seconds"),i=e.as(r);return`${Math.floor(i)} ${a=i,n=r,1===Math.floor(a)?mt[n]:dt[n]}`}var a,n})(e),u=a?r.a.createElement(g.EuiButton,{color:"primary",iconSide:"left",iconType:"pause",onClick:s},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.waffleTime.stopRefreshingButtonLabel",defaultMessage:"Stop refreshing"})):r.a.createElement(g.EuiButton,{iconSide:"left",iconType:"play",onClick:i},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.waffleTime.autoRefreshButtonLabel",defaultMessage:"Auto-refresh"})),d=Object(n.useCallback)((e=>{e&&l(e.valueOf())}),[l]);return r.a.createElement(g.EuiFlexGroup,{gutterSize:"m"},r.a.createElement(g.EuiFlexItem,{grow:!1,"data-test-subj":"waffleDatePicker"},r.a.createElement(g.EuiToolTip,{content:`Last ${c} of data for the selected time`,delay:"long",display:"inlineBlock",position:"top","data-test-subj":"waffleDatePickerIntervalTooltip"},r.a.createElement(g.EuiDatePicker,{dateFormat:"L LTS",disabled:a,injectTimes:o?[o]:[],isLoading:a,onChange:d,popoverPlacement:"upRight",selected:o,shouldCloseOnSelect:!0,showTimeSelect:!0,timeFormat:"LT"}))),r.a.createElement(g.EuiFlexItem,{grow:!1},u))}));var kt=a(232),Mt=a(222),Ot=a(107),wt=a(106);const jt={kind:"kuery",expression:""},St=Be.type({kind:Be.literal("kuery"),expression:Be.string}),Ct=St.encode,Tt=e=>Object(Re.pipe)(St.decode(e),Object(Ae.fold)(Object(Ne.constant)(void 0),Ne.identity)),Lt=_e()((()=>{const{createDerivedIndexPattern:e}=Object(j.c)(),t=e(),[a,r]=Object(Ve.b)({defaultState:jt,decodeUrlState:Tt,encodeUrlState:Ct,urlStateKey:"waffleFilter"}),[i,s]=Object(n.useState)(a);Object(n.useEffect)((()=>r(i)),[r,i]);const[l,o]=Object(n.useState)(a.expression),c=Object(n.useMemo)((()=>Object(wt.a)(a.expression,t)),[t,a.expression]),u=Object(n.useCallback)((e=>{s((t=>({...t,kind:"kuery",expression:e})))}),[s]),d=Object(n.useCallback)((e=>{s(e),o(e.expression)}),[]),m=Object(n.useMemo)((()=>(e=>{try{Object(Ot.c)(e)}catch(e){return!1}return!0})(l)),[l]),{inventoryPrefill:p}=Object(J.b)(),g=Object(n.useMemo)((()=>p),[p]);return Object(n.useEffect)((()=>g.setFilterQuery(i.expression)),[g,i]),{filterQuery:a,filterQueryDraft:l,filterQueryAsJson:c,applyFilterQuery:d,setFilterQueryDraftFromKueryExpression:o,applyFilterQueryFromKueryExpression:u,isFilterQueryDraftValid:m,setWaffleFiltersState:d}})),[Ft,Pt]=Lt,It=()=>{const{createDerivedIndexPattern:e}=Object(n.useContext)(j.a.Context),{applyFilterQueryFromKueryExpression:t,filterQueryDraft:a,isFilterQueryDraftValid:i,setFilterQueryDraftFromKueryExpression:s}=Pt();return r.a.createElement(Mt.a,{indexPattern:e()},(({isLoadingSuggestions:e,loadSuggestions:n,suggestions:l})=>r.a.createElement(kt.a,{isLoadingSuggestions:e,isValid:i,loadSuggestions:n,onChange:s,onSubmit:t,placeholder:p.i18n.translate("xpack.infra.homePage.toolbar.kqlSearchFieldPlaceholder",{defaultMessage:"Search for infrastructure data… (e.g. host.name:host-1)"}),suggestions:l,value:a||"",autoFocus:!0})))},Dt=({interval:e})=>r.a.createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween",gutterSize:"m",style:{flexGrow:0}},r.a.createElement(g.EuiFlexItem,null,r.a.createElement(It,null)),r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(xt,{interval:e})));var _t=a(128);const Bt=({detailedMessage:e,retry:t,shortMessage:a})=>r.a.createElement(_t.a,{isEmptyState:!0},r.a.createElement(g.EuiCallOut,{color:"danger",iconType:"cross",title:r.a.createElement(I.FormattedMessage,{id:"xpack.infra.errorPage.errorOccurredTitle",defaultMessage:"An error occurred"})},r.a.createElement(g.EuiFlexGroup,{alignItems:"center"},r.a.createElement(g.EuiFlexItem,null,a),t?r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiButton,{onClick:t,iconType:"refresh"},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.errorPage.tryAgainButtonLabel",defaultMessage:"Try again"}))):null),e?r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiSpacer,null),r.a.createElement("div",null,e)):null)),Rt=({errorMessage:e,retry:t})=>r.a.createElement(Bt,{shortMessage:r.a.createElement(I.FormattedMessage,{id:"xpack.infra.sourceErrorPage.failedToLoadDataSourcesMessage",defaultMessage:"Failed to load data sources."}),detailedMessage:r.a.createElement("code",null,e),retry:t});var At=a(105),Nt=a(125),Vt=a.n(Nt),zt=a(114);function $t(e){return e&&null!=e.nodes&&Array.isArray(e.nodes)}function Ut(e){return e&&null!=e.groups&&Array.isArray(e.groups)}function qt(e){return e.map((e=>e.value)).join("/")}function Ht(e,t){const a=0===t.length?"__all__":qt(t),n=Object(R.first)(t);if(2===t.length&&n){const t=n.value,r=e.find((e=>e.id===t));if(Ut(r)){const e=r.groups.find((e=>e.id===a));if($t(e))return e}}const r=Object(R.last)(t),i=e.find((e=>e.id===a));return $t(i)?i:{id:a,name:"__all__"===a?p.i18n.translate("xpack.infra.nodesToWaffleMap.groupsWithNodes.allName",{defaultMessage:"All"}):r&&r.label||"Unknown Group",count:0,width:0,squareSize:0,nodes:[]}}function Gt(e){const t=Object(R.last)(e.path);if(!t)throw new Error("There must be at least one node path item");return{pathId:e.path.map((e=>e.value)).join("/"),path:e.path,id:t.value,ip:t.ip,name:t.label||t.value,metrics:e.metrics}}function Jt(e){return t=>t.id!==e.id}var Wt=a(6),Kt=a.n(Wt);class group_name_GroupName extends r.a.PureComponent{constructor(...e){super(...e),Kt()(this,"handleClick",(e=>{e.preventDefault();const{groupBy:t}=this.props.options;if(0===t.length)return;const a=this.props.isChild&&t.length>1?t[1]:t[0];this.props.onDrilldown(`${a.field}: "${this.props.group.name}"`)}))}render(){const{group:e,isChild:t}=this.props,a={fontSize:t?"0.85em":"1em"};return r.a.createElement(Qt,null,r.a.createElement(Xt,{isChild:t},r.a.createElement(Yt,null,r.a.createElement(g.EuiToolTip,{position:"top",content:e.name},r.a.createElement(g.EuiLink,{style:a,onClickCapture:this.handleClick,"data-test-subj":"groupNameLink"},e.name))),r.a.createElement(Zt,null,e.count)))}}const Qt=V.euiStyled.div`
  position: relative;
  text-align: center;
  font-size: 16px;
  margin-bottom: 5px;
  top: 20px;
  display: flex;
  justify-content: center;
  padding: 0 10px;
`,Xt=V.euiStyled.div`
  border: 1px solid ${e=>e.theme.eui.euiBorderColor};
  background-color: ${e=>e.isChild?e.theme.eui.euiColorLightestShade:e.theme.eui.euiColorEmptyShade};
  border-radius: 4px;
  box-shadow: 0px 2px 0px 0px ${e=>e.theme.eui.euiBorderColor};
  display: flex;
  align-items: center;
  justify-content: center;
  overflow: hidden;
`,Yt=V.euiStyled.div`
  flex: 1 1 auto;
  padding: 6px 10px;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
`,Zt=V.euiStyled.div`
  flex: 0 0 auto;
  border-left: 1px solid ${e=>e.theme.eui.euiBorderColor};
  padding: 6px 10px;
  font-size: 0.85em;
  font-weight: normal;
`;var ea=a(102),ta=a(87),aa=a(74),na=a(75),ra=a(134),ia=a(135),sa=a(119);const la=Object.keys(na.e).reduce(((e,t)=>{var a;const n=null===(a=Object(sa.a)(t))||void 0===a?void 0:a.text;return n?{...e,[t]:n}:e}),{});var oa=a(76);const ca=Object(V.withTheme)((({theme:e,node:t,nodeType:a,currentTime:n})=>{const{sourceId:i}=Object(j.c)(),s=Object(aa.b)(a),{customMetrics:l}=Object(oa.d)(),o=s.tooltipMetrics.map((e=>({type:e}))).concat(l),c=JSON.stringify({bool:{filter:{match_phrase:{[s.fields.id]:t.id}}}}),{nodes:u}=Object(ra.a)(c,o,[],a,i,n,"",""),d=Object(R.first)(u),m=d&&d.metrics||[];return r.a.createElement("div",{style:{minWidth:200},"data-test-subj":`conditionalTooltipContent-${t.name}`},r.a.createElement("div",{style:{borderBottom:`1px solid ${null==e?void 0:e.eui.euiColorMediumShade}`,paddingBottom:null==e?void 0:e.eui.euiSizeXS,marginBottom:null==e?void 0:e.eui.euiSizeXS}},t.name),m.map((e=>{const t=na.f.is(e.name)?e.name:"custom",a=la[t]||t,n="custom"===a?l.find((t=>t.id===e.name)):null,i=n?Object(z.a)(n):Object(ia.a)({type:t});return r.a.createElement(g.EuiFlexGroup,{gutterSize:"s",key:e.name},r.a.createElement(g.EuiFlexItem,{grow:1,className:"eui-textTruncate eui-displayBlock","data-test-subj":"conditionalTooltipContent-metric"},n?Object(ta.a)(n):a),r.a.createElement(g.EuiFlexItem,{grow:!1,"data-test-subj":"conditionalTooltipContent-value"},e.value&&i(e.value)||"-"))})))})),ua={[te.c.eq]:R.isEqual,[te.c.lt]:R.lt,[te.c.lte]:R.lte,[te.c.gte]:R.gte,[te.c.gt]:R.gt},da=e=>Object(ea.toColorString)(Object(ea.parseToRgb)(e)),ma=(e,t,a)=>(a-e)/(t-e),pa=V.euiStyled.div`
  padding: ${e=>e.theme.eui.euiSizeM};
  flex: 1;
  overflow-y: auto;
  overflow-x: hidden;
`,ga=({title:e,metrics:t})=>r.a.createElement(g.EuiFlexGroup,{gutterSize:"s",responsive:!1},r.a.createElement(fa,{grow:1},r.a.createElement(g.EuiText,{size:"s"},r.a.createElement(ba,null,e))),r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",responsive:!1},t.map((e=>r.a.createElement(g.EuiFlexItem,{key:e.label},r.a.createElement(g.EuiFlexGroup,{key:e.label,gutterSize:"xs",alignItems:"center",responsive:!1},r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiIcon,{color:Object(Z.b)(e.color),type:"dot"})),r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiText,{size:"xs"},e.label))))))))),fa=Object(V.euiStyled)(g.EuiFlexItem).attrs({grow:1})`
  overflow: hidden;
`,ba=Object(V.euiStyled)("h4")`
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
`,ha=["100%",160],ya=({title:e,style:t,chartRef:a,series:n,tickFormatterForTime:i,tickFormatter:s,onPointerUpdate:l,domain:o,stack:c=!1})=>{const u=Object(f.useUiSetting)("theme:darkMode"),d=n.map((e=>e.metric)),m={headerFormatter:e=>N()(e.value).format("Y-MM-DD HH:mm:ss.SSS")};return r.a.createElement(r.a.Fragment,null,r.a.createElement(ga,{title:e,metrics:d}),r.a.createElement(B.Chart,{ref:a,size:ha},n.map(((e,a)=>r.a.createElement($.a,{type:t,metric:e.metric,id:"0",key:e.series.id,series:e.series,stack:c}))),r.a.createElement(B.Axis,{id:"timestamp",position:B.Position.Bottom,showOverlappingTicks:!0,tickFormat:i}),r.a.createElement(B.Axis,{id:"values",position:B.Position.Left,tickFormat:s,domain:o,ticks:6,showGridLines:!0}),r.a.createElement(B.Settings,{onPointerUpdate:l,tooltip:m,theme:fe(u)})))},Ea=p.i18n.translate("xpack.infra.nodeDetails.metrics.system",{defaultMessage:"System"}),va=p.i18n.translate("xpack.infra.nodeDetails.metrics.user",{defaultMessage:"User"}),xa=p.i18n.translate("xpack.infra.nodeDetails.metrics.inbound",{defaultMessage:"Inbound"}),ka=p.i18n.translate("xpack.infra.nodeDetails.metrics.outbound",{defaultMessage:"Outbound"}),Ma=p.i18n.translate("xpack.infra.nodeDetails.metrics.used",{defaultMessage:"Used"}),Oa=(p.i18n.translate("xpack.infra.nodeDetails.metrics.cached",{defaultMessage:"Cached"}),p.i18n.translate("xpack.infra.nodeDetails.metrics.free",{defaultMessage:"Free"})),wa=p.i18n.translate("xpack.infra.nodeDetails.metrics.charts.networkTitle",{defaultMessage:"Network"}),ja=p.i18n.translate("xpack.infra.nodeDetails.metrics.charts.memoryTitle",{defaultMessage:"Memory"}),Sa=p.i18n.translate("xpack.infra.nodeDetails.metrics.fcharts.cpuTitle",{defaultMessage:"CPU"}),Ca=p.i18n.translate("xpack.infra.nodeDetails.metrics.charts.loadTitle",{defaultMessage:"Load"}),Ta=p.i18n.translate("xpack.infra.nodeDetails.metrics.logRate",{defaultMessage:"Log Rate"}),La=p.i18n.translate("xpack.infra.nodeDetails.metrics.charts.logRateTitle",{defaultMessage:"Log Rate"}),Fa=e=>r.a.createElement(g.EuiSelect,{fullWidth:!0,options:[{text:p.i18n.translate("xpack.infra.nodeDetails.metrics.last15Minutes",{defaultMessage:"Last 15 minutes"}),value:9e5},{text:p.i18n.translate("xpack.infra.nodeDetails.metrics.lastHour",{defaultMessage:"Last hour"}),value:36e5},{text:p.i18n.translate("xpack.infra.nodeDetails.metrics.last3Hours",{defaultMessage:"Last 3 hours"}),value:108e5},{text:p.i18n.translate("xpack.infra.nodeDetails.metrics.last24Hours",{defaultMessage:"Last 24 hours"}),value:864e5},{text:p.i18n.translate("xpack.infra.nodeDetails.metrics.last7Days",{defaultMessage:"Last 7 days"}),value:6048e5}],value:e.value,onChange:e.onChange}),Pa=Object(V.euiStyled)(g.EuiFlexItem)`
  overflow: hidden
`,Ia=()=>r.a.createElement("div",{style:{width:"100%",height:"200px",padding:"16px",display:"flex",alignItems:"center",justifyContent:"center"}},r.a.createElement(g.EuiLoadingChart,{size:"xl"})),Da={id:"metrics",name:p.i18n.translate("xpack.infra.nodeDetails.tabs.metrics",{defaultMessage:"Metrics"}),content:e=>{const t=Object(n.useRef)(null),a=Object(n.useRef)(null),i=Object(n.useRef)(null),s=Object(n.useRef)(null),l=Object(n.useRef)(null),o=Object(n.useRef)({}),[c,u]=Object(n.useState)(36e5),d=Object(n.useMemo)((()=>[t,a,i,s,l,o]),[t,a,i,s,l,o]),{sourceId:m,createDerivedIndexPattern:p}=Object(j.c)(),{nodeType:f,accountId:b,region:h,customMetrics:y}=Object(oa.d)(),{currentTime:E,node:x}=e,k=Object(n.useMemo)((()=>p()),[p]);let M=`${Object(aa.a)(f).id}: "${x.id}"`;M&&(M=Object(wt.a)(M,k));const O=Object(n.useCallback)(((e,t,a="avg")=>({type:"custom",aggregation:a,field:e,id:t})),[]),w=Object(n.useCallback)((e=>{u(Number(e.currentTarget.value))}),[u]),S={interval:"1m",to:E,from:E-c,ignoreLookback:!0},C=[{type:"rx"},{type:"tx"},O("system.cpu.user.pct","user"),O("system.cpu.system.pct","system"),O("system.load.1","load1m"),O("system.load.5","load5m"),O("system.load.15","load15m"),O("system.memory.actual.used.bytes","usedMemory"),O("system.memory.actual.free","freeMemory"),O("system.cpu.cores","cores","max")],{nodes:T,reload:L}=Object(ra.a)(M,[...C,...y],[],f,m,E,b,h,!1,S),{nodes:F,reload:P}=Object(ra.a)(M,[{type:"logRate"}],[],f,m,E,b,h,!1,S),I=Object(n.useCallback)(((e,t)=>{const a=e?Object(ye.a)(e,t,!1):null;return a?{max:1.1*a.max,min:a.min}:{max:0,min:0}}),[]),D=Object(n.useCallback)((e=>{var t,a;if(!e)return()=>"";const n=null===(t=Object(R.first)(e.rows))||void 0===t?void 0:t.timestamp,r=null===(a=Object(R.last)(e.rows))||void 0===a?void 0:a.timestamp;return null==n||null==r?e=>`${e}`:Object(B.niceTimeFormatter)([n,r])}),[]),_=Object(n.useMemo)((()=>Object(ia.a)({type:"rx"})),[]),A=Object(n.useMemo)((()=>Object(ia.a)({type:"cpu"})),[]),N=Object(n.useMemo)((()=>Object(ia.a)({type:"s3BucketSize"})),[]),V=Object(n.useMemo)((()=>Object(ia.a)({type:"load"})),[]),$=Object(n.useMemo)((()=>Object(ia.a)({type:"logRate"})),[]),U=Object(n.useCallback)(((...e)=>{const t=e[0],a=e.slice(1);return t.rows=t.rows.map(((e,t)=>{const n={...e};return a.forEach(((e,a)=>{n[`metric_${a+1}`]=e.rows[t].metric_0})),n})),t}),[]),q=Object(n.useCallback)(((e,t)=>{const a={color:Z.a.color0,aggregation:t,label:"System"};return e.map(((e,t)=>({...a,color:Z.a[`color${t}`],label:e})))}),[]),H=Object(n.useCallback)((e=>{d.forEach((t=>{t.current&&(t.current instanceof B.Chart?t.current.dispatchExternalPointerEvent(e):Object.values(t.current).forEach((t=>{t&&t.dispatchExternalPointerEvent(e)})))}))}),[d]),G=Object(n.useCallback)((e=>T&&T.length?T[0].metrics.find((t=>t.name===e)).timeseries:null),[T]),J=Object(n.useCallback)((()=>F?0===F.length?{rows:[],columns:[],id:"0"}:F[0].metrics.find((e=>"logRate"===e.name)).timeseries:null),[F]),W=Object(n.useMemo)((()=>G("system")),[G]),K=Object(n.useMemo)((()=>G("user")),[G]),Q=Object(n.useMemo)((()=>G("rx")),[G]),X=Object(n.useMemo)((()=>G("tx")),[G]),Y=Object(n.useMemo)((()=>G("load1m")),[G]),ee=Object(n.useMemo)((()=>G("load5m")),[G]),te=Object(n.useMemo)((()=>G("load15m")),[G]),ae=Object(n.useMemo)((()=>G("usedMemory")),[G]),ne=Object(n.useMemo)((()=>G("freeMemory")),[G]),re=Object(n.useMemo)((()=>G("cores")),[G]),ie=Object(n.useMemo)((()=>J()),[J]);if(Object(n.useEffect)((()=>{L(),P()}),[c,L,P]),!(W&&K&&Q&&X&&Y&&ee&&te&&ae&&ne&&ie))return r.a.createElement(Ia,null);const se=q([Ea,va],"avg"),le=q([Ta],"rate"),oe=q([xa,ka],"rate"),ce=q(["1m","5m","15m"],"avg"),ue=q([Ma,Oa],"rate");W.rows=W.rows.slice().map(((e,t)=>{const a=e.metric_0,n=re.rows[t].metric_0;return a&&n&&(e.metric_0=a/n),e})),K.rows=K.rows.slice().map(((e,t)=>{const a=e.metric_0,n=re.rows[t].metric_0;return a&&n&&(e.metric_0=a/n),e}));const de=U(W,K),me=U(ie),pe=U(Q,X),ge=U(Y,ee,te),fe=U(ae,ne),be=D(Q);return r.a.createElement(pa,null,r.a.createElement(Fa,{value:c,onChange:w}),r.a.createElement(g.EuiSpacer,{size:"l"}),r.a.createElement(g.EuiFlexGrid,{columns:2,gutterSize:"l",responsive:!1},r.a.createElement(Pa,null,r.a.createElement(ya,{title:Sa,style:v.b.line,chartRef:t,series:[{metric:se[0],series:W},{metric:se[1],series:K}],tickFormatterForTime:be,tickFormatter:A,onPointerUpdate:H,domain:I(de,se)})),r.a.createElement(Pa,null,r.a.createElement(ya,{title:Ca,style:v.b.line,chartRef:s,series:[{metric:ce[0],series:Y},{metric:ce[1],series:ee},{metric:ce[2],series:te}],tickFormatterForTime:be,tickFormatter:V,onPointerUpdate:H,domain:I(ge,ce)})),r.a.createElement(Pa,null,r.a.createElement(ya,{title:ja,style:v.b.line,chartRef:i,series:[{metric:ue[0],series:ae},{metric:ue[1],series:ne}],tickFormatterForTime:be,tickFormatter:N,onPointerUpdate:H,domain:I(fe,ue)})),r.a.createElement(Pa,null,r.a.createElement(ya,{title:wa,style:v.b.line,chartRef:a,series:[{metric:oe[0],series:Q},{metric:oe[1],series:X}],tickFormatterForTime:be,tickFormatter:_,onPointerUpdate:H,domain:I(pe,oe),stack:!0})),r.a.createElement(Pa,null,r.a.createElement(ya,{title:La,style:v.b.line,chartRef:l,series:[{metric:le[0],series:ie}],tickFormatterForTime:be,tickFormatter:$,onPointerUpdate:H,domain:I(me,le),stack:!0})),y.map((e=>{const t=G(e.id),a=q([e.field],e.aggregation);return t?r.a.createElement(Pa,null,r.a.createElement(ya,{title:Object(ta.a)(e),style:v.b.line,chartRef:t=>{o.current[e.id]=t},series:[{metric:a[0],series:t}],tickFormatterForTime:be,tickFormatter:Object(z.a)(e),onPointerUpdate:H,domain:I(U(t),a),stack:!0})):null}))))}};var _a=a(173),Ba=a.n(_a),Ra=a(211),Aa=a(120);const Na={id:"logs",name:p.i18n.translate("xpack.infra.nodeDetails.tabs.logs",{defaultMessage:"Logs"}),content:e=>{const[t,a]=Object(n.useState)(""),i=e.currentTime,s=i-36e5,{nodeType:l}=Object(oa.d)(),{node:o}=e,c=Ba()(t,Va),u=Object(n.useMemo)((()=>({language:"kuery",query:[`${Object(aa.a)(l).id}: "${o.id}"`,...""!==c?[c]:[]].join(" and ")})),[l,o.id,c]),d=Object(n.useCallback)((e=>{a(e.target.value)}),[]),f=Object(b.useLinkProps)(Object(Aa.b)({nodeType:l,nodeId:o.id,time:s}));return r.a.createElement(pa,null,r.a.createElement(g.EuiFlexGroup,{gutterSize:"m",alignItems:"center",responsive:!1},r.a.createElement(g.EuiFlexItem,null,r.a.createElement(g.EuiFieldSearch,{fullWidth:!0,placeholder:p.i18n.translate("xpack.infra.nodeDetails.logs.textFieldPlaceholder",{defaultMessage:"Search for log entries..."}),value:t,isClearable:!0,onChange:d})),r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiButtonEmpty,m()({size:"xs",flush:"both",iconType:"popout"},f),r.a.createElement(I.FormattedMessage,{id:"xpack.infra.nodeDetails.logs.openLogsLink",defaultMessage:"Open in Logs"})))),r.a.createElement(Ra.a,{logView:{type:"log-view-reference",logViewId:"default"},startTimestamp:s,endTimestamp:i,query:u}))}},Va=1e3;var za=a(85),$a=a(17),Ua=a(79);const qa=_e()((function(e){const{hostTerm:t,to:a}=e,{createDerivedIndexPattern:n}=Object(j.c)();return{hostTerm:t,indexPattern:n().title,to:a}})),[Ha,Ga]=qa,Ja={running:p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.stateRunning",{defaultMessage:"Running"}),sleeping:p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.stateSleeping",{defaultMessage:"Sleeping"}),dead:p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.stateDead",{defaultMessage:"Dead"}),stopped:p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.stateStopped",{defaultMessage:"Stopped"}),idle:p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.stateIdle",{defaultMessage:"Idle"}),zombie:p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.stateZombie",{defaultMessage:"Zombie"}),unknown:p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.stateUnknown",{defaultMessage:"Unknown"})},Wa=["running","sleeping","stopped","idle","dead","zombie","unknown"],Ka=({processSummary:e,isLoading:t})=>{const a=Object(n.useMemo)((()=>({total:t?-1:e.total,...Object(R.mapValues)(Ja,(()=>t?-1:0)),...t?{}:e})),[e,t]);return r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiFlexGroup,{gutterSize:"m",responsive:!1,wrap:!0},Object.entries(a).map((([e,t])=>r.a.createElement(g.EuiFlexItem,null,r.a.createElement(g.EuiDescriptionList,{compressed:!0},r.a.createElement(Ya,null,Qa[e]),r.a.createElement(g.EuiDescriptionListDescription,null,-1===t?r.a.createElement(Xa,null):t)))))),r.a.createElement(g.EuiHorizontalRule,{margin:"m"}))},Qa={total:p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.headingTotalProcesses",{defaultMessage:"Total processes"}),...Ja},Xa=Object(V.euiStyled)(g.EuiLoadingSpinner).attrs({size:"m"})`
  margin-top: 2px;
  margin-bottom: 3px;
`,Ya=Object(V.euiStyled)(g.EuiDescriptionListTitle)`
  white-space: nowrap;
`;var Za=a(33);const en=({command:e})=>{const{loading:t,error:a,response:i}=function(e){const[t,a]=Object(n.useState)(!1),{hostTerm:r,indexPattern:i,to:s}=Ga(),{error:l,loading:o,response:c,makeRequest:u}=Object(Ua.a)("/api/metrics/process_list/chart","POST",JSON.stringify({hostTerm:r,indexPattern:i,to:s,command:e}),(e=>Object(Re.pipe)(za.h.decode(e),Object(Ae.fold)(Object($a.c)($a.a),Ne.identity))));return Object(n.useEffect)((()=>a(!0)),[l]),Object(n.useEffect)((()=>a(!1)),[o]),Object(n.useEffect)((()=>{u()}),[u]),{error:t,loading:o,response:c,makeRequest:u}}(e),s=t||!i,l=a?r.a.createElement(g.EuiEmptyPrompt,{iconType:"alert",title:r.a.createElement(g.EuiText,null,sn)}):s?r.a.createElement(g.EuiLoadingChart,null):r.a.createElement(tn,{timeseries:i.cpu,color:Z.a.color2,label:nn}),o=a?r.a.createElement(g.EuiEmptyPrompt,{iconType:"alert",title:r.a.createElement(g.EuiText,null,sn)}):s?r.a.createElement(g.EuiLoadingChart,null):r.a.createElement(tn,{timeseries:i.memory,color:Z.a.color0,label:rn});return r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiFlexItem,null,r.a.createElement(g.EuiDescriptionListTitle,null,nn),r.a.createElement(g.EuiDescriptionListDescription,null,l)),r.a.createElement(g.EuiFlexItem,null,r.a.createElement(g.EuiDescriptionListTitle,null,rn),r.a.createElement(g.EuiDescriptionListDescription,null,o)))},tn=({timeseries:e,color:t,label:a})=>{const i={color:t,aggregation:"avg",label:a},s=Object(f.useUiSetting)("theme:darkMode"),l=Object(n.useMemo)((()=>{var t,a;if(!e)return()=>"";const n=null===(t=Object(R.first)(e.rows))||void 0===t?void 0:t.timestamp,r=null===(a=Object(R.last)(e.rows))||void 0===a?void 0:a.timestamp;return null==n||null==r?e=>`${e}`:Object(B.niceTimeFormatter)([n,r])}),[e]),o=Object(Za.b)("percent"),c={headerFormatter:e=>N()(e.value).format("Y-MM-DD HH:mm:ss.SSS")},u=Object(ye.a)(e,[i],!1),d=u?{max:1.1*u.max,min:u.min}:{max:0,min:0};return r.a.createElement(an,null,r.a.createElement(B.Chart,null,r.a.createElement($.a,{type:v.b.area,metric:i,id:"0",series:e,stack:!1}),r.a.createElement(B.Axis,{id:"timestamp",position:B.Position.Bottom,showOverlappingTicks:!0,tickFormat:l}),r.a.createElement(B.Axis,{id:"values",position:B.Position.Left,tickFormat:o,domain:d,ticks:6,showGridLines:!0}),r.a.createElement(B.Settings,{tooltip:c,theme:ge(s)})))},an=V.euiStyled.div`
  width: 100%;
  height: 140px;
`,nn=p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.expandedRowLabelCPU",{defaultMessage:"CPU"}),rn=p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.expandedRowLabelMemory",{defaultMessage:"Memory"}),sn=p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.failedToLoadChart",{defaultMessage:"Unable to load chart"}),ln=({cells:e,item:t})=>{const[a,i]=Object(n.useState)(!1);return r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiTableRow,null,r.a.createElement(g.EuiTableRowCell,{isExpander:!0,textOnly:!1},r.a.createElement(g.EuiButtonEmpty,{iconType:a?"arrowDown":"arrowRight","aria-expanded":a,onClick:()=>i(!a)})),e),r.a.createElement(g.EuiTableRow,{isExpandable:!0,isExpandedRow:a},a&&r.a.createElement(zt.a,{bounds:!0},(({measureRef:e,bounds:{height:a=0}})=>r.a.createElement(dn,{commandHeight:a},r.a.createElement(g.EuiSpacer,{size:"s"}),r.a.createElement(on,null,r.a.createElement(g.EuiFlexGroup,{gutterSize:"s"},r.a.createElement(g.EuiFlexItem,null,r.a.createElement("div",{ref:e},r.a.createElement(g.EuiDescriptionListTitle,null,p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.expandedRowLabelCommand",{defaultMessage:"Command"})),r.a.createElement(g.EuiDescriptionListDescription,null,r.a.createElement(un,null,t.command)))),t.apmTrace&&r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiButton,null,p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.viewTraceInAPM",{defaultMessage:"View trace in APM"})))),r.a.createElement(g.EuiFlexGrid,{columns:2,gutterSize:"s",responsive:!1},r.a.createElement(g.EuiFlexItem,null,r.a.createElement(g.EuiDescriptionListTitle,null,p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.expandedRowLabelPID",{defaultMessage:"PID"})),r.a.createElement(g.EuiDescriptionListDescription,null,r.a.createElement(cn,null,t.pid))),r.a.createElement(g.EuiFlexItem,null,r.a.createElement(g.EuiDescriptionListTitle,null,p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.expandedRowLabelUser",{defaultMessage:"User"})),r.a.createElement(g.EuiDescriptionListDescription,null,r.a.createElement(cn,null,t.user))),r.a.createElement(en,{command:t.command}))))))))},on=Object(V.euiStyled)(g.EuiDescriptionList).attrs({compressed:!0})`
  width: 100%;
`,cn=Object(V.euiStyled)(g.EuiCode).attrs({transparentBackground:!0})`
  padding: 0 !important;
  & code.euiCodeBlock__code {
    white-space: nowrap !important;
    vertical-align: middle;
  }
`,un=Object(V.euiStyled)(g.EuiCode).attrs({transparentBackground:!0})`
  padding: 0 !important;
  margin-bottom: ${e=>e.theme.eui.euiSizeS};
`,dn=Object(V.euiStyled)(g.EuiTableRowCell).attrs({textOnly:!1,colSpan:6})`
  height: ${e=>e.commandHeight+240}px;
  padding: 0 ${e=>e.theme.eui.euiSizeM};
  background-color: ${e=>e.theme.eui.euiColorLightestShade};
`,mn=({state:e})=>{switch(e){case"running":return r.a.createElement(g.EuiBadge,{color:"success"},Ja.running);case"sleeping":return r.a.createElement(g.EuiBadge,{color:"default"},Ja.sleeping);case"dead":return r.a.createElement(g.EuiBadge,{color:"danger"},Ja.dead);case"stopped":return r.a.createElement(g.EuiBadge,{color:"warning"},Ja.stopped);case"idle":return r.a.createElement(g.EuiBadge,{color:"primary"},Ja.idle);case"zombie":return r.a.createElement(g.EuiBadge,{color:"danger"},Ja.zombie);default:return r.a.createElement(g.EuiBadge,{color:"hollow"},Ja.unknown)}},pn=({processList:e,currentTime:t,isLoading:a,sortBy:i,setSortBy:s,clearSearchBar:l})=>{const{updateSortableProperties:o}=function(e,t,a){const[r]=Object(n.useState)(new g.SortableProperties(e,"cpu"));return{updateSortableProperties:Object(n.useCallback)((e=>{r.sortOn(e),a(Object(R.omit)(r.getSortedProperty(),"getValue"))}),[r,a])}}([{name:"startTime",getValue:e=>Date.parse(e.startTime),isAscending:!0},{name:"cpu",getValue:e=>e.cpu,isAscending:!1},{name:"memory",getValue:e=>e.memory,isAscending:!1}],0,s),c=Object(n.useMemo)((()=>e.sort(((e,t)=>Wa.indexOf(e.state)-Wa.indexOf(t.state)))),[e]);return a?r.a.createElement(gn,null):0===c.length?r.a.createElement(g.EuiEmptyPrompt,{iconType:"search",titleSize:"s",title:r.a.createElement("strong",null,p.i18n.translate("xpack.infra.metrics.nodeDetails.noProcesses",{defaultMessage:"No processes found"})),body:r.a.createElement(g.EuiText,{size:"s"},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.metrics.nodeDetails.noProcessesBody",defaultMessage:"Try modifying your filter. Only processes that are within the configured {metricbeatDocsLink} will display here.",values:{metricbeatDocsLink:r.a.createElement(g.EuiLink,{href:"https://www.elastic.co/guide/en/beats/metricbeat/current/metricbeat-module-system.html",target:"_blank"},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.metrics.nodeDetails.noProcessesBody.metricbeatDocsLinkText",defaultMessage:"top N by CPU or Memory"}))}})),actions:r.a.createElement(g.EuiButton,{onClick:l},p.i18n.translate("xpack.infra.metrics.nodeDetails.noProcessesClearFilters",{defaultMessage:"Clear filters"}))}):r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiTable,{responsive:!1},r.a.createElement(g.EuiTableHeader,null,r.a.createElement(g.EuiTableHeaderCell,{width:24}),En.map((e=>{var t;return r.a.createElement(g.EuiTableHeaderCell,{key:`${String(e.field)}-header`,align:null!==(t=e.align)&&void 0!==t?t:g.LEFT_ALIGNMENT,width:e.width,onSort:e.sortable?()=>o(e.field):void 0,isSorted:i.name===e.field,isSortAscending:i.name===e.field&&i.isAscending},e.name)}))),r.a.createElement(bn,null,r.a.createElement(fn,{items:c,currentTime:t}))))},gn=()=>r.a.createElement("div",{style:{width:"100%",height:"200px",padding:"16px",display:"flex",alignItems:"center",justifyContent:"center"}},r.a.createElement(g.EuiLoadingChart,{size:"xl"})),fn=({items:e,currentTime:t})=>r.a.createElement(r.a.Fragment,null,e.map(((e,a)=>{const n=En.map((n=>{var i,s;return r.a.createElement(g.EuiTableRowCell,{key:`${String(n.field)}-${a}`,mobileOptions:{header:n.name},align:null!==(i=n.align)&&void 0!==i?i:g.LEFT_ALIGNMENT,textOnly:null===(s=n.textOnly)||void 0===s||s},n.render?n.render(e[n.field],t):e[n.field])}));return r.a.createElement(ln,{cells:n,item:e,key:`row-${a}`})}))),bn=Object(V.euiStyled)(g.EuiTableBody)`
  & .euiTableCellContent {
    padding-top: 0;
    padding-bottom: 0;

  }
`,hn=36e5,yn=({startTime:e,currentTime:t})=>{let a=t-e;const n=Math.floor(a/hn);a-=n*hn;const i=Math.floor(a/6e4);a-=6e4*i;const s=Math.floor(a/1e3);a-=1e3*s;const l=n?`${n}:`:"",o=i<10?`0${i}:`:`${i}:`,c=s<10?`0${s}`:s;return r.a.createElement(r.a.Fragment,null,`${l}${o}${c}`)},En=[{field:"state",name:p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.columnLabelState",{defaultMessage:"State"}),sortable:!1,render:e=>r.a.createElement(mn,{state:e}),width:84,textOnly:!1},{field:"command",name:p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.columnLabelCommand",{defaultMessage:"Command"}),sortable:!1,width:"40%",render:e=>r.a.createElement(vn,null,e)},{field:"startTime",name:p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.columnLabelTime",{defaultMessage:"Time"}),align:g.RIGHT_ALIGNMENT,sortable:!0,render:(e,t)=>r.a.createElement(yn,{startTime:e,currentTime:t})},{field:"cpu",name:p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.columnLabelCPU",{defaultMessage:"CPU"}),sortable:!0,render:e=>Za.a.percent(e)},{field:"memory",name:p.i18n.translate("xpack.infra.metrics.nodeDetails.processes.columnLabelMemory",{defaultMessage:"Mem."}),sortable:!0,render:e=>Za.a.percent(e)}],vn=V.euiStyled.div`
  font-family: ${e=>e.theme.eui.euiCodeFontFamily};
  font-size: ${e=>e.theme.eui.euiFontSizeS};
  white-space: pre;
  overflow: hidden;
  text-overflow: ellipsis;
`,xn=e=>e.replace(/([+-=!\(\)\{\}\[\]^"~*?:\\/!]|&&|\|\|)/g,"\\$1"),kn={id:"processes",name:p.i18n.translate("xpack.infra.metrics.nodeDetails.tabs.processes",{defaultMessage:"Processes"}),content:({currentTime:e,node:t,nodeType:a})=>{var i,s;const[l,o]=Object(n.useState)(g.Query.MATCH_ALL),[c,u]=Object(n.useState)(""),[d,m]=Object(n.useState)({name:"cpu",isAscending:!1}),f=Object(n.useMemo)((()=>{var e;return{[null!==(e=Object(aa.c)(a))&&void 0!==e?e:a]:t.name}}),[t,a]),{loading:b,error:h,response:y,makeRequest:E}=function(e,t,a,r){const{createDerivedIndexPattern:i}=Object(j.c)(),s=i().title,[l,o]=Object(n.useState)(!1),c="runtimeLength"===a.name?{...a,name:"startTime"}:a,{error:u,loading:d,response:m,makeRequest:p}=Object(Ua.a)("/api/metrics/process_list","POST",JSON.stringify({hostTerm:e,indexPattern:s,to:t,sortBy:c,searchFilter:r}),(e=>Object(Re.pipe)(za.i.decode(e),Object(Ae.fold)(Object($a.c)($a.a),Ne.identity))));return Object(n.useEffect)((()=>o(!0)),[u]),Object(n.useEffect)((()=>o(!1)),[d]),Object(n.useEffect)((()=>{p()}),[p]),{error:l,loading:d,response:m,makeRequest:p}}(f,e,d,(e=>{if(""===e.trim())return[{match_all:{}}];const t=e.split(" ").map((e=>e.trim())).filter(Boolean),a=t.filter((e=>e.startsWith("state=")));return[...t.filter((e=>!e.startsWith("state="))).map((e=>({query_string:{fields:["system.process.cmdline"],query:`*${xn(e)}*`,minimum_should_match:1}}))),...a.map((e=>({match:{"system.process.state":e.replace("state=","")}})))]})(c)),v=Object(n.useMemo)((()=>Object(R.debounce)((e=>u(e)),500)),[u]),x=Object(n.useCallback)((({query:e,queryText:t})=>{o(e),v(t)}),[o,v]),k=Object(n.useCallback)((()=>{o(g.Query.MATCH_ALL),u("")}),[o,u]);return r.a.createElement(pa,null,r.a.createElement(Ha,{hostTerm:f,to:e},r.a.createElement(Ka,{isLoading:b,processSummary:null!==(i=h?null:null==y?void 0:y.summary)&&void 0!==i?i:{total:0}}),r.a.createElement(g.EuiSpacer,{size:"m"}),r.a.createElement(g.EuiText,null,r.a.createElement("h4",null,p.i18n.translate("xpack.infra.metrics.nodeDetails.processesHeader",{defaultMessage:"Top processes"})," ",r.a.createElement(g.EuiIconTip,{"aria-label":p.i18n.translate("xpack.infra.metrics.nodeDetails.processesHeader.tooltipLabel",{defaultMessage:"More info"}),size:"m",type:"iInCircle",content:p.i18n.translate("xpack.infra.metrics.nodeDetails.processesHeader.tooltipBody",{defaultMessage:"The table below aggregates the top CPU and top memory consuming processes. It does not display all processes."})}))),r.a.createElement(g.EuiSpacer,{size:"m"}),r.a.createElement(g.EuiSearchBar,{query:l,onChange:x,box:{incremental:!0,placeholder:p.i18n.translate("xpack.infra.metrics.nodeDetails.searchForProcesses",{defaultMessage:"Search for processes…"})},filters:[{type:"field_value_selection",field:"state",name:"State",operator:"exact",multiSelect:!1,options:Object.entries(Ja).map((([e,t])=>({value:e,view:t})))}]}),r.a.createElement(g.EuiSpacer,{size:"m"}),h?r.a.createElement(g.EuiEmptyPrompt,{iconType:"alert",title:r.a.createElement("h4",null,p.i18n.translate("xpack.infra.metrics.nodeDetails.processListError",{defaultMessage:"Unable to load process data"})),actions:r.a.createElement(g.EuiButton,{color:"primary",fill:!0,onClick:E},p.i18n.translate("xpack.infra.metrics.nodeDetails.processListRetry",{defaultMessage:"Try again"}))}):r.a.createElement(pn,{currentTime:e,isLoading:b||!y,processList:null!==(s=null==y?void 0:y.processList)&&void 0!==s?s:[],sortBy:d,setSortBy:m,clearSearchBar:k})))}};var Mn=a(165),On=a(185);const wn=(e,t)=>{const a=t.filter((e=>e&&"metrics"===e.source)).map((e=>e&&e.name));return e.filter((e=>{const t=(0,On.a.tsvb[e])(T.j,"test",">=1m");return a.some((e=>e&&t.requires.includes(e)))}))};function jn(e,t,a,r,i){const{error:s,loading:l,response:o,makeRequest:c}=Object(Ua.a)("/api/infra/metadata","POST",JSON.stringify({nodeId:e,nodeType:t,sourceId:r,timeRange:{from:i.from,to:i.to}}),(e=>Object(Re.pipe)(Mn.a.decode(e),Object(Ae.fold)(Object($a.c)($a.a),Ne.identity))));return Object(n.useEffect)((()=>{(async()=>{await c()})()}),[c]),{name:o&&o.name||"",filteredRequiredMetrics:o&&wn(a,o.features)||[],error:s&&s.message||null,loading:l,metadata:o,cloudId:o&&o.info&&o.info.cloud&&o.info.cloud.instance&&o.info.cloud.instance.id||""}}const Sn=(e,t)=>{var a,n,r,i,s,l,o,c,u,d,m,p,g,f,b,h,y,E,v,x,k,M,O,w,j,S,C,T,L,F,P,I,D,_,B,R,A,N,V,z,$,U,q,H,G,J,W,K,Q,X,Y,Z,ee,te,ae,ne,re;switch(t){case"host":return Cn([{name:"host.architecture",value:null===(a=e.info)||void 0===a||null===(n=a.host)||void 0===n?void 0:n.architecture},{name:"host.hostname",value:null===(r=e.info)||void 0===r||null===(i=r.host)||void 0===i?void 0:i.name},{name:"host.id",value:null===(s=e.info)||void 0===s||null===(l=s.host)||void 0===l?void 0:l.id},{name:"host.ip",value:null===(o=e.info)||void 0===o||null===(c=o.host)||void 0===c?void 0:c.ip},{name:"host.mac",value:null===(u=e.info)||void 0===u||null===(d=u.host)||void 0===d?void 0:d.mac},{name:"host.name",value:null===(m=e.info)||void 0===m||null===(p=m.host)||void 0===p?void 0:p.name},{name:"host.os.build",value:null===(g=e.info)||void 0===g||null===(f=g.host)||void 0===f||null===(b=f.os)||void 0===b?void 0:b.build},{name:"host.os.family",value:null===(h=e.info)||void 0===h||null===(y=h.host)||void 0===y||null===(E=y.os)||void 0===E?void 0:E.family},{name:"host.os.name",value:null===(v=e.info)||void 0===v||null===(x=v.host)||void 0===x||null===(k=x.os)||void 0===k?void 0:k.name},{name:"host.os.kernel",value:null===(M=e.info)||void 0===M||null===(O=M.host)||void 0===O||null===(w=O.os)||void 0===w?void 0:w.kernel},{name:"host.os.platform",value:null===(j=e.info)||void 0===j||null===(S=j.host)||void 0===S||null===(C=S.os)||void 0===C?void 0:C.platform},{name:"host.os.version",value:null===(T=e.info)||void 0===T||null===(L=T.host)||void 0===L||null===(F=L.os)||void 0===F?void 0:F.version}]);case"cloud":return Cn([{name:"cloud.account.id",value:null===(P=e.info)||void 0===P||null===(I=P.cloud)||void 0===I||null===(D=I.account)||void 0===D?void 0:D.id},{name:"cloud.account.name",value:null===(_=e.info)||void 0===_||null===(B=_.cloud)||void 0===B||null===(R=B.account)||void 0===R?void 0:R.name},{name:"cloud.availability_zone",value:null===(A=e.info)||void 0===A||null===(N=A.cloud)||void 0===N?void 0:N.availability_zone},{name:"cloud.instance.id",value:null===(V=e.info)||void 0===V||null===(z=V.cloud)||void 0===z||null===($=z.instance)||void 0===$?void 0:$.id},{name:"cloud.instance.name",value:null===(U=e.info)||void 0===U||null===(q=U.cloud)||void 0===q||null===(H=q.instance)||void 0===H?void 0:H.name},{name:"cloud.machine.type",value:null===(G=e.info)||void 0===G||null===(J=G.cloud)||void 0===J||null===(W=J.machine)||void 0===W?void 0:W.type},{name:"cloud.provider",value:null===(K=e.info)||void 0===K||null===(Q=K.cloud)||void 0===Q?void 0:Q.provider},{name:"cloud.region",value:null===(X=e.info)||void 0===X||null===(Y=X.cloud)||void 0===Y?void 0:Y.region}]);case"agent":return Cn([{name:"agent.id",value:null===(Z=e.info)||void 0===Z||null===(ee=Z.agent)||void 0===ee?void 0:ee.id},{name:"agent.version",value:null===(te=e.info)||void 0===te||null===(ae=te.agent)||void 0===ae?void 0:ae.version},{name:"agent.policy",value:null===(ne=e.info)||void 0===ne||null===(re=ne.agent)||void 0===re?void 0:re.policy}])}},Cn=e=>e.filter((e=>!!e.value)),Tn=e=>{const{rows:t,title:a,onClick:i}=e,s=Object(n.useMemo)((()=>[{field:"name",name:"",width:"35%",sortable:!1,render:(e,t)=>r.a.createElement(g.EuiText,{size:"xs"},r.a.createElement("strong",null,t.name))},{field:"value",name:"",width:"65%",sortable:!1,render:(e,t)=>r.a.createElement("span",null,r.a.createElement(g.EuiFlexGroup,{gutterSize:"xs",alignItems:"center",responsive:!1},r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiToolTip,{content:p.i18n.translate("xpack.infra.nodeDetails.tabs.metadata.setFilterTooltip",{defaultMessage:"View event with filter"})},r.a.createElement(g.EuiButtonIcon,{color:"text",size:"s",iconType:"filter","aria-label":p.i18n.translate("xpack.infra.nodeDetails.tabs.metadata.filterAriaLabel",{defaultMessage:"Filter"}),onClick:()=>i(t)}))),r.a.createElement(g.EuiFlexItem,null,!Array.isArray(t.value)&&t.value,Array.isArray(t.value)&&r.a.createElement(Ln,{values:t.value}))))}]),[i]);return r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiText,null,r.a.createElement("h4",null,a)),r.a.createElement(g.EuiSpacer,{size:"s"}),r.a.createElement(table_TableWithoutHeader,{tableLayout:"fixed",compressed:!0,responsive:!1,columns:s,items:t}))};class table_TableWithoutHeader extends g.EuiBasicTable{renderTableHead(){return r.a.createElement(r.a.Fragment,null)}}const Ln=e=>{const{values:t}=e,[a,i]=Object(n.useState)(!1),s=Object(n.useCallback)((()=>{i(!0)}),[]),l=Object(n.useCallback)((()=>{i(!1)}),[]);return r.a.createElement(r.a.Fragment,null,!a&&r.a.createElement(g.EuiFlexGroup,{gutterSize:"xs",responsive:!1,alignItems:"baseline",wrap:!0},r.a.createElement(g.EuiFlexItem,{grow:!1},Object(R.first)(t)," ... "),r.a.createElement(g.EuiFlexItem,null,r.a.createElement(g.EuiLink,{onClick:s},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.nodeDetails.tabs.metadata.seeMore",defaultMessage:"+{count} more",values:{count:t.length}})))),a&&r.a.createElement("div",null,t.map((e=>r.a.createElement("div",{key:e},e))),r.a.createElement(g.EuiLink,{onClick:l},p.i18n.translate("xpack.infra.nodeDetails.tabs.metadata.seeLess",{defaultMessage:"Show less"}))))},Fn=V.euiStyled.div`
  &:not(:last-child) {
    margin-bottom: 16px
  }
`,Pn=()=>r.a.createElement("div",{style:{width:"100%",height:"200px",padding:"16px",display:"flex",alignItems:"center",justifyContent:"center"}},r.a.createElement(g.EuiLoadingChart,{size:"xl"})),In={id:"properties",name:p.i18n.translate("xpack.infra.nodeDetails.tabs.metadata.title",{defaultMessage:"Metadata"}),content:e=>{const t=e.node.id,a=e.nodeType,i=Object(aa.b)(a),{sourceId:s}=Object(n.useContext)(j.a.Context),{currentTimeRange:l}=vt(),{applyFilterQuery:o}=Pt(),{loading:c,metadata:u}=jn(t,a,i.requiredMetrics,s,l),d=Object(n.useMemo)((()=>u?Sn(u,"host"):null),[u]),m=Object(n.useMemo)((()=>u?Sn(u,"cloud"):null),[u]),g=Object(n.useMemo)((()=>u?Sn(u,"agent"):null),[u]),f=Object(n.useCallback)((e=>{o({kind:"kuery",expression:`${e.name}: "${e.value}"`})}),[o]);return c?r.a.createElement(Pn,null):r.a.createElement(pa,null,d&&d.length>0&&r.a.createElement(Fn,null,r.a.createElement(Tn,{title:p.i18n.translate("xpack.infra.nodeDetails.tabs.metadata.hostsHeader",{defaultMessage:"Hosts"}),onClick:f,rows:d})),m&&m.length>0&&r.a.createElement(Fn,null,r.a.createElement(Tn,{title:p.i18n.translate("xpack.infra.nodeDetails.tabs.metadata.cloudHeader",{defaultMessage:"Cloud"}),onClick:f,rows:m})),g&&g.length>0&&r.a.createElement(Fn,null,r.a.createElement(Tn,{title:p.i18n.translate("xpack.infra.nodeDetails.tabs.metadata.agentHeader",{defaultMessage:"Agent"}),onClick:f,rows:g})))}};var Dn=a(27),_n=a(91);const Bn=Be.tuple([Be.union([Be.string,Be.number]),Be.union([Be.string,Be.number])]),Rn=Be.keyof({metrics_hosts:null,metrics_k8s:null}),An=Be.keyof({anomalyScore:null,dataset:null,startTime:null}),Nn=Be.keyof({asc:null,desc:null}),Vn=Be.type({searchBefore:Bn}),zn=Be.type({searchAfter:Bn}),$n=Be.intersection([Be.type({pageSize:Be.number}),Be.partial({cursor:Be.union([Vn,zn])})]),Un=Be.type({field:An,direction:Nn}),qn=Be.keyof({memory_usage:null,network_in:null,network_out:null}),Hn=Be.intersection([Be.type({id:Be.string,anomalyScore:Be.number,typical:Be.number,actual:Be.number,type:Rn,influencers:Be.array(Be.string),duration:Be.number,startTime:Be.number,jobId:Be.string}),Be.partial({partitionFieldName:Be.string,partitionFieldValue:Be.string})]),Gn=Be.intersection([Be.type({data:Be.intersection([Be.type({anomalies:Be.array(Hn),hasMoreEntries:Be.boolean}),Be.partial({paginationCursors:Be.type({previousPageCursor:Bn,nextPageCursor:Bn})})])}),Be.partial({timing:_n.c})]),Jn=Be.type({data:Be.intersection([Be.type({sourceId:Be.string,anomalyThreshold:Be.number,timeRange:_n.d}),Be.partial({query:Be.string,hostName:Be.string,metric:qn,pagination:$n,sort:Un})])}),Wn=Be.intersection([Be.type({id:Be.string,anomalyScore:Be.number,typical:Be.number,actual:Be.number,type:Rn,influencers:Be.array(Be.string),duration:Be.number,startTime:Be.number,jobId:Be.string}),Be.partial({partitionFieldName:Be.string,partitionFieldValue:Be.string})]),Kn=Be.intersection([Be.type({data:Be.intersection([Be.type({anomalies:Be.array(Wn),hasMoreEntries:Be.boolean}),Be.partial({paginationCursors:Be.type({previousPageCursor:Bn,nextPageCursor:Bn})})])}),Be.partial({timing:_n.c})]),Qn=Be.type({data:Be.intersection([Be.type({sourceId:Be.string,anomalyThreshold:Be.number,timeRange:_n.d}),Be.partial({query:Be.string,metric:qn,pagination:$n,sort:Un})])});var Xn=a(68);const Yn=(e,t)=>{const a={page:1,paginationCursor:void 0};switch(t.type){case"changePaginationOptions":case"changeSortOptions":case"changeTimeRange":case"changeFilteredDatasets":return{...e,...a,...t.payload};case"changeHasNextPage":case"changeLastReceivedCursors":return{...e,...t.payload};case"fetchNextPage":return e.lastReceivedCursors?{...e,page:e.page+1,paginationCursor:{searchAfter:e.lastReceivedCursors.nextPageCursor}}:e;case"fetchPreviousPage":return e.lastReceivedCursors?{...e,page:e.page-1,paginationCursor:{searchBefore:e.lastReceivedCursors.previousPageCursor}}:e;default:return e}},Zn={page:1,lastReceivedCursors:void 0,paginationCursor:void 0,hasNextPage:!1},er=({endTime:e,startTime:t,sourceId:a,anomalyThreshold:r,defaultSortOptions:i,defaultPaginationOptions:s,onGetMetricsHostsAnomaliesDatasetsError:l,filteredDatasets:o})=>{const{services:c}=Object(Ye.b)(),[u,d]=Object(n.useReducer)(Yn,Zn,(a=>({...a,paginationOptions:s,sortOptions:i,filteredDatasets:o,timeRange:{start:t,end:e}}))),[m,p]=Object(n.useState)([]),[g,f]=Object(Xn.c)({cancelPreviousOn:"creation",createPromise:async(e,t)=>{const{timeRange:{start:n,end:i},sortOptions:s,paginationOptions:l,paginationCursor:o}=u;return await tr({sourceId:a,anomalyThreshold:r,startTime:n,endTime:i,metric:e,query:t,sort:s,pagination:{...l,cursor:o}},c.http.fetch)},onResolve:({data:{anomalies:e,paginationCursors:t,hasMoreEntries:a}})=>{const{paginationCursor:n}=u;t&&d({type:"changeLastReceivedCursors",payload:{lastReceivedCursors:t}}),!n||n&&"searchAfter"in n?d({type:"changeHasNextPage",payload:{hasNextPage:a}}):n&&"searchBefore"in n&&d({type:"changeHasNextPage",payload:{hasNextPage:!0}}),p(e)}},[a,r,d,u.timeRange.start,u.timeRange.end,u.sortOptions,u.paginationOptions,u.paginationCursor,u.filteredDatasets]),b=Object(n.useCallback)((e=>{d({type:"changeSortOptions",payload:{sortOptions:e}})}),[d]),h=Object(n.useCallback)((e=>{d({type:"changePaginationOptions",payload:{paginationOptions:e}})}),[d]);Object(n.useEffect)((()=>{d({type:"changeTimeRange",payload:{timeRange:{start:t,end:e}}})}),[t,e]),Object(n.useEffect)((()=>{d({type:"changeFilteredDatasets",payload:{filteredDatasets:o}})}),[o]);const y=Object(n.useCallback)((()=>{u.lastReceivedCursors&&d({type:"fetchNextPage"})}),[d,u]),E=Object(n.useCallback)((()=>{u.lastReceivedCursors&&d({type:"fetchPreviousPage"})}),[d,u]);return{metricsK8sAnomalies:m,getMetricsK8sAnomalies:f,isLoadingMetricsK8sAnomalies:Object(n.useMemo)((()=>"pending"===g.state),[g.state]),hasFailedLoadingMetricsK8sAnomalies:Object(n.useMemo)((()=>"rejected"===g.state),[g.state]),changeSortOptions:b,sortOptions:u.sortOptions,changePaginationOptions:h,paginationOptions:u.paginationOptions,fetchPreviousPage:u.page>1?E:void 0,fetchNextPage:u.hasNextPage?y:void 0,page:u.page}},tr=async(e,t)=>{const{sourceId:a,anomalyThreshold:n,startTime:r,endTime:i,metric:s,query:l,sort:o,pagination:c}=e,u=await t("/api/infra/infra_ml/results/metrics_k8s_anomalies",{method:"POST",body:JSON.stringify(Qn.encode({data:{sourceId:a,anomalyThreshold:n,timeRange:{startTime:r,endTime:i},metric:s,query:l,sort:o,pagination:c}}))});return Object($a.b)(Kn)(u)},ar=(e,t)=>{const a={page:1,paginationCursor:void 0};switch(t.type){case"changePaginationOptions":case"changeSortOptions":case"changeTimeRange":case"changeFilteredDatasets":return{...e,...a,...t.payload};case"changeHasNextPage":case"changeLastReceivedCursors":return{...e,...t.payload};case"fetchNextPage":return e.lastReceivedCursors?{...e,page:e.page+1,paginationCursor:{searchAfter:e.lastReceivedCursors.nextPageCursor}}:e;case"fetchPreviousPage":return e.lastReceivedCursors?{...e,page:e.page-1,paginationCursor:{searchBefore:e.lastReceivedCursors.previousPageCursor}}:e;default:return e}},nr={page:1,lastReceivedCursors:void 0,paginationCursor:void 0,hasNextPage:!1},rr=({endTime:e,startTime:t,sourceId:a,anomalyThreshold:r,defaultSortOptions:i,defaultPaginationOptions:s,onGetMetricsHostsAnomaliesDatasetsError:l,filteredDatasets:o})=>{const{services:c}=Object(Ye.b)(),[u,d]=Object(n.useReducer)(ar,nr,(a=>({...a,paginationOptions:s,sortOptions:i,filteredDatasets:o,timeRange:{start:t,end:e}}))),[m,p]=Object(n.useState)([]),[g,f]=Object(Xn.c)({cancelPreviousOn:"creation",createPromise:async(e,t,n)=>{const{timeRange:{start:i,end:s},sortOptions:l,paginationOptions:o,paginationCursor:d}=u;return await ir({sourceId:a,anomalyThreshold:r,startTime:i,endTime:s,metric:e,query:t,sort:l,pagination:{...o,cursor:d},hostName:n},c.http.fetch)},onResolve:({data:{anomalies:e,paginationCursors:t,hasMoreEntries:a}})=>{const{paginationCursor:n}=u;t&&d({type:"changeLastReceivedCursors",payload:{lastReceivedCursors:t}}),!n||n&&"searchAfter"in n?d({type:"changeHasNextPage",payload:{hasNextPage:a}}):n&&"searchBefore"in n&&d({type:"changeHasNextPage",payload:{hasNextPage:!0}}),p(e)}},[a,r,d,u.timeRange.start,u.timeRange.end,u.sortOptions,u.paginationOptions,u.paginationCursor,u.filteredDatasets]),b=Object(n.useCallback)((e=>{d({type:"changeSortOptions",payload:{sortOptions:e}})}),[d]),h=Object(n.useCallback)((e=>{d({type:"changePaginationOptions",payload:{paginationOptions:e}})}),[d]);Object(n.useEffect)((()=>{d({type:"changeTimeRange",payload:{timeRange:{start:t,end:e}}})}),[t,e]),Object(n.useEffect)((()=>{d({type:"changeFilteredDatasets",payload:{filteredDatasets:o}})}),[o]);const y=Object(n.useCallback)((()=>{u.lastReceivedCursors&&d({type:"fetchNextPage"})}),[d,u]),E=Object(n.useCallback)((()=>{u.lastReceivedCursors&&d({type:"fetchPreviousPage"})}),[d,u]);return{metricsHostsAnomalies:m,getMetricsHostsAnomalies:f,isLoadingMetricsHostsAnomalies:Object(n.useMemo)((()=>"pending"===g.state),[g.state]),hasFailedLoadingMetricsHostsAnomalies:Object(n.useMemo)((()=>"rejected"===g.state),[g.state]),changeSortOptions:b,sortOptions:u.sortOptions,changePaginationOptions:h,paginationOptions:u.paginationOptions,fetchPreviousPage:u.page>1?E:void 0,fetchNextPage:u.hasNextPage?y:void 0,page:u.page,timeRange:u.timeRange}},ir=async(e,t)=>{const{sourceId:a,anomalyThreshold:n,startTime:r,endTime:i,metric:s,sort:l,pagination:o,query:c,hostName:u}=e,d=await t("/api/infra/infra_ml/results/metrics_hosts_anomalies",{method:"POST",body:JSON.stringify(Jn.encode({data:{sourceId:a,anomalyThreshold:n,timeRange:{startTime:r,endTime:i},query:c,metric:s,sort:l,pagination:o,hostName:u}}))});return Object($a.b)(Gn)(d)},sr=p.i18n.translate("xpack.infra.logs.analysis.anomaliesTablePreviousPageLabel",{defaultMessage:"Previous page"}),lr=p.i18n.translate("xpack.infra.logs.analysis.anomaliesTableNextPageLabel",{defaultMessage:"Next page"}),or=({fetchPreviousPage:e,fetchNextPage:t,page:a,isLoading:n})=>r.a.createElement(g.EuiFlexGroup,{justifyContent:"center"},r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiFlexGroup,null,r.a.createElement(g.EuiButtonIcon,{iconType:"arrowLeft",isDisabled:!e||n,onClick:e,"aria-label":sr}),r.a.createElement("span",null,r.a.createElement("strong",null,a)),r.a.createElement(g.EuiButtonIcon,{iconType:"arrowRight",isDisabled:!t||n,onClick:t,"aria-label":lr}))));var cr=a(69);const ur=({anomaly:e})=>{const{actual:t,typical:a}=e,n=p.i18n.translate("xpack.infra.ml.anomalyFlyout.anomaliesTableMoreThanExpectedAnomalyMessage",{defaultMessage:"more"}),i=p.i18n.translate("xpack.infra.ml.anomalyFlyout.anomaliesTableFewerThanExpectedAnomalyMessage",{defaultMessage:"fewer"}),s=t>a,l=s?n:i,o=s?t/a:a/t,c=s?"sortUp":"sortDown",u=o!==1/0?`${Object(cr.h)(o)}x`:"";return r.a.createElement(g.EuiFlexGroup,{gutterSize:"s",responsive:!1,alignItems:"center"},r.a.createElement(g.EuiFlexItem,{grow:!1,component:"span"},r.a.createElement(g.EuiIcon,{type:c})),r.a.createElement(g.EuiFlexItem,{component:"span"},`${u} ${l}`))};var dr=a(171),mr=a(53),pr=a(192);const gr=Be.type({capabilities:Be.type({canGetJobs:Be.boolean,canCreateJob:Be.boolean,canDeleteJob:Be.boolean,canOpenJob:Be.boolean,canCloseJob:Be.boolean,canForecastJob:Be.boolean,canGetDatafeeds:Be.boolean,canStartStopDatafeed:Be.boolean,canUpdateJob:Be.boolean,canUpdateDatafeed:Be.boolean,canPreviewDatafeed:Be.boolean}),isPlatinumOrTrialLicense:Be.boolean,mlFeatureEnabledInSpace:Be.boolean,upgradeInProgress:Be.boolean}),fr=()=>{const{services:e}=Object(Ye.b)(),[t,a]=Object(n.useState)(yr),[r,i]=Object(Xn.c)({cancelPreviousOn:"resolution",createPromise:async()=>{const t=await e.http.fetch("/api/ml/ml_capabilities");return Object(Re.pipe)(gr.decode(t),Object(Ae.fold)(Object($a.c)($a.a),Ne.identity))},onResolve:e=>{a(e)}},[]);Object(n.useEffect)((()=>{i()}),[i]);const s=Object(n.useMemo)((()=>"pending"===r.state),[r.state]),l=t.capabilities.canCreateJob,o=t.capabilities.canGetJobs;return{hasInfraMLCapabilities:t.isPlatinumOrTrialLicense&&t.mlFeatureEnabledInSpace,hasInfraMLReadCapabilities:o,hasInfraMLSetupCapabilities:l,isLoading:s}},[br,hr]=_e()(fr),yr={capabilities:{canGetJobs:!1,canCreateJob:!1,canDeleteJob:!1,canOpenJob:!1,canCloseJob:!1,canForecastJob:!1,canGetDatafeeds:!1,canStartStopDatafeed:!1,canUpdateJob:!1,canUpdateDatafeed:!1,canPreviewDatafeed:!1,canGetCalendars:!1,canCreateCalendar:!1,canDeleteCalendar:!1,canGetFilters:!1,canCreateFilter:!1,canDeleteFilter:!1,canFindFileStructure:!1,canGetDataFrameJobs:!1,canDeleteDataFrameJob:!1,canPreviewDataFrameJob:!1,canCreateDataFrameJob:!1,canStartStopDataFrameJob:!1},isPlatinumOrTrialLicense:!1,mlFeatureEnabledInSpace:!1,upgradeInProgress:!1};var Er=a(187),vr=a(97);const xr=({jobTypes:e})=>({jobStatus:e.reduce(((e,t)=>({...e,[t]:"unknown"})),{}),jobSummaries:[],lastSetupErrorMessages:[],setupStatus:{type:"initializing"}}),kr=e=>null!=e.error,Mr=e=>Object(n.useReducer)((e=>(t,a)=>{switch(a.type){case"startedSetup":return{...t,jobStatus:e.reduce(((e,t)=>({...e,[t]:"initializing"})),{}),setupStatus:{type:"pending"}};case"finishedSetup":{const{datafeedSetupResults:n,jobSetupResults:r,jobSummaries:i,spaceId:s,sourceId:l}=a,o=e.reduce(((e,t)=>{return{...e,[t]:(i=Object(vr.c)(s,l,t),e=>e.filter((e=>e.id===i&&e.success&&!e.error)).length>0)(r)&&(a=Object(vr.b)(s,l,t),e=>e.filter((e=>e.id===a&&e.success&&e.started&&!e.error)).length>0)(n)?"started":"failed"};var a,i}),{}),c=Object.values(o).every((e=>"started"===e))?{type:"succeeded"}:{type:"failed",reasons:[...Object.values(n).filter(kr).map((e=>e.error.msg)),...Object.values(r).filter(kr).map((e=>e.error.msg))]};return{...t,jobStatus:o,jobSummaries:i,setupStatus:c}}case"failedSetup":return{...t,jobStatus:e.reduce(((e,t)=>({...e,[t]:"failed"})),{}),setupStatus:{type:"failed",reasons:["unknown"]}};case"fetchingJobStatuses":return{...t,setupStatus:"unknown"===t.setupStatus.type?{type:"initializing"}:t.setupStatus};case"fetchedJobStatuses":{const{payload:r,spaceId:i,sourceId:s}=a,{setupStatus:l}=t,o=e.reduce(((e,t)=>{return{...e,[t]:(a=Object(vr.c)(i,s,t),e=>e.filter((e=>e.id===a)).map((e=>"failed"===e.jobState||""===e.datafeedState?"failed":"closed"===e.jobState&&"stopped"===e.datafeedState&&e.fullJob&&null!=e.fullJob.finished_time?"finished":"closed"===e.jobState||"closing"===e.jobState||"stopped"===e.datafeedState?"stopped":"opening"===e.jobState&&!1===e.awaitingNodeAssignment||"resetting"===e.jobState||"reverting"===e.jobState?"initializing":"opened"===e.jobState&&"started"===e.datafeedState||"opening"===e.jobState&&"starting"===e.datafeedState&&!0===e.awaitingNodeAssignment?"started":"unknown"))[0]||"missing")(r)};var a}),{}),c=(n=o,e=>Object.entries(n).reduce(((e,[,t])=>"missing"===t?{type:"required"}:"required"===e.type||"succeeded"===e.type?e:"skipped"===e.type||Object(vr.e)(t)?{type:"skipped",newlyCreated:"skipped"===e.type&&e.newlyCreated}:e),e))(l);return{...t,jobSummaries:r,jobStatus:o,setupStatus:c}}case"failedFetchingJobStatuses":return{...t,setupStatus:{type:"unknown"},jobStatus:e.reduce(((e,t)=>({...e,[t]:"unknown"})),{})};case"viewedResults":return{...t,setupStatus:{type:"skipped",newlyCreated:!0}};default:return t}var n})(e),{jobTypes:e},xr),Or=({sourceConfiguration:e,moduleDescriptor:t})=>{const{services:a}=Object(Ye.b)(),{spaceId:r,sourceId:i}=e,[s,l]=Mr(t.jobTypes),[,o]=Object(Xn.c)({cancelPreviousOn:"resolution",createPromise:async()=>(l({type:"fetchingJobStatuses"}),await t.getJobSummary(r,i,a.http.fetch)),onResolve:e=>{l({type:"fetchedJobStatuses",payload:e,spaceId:r,sourceId:i})},onReject:()=>{l({type:"failedFetchingJobStatuses"})}},[r,i]),[,c]=Object(Xn.c)({cancelPreviousOn:"resolution",createPromise:async(e,n,s,o,c)=>(l({type:"startedSetup"}),{setupResult:await t.setUpModule({start:n,end:s,filter:o,moduleSourceConfiguration:{indices:e,sourceId:i,spaceId:r},partitionField:c},a.http.fetch),jobSummaries:await t.getJobSummary(r,i,a.http.fetch)}),onResolve:({setupResult:{datafeeds:e,jobs:t},jobSummaries:a})=>{l({type:"finishedSetup",datafeedSetupResults:e,jobSetupResults:t,jobSummaries:a,spaceId:r,sourceId:i})},onReject:()=>{l({type:"failedSetup"})}},[t.setUpModule,r,i]),[u,d]=Object(Xn.c)({cancelPreviousOn:"resolution",createPromise:async()=>await t.cleanUpModule(r,i,a.http.fetch)},[r,i]),m=Object(n.useMemo)((()=>"pending"===u.state),[u.state]),p=Object(n.useCallback)(((e,t,a,n,r)=>{l({type:"startedSetup"}),d().then((()=>{c(e,t,a,n,r)})).catch((()=>{l({type:"failedSetup"})}))}),[d,l,c]),g=Object(n.useCallback)((()=>{l({type:"viewedResults"})}),[l]),f=Object(n.useMemo)((()=>t.getJobIds(r,i)),[t,r,i]);return{cleanUpAndSetUpModule:p,cleanUpModule:d,fetchJobStatus:o,isCleaningUp:m,jobIds:f,jobStatus:s.jobStatus,jobSummaries:s.jobSummaries,lastSetupErrorMessages:s.lastSetupErrorMessages,moduleDescriptor:t,setUpModule:c,setupStatus:s.setupStatus,sourceConfiguration:e,viewResults:g}},wr=({moduleDescriptor:e,sourceConfiguration:t})=>({getIsJobConfigurationOutdated:Object(n.useMemo)((()=>jr(e,t)),[t,e])}),jr=({bucketSpan:e},t)=>a=>{if(!a.fullJob||!a.fullJob.custom_settings)return!1;const n=a.fullJob.custom_settings.metrics_source_config;return!(n&&n.bucketSpan===e&&n.indexPattern&&Sr(new Set(n.indexPattern.split(",")),new Set(t.indices)))},Sr=(e,t)=>Array.from(e).every((e=>t.has(e))),Cr=({sourceConfiguration:{spaceId:e,sourceId:t},moduleDescriptor:a})=>{const{services:r}=Object(Ye.b)(),[i,s]=Object(n.useState)(),l=Object(n.useMemo)((()=>i?i.jobs.reduce(((a,n)=>({...a,[Object(cr.k)(e,t,n.id)]:n})),{}):{}),[i,t,e]),[o,c]=Object(Xn.c)({cancelPreviousOn:"resolution",createPromise:async()=>await a.getModuleDefinition(r.http.fetch),onResolve:e=>{s(e)},onReject:()=>{s(void 0)}},[a.getModuleDefinition,e,t]),u=Object(n.useCallback)((e=>{var t,a,n;const r=l[e.id];if(null==r)return!1;const i=null==r?void 0:r.config.custom_settings.job_revision;return(null!==(t=null===(a=e.fullJob)||void 0===a||null===(n=a.custom_settings)||void 0===n?void 0:n.job_revision)&&void 0!==t?t:0)<(null!=i?i:0)}),[l]);return{fetchModuleDefinition:c,fetchModuleDefinitionRequestState:o.state,getIsJobDefinitionOutdated:u,jobDefinitionByJobId:l,moduleDefinition:i}};var Tr=a(268),Lr=a(269),Fr=a(270),Pr=a(271),Ir=a(272),Dr=a(273);const _r=async e=>{const t=await e("/api/ml/jobs/deleting_jobs_tasks");return Object($a.b)(Ar)(t)},Br=Be.type({jobIds:Be.array(Be.string)}),Rr=Be.record(Be.string,Be.type({deleted:Be.boolean})),Ar=Be.type({jobIds:Be.array(Be.string)}),Nr=Be.type({datafeedIds:Be.array(Be.string)}),Vr=Be.record(Be.string,Be.type({stopped:Be.boolean})),zr=async(e,t,a,n)=>{try{await(async(e,t)=>{const{spaceId:a,sourceId:n,jobTypes:r}=e,i=await t("/api/ml/jobs/stop_datafeeds",{method:"POST",body:JSON.stringify(Nr.encode({datafeedIds:r.map((e=>Object(vr.b)(a,n,e)))}))});return Object($a.b)(Vr)(i)})({spaceId:e,sourceId:t,jobTypes:a},n)}catch(e){var r;if(404!==(null==e||null===(r=e.res)||void 0===r?void 0:r.status))throw e}return await $r(e,t,a,n)},$r=async(e,t,a,n)=>{const r=await(async(e,t)=>{const{spaceId:a,sourceId:n,jobTypes:r}=e,i=await t("/api/ml/jobs/delete_jobs",{method:"POST",body:JSON.stringify(Br.encode({jobIds:r.map((e=>Object(vr.c)(a,n,e)))}))});return Object($a.b)(Rr)(i)})({spaceId:e,sourceId:t,jobTypes:a},n);return await Ur(e,t,a,n),r},Ur=async(e,t,a,n)=>{const r=a.map((a=>Object(vr.c)(e,t,a)));for(;;){const{jobIds:e}=await _r(n);if(!e.some((e=>r.includes(e))))return!0;await qr(1e3)}},qr=e=>new Promise((t=>setTimeout(t,e))),Hr=async(e,t)=>{const{spaceId:a,sourceId:n,jobTypes:r}=e,i=await t("/api/ml/jobs/jobs_summary",{method:"POST",body:JSON.stringify(Gr.encode({jobIds:r.map((e=>Object(vr.c)(a,n,e)))}))});return Object($a.b)(Yr)(i)},Gr=Be.type({jobIds:Be.array(Be.string)}),Jr=Be.keyof({started:null,starting:null,stopped:null,stopping:null,"":null}),Wr=Be.keyof({closed:null,closing:null,deleting:null,failed:null,opened:null,opening:null,resetting:null,reverting:null}),Kr=Be.keyof({ok:null,warn:null}),Qr=Be.type({categorization_status:Kr,categorized_doc_count:Be.number,dead_category_count:Be.number,frequent_category_count:Be.number,rare_category_count:Be.number,total_category_count:Be.number}),Xr=Be.intersection([Be.type({id:Be.string,jobState:Wr}),Be.partial({awaitingNodeAssignment:Be.boolean,datafeedIndices:Be.array(Be.string),datafeedState:Jr,fullJob:Be.partial({custom_settings:vr.f,finished_time:Be.number,model_size_stats:Qr})})]),Yr=Be.array(Xr),Zr=async(e,t)=>{const a=await t(`/api/ml/modules/get_module/${e}`,{method:"GET"});return Object($a.b)(ti)(a)},ei=Be.type({id:Be.string,config:Be.type({custom_settings:cr.q})}),ti=Be.type({id:Be.string,jobs:Be.array(ei)}),ai=async(e,t)=>{const{moduleId:a,start:n,end:r,spaceId:i,sourceId:s,indexPattern:l,jobOverrides:o=[],datafeedOverrides:c=[],query:u}=e,d=await t(`/api/ml/modules/setup/${a}`,{method:"POST",body:JSON.stringify(li.encode({start:n,end:r,indexPatternName:l,prefix:Object(vr.d)(i,s),startDatafeed:!0,jobOverrides:o,datafeedOverrides:c,query:u}))});return Object($a.b)(di)(d)},ni=Be.partial({start:Be.number,end:Be.number}),ri=Be.type({job_id:Be.string,custom_settings:vr.f}),ii=Be.object,si=Be.intersection([Be.strict({indexPatternName:Be.string,prefix:Be.string,startDatafeed:Be.boolean,jobOverrides:Be.array(ri),datafeedOverrides:Be.array(ii)}),Be.exact(Be.partial({query:Be.object}))]),li=Be.intersection([ni,si]),oi=Be.type({msg:Be.string}),ci=Be.intersection([Be.type({id:Be.string,started:Be.boolean,success:Be.boolean}),Be.partial({error:oi})]),ui=Be.intersection([Be.type({id:Be.string,success:Be.boolean}),Be.partial({error:oi})]),di=Be.type({datafeeds:Be.array(ci),jobs:Be.array(ui)}),mi="metrics_ui_hosts",pi=p.i18n.translate("xpack.infra.ml.metricsModuleName",{defaultMessage:"Metrics anomanly detection"}),gi=p.i18n.translate("xpack.infra.ml.metricsHostModuleDescription",{defaultMessage:"Use Machine Learning to automatically detect anomalous log entry rates."}),fi=(e,t)=>vr.g.reduce(((a,n)=>({...a,[n]:Object(vr.c)(e,t,n)})),{}),bi=e=>{switch(e){case"hosts_memory_usage":return{datafeed:Lr,job:Tr};case"hosts_network_in":return{datafeed:Pr,job:Fr};case"hosts_network_out":return{datafeed:Dr,job:Ir}}},hi={moduleId:mi,moduleName:pi,moduleDescription:gi,jobTypes:vr.g,bucketSpan:vr.a,getJobIds:fi,getJobSummary:async(e,t,a)=>{const n=await Hr({spaceId:e,sourceId:t,jobTypes:vr.g},a),r=Object.values(fi(e,t));return n.filter((e=>r.includes(e.id)))},getModuleDefinition:async e=>await Zr(mi,e),setUpModule:async(e,t)=>{const{start:a,end:n,filter:r,moduleSourceConfiguration:{spaceId:i,sourceId:s,indices:l},partitionField:o}=e,c=l.join(","),u=["hosts_memory_usage","hosts_network_in","hosts_network_out"],d=u.map((e=>{const{job:t}=bi(e),a={...t.analysis_config};return o&&(a.detectors[0].partition_field_name=o,-1===a.influencers.indexOf(o)&&a.influencers.push(o)),{job_id:e,data_description:{time_field:T.j},analysis_config:a,custom_settings:{metrics_source_config:{indexPattern:c,timestampField:T.j,bucketSpan:vr.a}}}})),m=u.map((e=>{const{datafeed:t}=bi(e),a={...t};if(r){const e=JSON.parse(r);a.query.bool={...a.query.bool,...e.bool}}if(!o||"hosts_memory_usage"===e)return{...a,job_id:e};const n={[o]:{terms:{field:o},aggregations:{...t.aggregations}}};return{...a,job_id:e,aggregations:n}}));return ai({moduleId:mi,start:a,end:n,spaceId:i,sourceId:s,indexPattern:c,jobOverrides:d,datafeedOverrides:m},t)},cleanUpModule:async(e,t,a)=>await zr(e,t,vr.g,a)},[yi,Ei]=_e()((({indexPattern:e,sourceId:t,spaceId:a})=>{const r=Object(n.useMemo)((()=>({indices:e.split(","),sourceId:t,spaceId:a})),[e,t,a]),i=Or({moduleDescriptor:hi,sourceConfiguration:r}),{getIsJobConfigurationOutdated:s}=wr({sourceConfiguration:r,moduleDescriptor:hi}),{fetchModuleDefinition:l,getIsJobDefinitionOutdated:o}=Cr({sourceConfiguration:r,moduleDescriptor:hi}),c=Object(n.useMemo)((()=>i.jobSummaries.some(s)),[s,i.jobSummaries]),u=Object(n.useMemo)((()=>i.jobSummaries.some(o)),[o,i.jobSummaries]),d=Object(n.useMemo)((()=>Object.values(i.jobStatus).some((e=>"stopped"===e))),[i.jobStatus]);return{...i,fetchModuleDefinition:l,hasOutdatedJobConfigurations:c,hasOutdatedJobDefinitions:u,hasStoppedJobs:d}}));var vi=a(274),xi=a(275),ki=a(276),Mi=a(277),Oi=a(278),wi=a(279);const ji="kubernetes.namespace",Si="metrics_ui_k8s",Ci=p.i18n.translate("xpack.infra.ml.metricsModuleName",{defaultMessage:"Metrics anomanly detection"}),Ti=p.i18n.translate("xpack.infra.ml.metricsHostModuleDescription",{defaultMessage:"Use Machine Learning to automatically detect anomalous log entry rates."}),Li=(e,t)=>vr.h.reduce(((a,n)=>({...a,[n]:Object(vr.c)(e,t,n)})),{}),Fi=e=>{switch(e){case"k8s_memory_usage":return{datafeed:xi,job:vi};case"k8s_network_in":return{datafeed:Mi,job:ki};case"k8s_network_out":return{datafeed:wi,job:Oi}}},Pi={moduleId:Si,moduleName:Ci,moduleDescription:Ti,jobTypes:vr.h,bucketSpan:vr.a,getJobIds:Li,getJobSummary:async(e,t,a)=>{const n=await Hr({spaceId:e,sourceId:t,jobTypes:vr.h},a),r=Object.values(Li(e,t));return n.filter((e=>r.includes(e.id)))},getModuleDefinition:async e=>await Zr(Si,e),setUpModule:async(e,t)=>{const{start:a,end:n,filter:r,moduleSourceConfiguration:{spaceId:i,sourceId:s,indices:l},partitionField:o}=e,c=l.join(","),u=["k8s_memory_usage","k8s_network_in","k8s_network_out"],d=u.map((e=>{const{job:t}=Fi(e),a={...t.analysis_config};return o&&(a.detectors[0].partition_field_name=o,-1===a.influencers.indexOf(o)&&a.influencers.push(o)),{job_id:e,data_description:{time_field:T.j},analysis_config:a,custom_settings:{metrics_source_config:{indexPattern:c,timestampField:T.j,bucketSpan:vr.a}}}})),m=u.map((e=>{const{datafeed:t}=Fi(e),a={...t};if(r){const e=JSON.parse(r);a.query.bool={...a.query.bool,...e.bool}}if(!o||"k8s_memory_usage"===e)return{...a,job_id:e};const n=t.aggregations["kubernetes.namespace"].aggregations,i={[o]:{terms:{field:o,size:25},aggregations:{...n}}};return{...a,job_id:e,aggregations:i}}));return ai({moduleId:Si,start:a,end:n,spaceId:i,sourceId:s,indexPattern:c,jobOverrides:d,datafeedOverrides:m},t)},cleanUpModule:async(e,t,a)=>await zr(e,t,vr.h,a)},[Ii,Di]=_e()((({indexPattern:e,sourceId:t,spaceId:a})=>{const r=Object(n.useMemo)((()=>({indices:e.split(","),sourceId:t,spaceId:a})),[e,t,a]),i=Or({moduleDescriptor:Pi,sourceConfiguration:r}),{getIsJobConfigurationOutdated:s}=wr({sourceConfiguration:r,moduleDescriptor:Pi}),{fetchModuleDefinition:l,getIsJobDefinitionOutdated:o}=Cr({sourceConfiguration:r,moduleDescriptor:Pi}),c=Object(n.useMemo)((()=>i.jobSummaries.some(s)),[s,i.jobSummaries]),u=Object(n.useMemo)((()=>i.jobSummaries.some(o)),[o,i.jobSummaries]),d=Object(n.useMemo)((()=>Object.values(i.jobStatus).some((e=>"stopped"===e))),[i.jobStatus]);return{...i,fetchModuleDefinition:l,hasOutdatedJobConfigurations:c,hasOutdatedJobDefinitions:u,hasStoppedJobs:d}}));var _i=a(90);const Bi=e=>{const[t,a]=Object(n.useState)("jobs"),{goToSetup:i,closeFlyout:s}=e,{fetchJobStatus:l,setupStatus:o,jobSummaries:c}=Ei(),{fetchJobStatus:u,setupStatus:d,jobSummaries:f}=Di(),{hasInfraMLCapabilities:h,hasInfraMLReadCapabilities:y,hasInfraMLSetupCapabilities:E}=hr(),v=Object(n.useCallback)((()=>{i("hosts")}),[i]),x=Object(n.useCallback)((()=>{i("kubernetes")}),[i]),k=[...(f||[]).map((e=>e.id)),...(c||[]).map((e=>e.id))];Object(n.useEffect)((()=>{y&&(l(),u())}),[u,l,y]);const M=c.length>0||f.length>0,O=Object(b.useLinkProps)({app:"ml",pathname:"/jobs"});return h?y?"initializing"===o.type||"initializing"===d.type?r.a.createElement(_i.b,{message:p.i18n.translate("xpack.infra.ml.anomalyFlyout.jobStatusLoadingMessage",{defaultMessage:"Checking status of metrics jobs..."})}):E?r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiFlyoutHeader,null,r.a.createElement(g.EuiTitle,{size:"m"},r.a.createElement("h2",null,r.a.createElement(I.FormattedMessage,{defaultMessage:"Machine Learning anomaly detection",id:"xpack.infra.ml.anomalyFlyout.flyoutHeader"})))),r.a.createElement(g.EuiTabs,null,r.a.createElement(g.EuiTab,{isSelected:"jobs"===t,onClick:()=>a("jobs")},"Jobs"),r.a.createElement(g.EuiTab,{isSelected:"anomalies"===t,onClick:()=>a("anomalies"),"data-test-subj":"anomalyFlyoutAnomaliesTab"},"Anomalies")),r.a.createElement(g.EuiFlyoutBody,{banner:r.a.createElement(r.a.Fragment,null,"jobs"===t&&M&&r.a.createElement(r.a.Fragment,null,r.a.createElement(Ri,{hasHostJobs:c.length>0,hasK8sJobs:f.length>0,jobIds:k})),r.a.createElement(mr.MLJobsAwaitingNodeWarning,{jobIds:k}))},"jobs"===t&&r.a.createElement(r.a.Fragment,null,M&&r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiFlexGroup,{gutterSize:"s"},r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiButton,m()({},O,{style:{marginRight:5}}),r.a.createElement(I.FormattedMessage,{defaultMessage:"Manage jobs in ML",id:"xpack.infra.ml.anomalyFlyout.manageJobs"})))),r.a.createElement(g.EuiSpacer,{size:"l"})),r.a.createElement(g.EuiText,null,r.a.createElement("h4",null,"Create ML Jobs"),r.a.createElement("p",null,r.a.createElement(I.FormattedMessage,{defaultMessage:"Anomaly detection is powered by machine learning. Machine learning jobs are available for the following resource types. Enable these jobs to begin detecting anomalies in your infrastructure metrics.",id:"xpack.infra.ml.anomalyFlyout.createJobs"}))),r.a.createElement(g.EuiSpacer,{size:"l"}),r.a.createElement(Ai,{hasHostJobs:c.length>0,hasK8sJobs:f.length>0,hasSetupCapabilities:e.hasSetupCapabilities,createHosts:v,createK8s:x})),"anomalies"===t&&r.a.createElement(qi,{closeFlyout:s}))):r.a.createElement(Er.c,null):r.a.createElement(Er.b,null):r.a.createElement(pr.b,null)},Ri=e=>{let t="";return e.hasHostJobs&&e.hasK8sJobs?t=`${p.i18n.translate("xpack.infra.ml.anomalyFlyout.create.hostTitle",{defaultMessage:"Hosts"})} and ${p.i18n.translate("xpack.infra.ml.anomalyFlyout.create.k8sSuccessTitle",{defaultMessage:"Kubernetes"})}`:e.hasHostJobs?t=p.i18n.translate("xpack.infra.ml.anomalyFlyout.create.hostSuccessTitle",{defaultMessage:"Hosts"}):e.hasK8sJobs&&(t=p.i18n.translate("xpack.infra.ml.anomalyFlyout.create.k8sSuccessTitle",{defaultMessage:"Kubernetes"})),r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiCallOut,{size:"m",color:"success",title:r.a.createElement(I.FormattedMessage,{defaultMessage:"Anomaly detection enabled for {target}",id:"xpack.infra.ml.anomalyFlyout.enabledCallout",values:{target:t}}),iconType:"check"}))},Ai=e=>r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiFlexGroup,{gutterSize:"m"},r.a.createElement(g.EuiFlexItem,null,r.a.createElement(g.EuiCard,{isDisabled:!e.hasSetupCapabilities,icon:r.a.createElement(g.EuiIcon,{type:"storage",size:"xl"}),title:r.a.createElement(I.FormattedMessage,{defaultMessage:"Hosts",id:"xpack.infra.ml.anomalyFlyout.create.hostTitle"}),description:r.a.createElement(I.FormattedMessage,{defaultMessage:"Detect anomalies for memory usage and network traffic on hosts.",id:"xpack.infra.ml.anomalyFlyout.create.hostDescription"}),footer:r.a.createElement(r.a.Fragment,null,e.hasHostJobs&&r.a.createElement(g.EuiButtonEmpty,{onClick:e.createHosts},r.a.createElement(I.FormattedMessage,{defaultMessage:"Recreate jobs",id:"xpack.infra.ml.anomalyFlyout.create.recreateButton"})),!e.hasHostJobs&&r.a.createElement(g.EuiButton,{onClick:e.createHosts},r.a.createElement(I.FormattedMessage,{defaultMessage:"Enable",id:"xpack.infra.ml.anomalyFlyout.create.createButton"})))})),r.a.createElement(g.EuiFlexItem,null,r.a.createElement(g.EuiCard,{isDisabled:!e.hasSetupCapabilities,icon:r.a.createElement(g.EuiIcon,{type:"logoKubernetes",size:"xl"}),title:r.a.createElement(I.FormattedMessage,{defaultMessage:"Kubernetes Pods",id:"xpack.infra.ml.anomalyFlyout.create.k8sTitle"}),description:r.a.createElement(I.FormattedMessage,{defaultMessage:"Detect anomalies for memory usage and network traffic on Kubernetes Pods.",id:"xpack.infra.ml.anomalyFlyout.create.k8sDescription"}),footer:r.a.createElement(r.a.Fragment,null,e.hasK8sJobs&&r.a.createElement(g.EuiButtonEmpty,{onClick:e.createK8s},r.a.createElement(I.FormattedMessage,{defaultMessage:"Recreate jobs",id:"xpack.infra.ml.anomalyFlyout.create.recreateButton"})),!e.hasK8sJobs&&r.a.createElement(g.EuiButton,{onClick:e.createK8s},r.a.createElement(I.FormattedMessage,{defaultMessage:"Enable",id:"xpack.infra.ml.anomalyFlyout.create.createButton"})))})))),Ni=(e,t="absolute")=>{let a="";return a+=`(ml:(jobIds:!(${e.map((e=>`'${e}'`)).join(",")}))`,a+=`,refreshInterval:(display:Off,pause:!f,value:0),time:(from:'${N()().subtract(4,"weeks").toISOString()}'`,a+=`,to:'${N()().toISOString()}'`,"invalid"===t&&(a+=",mode:invalid"),a+="))&_a=(query:(query_string:(analyze_wildcard:!t,query:'*')))",a},Vi={...oa.b,filterQuery:jt,time:gt.currentTime,autoReload:gt.isAutoReloading},zi=()=>{const{metric:e,groupBy:t,nodeType:a,view:r,customOptions:i,customMetrics:s,boundsOverride:l,autoBounds:o,accountId:c,region:u,legend:d,sort:m,timelineOpen:p,setWaffleOptionsState:g}=Object(oa.d)(),{currentTime:f,isAutoReloading:b,setWaffleTimeState:h}=vt(),{filterQuery:y,setWaffleFiltersState:E}=Pt(),v={metric:e,sort:m,groupBy:t,nodeType:a,view:r,customOptions:i,customMetrics:s,boundsOverride:l,autoBounds:o,accountId:c,region:u,time:f,autoReload:b,filterQuery:y,legend:d,timelineOpen:p},x=Object(n.useCallback)((e=>{g({sort:e.sort,metric:e.metric,groupBy:e.groupBy,nodeType:e.nodeType,view:e.view,customOptions:e.customOptions,customMetrics:e.customMetrics,boundsOverride:e.boundsOverride,autoBounds:e.autoBounds,accountId:e.accountId,region:e.region,legend:e.legend,timelineOpen:e.timelineOpen}),e.time&&h({currentTime:e.time,isAutoReloading:e.autoReload}),E(e.filterQuery)}),[g,h,E]);return{viewState:v,defaultViewState:Vi,onViewChange:x}},$i=({jobId:e,type:t,startTime:a,closeFlyout:i,influencerField:s,influencers:l,disableShowInInventory:o})=>{const[c,u]=Object(n.useState)(!1),d=Object(n.useCallback)((()=>u(!1)),[u]),f=Object(n.useCallback)((()=>u(!c)),[c]),{onViewChange:h}=zi(),y=Object(n.useCallback)((()=>{const n=e.split("-"),r={metric:{type:{memory_usage:"memory",network_in:"rx",network_out:"tx"}[n[n.length-1].replace(/hosts_|k8s_/,"")]},sort:{by:"name",direction:"desc"},groupBy:[],nodeType:"metrics_k8s"===t?"pod":"host",view:"map",customOptions:[],customMetrics:[],boundsOverride:{max:1,min:0},autoBounds:!0,accountId:"",region:"",autoReload:!1,filterQuery:{expression:l.reduce(((e,t)=>(e&&(e=`${e} or `),`${e} ${s}: "${t}"`)),""),kind:"kuery"},legend:{palette:"cool",reverseColors:!1,steps:10},time:a};h(r),i()}),[e,h,a,t,l,s,i]),E=Object(b.useLinkProps)({app:"ml",pathname:`/explorer?_g=${Ni([e.toString()])}`}),v=[r.a.createElement(g.EuiContextMenuItem,m()({key:"openInAnomalyExplorer",icon:"popout"},E),r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.anomalyFlyout.actions.openInAnomalyExplorer",defaultMessage:"Open in Anomaly Explorer"}))];return o||v.push(r.a.createElement(g.EuiContextMenuItem,{key:"showInInventory",icon:"search",onClick:y},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.anomalyFlyout.actions.showInInventory",defaultMessage:"Show in Inventory"}))),r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiPopover,{anchorPosition:"downRight",panelPaddingSize:"none",button:r.a.createElement(g.EuiButtonIcon,{iconType:"boxesHorizontal",onClick:f,"aria-label":p.i18n.translate("xpack.infra.ml.anomalyFlyout.actions.openActionMenu",{defaultMessage:"Open"})}),isOpen:c,closePopover:d},r.a.createElement(g.EuiContextMenuPanel,{items:v})))},Ui=Object(V.withTheme)((({theme:e})=>r.a.createElement(g.EuiText,null,r.a.createElement(g.EuiSpacer,{size:"xl"}),r.a.createElement("p",null,r.a.createElement(g.EuiIcon,{type:"eyeClosed",size:"xl",color:e.eui.euiColorMediumShade})),r.a.createElement("h3",{"data-test-subj":"noAnomaliesFoundMsg"},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.anomalyFlyout.anomalyTable.noAnomaliesFound",defaultMessage:"No anomalies found"})),r.a.createElement(g.EuiSpacer,{size:"m"}),r.a.createElement(g.EuiText,{color:"subdued"},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.anomalyFlyout.anomalyTable.noAnomaliesSuggestion",defaultMessage:"Try modifying your search or selected time range."}))))),qi=e=>{const{closeFlyout:t,hostName:a}=e,[i,s]=Object(n.useState)(""),[l,o]=Object(n.useState)("now-30d"),[c,u]=Object(n.useState)("now"),d=Object(b.useUiTracker)({app:"infra_metrics"}),[m,f]=Object(n.useState)({start:Object(Dn.a)(l)||0,end:Object(Dn.a)(c,"up")||0}),{sorting:h,setSorting:y}=function(e){const[t,a]=Object(n.useState)({field:"startTime",direction:"desc"});return{sorting:t,setSorting:a}}(),E=[{id:"hosts",label:p.i18n.translate("xpack.infra.ml.anomalyFlyout.hostBtn",{defaultMessage:"Hosts"}),"data-test-subj":"anomaliesHostComboBoxItem"},{id:"k8s",label:p.i18n.translate("xpack.infra.ml.anomalyFlyout.podsBtn",{defaultMessage:"Kubernetes Pods"}),"data-test-subj":"anomaliesK8sComboBoxItem"}],[v,x]=Object(n.useState)("hosts"),[k,M]=Object(n.useState)([E.find((e=>"hosts"===e.id))||E[0]]),{source:O}=Object(j.c)(),w=null==O?void 0:O.configuration.anomalyThreshold,S=Object(n.useCallback)((({isInvalid:e,start:t,end:a})=>{e||(o(t),u(a),f({start:Object(Dn.a)(t),end:Object(Dn.a)(a,"up")}))}),[]),C=Object(n.useMemo)((()=>({sourceId:"default",anomalyThreshold:w||0,startTime:m.start,endTime:m.end,defaultSortOptions:{direction:(null==h?void 0:h.direction)||"desc",field:(null==h?void 0:h.field)||"startTime"},defaultPaginationOptions:{pageSize:10}})),[m.start,m.end,null==h?void 0:h.field,null==h?void 0:h.direction,w]),{metricsHostsAnomalies:T,getMetricsHostsAnomalies:L,page:F,changeSortOptions:P,fetchNextPage:D,fetchPreviousPage:_,isLoadingMetricsHostsAnomalies:B}=rr(C),{metricsK8sAnomalies:R,getMetricsK8sAnomalies:A,page:N,changeSortOptions:V,fetchNextPage:z,fetchPreviousPage:$,isLoadingMetricsK8sAnomalies:U}=er(C),q=Object(n.useMemo)((()=>"hosts"===v?F:N),[v,F,N]),H=Object(n.useMemo)((()=>"hosts"===v?B:U),[v,B,U]),G=Object(n.useMemo)((()=>"hosts"===v?D:z),[v,D,z]),J=Object(n.useMemo)((()=>"hosts"===v?_:$),[v,_,$]),W=Object(n.useMemo)((()=>"hosts"===v?L:"k8s"===v?A:void 0),[v,A,L]),K=Object(n.useMemo)((()=>"hosts"===v?T:R),[v,T,R]),Q=Object(n.useCallback)((e=>{s(e.target.value)}),[]),X=Object(n.useCallback)((e=>{M(e),x(e[0].id)}),[]),Y=Object(n.useCallback)((e=>{"hosts"===v?P(e):V(e)}),[P,V,v]);Object(n.useEffect)((()=>{K&&K.forEach((e=>{e.influencers.length>100&&d({metric:"metrics_ml_anomaly_detection_more_than_100_influencers"})}))}),[K,d]);let Z=[{field:"startTime",name:p.i18n.translate("xpack.infra.ml.anomalyFlyout.columnTime",{defaultMessage:"Time"}),width:"15%",sortable:!0,textOnly:!0,truncateText:!0,render:e=>r.a.createElement(I.FormattedDate,{value:e,year:"numeric",month:"short",day:"2-digit"})},{field:"jobId",name:p.i18n.translate("xpack.infra.ml.anomalyFlyout.columnJob",{defaultMessage:"Job"}),width:"25%",render:e=>e,"data-test-subj":"anomalyRow"},{field:"anomalyScore",name:p.i18n.translate("xpack.infra.ml.anomalyFlyout.columnSeverit",{defaultMessage:"Severity"}),width:"15%",sortable:!0,render:e=>r.a.createElement(dr.a,{anomalyScore:e})},{field:"typical",name:p.i18n.translate("xpack.infra.ml.anomalyFlyout.columnSummary",{defaultMessage:"Summary"}),width:"15%",textOnly:!0,render:(e,t)=>r.a.createElement(ur,{anomaly:t})},{field:"influencers",name:p.i18n.translate("xpack.infra.ml.anomalyFlyout.columnInfluencerName",{defaultMessage:"Node name"}),width:"20%",textOnly:!0,truncateText:!0,render:e=>e.join(",")},{name:p.i18n.translate("xpack.infra.ml.anomalyFlyout.columnActionsName",{defaultMessage:"Actions"}),width:"10%",actions:[{render:e=>r.a.createElement($i,{jobId:e.jobId,type:e.type,influencerField:"metrics_hosts"===e.type?"host.name":"kubernetes.pod.uid",disableShowInInventory:e.influencers.length>100,influencers:e.influencers,startTime:e.startTime,closeFlyout:t})}]}];return Z=a?Z.filter((e=>!("field"in e)||"influencers"!==e.field)):Z,Object(n.useEffect)((()=>{W&&W(void 0,i,a)}),[W,i,a]),r.a.createElement("div",null,r.a.createElement(g.EuiFlexGroup,null,r.a.createElement(g.EuiFlexItem,{grow:1},r.a.createElement(g.EuiSuperDatePicker,{start:l,end:c,showUpdateButton:!1,onTimeChange:S}))),!a&&r.a.createElement(g.EuiFlexGroup,{alignItems:"center"},r.a.createElement(g.EuiFlexItem,{grow:3},r.a.createElement(g.EuiFieldSearch,{fullWidth:!0,placeholder:p.i18n.translate("xpack.infra.ml.anomalyFlyout.searchPlaceholder",{defaultMessage:"Search"}),value:i,onChange:Q,isClearable:!0})),r.a.createElement(g.EuiFlexItem,{grow:1},r.a.createElement(g.EuiComboBox,{placeholder:p.i18n.translate("xpack.infra.ml.anomalyFlyout.jobTypeSelect",{defaultMessage:"Select group"}),singleSelection:{asPlainText:!0},options:E,selectedOptions:k,onChange:X,isClearable:!1,"data-test-subj":"anomaliesComboBoxType"}))),r.a.createElement(g.EuiSpacer,{size:"m"}),r.a.createElement(g.EuiBasicTable,{columns:Z,items:K,sorting:{sort:h},onChange:e=>{var t,a;y(e.sort),Y({field:(null==e||null===(t=e.sort)||void 0===t?void 0:t.field)||"startTime",direction:(null==e||null===(a=e.sort)||void 0===a?void 0:a.direction)||"desc"})},hasActions:!0,loading:H,noItemsMessage:H?r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.anomalyFlyout.anomalyTable.loading",defaultMessage:"Loading anomalies"}):r.a.createElement(Ui,null)}),r.a.createElement(g.EuiSpacer,{size:"l"}),r.a.createElement(or,{fetchNextPage:G,fetchPreviousPage:J,page:q,isLoading:H}))},Hi={id:"anomalies",name:p.i18n.translate("xpack.infra.nodeDetails.tabs.anomalies",{defaultMessage:"Anomalies"}),content:e=>{const{node:t,onClose:a}=e;return r.a.createElement(pa,null,r.a.createElement(qi,{closeFlyout:a,hostName:t.name}))}},Gi={id:"osquery",name:p.i18n.translate("xpack.infra.nodeDetails.tabs.osquery",{defaultMessage:"Osquery"}),content:e=>{const t=e.node.id,a=e.nodeType,i=Object(aa.b)(a),{sourceId:s}=Object(n.useContext)(j.a.Context),{currentTimeRange:l}=vt(),{loading:o,metadata:c}=jn(t,a,i.requiredMetrics,s,l),{services:{osquery:u}}=Object(Ye.b)(),d=null==u?void 0:u.OsqueryAction;return Object(n.useMemo)((()=>{var e,t;return o||!d?r.a.createElement(pa,null,r.a.createElement(g.EuiLoadingContent,{lines:10})):r.a.createElement(pa,null,r.a.createElement(d,{agentId:null==c||null===(e=c.info)||void 0===e||null===(t=e.agent)||void 0===t?void 0:t.id,hideAgentsField:!0}))}),[d,o,c])}},Ji=(e,t,a)=>e.get(b.uptimeOverviewLocatorID).navigate({[t]:a.id,ip:a.ip}),Wi=({isOpen:e,node:t,nodeType:a,currentTime:i,options:s,onClose:l,openAlertFlyout:o})=>{const c=[Da,Na,kn,In,Hi,Gi],u=Object(aa.b)(a),d=i-1e3*u.metrics.defaultTimeRangeInSeconds,{application:m,share:p}=Object(f.useKibana)().services,h=null==m?void 0:m.capabilities,y=Object(n.useMemo)((()=>{var e;return Boolean(null==h||null===(e=h.infrastructure)||void 0===e?void 0:e.save)}),[h]),E=Object(n.useMemo)((()=>c.map((e=>{const n=e.content;return{...e,content:r.a.createElement(n,{onClose:l,node:t,nodeType:a,currentTime:i,options:s})}}))),[c,t,a,i,l,s]),[v,x]=Object(n.useState)(0),k=Object(b.useLinkProps)({...Object(Aa.a)({nodeType:a,nodeId:t.id,from:d,to:i})}),M="host"===a?"host.hostname":u.fields.id,O=Object(b.useLinkProps)({app:"apm",hash:"traces",search:{kuery:`${M}:"${t.id}"`}});return e?r.a.createElement(g.EuiPortal,null,r.a.createElement(g.EuiOutsideClickDetector,{onOutsideClick:l},r.a.createElement(Qi,null,r.a.createElement(Ki,null,r.a.createElement(g.EuiFlexGroup,{responsive:!1,gutterSize:"m"},r.a.createElement(Xi,{grow:!0},r.a.createElement(g.EuiTitle,{size:"xs"},r.a.createElement("h4",null,t.name))),r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiFlexGroup,{gutterSize:"m",responsive:!1},y&&r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiButtonEmpty,{onClick:o,size:"xs",iconSide:"left",flush:"both",iconType:"bell"},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.infra.nodeDetails.createAlertLink",defaultMessage:"Create inventory rule"}))),r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiButtonEmpty,{size:"xs",iconSide:"left",iconType:"popout",href:k.href,flush:"both"},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.infra.nodeDetails.openAsPage",defaultMessage:"Open as page"}))),r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiButtonIcon,{size:"s",onClick:l,iconType:"cross"}))))),r.a.createElement(g.EuiSpacer,{size:"s"}),r.a.createElement(g.EuiTabs,{size:"s"},E.map(((e,t)=>r.a.createElement(g.EuiTab,{key:e.id,isSelected:t===v,onClick:()=>x(t)},e.name))),r.a.createElement(g.EuiTab,O,r.a.createElement(g.EuiIcon,{type:"popout"})," ",r.a.createElement(I.FormattedMessage,{id:"xpack.infra.infra.nodeDetails.apmTabLabel",defaultMessage:"APM"})),r.a.createElement(g.EuiTab,{onClick:()=>Ji(p.url.locators,a,t)},r.a.createElement(g.EuiIcon,{type:"popout"})," ",r.a.createElement(I.FormattedMessage,{id:"xpack.infra.infra.nodeDetails.updtimeTabLabel",defaultMessage:"Uptime"})))),E[v].content))):null},Ki=V.euiStyled.div`
  padding-top: ${e=>e.theme.eui.euiSizeM};
  padding-right: ${e=>e.theme.eui.euiSizeM};
  padding-left: ${e=>e.theme.eui.euiSizeM};
  background-color: ${e=>e.theme.eui.euiPageBackgroundColor};
  box-shadow: inset 0 -1px ${e=>e.theme.eui.euiBorderColor};
`,Qi=Object(V.euiStyled)(g.EuiPanel).attrs({paddingSize:"none"})`
  display: flex;
  flex-direction: column;
  position: absolute;
  right: 16px;
  top: ${266}px;
  width: 100%;
  max-width: 720px;
  z-index: 2;
  max-height: calc(100vh - ${282}px);
  overflow: hidden;

  @media (max-width: 752px) {
    border-radius: 0px !important;
    left: 0px;
    right: 0px;
    top: 97px;
    bottom: 0;
    max-height: calc(100vh - 97px);
    max-width: 100%;
  }
`,Xi=Object(V.euiStyled)(g.EuiFlexItem)`
  overflow: hidden;
  & h4 {
    text-overflow: ellipsis;
    overflow: hidden;
    white-space: nowrap;
  }
`,Yi=({options:e,nodeType:t,filter:a,visible:i,setVisible:s})=>{const{triggersActionsUI:l}=Object(n.useContext)(H.a),{inventoryPrefill:o}=Object(J.b)(),{customMetrics:c}=o,u=Object(n.useCallback)((()=>s(!1)),[s]),d=Object(n.useMemo)((()=>l&&l.getAddAlertFlyout({consumer:"infrastructure",onClose:u,canChangeTrigger:!1,ruleTypeId:G.d,metadata:{options:e,nodeType:t,filter:a,customMetrics:c}})),[l,i]);return r.a.createElement(r.a.Fragment,null,i&&d)},Zi=({onClose:e})=>{const{inventoryPrefill:t}=Object(J.b)(),{nodeType:a,metric:n,filterQuery:i}=t;return r.a.createElement(Yi,{options:{metric:n},nodeType:a,filter:i,visible:!0,setVisible:e})},es=Object(V.withTheme)((({options:e,currentTime:t,node:a,nodeType:i})=>{var s,l;const[o,c]=Object(n.useState)(!1),u=Object(aa.b)(i),d=t-1e3*u.metrics.defaultTimeRangeInSeconds,{application:h,share:y}=Object(f.useKibana)().services,E=null==h?void 0:h.capabilities,v="host"===i?"host.hostname":u.fields.id,x=u.crosslinkSupport.details,k=u.crosslinkSupport.logs&&a.id&&(null==E||null===(s=E.logs)||void 0===s?void 0:s.show),M=u.crosslinkSupport.apm&&(null==E?void 0:E.apm)&&(null==E?void 0:E.apm.show),O=u.crosslinkSupport.uptime&&(["pod","container"].includes(i)||a.ip),w=null==E||null===(l=E.infrastructure)||void 0===l?void 0:l.save,j=Object(n.useMemo)((()=>{if("host"!==i){const{id:e}=Object(aa.a)(i);return{label:r.a.createElement(g.EuiCode,null,e),value:a.id}}return a.ip?{label:r.a.createElement(g.EuiCode,null,"host.ip"),value:a.ip}:{label:"",value:""}}),[i,a.ip,a.id]),S=Object(b.useLinkProps)(Object(Aa.b)({nodeType:i,nodeId:a.id,time:t})),C=Object(b.useLinkProps)({...Object(Aa.a)({nodeType:i,nodeId:a.id,from:d,to:t})}),T=Object(b.useLinkProps)({app:"apm",hash:"traces",search:{kuery:`${v}:"${a.id}"`}}),L={label:p.i18n.translate("xpack.infra.nodeContextMenu.viewLogsName",{defaultMessage:"{inventoryName} logs",values:{inventoryName:u.singularDisplayName}}),...S,"data-test-subj":"viewLogsContextMenuItem",isDisabled:!k},F={label:p.i18n.translate("xpack.infra.nodeContextMenu.viewMetricsName",{defaultMessage:"{inventoryName} metrics",values:{inventoryName:u.singularDisplayName}}),...C,isDisabled:!x},P={label:p.i18n.translate("xpack.infra.nodeContextMenu.viewAPMTraces",{defaultMessage:"{inventoryName} APM traces",values:{inventoryName:u.singularDisplayName}}),...T,"data-test-subj":"viewApmTracesContextMenuItem",isDisabled:!M},D={label:p.i18n.translate("xpack.infra.nodeContextMenu.viewUptimeLink",{defaultMessage:"{inventoryName} in Uptime",values:{inventoryName:u.singularDisplayName}}),onClick:()=>Ji(y.url.locators,i,a),isDisabled:!O},_={label:p.i18n.translate("xpack.infra.nodeContextMenu.createRuleLink",{defaultMessage:"Create inventory rule"}),onClick:()=>{c(!0)},isDisabled:!w};return r.a.createElement(r.a.Fragment,null,r.a.createElement("div",{style:{maxWidth:300},"data-test-subj":"nodeContextMenu"},r.a.createElement(b.Section,null,r.a.createElement(b.SectionTitle,null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.nodeContextMenu.title",defaultMessage:"{inventoryName} details",values:{inventoryName:u.singularDisplayName}})),j.label&&r.a.createElement(b.SectionSubtitle,null,r.a.createElement("div",{style:{wordBreak:"break-all"}},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.nodeContextMenu.description",defaultMessage:"View details for {label} {value}",values:{label:j.label,value:j.value}}))),r.a.createElement(b.SectionLinks,null,r.a.createElement(b.SectionLink,m()({"data-test-subj":"viewLogsContextMenuItem"},L)),r.a.createElement(b.SectionLink,F),r.a.createElement(b.SectionLink,m()({"data-test-subj":"viewApmTracesContextMenuItem"},P)),r.a.createElement(b.SectionLink,m()({},D,{color:"primary"}))),r.a.createElement(b.ActionMenuDivider,null),r.a.createElement(b.SectionLinks,null,r.a.createElement(b.SectionLink,m()({iconType:"bell",color:"primary"},_))))),o&&r.a.createElement(Yi,{filter:`${Object(aa.a)(i).id}: "${a.id}"`,options:e,nodeType:i,setVisible:c,visible:o}))})),ts={isPopoverOpen:!1,isOverlayOpen:!1,isAlertFlyoutVisible:!1,isToolTipOpen:!1};class node_Node extends r.a.PureComponent{constructor(...e){super(...e),Kt()(this,"state",ts),Kt()(this,"openAlertFlyout",(()=>{this.setState({isOverlayOpen:!1,isAlertFlyoutVisible:!0})})),Kt()(this,"setAlertFlyoutVisible",(e=>{this.setState({isAlertFlyoutVisible:e})})),Kt()(this,"togglePopover",(()=>{const{nodeType:e}=this.props;"host"===e?this.toggleNewOverlay():this.setState((e=>({isPopoverOpen:!e.isPopoverOpen})))})),Kt()(this,"toggleNewOverlay",(()=>{this.setState((e=>({isPopoverOpen:1!=!e.isOverlayOpen&&e.isPopoverOpen,isOverlayOpen:!e.isOverlayOpen})))})),Kt()(this,"closePopover",(()=>{this.state.isPopoverOpen&&this.setState({isPopoverOpen:!1})})),Kt()(this,"showToolTip",(()=>{this.setState({isToolTipOpen:!0})})),Kt()(this,"hideToolTip",(()=>{this.setState({isToolTipOpen:!1})}))}render(){const{nodeType:e,node:t,options:a,squareSize:n,bounds:i,formatter:s,currentTime:l}=this.props,{isPopoverOpen:o,isAlertFlyoutVisible:c,isToolTipOpen:u}=this.state,d=Object(R.first)(t.metrics),m=n>70,f=n>30,b=d&&d.value||0,h=((e,t,a,n="rgba(217, 217, 217, 1)")=>{try{return te.f.is(e)?da(((e,t,a="rgba(217, 217, 217, 1)")=>e.reduce(((e,a)=>(0,ua[a.operator])(t,a.value)?a.color:e),a))(e.rules,t,n)):te.a.is(e)?da(((e,t,a,n="rgba(0, 179, 164, 1)")=>{if(0===e.length)return n;if(1===e.length)return Object(R.last)(e).color;const{min:r,max:i}=a,s=Object(R.sortBy)(e,"value"),l=ma(r,i,Number(t)),o=s.reduce(((e,t)=>t.value<=l?t:e),Object(R.first)(s)),c=s.filter((e=>e!==o)).find((e=>e.value>=l));if(!c)return o.color;const u=ma(o.value,c.value,l);return Object(ea.mix)(u,c.color,o.color)})(e.rules,t,a,n)):te.g.is(e)?da(((e,t,a,n="rgba(217, 217, 217, 1)")=>{var r,i;const s=ma(a.min,a.max,Number(t)),l=e.length,o=Object(R.last)(e);return o&&Object(R.gte)(s,o.value)?o.color:e.reduce(((e,t)=>{const a=t.value-1/l,n=t.value;return Object(R.gte)(s,a)&&Object(R.lte)(s,n)?t.color:e}),null!==(r=null===(i=Object(R.first)(e))||void 0===i?void 0:i.color)&&void 0!==r?r:n)})(e.rules,t,a,n)):n}catch(e){return n}})(a.legend,b,i),y=s(b),E=p.i18n.translate("xpack.infra.node.ariaLabel",{defaultMessage:"{nodeName}, click to open menu",values:{nodeName:t.name}}),v=this.state.isOverlayOpen?{border:"solid 4px #000"}:void 0,x=r.a.createElement(as,{"data-test-subj":"nodeContainer",style:{width:n||0,height:n||0},onClick:this.togglePopover,onMouseOver:this.showToolTip,onMouseLeave:this.hideToolTip,className:"buttonContainer"},r.a.createElement(rs,{color:h,style:v},r.a.createElement(is,{color:h},m?r.a.createElement(ss,{"aria-label":E},r.a.createElement(cs,{"data-test-subj":"nodeName",color:h},t.name),r.a.createElement(os,{"data-test-subj":"nodeValue",color:h},y)):f&&r.a.createElement(ss,{"aria-label":E},r.a.createElement(cs,{color:h},"..."))))),k=r.a.createElement(ns,{"data-test-subj":"nodeContainer",style:{width:n||0,height:n||0,...v},onClick:this.togglePopover,onMouseOver:this.showToolTip,onMouseLeave:this.hideToolTip,color:h}),M=m||f?x:k;return r.a.createElement(r.a.Fragment,null,o?r.a.createElement(g.EuiPopover,{button:M,isOpen:o,closePopover:this.closePopover,anchorPosition:"downCenter",style:{height:n}},r.a.createElement(es,{node:t,nodeType:e,options:a,currentTime:l})):u?r.a.createElement(g.EuiToolTip,{delay:"regular",position:"right",content:r.a.createElement(ca,{currentTime:l,node:t,nodeType:e})},M):M,this.state.isOverlayOpen&&r.a.createElement(Wi,{openAlertFlyout:this.openAlertFlyout,node:t,nodeType:e,isOpen:this.state.isOverlayOpen,options:a,currentTime:l,onClose:this.toggleNewOverlay}),c&&r.a.createElement(Yi,{filter:`${Object(aa.a)(e).id}: "${t.id}"`,options:a,nodeType:e,setVisible:this.setAlertFlyoutVisible,visible:c}))}}const as=V.euiStyled.div`
  position: relative;
  cursor: pointer;
`,ns=V.euiStyled.div`
  cursor: pointer;
  position: relative;
  background-color: ${e=>Object(ea.darken)(.1,e.color)};
  border-radius: 3px;
  margin: 2px;
  box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.2);
`,rs=V.euiStyled.div`
  position: absolute;
  top: 4px;
  left: 4px;
  bottom: 4px;
  right: 4px;
  background-color: ${e=>Object(ea.darken)(.1,e.color)};
  border-radius: 3px;
  box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.2);
`,is=V.euiStyled.div`
  position: absolute;
  top: 0;
  right: 0;
  bottom: 2px;
  left: 0;
  border-radius: 3px;
  background-color: ${e=>e.color};
`,ss=V.euiStyled.button`
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  display: flex;
  line-height: 1.2em;
  align-items: center;
  align-content: center;
  padding: 1em;
  overflow: hidden;
  flex-wrap: wrap;
  width: 100%;
  border: none;
  &:focus {
    outline: none !important;
    border: ${e=>{var t;return null===(t=e.theme)||void 0===t?void 0:t.eui.euiFocusRingSize}} solid
      ${e=>{var t;return null===(t=e.theme)||void 0===t?void 0:t.eui.euiFocusRingColor}};
    box-shadow: none;
  }
`,ls=V.euiStyled.div`
  text-align: center;
  width: 100%;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
  flex: 1 0 auto;
  color: ${e=>Object(ea.readableColor)(e.color)};
`,os=Object(V.euiStyled)(ls)`
  font-weight: bold;
  font-size: 0.9em;
  line-height: 1.2em;
`,cs=Object(V.euiStyled)(ls)`
  font-size: 0.7em;
  margin-bottom: 0.7em;
`,us=(e,t)=>{const{bounds:a,group:n,...r}=e,{bounds:i,group:s,...l}=t,{nodes:o,...c}=e.group,{nodes:u,...d}=t.group;return Object(R.isEqual)(r,l)&&Object(R.isEqual)(c,d)},ds=r.a.memo((({group:e,options:t,formatter:a,onDrilldown:n,isChild:i=!1,bounds:s,nodeType:l,currentTime:o})=>{const c=e.width>200?e.width:200;return r.a.createElement(ms,{style:{width:c}},r.a.createElement(group_name_GroupName,{group:e,onDrilldown:n,isChild:i,options:t}),r.a.createElement(ps,null,e.width?e.nodes.map((n=>r.a.createElement(node_Node,{key:`${n.pathId}:${n.name}`,options:t,squareSize:e.squareSize,node:n,formatter:a,bounds:s,nodeType:l,currentTime:o}))):r.a.createElement(g.EuiLoadingSpinner,{size:"xl"})))}),us),ms=V.euiStyled.div`
  margin: 0 10px;
`,ps=V.euiStyled.div`
  display: flex;
  background-color: rgba(0, 0, 0, 0.05);
  flex-wrap: wrap;
  justify-content: center;
  padding: 20px 10px 10px;
  border-radius: 4px;
  border: 1px solid ${e=>e.theme.eui.euiBorderColor};
  box-shadow: 0 1px 7px rgba(0, 0, 0, 0.1);
`,gs=e=>r.a.createElement(fs,null,r.a.createElement(group_name_GroupName,{group:e.group,onDrilldown:e.onDrilldown,options:e.options}),r.a.createElement(bs,null,e.group.groups.map((t=>r.a.createElement(ds,{isChild:!0,key:t.id,onDrilldown:e.onDrilldown,options:e.options,group:t,formatter:e.formatter,bounds:e.bounds,nodeType:e.nodeType,currentTime:e.currentTime}))))),fs=V.euiStyled.div`
  margin: 0 10px;
  width: 100%;
`,bs=V.euiStyled.div`
  display: flex;
  background-color: rgba(0, 0, 0, 0.05);
  flex-wrap: wrap;
  justify-content: center;
  padding: 20px 10px 10px;
  border-radius: 4px;
  border: 1px solid ${e=>e.theme.eui.euiBorderColor};
  box-shadow: 0 1px 7px rgba(0, 0, 0, 0.1);
`;function hs(e,t=1,a=1){const n=t/a,r=n>1.2?1.2:n,i=Math.ceil(Math.sqrt(e));return Math.ceil(i*r)}function ys(e){return e?e.reduce(((e,t)=>Ut(t)?t.groups.reduce(((e,t)=>t.nodes.length+e),e):$t(t)?t.nodes.length+e:e),0):0}const Es=e=>ys([e]);const vs={name:e=>Object(R.last)(e.path),value:e=>{const t=Object(R.first)(e.metrics);return t&&t.value||0}},xs=({nodes:e,options:t,currentTime:a,onFilter:n,formatter:i,bounds:s,nodeType:l,dataBounds:o,bottomMargin:c,staticHeight:u})=>{const d=((e,t)=>{const a=vs[e.by],n=Object(R.sortBy)(t,a);return"desc"===e.direction?n.reverse():n})(t.sort,e),m=function(e){return e.reduce(((e,t)=>{const a=Gt(t);if(2===t.path.length){const n=Ht(e,t.path.slice(0,t.path.length-1));return n.nodes.push(a),e.filter(Jt(n)).concat([n])}if(3===t.path.length){const n=Ht(e,t.path.slice(0,t.path.length-1));n.nodes.push(a);const r=function(e,t){const a=0===t.length?"__all__":qt(t),n=Object(R.last)(t),r=e.find((e=>e.id===a));return Ut(r)?r:{id:a,name:"__all__"===a?p.i18n.translate("xpack.infra.nodesToWaffleMap.groupsWithGroups.allName",{defaultMessage:"All"}):n&&n.label||"Unknown Group",count:0,width:0,squareSize:0,groups:[]}}(e,t.path.slice(0,t.path.length-2));return r.groups=r.groups.filter(Jt(n)).concat([n]),e.filter(Jt(r)).concat([r])}const n=Ht(e,[]);return n.nodes.push(a),e.filter(Jt(n)).concat([n])}),[])}(d);return r.a.createElement(zt.a,{bounds:!0},(({measureRef:e,bounds:{width:o=0,height:d=0}})=>{const p=function(e,t,a){if(0===e.length)return[];const n=Ut(Object(R.first)(e))?2:1,r=ys(e),i=Math.round(function(e,t,a,n=1){const r=.55/(n>1?.7*n:1),i=e*r,s=t*r,l=Math.ceil(Math.sqrt(a*i/s));let o,c;o=Math.floor(l*s/i)*l<a?s/Math.ceil(l*s/i):i/l;const u=Math.ceil(Math.sqrt(a*s/i));c=Math.floor(u*i/s)*u<a?i/Math.ceil(i*u/s):s/u;const d=Math.max(o,c);return Math.min(Math.max(d,24),1/0)}(t,a,r,n)),s=function(e){return e?e.reduce(((e,t)=>Ut(t)?t.groups.reduce(((e,t)=>$t(t)?e>t.nodes.length?e:t.nodes.length:e),e):$t(t)?e>t.nodes.length?e:t.nodes.length:e),0):0}(e);return Object(R.sortBy)(e,Es).reverse().map((e=>{if(Ut(e)){const n=hs(s,t,a),r=e.groups,l=Object(R.sortBy)(r,Es).reverse().filter($t).map((e=>({...e,count:e.nodes.length,columns:n,width:n*i,squareSize:i})));return{...e,groups:l,count:ys([e]),squareSize:i}}if($t(e)){const n=hs(Math.max(e.nodes.length,s),t,a);return{...e,count:e.nodes.length,squareSize:i,width:n*i}}return e}))}(m,o,d);return r.a.createElement(ks,{ref:t=>e(t),bottomMargin:c,"data-test-subj":"waffleMap",staticHeight:u},r.a.createElement(Ms,null,p.map((e=>Ut(e)?r.a.createElement(gs,{onDrilldown:n,key:e.id,options:t,group:e,formatter:i,bounds:s,nodeType:l,currentTime:a}):$t(e)?r.a.createElement(ds,{key:e.id,options:t,group:e,onDrilldown:n,formatter:i,isChild:!1,bounds:s,nodeType:l,currentTime:a}):void 0))))}))},ks=V.euiStyled.div`
  flex: 1 0 0%;
  display: flex;
  justify-content: flex-start;
  flex-direction: column;
  overflow-x: hidden;
  overflow-y: auto;
  margin-bottom: ${e=>e.bottomMargin}px;
  ${e=>e.staticHeight&&"min-height: 300px;"}
`,Ms=V.euiStyled.div`
  display: flex;
  flex-direction: row;
  flex-wrap: wrap;
  justify-content: center;
  align-content: flex-start;
  padding: 10px;
`;var Os=a(151),ws=a(174);const js=e=>{switch(e.length){case 3:return e.slice(0,2);case 2:return e.slice(0,1);default:return[]}},Ss=e=>{const{nodes:t,options:a,formatter:i,currentTime:s,nodeType:l}=e,[o,c]=Object(n.useState)([]),u=Object(n.useCallback)((e=>()=>{c([...o,e])}),[o]),d=Object(n.useCallback)((e=>()=>{o.includes(e)&&c(o.filter((t=>t!==e)))}),[o]);Object(n.useEffect)((()=>{const e=document.getElementsByClassName(ws.a)[0];e instanceof HTMLElement&&(o.length>0?e.style.overflowY="hidden":e.style.overflowY="auto")}),[o]);const m=[{field:"name",name:p.i18n.translate("xpack.infra.tableView.columnName.name",{defaultMessage:"Name"}),sortable:!0,truncateText:!0,textOnly:!0,render:(e,t)=>{const n=t.node.id===e?`${e}`:`${e} (${t.node.id})`,i=[...t.node.path.map((e=>e.value)),t.node.name].join(":"),c=r.a.createElement(g.EuiToolTip,{content:n},r.a.createElement(g.EuiButtonEmpty,{onClick:u(i)},e));return r.a.createElement(g.EuiPopover,{button:c,isOpen:o.includes(i),closePopover:d(i),anchorPosition:"rightCenter"},r.a.createElement(es,{node:t.node,nodeType:l,currentTime:s,options:a}))}},...a.groupBy.map(((t,a)=>({field:`group_${a}`,name:Object(Os.a)(t&&t.field||""),sortable:!0,truncateText:!0,textOnly:!0,render:a=>r.a.createElement(g.EuiToolTip,{content:"Set Filter"},r.a.createElement(g.EuiButtonEmpty,{onClick:()=>e.onFilter(`${t.field}:"${a}"`)},a))}))),{field:"value",name:p.i18n.translate("xpack.infra.tableView.columnName.last1m",{defaultMessage:"Last 1m"}),sortable:!0,truncateText:!0,dataType:"number",render:e=>r.a.createElement("span",null,i(e))},{field:"avg",name:p.i18n.translate("xpack.infra.tableView.columnName.avg",{defaultMessage:"Avg"}),sortable:!0,truncateText:!0,dataType:"number",render:e=>r.a.createElement("span",null,i(e))},{field:"max",name:p.i18n.translate("xpack.infra.tableView.columnName.max",{defaultMessage:"Max"}),sortable:!0,truncateText:!0,dataType:"number",render:e=>r.a.createElement("span",null,i(e))}],f=t.map((e=>{const t=Object(R.last)(e.path),a=Object(R.first)(e.metrics);return{name:t&&t.label||"unknown",...js(e.path).reduce(((e,t,a)=>({...e,[`group_${a}`]:t.label})),{}),value:a&&a.value||0,avg:a&&a.avg||0,max:a&&a.max||0,node:Gt(e)}}));return r.a.createElement(g.EuiInMemoryTable,{pagination:!0,sorting:{sort:{field:"value",direction:"desc"}},items:f,columns:m})},Cs=e=>{const t=e.map((e=>{const t=Object(R.first)(e.metrics);return t&&t.value?t.value:0}));1===t.length&&t.unshift(0);const a=Object(R.max)(t)||0,n=Object(R.min)(t)||0;return{min:Object(R.isFinite)(n)?n:0,max:Object(R.isFinite)(a)?a:0}},Ts=({legend:e,bounds:t,formatter:a})=>{const n=e.rules.reduce(((e,t)=>e<t.value?t.value:e),0),i={background:`linear-gradient(to right, ${e.rules.map((e=>{const t=e.value/n*100;return`${e.color} ${t}%`}))})`};return r.a.createElement(Ls,{style:i},e.rules.map(((e,t)=>(a,n)=>{const i=0===a.value?e.min:e.max*a.value,s={left:100*a.value+"%"},l=t(i);return r.a.createElement(Fs,{style:s,key:`legend-rule-${n}`},r.a.createElement(Ps,null),r.a.createElement(Is,null,l))})(t,a)))},Ls=V.euiStyled.div`
  position: absolute;
  height: 10px;
  bottom: 0;
  left: 0;
  right: 40px;
`,Fs=V.euiStyled.div`
  position: absolute;
  bottom: 0;
  top: -18px;
`,Ps=V.euiStyled.div`
  position: absolute;
  background-color: ${e=>e.theme.eui.euiBorderColor};
  width: 1px;
  left: 0;
  top: 15px;
  bottom: 0;
  ${Fs}:first-child {
    top: 2px;
  }
  ${Fs}:last-child {
    top: 2px;
  }
`,Is=V.euiStyled.div`
  position: absolute;
  font-size: 11px;
  text-align: center;
  top: 0;
  left: 0;
  white-space: nowrap;
  transform: translate(-50%, 0);
  ${Fs}:first-child & {
    padding-left: 5px;
    transform: translate(0, 0);
  }
  ${Fs}:last-child & {
    padding-right: 5px;
    transform: translate(-100%, 0);
  }
`,Ds={[te.c.gte]:">=",[te.c.gt]:">",[te.c.lte]:"<=",[te.c.lt]:"<",[te.c.eq]:"="},_s=({legend:e,formatter:t})=>r.a.createElement(Bs,null,e.rules.map((e=>(t,a)=>{const n=null!=t.label?t.label:`${Ds[t.operator]} ${e(t.value)}`,i={backgroundColor:Object(ea.darken)(.4,t.color)},s={backgroundColor:t.color};return r.a.createElement(Rs,{key:`legend-step-${a}`},r.a.createElement(As,{style:i},r.a.createElement(Ns,{style:s})),r.a.createElement(Vs,null,n))})(t))),Bs=V.euiStyled.div`
  display: flex;
  padding: 10px 40px 10px 10px;
`,Rs=V.euiStyled.div`
  display: flex;
  margin-right: 20px
  align-items: center;
`,As=V.euiStyled.div`
  position: relative;
  width: 24px;
  height: 24px;
  flex: 0 0 auto;
  margin-right: 5px;
  border-radius: 3px;
  box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.2);
`,Ns=V.euiStyled.div`
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 2px;
  border-radius: 3px;
`,Vs=V.euiStyled.div`
  font-size: 12px;
`,zs=({legend:e,bounds:t,formatter:a})=>r.a.createElement(Us,null,r.a.createElement($s,{value:1,bounds:t,formatter:a}),r.a.createElement(qs,null,e.rules.slice().reverse().map(((e,t)=>r.a.createElement(Hs,{key:`step-${t}-${e.value}`,style:{backgroundColor:e.color}})))),r.a.createElement($s,{value:0,bounds:t,formatter:a})),$s=({value:e,bounds:t,formatter:a})=>{const n=a(0===e?t.min:t.max*e);return r.a.createElement("div",null,r.a.createElement(g.EuiText,{size:"xs"},n))},Us=V.euiStyled.div`
  position: relative;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
`,qs=V.euiStyled.div`
  height: 200px;
  width: 10px;
  display: flex;
  flex-direction: column;
  align-items: stretch;
`,Hs=V.euiStyled.div`
  flex: 1 1 auto;
  &:first-child {
    border-radius: ${e=>e.theme.eui.euiBorderRadius} ${e=>e.theme.eui.euiBorderRadius} 0 0;
  }
  &:last-child {
    border-radius: 0 0 ${e=>e.theme.eui.euiBorderRadius} ${e=>e.theme.eui.euiBorderRadius};
  }
`,Gs=({legend:e,bounds:t,formatter:a})=>r.a.createElement(Js,null,te.a.is(e)&&r.a.createElement(Ts,{formatter:a,legend:e,bounds:t}),te.f.is(e)&&r.a.createElement(_s,{formatter:a,legend:e}),te.g.is(e)&&r.a.createElement(zs,{formatter:a,bounds:t,legend:e})),Js=V.euiStyled.div`
  margin: 0 10px;
  display: flex;
`,Ws=({autoBounds:e,boundsOverride:t,loading:a,nodes:i,nodeType:s,reload:l,view:o,currentTime:c,options:u,formatter:d,onDrilldown:m,bottomMargin:f,topMargin:b,showLoading:h})=>{const y=Object(n.useCallback)((e=>{m({kind:"kuery",expression:e})}),[m]),E=!a&&i&&0===i.length;if(a&&h)return r.a.createElement(D.a,{height:"100%",width:"100%",text:p.i18n.translate("xpack.infra.waffle.loadingDataText",{defaultMessage:"Loading data"})});if(E)return r.a.createElement(P.a,{titleText:p.i18n.translate("xpack.infra.waffle.noDataTitle",{defaultMessage:"There is no data to display."}),bodyText:p.i18n.translate("xpack.infra.waffle.noDataDescription",{defaultMessage:"Try adjusting your time or filter."}),refetchText:p.i18n.translate("xpack.infra.waffle.checkNewDataButtonLabel",{defaultMessage:"Check for new data"}),onRefetch:()=>{l()},testString:"noMetricsDataPrompt"});const v=Cs(i),x=e?v:t,k=["xs","s"].includes(Object(g.getBreakpoint)(window.innerWidth));return"table"===o?r.a.createElement(Ks,null,r.a.createElement(Ss,{nodeType:s,nodes:i,options:u,formatter:d,currentTime:c,onFilter:y})):r.a.createElement(Qs,{top:b,positionStatic:k},r.a.createElement(xs,{nodeType:s,nodes:i,options:u,formatter:d,currentTime:c,onFilter:y,bounds:x,dataBounds:v,bottomMargin:f,staticHeight:k}),r.a.createElement(Gs,{formatter:d,bounds:x,dataBounds:v,legend:u.legend}))},Ks=V.euiStyled.div`
  padding: ${e=>e.theme.eui.euiSizeL};
`,Qs=V.euiStyled.div`
  position: ${e=>e.positionStatic?"static":"absolute"};
  display: flex;
  top: ${e=>e.top}px;
  right: 0;
  bottom: 0;
  left: 0;
`;var Xs=a(147),Ys=a(177),Zs=a(178),el=a(179),tl=a(180),al=a(181),nl=a(182),rl=a(183);const il={host:Ys.a,container:Zs.a,pod:el.a,awsEC2:tl.a,awsS3:al.a,awsRDS:nl.a,awsSQS:rl.a};var sl=a(158);const ll=Be.type({value:Be.string,name:Be.string}),ol=Be.type({accounts:Be.array(ll),projects:Be.array(Be.string),regions:Be.array(Be.string)});Be.type({sourceId:Be.string,nodeType:na.c,currentTime:Be.number});const cl=({nodeType:e,currentTime:t})=>{const{sourceId:a}=Object(j.c)(),{accounts:i,regions:s}=function(e,t,a){const{error:r,loading:i,response:s,makeRequest:l}=Object(Ua.a)("/api/infra/inventory/meta","POST",JSON.stringify({sourceId:e,nodeType:t,currentTime:a}),(e=>Object(Re.pipe)(ol.decode(e),Object(Ae.fold)(Object($a.c)($a.a),Ne.identity))));return Object(n.useEffect)((()=>{l()}),[l]),{error:r,loading:i,accounts:s?s.accounts:[],regions:s?s.regions:[],makeRequest:l}}(a,e,t);return((e,t,a)=>r.a.createElement(sl.a,null,(n=>r.a.createElement(r.a.Fragment,null,r.a.createElement(e,m()({},n,{accounts:t,regions:a})),r.a.createElement(g.EuiFlexItem,{grow:!0})))))((e=>{const t=null==il?void 0:il[e];if(!t)throw new Error(p.i18n.translate("xpack.infra.inventoryModels.findToolbar.error",{defaultMessage:"The toolbar you've attempted to find does not exist."}));return t})(e),i,s)},ul=({view:e,onChange:t})=>{const a=[{id:"map",label:p.i18n.translate("xpack.infra.viewSwitcher.mapViewLabel",{defaultMessage:"Map view"}),iconType:"grid"},{id:"table",label:p.i18n.translate("xpack.infra.viewSwitcher.tableViewLabel",{defaultMessage:"Table view"}),iconType:"visTable"}];return r.a.createElement(g.EuiButtonGroup,{legend:p.i18n.translate("xpack.infra.viewSwitcher.lenged",{defaultMessage:"Switch between table and map view"}),options:a,color:"text",buttonSize:"s",idSelected:e,onChange:t,isIconOnly:!0})},dl=(e="cool",t=10)=>{switch(e){case"temperature":return Object(g.euiPaletteForTemperature)(t);case"status":return Object(g.euiPaletteForStatus)(t);case"warm":return Object(g.euiPaletteWarm)(t);case"positive":return Object(g.euiPalettePositive)(t);case"negative":return Object(g.euiPaletteNegative)(t);default:return Object(g.euiPaletteCool)(t)}},ml=(e="cool",t=10,a=!1)=>a?dl(e,t).reverse():dl(e,t),pl=(e,t=10,a=!1)=>({type:"steppedGradient",rules:ml(e,t,a).map(((e,a)=>({color:e,value:(a+1)/t})))}),gl=new RegExp("^([0-9\\.]*)\\s*("+["y","M","w","d","h","m","s","ms"].join("|")+")$"),fl={ms:.001,s:1,m:60,h:3600,d:86400,w:604800,M:2592e3,y:30758400},bl=e=>{const t=e.match(gl);if(t)return parseFloat(t[1])*fl[t[2]];throw new Error("Invalid interval string format.")};var hl=a(72);const yl=({interval:e,yAxisFormatter:t,isVisible:a})=>{var i,s;const{sourceId:l,source:o}=Object(j.c)(),{metric:c,nodeType:u,accountId:d,region:m}=Object(oa.d)(),{currentTime:p,jumpToTime:b,stopAutoReload:h}=vt(),{filterQueryAsJson:y}=Pt(),{loading:E,error:x,startTime:k,endTime:M,timeseries:O,reload:w}=function(e,t,a,r,i,s,l,o,c){const u=Object(n.useMemo)((()=>(e=>e&&bl(e)<300?"5m":e)(o)),[o]),d=Object(n.useMemo)((()=>(e=>{if(e){const t=bl(e);return{timeLength:t<=900?86400:t<=2100?259200:t<=9e3?604800:2592e3,intervalInSeconds:t}}return{timeLength:0,intervalInSeconds:0}})(u)),[u]),{timeLength:m,intervalInSeconds:p}=d,g=i+1e3*p,f=i-1e3*m,b={interval:null!=u?u:"",to:g,from:f,ignoreLookback:!0,forceInterval:!0},{error:h,loading:y,response:E,makeRequest:v}=Object(Ua.a)("/api/metrics/snapshot","POST",JSON.stringify({metrics:t,groupBy:null,nodeType:a,timerange:b,filterQuery:e,sourceId:r,accountId:s,region:l,includeTimeseries:!0}),(e=>Object(Re.pipe)(hl.g.decode(e),Object(Ae.fold)(Object($a.c)($a.a),Ne.identity)))),x=Object(n.useCallback)((()=>c?v():Promise.resolve()),[v,c]);Object(n.useEffect)((()=>{(async()=>{m&&await x()})()}),[x,m]);const k=E?Object(R.first)(E.nodes.map((e=>{var t;return null===(t=Object(R.first)(e.metrics))||void 0===t?void 0:t.timeseries}))):null;return{error:h&&h.message||null,loading:!o||y,timeseries:k,startTime:f,endTime:g,reload:v}}(y,[c],u,l,p,d,m,e,a),S={sourceId:"default",anomalyThreshold:(null==o?void 0:o.configuration.anomalyThreshold)||0,startTime:k,endTime:M,defaultSortOptions:{direction:"desc",field:"anomalyScore"},defaultPaginationOptions:{pageSize:100}},{metricsHostsAnomalies:C,getMetricsHostsAnomalies:T}=rr(S),{metricsK8sAnomalies:L,getMetricsK8sAnomalies:F}=er(S),P=Object(n.useMemo)((()=>"host"===u?T:"pod"===u?F:void 0),[u,F,T]),D=Object(n.useMemo)((()=>"host"===u?C:"pod"===u?L:void 0),[u,C,L]),_=null===(i=Object(sa.a)(c.type))||void 0===i?void 0:i.textLC,A=null===(s=Object(sa.a)(c.type))||void 0===s?void 0:s.text,V={color:Z.a.color0,aggregation:"avg",label:A},z=Object(n.useMemo)((()=>{var e,t;if(!O)return()=>"";const a=null===(e=Object(R.first)(O.rows))||void 0===e?void 0:e.timestamp,n=null===(t=Object(R.last)(O.rows))||void 0===t?void 0:t.timestamp;return null==a||null==n?e=>`${e}`:Object(B.niceTimeFormatter)([a,n])}),[O]),U=Object(f.useUiSetting)("theme:darkMode"),q={headerFormatter:e=>N()(e.value).format("Y-MM-DD HH:mm:ss.SSS")},H=O?Object(ye.a)(O,[V],!1):null,G=H?{max:1.1*H.max,min:H.min}:{max:0,min:0},J=Object(n.useCallback)((([e])=>{const[t]=e;if(t&&!Array.isArray(t)){const{x:e}=t;b(e),h()}}),[b,h]),W=Object(n.useMemo)((()=>{const e=c.type;return"memory"===e?"memory_usage":"rx"===e?"network_in":"tx"===e?"network_out":void 0}),[c]);return Object(n.useEffect)((()=>{P&&W&&P(W)}),[P,W]),E?r.a.createElement(El,null,r.a.createElement(kl,null,r.a.createElement(g.EuiLoadingChart,{size:"xl"}))):E||!x&&O?r.a.createElement(El,{"data-test-subj":a?"timelineContainerOpen":"timelineContainerClosed"},r.a.createElement(vl,null,r.a.createElement(g.EuiFlexItem,{grow:!0},r.a.createElement(g.EuiText,null,r.a.createElement("strong",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.inventoryTimeline.header",defaultMessage:"Average {metricLabel}",values:{metricLabel:_}})))),r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiFlexGroup,{alignItems:"center",responsive:!1},r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",responsive:!1},r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiIcon,{color:Object(Z.b)(V.color),type:"dot"})),r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiText,{size:"xs"},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.inventoryTimeline.header",defaultMessage:"Average {metricLabel}",values:{metricLabel:_}}))))),r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",responsive:!1},r.a.createElement(g.EuiFlexItem,{grow:!1,style:{backgroundColor:"#D36086",height:5,width:10}}),r.a.createElement(g.EuiFlexItem,null,r.a.createElement(g.EuiText,{size:"xs"},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.inventoryTimeline.legend.anomalyLabel",defaultMessage:"Anomaly detected"})))))))),r.a.createElement(xl,null,r.a.createElement(B.Chart,null,D&&r.a.createElement(B.RectAnnotation,{id:"anomalies",dataValues:(K=D.map((e=>[e.startTime,e.influencers])),K.map((e=>{const[t,a]=e;return{coordinates:{x0:t,x1:N()(t).add(15,"minutes").valueOf(),y0:null==H?void 0:H.min,y1:null==H?void 0:H.max},details:a.join(",")}}))),style:{fill:"#D36086"}}),r.a.createElement($.a,{type:v.b.area,metric:V,id:"0",series:O,stack:!1}),r.a.createElement(B.Axis,{id:"timestamp",position:B.Position.Bottom,showOverlappingTicks:!0,tickFormat:z}),r.a.createElement(B.Axis,{id:"values",position:B.Position.Left,tickFormat:t,domain:G,ticks:6,showGridLines:!0}),r.a.createElement(B.Settings,{tooltip:q,theme:fe(U),onElementClick:J})))):r.a.createElement(El,null,r.a.createElement(g.EuiEmptyPrompt,{iconType:"visArea",title:r.a.createElement("h4",null,x?Ol:Ml),actions:r.a.createElement(g.EuiButton,{color:"primary",fill:!0,onClick:w},x?jl:wl)}));var K},El=V.euiStyled.div`
  background-color: ${e=>e.theme.eui.euiPageBackgroundColor};
  border-top: 1px solid ${e=>e.theme.eui.euiColorLightShade};
  height: 220px;
  width: 100%;
  padding: ${e=>e.theme.eui.euiSizeS} ${e=>e.theme.eui.euiSizeM};
  display: flex;
  flex-direction: column;
`,vl=V.euiStyled.div`
  display: flex;
  width: 100%;
  padding: ${e=>e.theme.eui.euiSizeS} ${e=>e.theme.eui.euiSizeM};
  @media only screen and (max-width: 767px) {
      margin-top: 30px;
  }
`,xl=V.euiStyled.div`
  padding-left: ${e=>e.theme.eui.euiSizeXS};
  width: 100%;
  height: 100%;
`,kl=V.euiStyled.div`
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100%;
`,Ml=p.i18n.translate("xpack.infra.inventoryTimeline.noHistoryDataTitle",{defaultMessage:"There is no historical data to display."}),Ol=p.i18n.translate("xpack.infra.inventoryTimeline.errorTitle",{defaultMessage:"Unable to show historical data."}),wl=p.i18n.translate("xpack.infra.inventoryTimeline.checkNewDataButtonLabel",{defaultMessage:"Check for new data"}),jl=p.i18n.translate("xpack.infra.inventoryTimeline.retryButtonLabel",{defaultMessage:"Try again"}),Sl=p.i18n.translate("xpack.infra.showHistory",{defaultMessage:"Show history"}),Cl=p.i18n.translate("xpack.infra.hideHistory",{defaultMessage:"Hide history"}),Tl=({measureRef:e,width:t,interval:a,formatter:i,children:s})=>{const{timelineOpen:l,changeTimelineOpen:o}=Object(oa.d)(),[c,u]=Object(n.useState)(Boolean(l));Object(n.useEffect)((()=>{c!==l&&u(Boolean(l))}),[c,l]);const d=Object(b.useUiTracker)({app:"infra_metrics"}),m=Object(n.useCallback)((()=>{c||d({metric:"open_timeline_drawer__inventory"}),u(!c),o(!c)}),[c,d,o]);return r.a.createElement(Ll,{ref:c?e:null,isOpen:c,outerWidth:t},r.a.createElement(Fl,{ref:c?null:e},r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(Pl,{"aria-expanded":c,iconType:c?"arrowDown":"arrowRight",onClick:m,"data-test-subj":"toggleTimelineButton"},c?Cl:Sl))),r.a.createElement(g.EuiFlexGroup,{style:{marginTop:0}},r.a.createElement(yl,{isVisible:c,interval:a,yAxisFormatter:i})))},Ll=V.euiStyled.div`
  padding: ${e=>e.theme.eui.euiSizeM} 0;
  position: fixed;
  bottom: 0;
  right: 0;
  transition: transform ${300}ms;
  transform: translateY(${e=>e.isOpen?0:"224px"});
  width: ${e=>e.outerWidth+34}px;
`,Fl=Object(V.euiStyled)(g.EuiFlexGroup).attrs({justifyContent:"spaceBetween",alignItems:"center"})`
 margin-bottom: 0;
 height: 48px;
`,Pl=Object(V.euiStyled)(g.EuiButtonEmpty).attrs({size:"s"})`
  width: 140px;
`,Il=e=>({min:100*e.min,max:100*(e.max||1)}),Dl=({label:e,color:t})=>r.a.createElement(g.EuiFlexGroup,{alignItems:"center",gutterSize:"s",responsive:!1},r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiColorPickerSwatch,{color:t})),r.a.createElement(g.EuiFlexItem,null,r.a.createElement(g.EuiText,{size:"xs"},r.a.createElement("strong",null,e)))),_l=({steps:e,palette:t,reverse:a})=>{const n=ml(t,e,a);return r.a.createElement(Rl,null,n.map((e=>r.a.createElement(Bl,{key:e,style:{backgroundColor:e}}))))},Bl=V.euiStyled.div`
  width: 15px;
  height: 12px;
  flex: 0 0 auto;
  &:first-child {
    border-radius: ${e=>e.theme.eui.euiBorderRadius} 0 0 ${e=>e.theme.eui.euiBorderRadius};
  }
  &:last-child {
    border-radius: 0 ${e=>e.theme.eui.euiBorderRadius} ${e=>e.theme.eui.euiBorderRadius} 0;
`,Rl=V.euiStyled.div`
  display: flex;
`,Al=["temperature","status","cool","warm","positive","negative"].map((e=>({text:te.e[e],value:e}))),Nl=({autoBounds:e,boundsOverride:t,onChange:a,dataBounds:i,options:s})=>{const[l,o]=Object(n.useState)(!1),[c,u]=Object(n.useState)(e),[d,m]=Object(n.useState)(s),[f,b]=Object(n.useState)(Il(t));Object(n.useEffect)((()=>{c&&b(Il(i))}),[e,i,c,a,s]);const h=r.a.createElement(g.EuiButtonIcon,{iconType:"color",color:"text",display:"base",size:"s","aria-label":p.i18n.translate("xpack.infra.legendControls.buttonLabel",{defaultMessage:"configure legend"}),onClick:()=>o(!0),"data-test-subj":"openLegendControlsButton"}),y=Object(n.useCallback)((e=>{const a=e.target.checked;u(a),a||b(Il(t))}),[t]),E=Object(n.useCallback)((e=>{m((t=>({...t,reverseColors:e.target.checked})))}),[m]),v=Object(n.useCallback)((e=>{const t=parseFloat(e.currentTarget.value),a=t<=f.min?f.min+1:t>100?100:t;b({...f,max:a})}),[f]),x=Object(n.useCallback)((e=>{const t=parseFloat(e.currentTarget.value),a=t>=f.max?f.max-1:t<0?0:t;b({...f,min:a})}),[f]),k=Object(n.useCallback)((()=>{a({auto:c,bounds:{min:f.min/100,max:f.max/100},legend:d}),o(!1)}),[a,c,f,d]),M=Object(n.useCallback)((()=>{b(Il(t)),u(e),m(s),o(!1)}),[e,t,s]),O=Object(n.useCallback)((e=>{const t=parseInt(e.target.value,10);m((e=>({...e,steps:t})))}),[m]),w=Object(n.useCallback)((e=>{const t=e.target.value;m((e=>({...e,palette:t})))}),[m]),j=c===e&&100*t.min===f.min&&100*t.max===f.max&&s.steps===d.steps&&s.reverseColors===d.reverseColors&&s.palette===d.palette,S=f.min<f.max,C=ml(d.palette,d.steps,d.reverseColors),T=S?[]:[p.i18n.translate("xpack.infra.legnedControls.boundRangeError",{defaultMessage:"Minimum must be smaller than the maximum"})];return r.a.createElement(g.EuiPopover,{isOpen:l,closePopover:M,id:"legendControls",button:h,anchorPosition:"leftCenter","data-test-subj":"legendControls"},r.a.createElement(g.EuiPopoverTitle,null,"Legend Options"),r.a.createElement(g.EuiForm,{style:{minWidth:400}},r.a.createElement(g.EuiFormRow,{display:"columnCompressed",label:p.i18n.translate("xpack.infra.legendControls.colorPaletteLabel",{defaultMessage:"Color palette"})},r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiSelect,{options:Al,value:d.palette,id:"palette",onChange:w,compressed:!0,"data-test-subj":"legendControlsPalette"}),r.a.createElement(g.EuiSpacer,{size:"m"}),r.a.createElement(_l,{palette:d.palette,steps:d.steps,reverse:d.reverseColors}))),r.a.createElement(g.EuiFormRow,{display:"columnCompressed",label:p.i18n.translate("xpack.infra.legendControls.stepsLabel",{defaultMessage:"Number of colors"})},r.a.createElement(g.EuiRange,{id:"steps",min:2,max:18,step:1,value:d.steps,onChange:O,showValue:!0,fullWidth:!0})),r.a.createElement(g.EuiFormRow,{fullWidth:!0,display:"columnCompressed",label:p.i18n.translate("xpack.infra.legendControls.reverseDirectionLabel",{defaultMessage:"Reverse direction"})},r.a.createElement(g.EuiSwitch,{showLabel:!1,name:"reverseColors",label:"reverseColors",checked:d.reverseColors,onChange:E,compressed:!0,style:{position:"relative",top:"8px"}})),r.a.createElement(g.EuiFormRow,{fullWidth:!0,display:"columnCompressed",label:p.i18n.translate("xpack.infra.legendControls.switchLabel",{defaultMessage:"Auto calculate range"})},r.a.createElement(g.EuiSwitch,{showLabel:!1,name:"bounds",label:"bounds",checked:c,onChange:y,compressed:!0,style:{position:"relative",top:"8px"}})),r.a.createElement(g.EuiFormRow,{fullWidth:!0,label:r.a.createElement(Dl,{color:Object(R.first)(C),label:p.i18n.translate("xpack.infra.legendControls.minLabel",{defaultMessage:"Minimum"})}),isInvalid:!S,display:"columnCompressed",error:T},r.a.createElement("div",{style:{maxWidth:150}},r.a.createElement(g.EuiFieldNumber,{disabled:c,step:1,value:isNaN(f.min)?"":f.min,isInvalid:!S,name:"legendMin",onChange:x,append:"%",compressed:!0}))),r.a.createElement(g.EuiFormRow,{fullWidth:!0,display:"columnCompressed",label:r.a.createElement(Dl,{color:Object(R.last)(C),label:p.i18n.translate("xpack.infra.legendControls.maxLabel",{defaultMessage:"Maxium"})}),isInvalid:!S,error:T},r.a.createElement("div",{style:{maxWidth:150}},r.a.createElement(g.EuiFieldNumber,{disabled:c,step:1,isInvalid:!S,value:isNaN(f.max)?"":f.max,name:"legendMax",onChange:v,append:"%",compressed:!0}))),r.a.createElement(g.EuiSpacer,{size:"m"}),r.a.createElement(g.EuiFlexGroup,{justifyContent:"flexEnd",responsive:!1},r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiButtonEmpty,{type:"submit",size:"s",onClick:M},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.legendControls.cancelButton",defaultMessage:"Cancel"}))),r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiButton,{type:"submit",size:"s",fill:!0,disabled:j||!S,onClick:k,"data-test-subj":"applyLegendControlsButton"},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.legendControls.applyButton",defaultMessage:"Apply"}))))))},Vl=r.a.memo((({shouldLoadDefault:e,currentView:t,reload:a,interval:i,nodes:s,loading:l})=>{var o,c,u;const[d,m]=Object(n.useState)(!0),{metric:p,groupBy:f,sort:b,nodeType:h,changeView:y,view:E,autoBounds:v,boundsOverride:x,legend:k,changeBoundsOverride:M,changeAutoBounds:O,changeLegend:w}=Object(oa.d)(),{currentTime:j,jumpToTime:S,isAutoReloading:C}=vt(),{applyFilterQuery:T}=Pt(),L=null!==(o=null==k?void 0:k.palette)&&void 0!==o?o:oa.a.palette,F=null!==(c=null==k?void 0:k.steps)&&void 0!==c?c:oa.a.steps,P=null!==(u=null==k?void 0:k.reverseColors)&&void 0!==u?u:oa.a.reverseColors,I={formatter:te.b.percent,formatTemplate:"{{value}}",legend:pl(L,F,P),metric:p,sort:b,groupBy:f};Vt()((()=>{l||S(Date.now())}),C?5e3:null);const D=Cs(s),_=v?D:x,B=Object(n.useCallback)(Object(ia.a)(I.metric),[I.metric]),{onViewChange:R}=zi();Object(n.useEffect)((()=>{t&&R(t)}),[t,R]),Object(n.useEffect)((()=>{null==t&&e||a()}),[a,e]),Object(n.useEffect)((()=>{m(!0)}),[I.metric,h]),Object(n.useEffect)((()=>{const e=s&&s.length;m(!e)}),[s]);const A=Object(n.useCallback)((e=>{M(e.bounds),O(e.auto),w(e.legend)}),[M,O,w]);return r.a.createElement(r.a.Fragment,null,r.a.createElement(Xs.b,null,r.a.createElement(zt.a,{bounds:!0},(({measureRef:e,bounds:{width:t=0}})=>r.a.createElement(zl,{ref:e},r.a.createElement(zt.a,{bounds:!0},(({measureRef:e,bounds:{height:n=0}})=>r.a.createElement(r.a.Fragment,null,r.a.createElement($l,{ref:e},r.a.createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center",gutterSize:"m"},r.a.createElement(cl,{nodeType:h,currentTime:j}),r.a.createElement(g.EuiFlexGroup,{responsive:!1,style:{margin:0,justifyContent:"end"}},"map"===E&&r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(Nl,{options:null!=k?k:oa.a,dataBounds:D,bounds:_,autoBounds:v,boundsOverride:x,onChange:A})),r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(ul,{view:E,onChange:y}))))),r.a.createElement(zt.a,{bounds:!0},(({measureRef:e,bounds:{height:o=0}})=>r.a.createElement(r.a.Fragment,null,r.a.createElement(Ws,{nodes:s,options:I,nodeType:h,loading:l,showLoading:d,reload:a,onDrilldown:T,currentTime:j,view:E,autoBounds:v,boundsOverride:x,formatter:B,bottomMargin:o,topMargin:n}),"map"===E&&r.a.createElement(Tl,{measureRef:e,interval:i,formatter:B,width:t}))))))))))))})),zl=V.euiStyled.div`
  position: relative;
  flex: 1 1 auto;
`,$l=V.euiStyled.div`
  padding: ${e=>`12px ${e.theme.eui.euiSizeM}`};
`,Ul=e=>{const{shouldLoadDefault:t,currentView:a}=Ke();return r.a.createElement(Vl,m()({shouldLoadDefault:t,currentView:a},e))},ql=()=>{const{viewState:e}=zi();return r.a.createElement(it,{viewState:e})},Hl=({render:e})=>{const{sourceId:t}=Object(j.c)(),{metric:a,groupBy:n,nodeType:r,accountId:i,region:s}=Object(oa.d)(),{currentTime:l}=vt(),{filterQueryAsJson:o}=Pt(),{loading:c,nodes:u,reload:d,interval:m}=Object(ra.a)(o,[a],n,r,t,l,i,s,!1);return e({loading:c,nodes:u,reload:d,interval:m})},Gl=()=>{const{hasFailedLoadingSource:e,isLoading:t,loadSourceFailureMessage:a,loadSource:i,source:s,metricIndicesExist:l}=Object(n.useContext)(j.a.Context);Object(b.useTrackPageview)({app:"infra_metrics",path:"inventory"}),Object(b.useTrackPageview)({app:"infra_metrics",path:"inventory",delay:15e3});const{source:o}=Object(oa.d)();return F([{text:L.b}]),r.a.createElement(g.EuiErrorBoundary,null,r.a.createElement(h.a,{title:e=>p.i18n.translate("xpack.infra.infrastructureSnapshotPage.documentTitle",{defaultMessage:"{previousTitle} | Inventory",values:{previousTitle:e}})}),t&&!s?r.a.createElement(At.a,null):l?r.a.createElement(r.a.Fragment,null,r.a.createElement(Jl,{className:ot.APP_WRAPPER_CLASS},r.a.createElement(We,{shouldLoadDefault:"default"===o,viewType:"inventory-view",defaultViewState:Vi},r.a.createElement(Ze,{hasData:l,pageHeader:{pageTitle:L.b,rightSideItems:[r.a.createElement(ql,null)]},pageBodyProps:{paddingSize:"none"}},r.a.createElement(Hl,{render:({loading:e,nodes:t,reload:a,interval:n})=>r.a.createElement(r.a.Fragment,null,r.a.createElement(Dt,{interval:n}),r.a.createElement(Ul,{loading:e,nodes:t,reload:a,interval:n}))}))))):e?r.a.createElement(Rt,{errorMessage:a||"",retry:i}):r.a.createElement(Ze,{hasData:l,"data-test-subj":"noMetricsIndicesPrompt"}))},Jl=V.euiStyled.div`
  .euiPage .euiPageContentBody {
    display: flex;
    flex-direction: column;
    flex: 1 0 auto;
    width: 100%;
    height: 100%;
  }
`;var Wl=a(148);const Kl=Be.intersection([Be.type({timestamp:Be.number}),Be.partial({value:Be.union([Be.number,Be.null])})]),Ql=Be.type({id:Be.string,label:Be.string,data:Be.array(Kl)}),Xl=Be.intersection([Be.partial({id:Be.union([na.a,Be.null])}),Be.type({series:Be.array(Ql)})]),Yl=Be.type({metrics:Be.array(Xl)});Be.intersection([Be.type({nodeType:na.c,nodeId:Be.string,metrics:Be.array(na.a),timerange:hl.a,sourceId:Be.string}),Be.partial({cloudId:Be.union([Be.string,Be.null])})]);const Zl=({loading:e,name:t,items:a})=>{const[i,s]=Object(n.useState)(!1),l=Object(n.useCallback)((()=>{s(!i)}),[i]),o=e?null:r.a.createElement(g.EuiSideNav,{items:a}),c=e?null:r.a.createElement(g.EuiSideNav,{items:a,mobileTitle:t,toggleOpenOnMobile:l,isOpenOnMobile:i});return r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiHideFor,{sizes:["xs","s","m"]},r.a.createElement(g.EuiPageSideBar,{sticky:!0},o)),r.a.createElement(g.EuiShowFor,{sizes:["xs","s","m"]},r.a.createElement(g.EuiPageSideBar,null,c)))},eo=e=>{const[t]=Object(he.a)(Oe.UI_SETTINGS.TIMEPICKER_QUICK_RANGES),{onChangeTimeRange:a,onRefresh:i,currentTimeRange:s,isLiveStreaming:l,refreshInterval:o,setAutoReload:c,setRefreshInterval:u}=e,d=Fe(t),m=Object(n.useCallback)((({start:e,end:t})=>{a({from:e,to:t,interval:">=1m"})}),[a]),p=Object(n.useCallback)((({isPaused:e,refreshInterval:t})=>{e?c(!1):(u(t),c(!0))}),[c,u]);return r.a.createElement(to,null,r.a.createElement(g.EuiSuperDatePicker,{start:s.from.toString(),end:s.to.toString(),isPaused:!l,refreshInterval:o||0,onTimeChange:m,onRefreshChange:p,onRefresh:i,commonlyUsedRanges:d}))},to=V.euiStyled.div`
  max-width: 750px;
`,ao=r.a.createContext({items:[],addNavItem:e=>{}}),no=({children:e,metrics:t,navLabel:a,sectionLabel:i,onChangeRangeTime:s,isLiveStreaming:l,stopLiveStreaming:o})=>{const{addNavItem:c}=Object(n.useContext)(ao),u=n.Children.toArray(e).reduce(((e,a)=>{var r;return Object(n.isValidElement)(a)?null===(null!==(r=null==t?void 0:t.find((e=>e.id===a.props.id)))&&void 0!==r?r:null)?e:a.props.label?[...e,{id:a.props.id,name:a.props.label,onClick:()=>{const e=document.getElementById(a.props.id);e&&e.scrollIntoView()}}]:e:e}),[]),d=n.Children.map(e,(e=>Object(n.isValidElement)(e)?Object(n.cloneElement)(e,{metrics:t,onChangeRangeTime:s,isLiveStreaming:l,stopLiveStreaming:o}):null));return t&&u.length?(c({id:a,name:a,items:u}),r.a.createElement("div",null,r.a.createElement(g.EuiTitle,null,r.a.createElement("h1",null,i)),d)):null},ro=({id:e,label:t,children:a,metrics:i,onChangeRangeTime:s,isLiveStreaming:l,stopLiveStreaming:o})=>{const c=Object(n.useMemo)((()=>null==i?void 0:i.find((t=>t.id===e))),[e,i]);if(!a||!c)return null;const u=n.Children.map(a,(t=>Object(n.isValidElement)(t)?Object(n.cloneElement)(t,{metric:c,id:e,onChangeRangeTime:s,isLiveStreaming:l,stopLiveStreaming:o}):null));return r.a.createElement("div",{style:{margin:"10px 0 16px 0"},id:e},t?r.a.createElement(g.EuiTitle,{size:"s"},r.a.createElement("h4",null,t)):null,u)};var io=a(280),so=a.n(io);const lo=e=>e.data.length<2,oo=(e,t,a)=>e?Object(R.get)(e,[t,"name"],a):a,co=(e,t)=>{const a=e?Object(R.get)(e,[t,"color"]):null;return a?new so.a(a).hex().toString():null},uo=(e,t,a)=>{if(!e||!t)return"line";const n=Object(R.get)(e,[a,"type"]);return na.b.is(n)?n:na.b.is(t)?t:"line"},mo=({id:e,metric:t,seriesOverrides:a,formatter:n,formatterTemplate:i})=>t&&e?r.a.createElement(g.EuiPageContentBody,null,r.a.createElement(g.EuiSpacer,{size:"m"}),r.a.createElement(po,null,t.series.map((t=>{const s=Object(R.last)(t.data);if(!s)return null;const l=((e="number",t="{{value}}",a={},n)=>r=>{if(null==r)return"";const i=Object(R.get)(a,[n,"formatter"],e),s=Object(R.get)(a,[n,"formatterTemplate"],t);return Object(Za.b)(i,s)(r)})(n,i,a,t.id),o=l(s.value||0),c=oo(a,t.id,t.id),u=Object(R.max)(t.data.map((e=>e.value||0))),d=Object(R.get)(a,[t.id,"gaugeMax"],u);return r.a.createElement(g.EuiFlexItem,{key:`${e}-${t.id}`,style:{margin:"0.4rem"}},r.a.createElement(g.EuiPanel,{style:{minWidth:"160px"}},r.a.createElement(g.EuiText,{style:{textAlign:"right"},size:"s"},c),r.a.createElement(g.EuiTitle,{size:"s"},r.a.createElement("h1",{style:{textAlign:"right",whiteSpace:"nowrap"}},o)),r.a.createElement(g.EuiProgress,{value:s.value||0,max:d,size:"s",color:"primary"})))}))),r.a.createElement(g.EuiSpacer,{size:"m"})):null,po=V.euiStyled.div`
  display: flex;
  flex-flow: row wrap;
  justify-content: space-evenly;
`;var go=a(115);const fo=e=>"bar"===e.type?r.a.createElement(ho,e):r.a.createElement(bo,e),bo=({id:e,color:t,series:a,name:n,type:i,stack:s})=>{const l=Object(go.a)(),o={area:{opacity:1,visible:"area"===i},line:{strokeWidth:"area"===i?1:2,visible:!0}};return r.a.createElement(B.AreaSeries,{id:e,name:n,xScaleType:B.ScaleType.Time,yScaleType:B.ScaleType.Linear,xAccessor:"timestamp",yAccessors:["value"],data:a.data,areaSeriesStyle:o,color:t||void 0,stackAccessors:s?["timestamp"]:void 0,timeZone:l})},ho=({id:e,color:t,series:a,name:n,stack:i})=>{const s=Object(go.a)(),l={rectBorder:{stroke:t||void 0,strokeWidth:1,visible:!0},rect:{opacity:1}};return r.a.createElement(B.BarSeries,{id:e,name:n,xScaleType:B.ScaleType.Time,yScaleType:B.ScaleType.Linear,xAccessor:"timestamp",yAccessors:["value"],data:a.data,barSeriesStyle:l,color:t||void 0,stackAccessors:i?["timestamp"]:void 0,timeZone:s})},yo=({title:e,body:t})=>r.a.createElement(g.EuiEmptyPrompt,{iconType:"stats",title:r.a.createElement("h3",null,e),body:r.a.createElement("p",null,t)}),Eo=({id:e,onChangeRangeTime:t,metric:a,stopLiveStreaming:i,isLiveStreaming:s,formatter:l,formatterTemplate:o,stacked:c,seriesOverrides:u,type:d})=>{const m=Object(f.useUiSetting)("theme:darkMode"),[b]=Object(he.a)("dateFormat"),h=Object(n.useCallback)(((e="number",t="{{value}}")=>a=>null!=a?Object(Za.b)(e,t)(a):"")(l,o),[l,o]),y=Object(n.useMemo)((()=>null!=a?Object(B.niceTimeFormatter)((e=>{if(e.series.some(lo))return[0,0];const t=e.series.reduce(((e,t)=>{const a=Object(R.first)(t.data),n=Object(R.last)(t.data);return e.concat([a&&a.timestamp||0,n&&n.timestamp||0])}),[]);return[Object(R.min)(t),Object(R.max)(t)]})(a)):void 0),[a]),E=Object(n.useCallback)((({x:e})=>{if(!e)return;const[a,n]=e;t&&(s&&i&&i(),t({from:N()(a).toISOString(),to:N()(n).toISOString(),interval:">=1m"}))}),[t,s,i]),v={headerFormatter:Object(n.useCallback)((e=>N()(e.value).format(b||"Y-MM-DD HH:mm:ss.SSS")),[b])};return e?a?a.series.some(lo)?r.a.createElement(yo,{title:p.i18n.translate("xpack.infra.chartSection.notEnoughDataPointsToRenderTitle",{defaultMessage:"Not Enough Data"}),body:p.i18n.translate("xpack.infra.chartSection.notEnoughDataPointsToRenderText",{defaultMessage:"Not enough data points to render chart, try increasing the time range."})}):r.a.createElement(g.EuiPageContentBody,null,r.a.createElement("div",{className:"infrastructureChart",style:{height:250,marginBottom:16}},r.a.createElement(B.Chart,null,r.a.createElement(B.Axis,{id:"timestamp",position:B.Position.Bottom,showOverlappingTicks:!0,tickFormat:y}),r.a.createElement(B.Axis,{id:"values",position:B.Position.Left,tickFormat:h}),a&&a.series.map((t=>r.a.createElement(fo,{key:`series-${e}-${t.id}`,id:`series-${e}-${t.id}`,series:t,name:oo(u,t.id,t.id),type:uo(u,d,t.id),color:co(u,t.id),stack:c}))),r.a.createElement(B.Settings,{tooltip:v,onBrushEnd:E,theme:ge(m),showLegend:!0,showLegendExtra:!0,legendPosition:"right"})))):r.a.createElement(yo,{title:p.i18n.translate("xpack.infra.chartSection.missingMetricDataText",{defaultMessage:"Missing Data"}),body:p.i18n.translate("xpack.infra.chartSection.missingMetricDataBody",{defaultMessage:"The data for this chart is missing."})}):null},vo=Object(V.withTheme)((({metrics:e,onChangeRangeTime:t,theme:a})=>r.a.createElement(r.a.Fragment,null,r.a.createElement(no,{navLabel:"AWS",sectionLabel:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.overviewSection.sectionLabel",{defaultMessage:"AWS Overview"}),metrics:e,onChangeRangeTime:t},r.a.createElement(ro,{id:"awsOverview"},r.a.createElement(mo,{seriesOverrides:{"cpu-util":{name:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.overviewSection.cpuUtilizationSeriesLabel",{defaultMessage:"CPU Utilization"}),color:a.eui.euiColorFullShade,formatter:"percent",gaugeMax:1},"status-check-failed":{name:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.overviewSection.statusCheckFailedLabel",{defaultMessage:"Status check failed"}),color:a.eui.euiColorFullShade},"packets-in":{name:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.overviewSection.networkPacketsInLabel",{defaultMessage:"Packets (in)"}),color:a.eui.euiColorFullShade,formatter:"number"},"packets-out":{name:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.overviewSection.networkPacketsOutLabel",{defaultMessage:"Packets (out)"}),color:a.eui.euiColorFullShade,formatter:"number"}}})),r.a.createElement(ro,{id:"awsCpuUtilization",label:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.cpuUtilSection.sectionLabel",{defaultMessage:"CPU Utilization"})},r.a.createElement(Eo,{type:"area",formatter:"number",seriesOverrides:{"cpu-util":{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.cpuUtilSection.percentSeriesLabel",{defaultMessage:"percent"})}}})),r.a.createElement(ro,{id:"awsNetworkBytes",label:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.networkBytesSection.sectionLabel",{defaultMessage:"Network Traffic"})},r.a.createElement(Eo,{type:"area",formatter:"bits",formatterTemplate:"{{value}}/s",seriesOverrides:{tx:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.networkBytesSection.txSeriesLabel",{defaultMessage:"out"})},rx:{color:a.eui.euiColorVis2,name:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.networkBytesSection.rxSeriesLabel",{defaultMessage:"in"})}}})),r.a.createElement(ro,{id:"awsNetworkPackets",label:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.networkPacketsSection.sectionLabel",{defaultMessage:"Network Packets (Average)"})},r.a.createElement(Eo,{type:"area",formatter:"number",seriesOverrides:{"packets-out":{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.networkPacketsSection.packetsOutSeriesLabel",{defaultMessage:"out"})},"packets-in":{color:a.eui.euiColorVis2,name:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.networkPacketsSection.packetsInSeriesLabel",{defaultMessage:"in"})}}})),r.a.createElement(ro,{id:"awsDiskioOps",label:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.diskioOperationsSection.sectionLabel",{defaultMessage:"Disk I/O Operations"})},r.a.createElement(Eo,{type:"area",formatter:"number",seriesOverrides:{writes:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.diskioOperationsSection.writesSeriesLabel",{defaultMessage:"writes"})},reads:{color:a.eui.euiColorVis2,name:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.diskioOperationsSection.readsSeriesLabel",{defaultMessage:"reads"})}}})),r.a.createElement(ro,{id:"awsDiskioBytes",label:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.diskioBytesSection.sectionLabel",{defaultMessage:"Disk I/O Bytes"})},r.a.createElement(Eo,{type:"area",formatter:"number",seriesOverrides:{writes:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.diskioBytesSection.writesSeriesLabel",{defaultMessage:"writes"})},reads:{color:a.eui.euiColorVis2,name:p.i18n.translate("xpack.infra.metricDetailPage.awsMetricsLayout.diskioBytesSection.readsSeriesLabel",{defaultMessage:"reads"})}}})))))),xo=Object(V.withTheme)((({metrics:e,onChangeRangeTime:t,theme:a})=>r.a.createElement(r.a.Fragment,null,r.a.createElement(no,{navLabel:"Nginx",sectionLabel:"Nginx",metrics:e,onChangeRangeTime:t},r.a.createElement(ro,{id:"nginxHits",label:p.i18n.translate("xpack.infra.metricDetailPage.nginxMetricsLayout.hitsSection.sectionLabel",{defaultMessage:"Hits"})},r.a.createElement(Eo,{stacked:!0,type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{"200s":{color:a.eui.euiColorVis1},"300s":{color:a.eui.euiColorVis5},"400s":{color:a.eui.euiColorVis2},"500s":{color:a.eui.euiColorVis9}}})),r.a.createElement(ro,{id:"nginxRequestRate",label:p.i18n.translate("xpack.infra.metricDetailPage.nginxMetricsLayout.requestRateSection.sectionLabel",{defaultMessage:"Request Rate"})},r.a.createElement(Eo,{type:"area",formatter:"abbreviatedNumber",formatterTemplate:"{{value}}/s",seriesOverrides:{rate:{color:a.eui.euiColorVis1}}})),r.a.createElement(ro,{id:"nginxActiveConnections",label:p.i18n.translate("xpack.infra.metricDetailPage.nginxMetricsLayout.activeConnectionsSection.sectionLabel",{defaultMessage:"Active Connections"})},r.a.createElement(Eo,{type:"area",formatter:"abbreviatedNumber",seriesOverrides:{connections:{color:a.eui.euiColorVis1,type:"bar"}}})),r.a.createElement(ro,{id:"nginxRequestsPerConnection",label:p.i18n.translate("xpack.infra.metricDetailPage.nginxMetricsLayout.requestsPerConnectionsSection.sectionLabel",{defaultMessage:"Requests per Connections"})},r.a.createElement(Eo,{type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{reqPerConns:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.nginxMetricsLayout.requestsPerConnectionsSection.reqsPerConnSeriesLabel",{defaultMessage:"reqs per conn"})}}})))))),ko=r.a.createContext(null),Mo=[{field:"cloud.instance.id",label:p.i18n.translate("xpack.infra.nodeDetails.labels.instanceId",{defaultMessage:"Instance ID"})},{field:"cloud.provider",label:p.i18n.translate("xpack.infra.nodeDetails.labels.cloudProvider",{defaultMessage:"Cloud Provider"})},{field:"host.os.name",label:p.i18n.translate("xpack.infra.nodeDetails.labels.operatinSystem",{defaultMessage:"Operating System"})},{field:"host.os.kernel",label:p.i18n.translate("xpack.infra.nodeDetails.labels.kernelVersion",{defaultMessage:"Kernel Version"})},{field:"host.hostname",label:p.i18n.translate("xpack.infra.nodeDetails.labels.hostname",{defaultMessage:"Hostname"})},{field:"host.containerized",label:p.i18n.translate("xpack.infra.nodeDetails.labels.containerized",{defaultMessage:"Containerized"}),isBoolean:!0},{field:"cloud.project.id",label:p.i18n.translate("xpack.infra.nodeDetails.labels.projectId",{defaultMessage:"Project ID"})},{field:"cloud.availability_zone",label:p.i18n.translate("xpack.infra.nodeDetails.labels.availabilityZone",{defaultMessage:"Availability Zone"})},{field:"cloud.machine.type",label:p.i18n.translate("xpack.infra.nodeDetails.labels.machineType",{defaultMessage:"Machine Type"})},{field:"cloud.instance.name",label:p.i18n.translate("xpack.infra.nodeDetails.labels.instanceName",{defaultMessage:"Instance Name"})}],Oo=e=>{const[t,a]=Object(n.useState)(!1),i=Object(n.useCallback)((()=>a(!t)),[t]),s=Object(n.useMemo)((()=>e.fields&&e.fields.length?e.fields.map((e=>{const t=Mo.find((t=>t.field===e));if(t)return t})).filter((e=>e)):Mo),[e.fields]),l=Object(n.useMemo)((()=>t?s:s.slice(0,4)),[s,t]),o=Object(n.useContext)(ko);return o?r.a.createElement(wo,null,s.length>4?r.a.createElement(jo,null,r.a.createElement(g.EuiButtonIcon,{iconType:t?"arrowUp":"arrowDown",onClick:i,"aria-label":p.i18n.translate("xpack.infra.nodeDetails.labels.showMoreDetails",{defaultMessage:"Show more details"})})):null,r.a.createElement(g.EuiFlexGrid,{columns:4,style:{flexGrow:1},gutterSize:"s"},l.map((e=>r.a.createElement(g.EuiFlexItem,{key:e.field,style:{minWidth:0}},r.a.createElement(g.EuiTitle,{size:"xs"},r.a.createElement("h5",null,(({field:e})=>{const t=Mo.find((t=>t.field===e));return t?t.label:e})(e))),r.a.createElement(g.EuiText,null,((e,{field:t,isBoolean:a})=>a?Object(R.get)(e.info,t,!1)?p.i18n.translate("xpack.infra.nodeDetails.yes",{defaultMessage:"Yes"}):p.i18n.translate("xpack.infra.nodeDetails.no",{defaultMessage:"No"}):Object(R.get)(e.info,t,"--"))(o,e))))))):null},wo=V.euiStyled.div`
border-top: ${e=>e.theme.eui.euiBorderWidthThin} solid ${e=>e.theme.eui.euiBorderColor};
border-bottom: ${e=>e.theme.eui.euiBorderWidthThin} solid ${e=>e.theme.eui.euiBorderColor};
padding: ${e=>e.theme.eui.euiSizeM} 0;
margin-bottom: ${e=>e.theme.eui.euiSizeM};
display: flex;
`,jo=V.euiStyled.div`
flex-grow: 0;
margin-right: ${e=>e.theme.eui.euiSizeM};
min-width: 0px;
`,So=Object(V.euiStyled)(g.EuiPageContent)`
  position: relative;
`,Co={host:Object(V.withTheme)((({metrics:e,onChangeRangeTime:t,theme:a})=>r.a.createElement(r.a.Fragment,null,r.a.createElement(Oo,{fields:["host.hostname","host.os.name","host.os.kernel","host.containerized","cloud.provider","cloud.availability_zone","cloud.machine.type","cloud.project.id","cloud.instance.id","cloud.instance.name"]}),r.a.createElement(So,null,r.a.createElement(no,{navLabel:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.layoutLabel",{defaultMessage:"Host"}),sectionLabel:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.overviewSection.sectionLabel",{defaultMessage:"Host Overview"}),metrics:e,onChangeRangeTime:t},r.a.createElement(ro,{id:"hostSystemOverview"},r.a.createElement(mo,{seriesOverrides:{cpu:{name:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.overviewSection.cpuUsageSeriesLabel",{defaultMessage:"CPU Usage"}),color:a.eui.euiColorFullShade,formatter:"percent",gaugeMax:1},load:{name:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.overviewSection.loadSeriesLabel",{defaultMessage:"Load (5m)"}),color:a.eui.euiColorFullShade},memory:{name:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.overviewSection.memoryCapacitySeriesLabel",{defaultMessage:"Memory Usage"}),color:a.eui.euiColorFullShade,formatter:"percent",gaugeMax:1},rx:{name:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.overviewSection.inboundRXSeriesLabel",{defaultMessage:"Inbound (RX)"}),color:a.eui.euiColorFullShade,formatter:"bits",formatterTemplate:"{{value}}/s"},tx:{name:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.overviewSection.outboundTXSeriesLabel",{defaultMessage:"Outbound (TX)"}),color:a.eui.euiColorFullShade,formatter:"bits",formatterTemplate:"{{value}}/s"}}})),r.a.createElement(ro,{id:"hostCpuUsage",label:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.cpuUsageSection.sectionLabel",{defaultMessage:"CPU Usage"})},r.a.createElement(Eo,{stacked:!0,type:"area",formatter:"percent",seriesOverrides:{user:{color:a.eui.euiColorVis0},system:{color:a.eui.euiColorVis2},steal:{color:a.eui.euiColorVis9},irq:{color:a.eui.euiColorVis4},softirq:{color:a.eui.euiColorVis6},iowait:{color:a.eui.euiColorVis7},nice:{color:a.eui.euiColorVis5}}})),r.a.createElement(ro,{id:"hostLoad",label:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.loadSection.sectionLabel",{defaultMessage:"Load"})},r.a.createElement(Eo,{seriesOverrides:{load_1m:{color:a.eui.euiColorVis0,name:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.loadSection.oneMinuteSeriesLabel",{defaultMessage:"1m"})},load_5m:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.loadSection.fiveMinuteSeriesLabel",{defaultMessage:"5m"})},load_15m:{color:a.eui.euiColorVis3,name:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.loadSection.fifteenMinuteSeriesLabel",{defaultMessage:"15m"})}}})),r.a.createElement(ro,{id:"hostMemoryUsage",label:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.memoryUsageSection.sectionLabel",{defaultMessage:"Memory Usage"})},r.a.createElement(Eo,{stacked:!0,formatter:"bytes",type:"area",seriesOverrides:{used:{color:a.eui.euiColorVis2},free:{color:a.eui.euiColorVis0},cache:{color:a.eui.euiColorVis1}}})),r.a.createElement(ro,{id:"hostNetworkTraffic",label:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.networkTrafficSection.sectionLabel",{defaultMessage:"Network Traffic"})},r.a.createElement(Eo,{formatter:"bits",formatterTemplate:"{{value}}/s",type:"area",seriesOverrides:{rx:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.networkTrafficSection.networkRxRateSeriesLabel",{defaultMessage:"in"})},tx:{color:a.eui.euiColorVis2,name:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.networkTrafficSection.networkTxRateSeriesLabel",{defaultMessage:"out"})}}}))),r.a.createElement(no,{navLabel:"Kubernetes",sectionLabel:p.i18n.translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.overviewSection.sectionLabel",{defaultMessage:"Kubernetes Overview"}),metrics:e,onChangeRangeTime:t},r.a.createElement(ro,{id:"hostK8sOverview"},r.a.createElement(mo,{seriesOverrides:{cpucap:{name:p.i18n.translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.overviewSection.cpuUsageSeriesLabel",{defaultMessage:"CPU Capacity"}),color:"success",formatter:"percent",gaugeMax:1},load:{name:p.i18n.translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.overviewSection.loadSeriesLabel",{defaultMessage:"Load (5m)"}),color:"success"},memorycap:{name:p.i18n.translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.overviewSection.memoryUsageSeriesLabel",{defaultMessage:"Memory Capacity"}),color:"success",formatter:"percent",gaugeMax:1},podcap:{name:p.i18n.translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.overviewSection.podCapacitySeriesLabel",{defaultMessage:"Pod Capacity"}),color:"success",formatter:"percent",gaugeMax:1},diskcap:{name:p.i18n.translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.overviewSection.diskCapacitySeriesLabel",{defaultMessage:"Disk Capacity"}),color:"success",formatter:"percent",gaugeMax:1}}})),r.a.createElement(ro,{id:"hostK8sCpuCap",label:p.i18n.translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.nodeCpuCapacitySection.sectionLabel",{defaultMessage:"Node CPU Capacity"})},r.a.createElement(Eo,{formatter:"abbreviatedNumber",seriesOverrides:{capacity:{color:a.eui.euiColorVis2},used:{color:a.eui.euiColorVis1,type:"area"}}})),r.a.createElement(ro,{id:"hostK8sMemoryCap",label:p.i18n.translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.nodeMemoryCapacitySection.sectionLabel",{defaultMessage:"Node Memory Capacity"})},r.a.createElement(Eo,{formatter:"bytes",seriesOverrides:{capacity:{color:a.eui.euiColorVis2},used:{color:a.eui.euiColorVis1,type:"area"}}})),r.a.createElement(ro,{id:"hostK8sDiskCap",label:p.i18n.translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.nodeDiskCapacitySection.sectionLabel",{defaultMessage:"Node Disk Capacity"})},r.a.createElement(Eo,{formatter:"bytes",seriesOverrides:{capacity:{color:a.eui.euiColorVis2},used:{color:a.eui.euiColorVis1,type:"area"}}})),r.a.createElement(ro,{id:"hostK8sPodCap",label:p.i18n.translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.nodePodCapacitySection.sectionLabel",{defaultMessage:"Node Pod Capacity"})},r.a.createElement(Eo,{formatter:"number",seriesOverrides:{capacity:{color:a.eui.euiColorVis2},used:{color:a.eui.euiColorVis1,type:"area"}}}))),r.a.createElement(vo,{metrics:e,onChangeRangeTime:t}),r.a.createElement(xo,{metrics:e,onChangeRangeTime:t}))))),pod:Object(V.withTheme)((({metrics:e,onChangeRangeTime:t,theme:a})=>r.a.createElement(r.a.Fragment,null,r.a.createElement(Oo,null),r.a.createElement(So,null,r.a.createElement(no,{navLabel:p.i18n.translate("xpack.infra.metricDetailPage.podMetricsLayout.layoutLabel",{defaultMessage:"Pod"}),sectionLabel:p.i18n.translate("xpack.infra.metricDetailPage.podMetricsLayout.overviewSection.sectionLabel",{defaultMessage:"Pod Overview"}),metrics:e,onChangeRangeTime:t},r.a.createElement(ro,{id:"podOverview"},r.a.createElement(mo,{seriesOverrides:{cpu:{name:p.i18n.translate("xpack.infra.metricDetailPage.podMetricsLayout.overviewSection.cpuUsageSeriesLabel",{defaultMessage:"CPU Usage"}),color:a.eui.euiColorFullShade,formatter:"percent",gaugeMax:1},memory:{name:p.i18n.translate("xpack.infra.metricDetailPage.podMetricsLayout.overviewSection.memoryUsageSeriesLabel",{defaultMessage:"Memory Usage"}),color:a.eui.euiColorFullShade,formatter:"percent",gaugeMax:1},rx:{name:p.i18n.translate("xpack.infra.metricDetailPage.podMetricsLayout.overviewSection.inboundRXSeriesLabel",{defaultMessage:"Inbound (RX)"}),color:a.eui.euiColorFullShade,formatter:"bits",formatterTemplate:"{{value}}/s"},tx:{name:p.i18n.translate("xpack.infra.metricDetailPage.podMetricsLayout.overviewSection.outboundTXSeriesLabel",{defaultMessage:"Outbound (TX)"}),color:a.eui.euiColorFullShade,formatter:"bits",formatterTemplate:"{{value}}/s"}}})),r.a.createElement(ro,{id:"podCpuUsage",label:p.i18n.translate("xpack.infra.metricDetailPage.podMetricsLayout.cpuUsageSection.sectionLabel",{defaultMessage:"CPU Usage"})},r.a.createElement(Eo,{formatter:"percent",type:"area",seriesOverrides:{cpu:{color:a.eui.euiColorVis1}}})),r.a.createElement(ro,{id:"podMemoryUsage",label:p.i18n.translate("xpack.infra.metricDetailPage.podMetricsLayout.memoryUsageSection.sectionLabel",{defaultMessage:"Memory Usage"})},r.a.createElement(Eo,{type:"area",formatter:"percent",seriesOverrides:{memory:{color:a.eui.euiColorVis1}}})),r.a.createElement(ro,{id:"podNetworkTraffic",label:p.i18n.translate("xpack.infra.metricDetailPage.podMetricsLayout.networkTrafficSection.sectionLabel",{defaultMessage:"Network Traffic"})},r.a.createElement(Eo,{formatter:"bits",formatterTemplate:"{{value}}/s",type:"area",seriesOverrides:{rx:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.podMetricsLayout.networkTrafficSection.networkRxRateSeriesLabel",{defaultMessage:"in"})},tx:{color:a.eui.euiColorVis2,name:p.i18n.translate("xpack.infra.metricDetailPage.podMetricsLayout.networkTrafficSection.networkTxRateSeriesLabel",{defaultMessage:"out"})}}}))),r.a.createElement(xo,{metrics:e,onChangeRangeTime:t}))))),container:Object(V.withTheme)((({metrics:e,onChangeRangeTime:t,theme:a})=>r.a.createElement(r.a.Fragment,null,r.a.createElement(Oo,null),r.a.createElement(So,null,r.a.createElement(no,{navLabel:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.layoutLabel",{defaultMessage:"Container"}),sectionLabel:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.overviewSection.sectionLabel",{defaultMessage:"Container Overview"}),metrics:e,onChangeRangeTime:t},r.a.createElement(ro,{id:"containerK8sOverview"},r.a.createElement(mo,{seriesOverrides:{cpu:{name:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.overviewSection.cpuUsageSeriesLabel",{defaultMessage:"CPU Usage"}),color:a.eui.euiColorFullShade,formatter:"percent",gaugeMax:1},memory:{name:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.overviewSection.memoryUsageSeriesLabel",{defaultMessage:"Memory Usage"}),color:a.eui.euiColorFullShade,formatter:"percent",gaugeMax:1}}})),r.a.createElement(ro,{id:"containerOverview"},r.a.createElement(mo,{seriesOverrides:{cpu:{name:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.overviewSection.cpuUsageSeriesLabel",{defaultMessage:"CPU Usage"}),color:a.eui.euiColorFullShade,formatter:"percent",gaugeMax:1},memory:{name:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.overviewSection.memoryUsageSeriesLabel",{defaultMessage:"Memory Usage"}),color:a.eui.euiColorFullShade,formatter:"percent",gaugeMax:1},rx:{name:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.overviewSection.inboundRXSeriesLabel",{defaultMessage:"Inbound (RX)"}),color:a.eui.euiColorFullShade,formatter:"bits",formatterTemplate:"{{value}}/s"},tx:{name:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.overviewSection.outboundTXSeriesLabel",{defaultMessage:"Outbound (TX)"}),color:a.eui.euiColorFullShade,formatter:"bits",formatterTemplate:"{{value}}/s"}}})),r.a.createElement(ro,{id:"containerK8sCpuUsage",label:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.cpuUsageSection.sectionLabel",{defaultMessage:"CPU Usage"})},r.a.createElement(Eo,{stacked:!0,type:"area",formatter:"percent",seriesOverrides:{cpu:{color:a.eui.euiColorVis1}}})),r.a.createElement(ro,{id:"containerK8sMemoryUsage",label:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.memoryUsageSection.sectionLabel",{defaultMessage:"Memory Usage"})},r.a.createElement(Eo,{stacked:!0,type:"area",formatter:"percent",seriesOverrides:{memory:{color:a.eui.euiColorVis1}}})),r.a.createElement(ro,{id:"containerCpuUsage",label:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.cpuUsageSection.sectionLabel",{defaultMessage:"CPU Usage"})},r.a.createElement(Eo,{stacked:!0,type:"area",formatter:"percent",seriesOverrides:{cpu:{color:a.eui.euiColorVis1}}})),r.a.createElement(ro,{id:"containerMemory",label:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.memoryUsageSection.sectionLabel",{defaultMessage:"Memory Usage"})},r.a.createElement(Eo,{stacked:!0,type:"area",formatter:"percent",seriesOverrides:{memory:{color:a.eui.euiColorVis1}}})),r.a.createElement(ro,{id:"containerNetworkTraffic",label:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.networkTrafficSection.sectionLabel",{defaultMessage:"Network Traffic"})},r.a.createElement(Eo,{formatter:"bits",formatterTemplate:"{{value}}/s",type:"area",seriesOverrides:{rx:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.networkTrafficSection.networkRxRateSeriesLabel",{defaultMessage:"in"})},tx:{color:a.eui.euiColorVis2,name:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.networkTrafficSection.networkTxRateSeriesLabel",{defaultMessage:"out"})}}})),r.a.createElement(ro,{id:"containerDiskIOOps",label:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.diskIoOpsSection.sectionLabel",{defaultMessage:"Disk IO (Ops)"})},r.a.createElement(Eo,{type:"area",formatterTemplate:"{{value}}/s",formatter:"number",seriesOverrides:{read:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.diskIoOpsSection.readRateSeriesLabel",{defaultMessage:"reads"})},write:{color:a.eui.euiColorVis2,name:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.diskIoOpsSection.writeRateSeriesLabel",{defaultMessage:"writes"})}}})),r.a.createElement(ro,{id:"containerDiskIOBytes",label:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.diskIoBytesSection.sectionLabel",{defaultMessage:"Disk IO (Bytes)"})},r.a.createElement(Eo,{type:"area",formatter:"bytes",formatterTemplate:"{{value}}/s",seriesOverrides:{read:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.diskIoBytesSection.readRateSeriesLabel",{defaultMessage:"reads"})},write:{color:a.eui.euiColorVis2,name:p.i18n.translate("xpack.infra.metricDetailPage.containerMetricsLayout.diskIoBytesSection.writeRateSeriesLabel",{defaultMessage:"writes"})}}}))))))),awsEC2:Object(V.withTheme)((({metrics:e,theme:t,onChangeRangeTime:a})=>r.a.createElement(r.a.Fragment,null,r.a.createElement(Oo,{fields:["cloud.instance.id","cloud.provider","cloud.availability_zone","cloud.machine.type","cloud.instance.name","cloud.project.id"]}),r.a.createElement(So,null,r.a.createElement(no,{navLabel:"AWS EC2",sectionLabel:p.i18n.translate("xpack.infra.metricDetailPage.ec2MetricsLayout.overviewSection.sectionLabel",{defaultMessage:"Aws EC2 Overview"}),metrics:e,onChangeRangeTime:a},r.a.createElement(ro,{id:"awsEC2CpuUtilization",label:p.i18n.translate("xpack.infra.metricDetailPage.ec2MetricsLayout.cpuUsageSection.sectionLabel",{defaultMessage:"CPU Usage"})},r.a.createElement(Eo,{stacked:!0,type:"area",formatter:"percent",seriesOverrides:{total:{color:t.eui.euiColorVis1}}})),r.a.createElement(ro,{id:"awsEC2NetworkTraffic",label:p.i18n.translate("xpack.infra.metricDetailPage.ec2MetricsLayout.networkTrafficSection.sectionLabel",{defaultMessage:"Network Traffic"})},r.a.createElement(Eo,{formatter:"bits",formatterTemplate:"{{value}}/s",type:"area",seriesOverrides:{rx:{color:t.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.networkTrafficSection.networkRxRateSeriesLabel",{defaultMessage:"in"})},tx:{color:t.eui.euiColorVis2,name:p.i18n.translate("xpack.infra.metricDetailPage.hostMetricsLayout.networkTrafficSection.networkTxRateSeriesLabel",{defaultMessage:"out"})}}})),r.a.createElement(ro,{id:"awsEC2DiskIOBytes",label:p.i18n.translate("xpack.infra.metricDetailPage.ec2MetricsLayout.diskIOBytesSection.sectionLabel",{defaultMessage:"Disk IO (Bytes)"})},r.a.createElement(Eo,{formatter:"bytes",formatterTemplate:"{{value}}/s",type:"area",seriesOverrides:{write:{color:t.eui.euiColorVis2,name:p.i18n.translate("xpack.infra.metricDetailPage.ec2MetricsLayout.diskIOBytesSection.writeLabel",{defaultMessage:"writes"})},read:{color:t.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.ec2MetricsLayout.diskIOBytesSection.readLabel",{defaultMessage:"reads"})}}}))))))),awsS3:Object(V.withTheme)((({metrics:e,onChangeRangeTime:t,theme:a})=>r.a.createElement(r.a.Fragment,null,r.a.createElement(So,null,r.a.createElement(no,{navLabel:"AWS S3",sectionLabel:p.i18n.translate("xpack.infra.metricDetailPage.s3MetricsLayout.overviewSection.sectionLabel",{defaultMessage:"Aws S3 Overview"}),metrics:e,onChangeRangeTime:t},r.a.createElement(ro,{id:"awsS3BucketSize",label:p.i18n.translate("xpack.infra.metricDetailPage.s3MetricsLayout.bucketSize.sectionLabel",{defaultMessage:"Bucket Size"})},r.a.createElement(Eo,{type:"bar",formatter:"bytes",seriesOverrides:{bytes:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.s3MetricsLayout.bucketSize.chartLabel",{defaultMessage:"Total Bytes"})}}})),r.a.createElement(ro,{id:"awsS3NumberOfObjects",label:p.i18n.translate("xpack.infra.metricDetailPage.s3MetricsLayout.numberOfObjects.sectionLabel",{defaultMessage:"Number of Objects"})},r.a.createElement(Eo,{type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{objects:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.s3MetricsLayout.numberOfObjects.chartLabel",{defaultMessage:"Objects"})}}})),r.a.createElement(ro,{id:"awsS3TotalRequests",label:p.i18n.translate("xpack.infra.metricDetailPage.s3MetricsLayout.totalRequests.sectionLabel",{defaultMessage:"Total Requests"})},r.a.createElement(Eo,{type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{total:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.s3MetricsLayout.totalRequests.chartLabel",{defaultMessage:"Requests"})}}})),r.a.createElement(ro,{id:"awsS3DownloadBytes",label:p.i18n.translate("xpack.infra.metricDetailPage.s3MetricsLayout.downloadBytes.sectionLabel",{defaultMessage:"Downloaded Bytes"})},r.a.createElement(Eo,{type:"bar",formatter:"bytes",seriesOverrides:{bytes:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.s3MetricsLayout.downloadBytes.chartLabel",{defaultMessage:"Bytes"})}}})),r.a.createElement(ro,{id:"awsS3UploadBytes",label:p.i18n.translate("xpack.infra.metricDetailPage.s3MetricsLayout.uploadBytes.sectionLabel",{defaultMessage:"Uploaded Bytes"})},r.a.createElement(Eo,{type:"bar",formatter:"bytes",seriesOverrides:{bytes:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.s3MetricsLayout.uploadBytes.chartLabel",{defaultMessage:"Bytes"})}}}))))))),awsRDS:Object(V.withTheme)((({metrics:e,onChangeRangeTime:t,theme:a})=>r.a.createElement(r.a.Fragment,null,r.a.createElement(So,null,r.a.createElement(no,{navLabel:"AWS RDS",sectionLabel:p.i18n.translate("xpack.infra.metricDetailPage.rdsMetricsLayout.overviewSection.sectionLabel",{defaultMessage:"Aws RDS Overview"}),metrics:e,onChangeRangeTime:t},r.a.createElement(ro,{id:"awsRDSCpuTotal",label:p.i18n.translate("xpack.infra.metricDetailPage.rdsMetricsLayout.cpuTotal.sectionLabel",{defaultMessage:"Total CPU Usage"})},r.a.createElement(Eo,{type:"area",formatter:"percent",seriesOverrides:{cpu:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.rdsMetricsLayout.cpuTotal.chartLabel",{defaultMessage:"Total"})}}})),r.a.createElement(ro,{id:"awsRDSConnections",label:p.i18n.translate("xpack.infra.metricDetailPage.rdsMetricsLayout.connections.sectionLabel",{defaultMessage:"Connections"})},r.a.createElement(Eo,{type:"bar",formatter:"number",seriesOverrides:{connections:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.rdsMetricsLayout.connections.chartLabel",{defaultMessage:"Connections"})}}})),r.a.createElement(ro,{id:"awsRDSQueriesExecuted",label:p.i18n.translate("xpack.infra.metricDetailPage.rdsMetricsLayout.queriesExecuted.sectionLabel",{defaultMessage:"Queries Executed"})},r.a.createElement(Eo,{type:"bar",formatter:"number",seriesOverrides:{queries:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.rdsMetricsLayout.queriesExecuted.chartLabel",{defaultMessage:"Queries"})}}})),r.a.createElement(ro,{id:"awsRDSActiveTransactions",label:p.i18n.translate("xpack.infra.metricDetailPage.rdsMetricsLayout.activeTransactions.sectionLabel",{defaultMessage:"Transactions"})},r.a.createElement(Eo,{type:"bar",formatter:"number",seriesOverrides:{active:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.rdsMetricsLayout.active.chartLabel",{defaultMessage:"Active"})},blocked:{color:a.eui.euiColorVis2,name:p.i18n.translate("xpack.infra.metricDetailPage.rdsMetricsLayout.blocked.chartLabel",{defaultMessage:"Blocked"})}}})),r.a.createElement(ro,{id:"awsRDSLatency",label:p.i18n.translate("xpack.infra.metricDetailPage.rdsMetricsLayout.latency.sectionLabel",{defaultMessage:"Latency"})},r.a.createElement(Eo,{type:"bar",stacked:!0,formatter:"highPrecision",formatterTemplate:"{{value}} ms",seriesOverrides:{read:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.rdsMetricsLayout.latency.read.chartLabel",{defaultMessage:"Read"})},write:{color:a.eui.euiColorVis2,name:p.i18n.translate("xpack.infra.metricDetailPage.rdsMetricsLayout.latency.write.chartLabel",{defaultMessage:"Write"})},insert:{color:a.eui.euiColorVis0,name:p.i18n.translate("xpack.infra.metricDetailPage.rdsMetricsLayout.latency.insert.chartLabel",{defaultMessage:"Insert"})},update:{color:a.eui.euiColorVis7,name:p.i18n.translate("xpack.infra.metricDetailPage.rdsMetricsLayout.latency.update.chartLabel",{defaultMessage:"Update"})},commit:{color:a.eui.euiColorVis3,name:p.i18n.translate("xpack.infra.metricDetailPage.rdsMetricsLayout.latency.commit.chartLabel",{defaultMessage:"Commit"})}}}))))))),awsSQS:Object(V.withTheme)((({metrics:e,onChangeRangeTime:t,theme:a})=>r.a.createElement(r.a.Fragment,null,r.a.createElement(So,null,r.a.createElement(no,{navLabel:"AWS SQS",sectionLabel:p.i18n.translate("xpack.infra.metricDetailPage.sqsMetricsLayout.overviewSection.sectionLabel",{defaultMessage:"Aws SQS Overview"}),metrics:e,onChangeRangeTime:t},r.a.createElement(ro,{id:"awsSQSMessagesVisible",label:p.i18n.translate("xpack.infra.metricDetailPage.sqsMetricsLayout.messagesVisible.sectionLabel",{defaultMessage:"Messages Available"})},r.a.createElement(Eo,{type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{visible:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.sqsMetricsLayout.messagesVisible.chartLabel",{defaultMessage:"Available"})}}})),r.a.createElement(ro,{id:"awsSQSMessagesDelayed",label:p.i18n.translate("xpack.infra.metricDetailPage.sqsMetricsLayout.messagesDelayed.sectionLabel",{defaultMessage:"Messages Delayed"})},r.a.createElement(Eo,{type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{delayed:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.sqsMetricsLayout.messagesDelayed.chartLabel",{defaultMessage:"Delayed"})}}})),r.a.createElement(ro,{id:"awsSQSMessagesSent",label:p.i18n.translate("xpack.infra.metricDetailPage.sqsMetricsLayout.messagesSent.sectionLabel",{defaultMessage:"Messages Added"})},r.a.createElement(Eo,{type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{sent:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.sqsMetricsLayout.messagesSent.chartLabel",{defaultMessage:"Added"})}}})),r.a.createElement(ro,{id:"awsSQSMessagesEmpty",label:p.i18n.translate("xpack.infra.metricDetailPage.sqsMetricsLayout.messagesEmpty.sectionLabel",{defaultMessage:"Messages Empty"})},r.a.createElement(Eo,{type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{sent:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.sqsMetricsLayout.messagesEmpty.chartLabel",{defaultMessage:"Empty"})}}})),r.a.createElement(ro,{id:"awsSQSOldestMessage",label:p.i18n.translate("xpack.infra.metricDetailPage.sqsMetricsLayout.oldestMessage.sectionLabel",{defaultMessage:"Oldest Message"})},r.a.createElement(Eo,{type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{oldest:{color:a.eui.euiColorVis1,name:p.i18n.translate("xpack.infra.metricDetailPage.sqsMetricsLayout.oldestMessage.chartLabel",{defaultMessage:"Age"})}}})))))))},To=({loading:e,refetch:t,type:a,metrics:n,onChangeRangeTime:i,isLiveStreaming:s,stopLiveStreaming:l})=>{if(e)return r.a.createElement(D.a,{height:"100vh",width:"auto",text:p.i18n.translate("xpack.infra.metrics.loadingNodeDataText",{defaultMessage:"Loading data"})});if(!e&&n&&0===n.length)return r.a.createElement(P.a,{titleText:p.i18n.translate("xpack.infra.metrics.emptyViewTitle",{defaultMessage:"There is no data to display."}),bodyText:p.i18n.translate("xpack.infra.metrics.emptyViewDescription",{defaultMessage:"Try adjusting your time or filter."}),refetchText:p.i18n.translate("xpack.infra.metrics.refetchButtonLabel",{defaultMessage:"Check for new data"}),onRefetch:t,testString:"metricsEmptyViewState"});const o=(e=>{const t=null==Co?void 0:Co[e];if(!t)throw new Error(p.i18n.translate("xpack.infra.inventoryModels.findLayout.error",{defaultMessage:"The layout you've attempted to find does not exist"}));return t})(a);return r.a.createElement(o,{metrics:n,onChangeRangeTime:i,isLiveStreaming:s,stopLiveStreaming:l})},Lo=({"data-test-subj":e,app:t,children:a})=>{const n=Object(b.useLinkProps)({app:t,pathname:"/settings"});return r.a.createElement(g.EuiButton,m()({"data-test-subj":e,color:"primary"},n),a)},Fo=({nodeName:e})=>{const t=Object(b.useLinkProps)({app:"integrations",hash:"/browse"});return r.a.createElement(Po,{title:r.a.createElement("h2",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.metrics.invalidNodeErrorTitle",defaultMessage:"Looks like {nodeName} isn't collecting any metrics data",values:{nodeName:e}})),body:r.a.createElement("p",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.metrics.invalidNodeErrorDescription",defaultMessage:"Double check your configuration"})),actions:r.a.createElement(g.EuiFlexGroup,null,r.a.createElement(g.EuiFlexItem,null,r.a.createElement(g.EuiButton,m()({},t,{color:"primary",fill:!0}),r.a.createElement(I.FormattedMessage,{id:"xpack.infra.homePage.noMetricsIndicesInstructionsActionLabel",defaultMessage:"View setup instructions"}))),r.a.createElement(g.EuiFlexItem,null,r.a.createElement(Lo,{app:"metrics","data-test-subj":"configureSourceButton"},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.configureSourceActionLabel",defaultMessage:"Change source configuration"}))))})},Po=Object(V.euiStyled)(g.EuiEmptyPrompt)`
  align-self: center;
`;var Io=a(219);const Do=({error:e,name:t})=>{var a;return r.a.createElement(r.a.Fragment,null,r.a.createElement(h.a,{title:e=>p.i18n.translate("xpack.infra.metricDetailPage.documentTitleError",{defaultMessage:"{previousTitle} | Uh oh",values:{previousTitle:e}})}),404===(null===(a=e.body)||void 0===a?void 0:a.statusCode)?r.a.createElement(Fo,{nodeName:t}):r.a.createElement(Io.b,{message:e.message}))},_o=e=>{const t=q.a.parse(e.from.toString()),a=q.a.parse(e.to.toString(),{roundUp:!0});return{...e,from:t&&t.valueOf()||N()().subtract(1,"hour").valueOf(),to:a&&a.valueOf()||N()().valueOf()}},Bo=e=>{const{metricIndicesExist:t}=Object(n.useContext)(j.a.Context),[a,i]=Object(n.useState)(_o(e.timeRange)),{metrics:s,loading:l,makeRequest:o,error:c}=function(e,t,a,n,r,i){const{error:s,loading:l,response:o,makeRequest:c}=Object(Ua.a)("/api/metrics/node_details","POST",JSON.stringify({metrics:e,nodeId:t,nodeType:a,timerange:r,cloudId:i,sourceId:n}),(e=>Object(Re.pipe)(Yl.decode(e),Object(Ae.fold)(Object($a.c)($a.a),Ne.identity))));return{error:s,loading:l,metrics:o?o.metrics:[],makeRequest:c}}(e.requiredMetrics,e.nodeId,e.nodeType,e.sourceId,a,e.cloudId),u=Object(n.useCallback)((()=>{i(_o(e.timeRange))}),[e.timeRange]);return Object(n.useEffect)((()=>{i(_o(e.timeRange))}),[e.timeRange]),Object(n.useEffect)((()=>{o()}),[o,a]),c?r.a.createElement(Do,{error:c,name:e.name}):r.a.createElement(Ze,{hasData:t,pageHeader:{pageTitle:e.name,rightSideItems:[r.a.createElement(eo,{currentTimeRange:e.timeRange,isLiveStreaming:e.isAutoReloading,refreshInterval:e.refreshInterval,setRefreshInterval:e.setRefreshInterval,onChangeTimeRange:e.setTimeRange,setAutoReload:e.setAutoReload,onRefresh:u})]}},r.a.createElement(g.EuiFlexGroup,null,r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(Zl,{loading:e.metadataLoading,name:e.name,items:e.sideNav})),r.a.createElement(g.EuiFlexItem,null,r.a.createElement(ao.Provider,{value:{items:e.sideNav,addNavItem:e.addNavItem}},r.a.createElement(ko.Provider,{value:e.metadata},r.a.createElement(To,{loading:!(s.length>0&&e.isAutoReloading)&&l,refetch:u,type:e.nodeType,metrics:s,onChangeRangeTime:e.setTimeRange,isLiveStreaming:e.isAutoReloading,stopLiveStreaming:()=>e.setAutoReload(!1)}))))))},Ro=(Ao=Object(V.withTheme)((({match:e})=>{const t=e.params.node,a=e.params.type,i=Object(aa.b)(a),{sourceId:s,metricIndicesExist:l}=Object(n.useContext)(j.a.Context),{timeRange:o,parsedTimeRange:c,setTimeRange:u,refreshInterval:d,setRefreshInterval:m,isAutoReloading:g,setAutoReload:f,triggerRefresh:y}=Object(Wl.c)(),{name:E,filteredRequiredMetrics:v,loading:x,cloudId:k,metadata:M}=jn(t,a,i.requiredMetrics,s,c),[O,w]=Object(n.useState)([]),S=r.a.useCallback((e=>{O.some((t=>t.id===e.id))||w([e,...O])}),[O]),C=Object(b.useLinkProps)({app:"metrics",pathname:"/inventory"});return F([{...C,text:L.b},{text:E}]),x&&!v.length?r.a.createElement(Ze,{hasData:l},r.a.createElement(D.a,{height:"100vh",width:"100%",text:p.i18n.translate("xpack.infra.metrics.loadingNodeDataText",{defaultMessage:"Loading data"})})):r.a.createElement(r.a.Fragment,null,r.a.createElement(h.a,{title:p.i18n.translate("xpack.infra.metricDetailPage.documentTitle",{defaultMessage:"Infrastructure | Metrics | {name}",values:{name:E}})}),M?r.a.createElement(Bo,{name:E,requiredMetrics:v,sourceId:s,timeRange:o,nodeType:a,nodeId:t,cloudId:k,metadataLoading:x,isAutoReloading:g,refreshInterval:d,sideNav:O,metadata:M,addNavItem:S,setRefreshInterval:m,setAutoReload:f,triggerRefresh:y,setTimeRange:u}):null)})),e=>r.a.createElement(g.EuiErrorBoundary,null,r.a.createElement(j.a.Provider,{sourceId:"default"},r.a.createElement(Wl.a,null,r.a.createElement(Ao,e)))));var Ao;const No=({isLoading:e,readOnly:t,metricAliasFieldProps:a})=>r.a.createElement(g.EuiForm,null,r.a.createElement(g.EuiTitle,{size:"s"},r.a.createElement("h3",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.sourceConfiguration.indicesSectionTitle",defaultMessage:"Indices"}))),r.a.createElement(g.EuiSpacer,{size:"m"}),r.a.createElement(g.EuiDescribedFormGroup,{title:r.a.createElement("h4",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.sourceConfiguration.metricIndicesTitle",defaultMessage:"Metrics indices"})),description:r.a.createElement(I.FormattedMessage,{id:"xpack.infra.sourceConfiguration.metricIndicesDescription",defaultMessage:"Index pattern for matching indices that contain metrics data"})},r.a.createElement(g.EuiFormRow,{error:a.error,fullWidth:!0,helpText:r.a.createElement(I.FormattedMessage,{id:"xpack.infra.sourceConfiguration.metricIndicesRecommendedValue",defaultMessage:"The recommended value is {defaultValue}",values:{defaultValue:r.a.createElement(g.EuiCode,null,T.g)}}),isInvalid:a.isInvalid,label:r.a.createElement(I.FormattedMessage,{id:"xpack.infra.sourceConfiguration.metricIndicesLabel",defaultMessage:"Metrics indices"})},r.a.createElement(g.EuiFieldText,m()({"data-test-subj":"metricIndicesInput",fullWidth:!0,disabled:e,readOnly:t,isLoading:e},a))))),Vo=({isLoading:e,readOnly:t,anomalyThresholdFieldProps:a})=>r.a.createElement(g.EuiForm,null,r.a.createElement(g.EuiTitle,{size:"s"},r.a.createElement("h3",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.sourceConfiguration.mlSectionTitle",defaultMessage:"Machine Learning"}))),r.a.createElement(g.EuiSpacer,{size:"m"}),r.a.createElement(g.EuiDescribedFormGroup,{title:r.a.createElement("h4",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.sourceConfiguration.anomalyThresholdTitle",defaultMessage:"Anomaly Severity Threshold"})),description:r.a.createElement(I.FormattedMessage,{id:"xpack.infra.sourceConfiguration.anomalyThresholdDescription",defaultMessage:"Sets the minimum severity score required to show anomalies in the Metrics application."})},r.a.createElement(g.EuiFormRow,{error:a.error,fullWidth:!0,isInvalid:a.isInvalid,label:r.a.createElement(I.FormattedMessage,{id:"xpack.infra.sourceConfiguration.anomalyThresholdLabel",defaultMessage:"Minimum severity score"})},r.a.createElement(g.EuiRange,m()({min:0,max:100,"data-test-subj":"anomalyThresholdInput",showInput:!0,showTicks:!0,showRange:!0,tickInterval:20,"aria-label":"Minimum severity score",disabled:e,readOnly:t,isLoading:e},a))))),zo=({isLoading:e,readOnly:t,nameFieldProps:a})=>r.a.createElement(g.EuiForm,null,r.a.createElement(g.EuiTitle,{size:"s","data-test-subj":"sourceConfigurationNameSectionTitle"},r.a.createElement("h3",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.sourceConfiguration.nameSectionTitle",defaultMessage:"Name"}))),r.a.createElement(g.EuiSpacer,{size:"m"}),r.a.createElement(g.EuiDescribedFormGroup,{title:r.a.createElement("h4",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.sourceConfiguration.nameLabel",defaultMessage:"Name"})),description:r.a.createElement(I.FormattedMessage,{id:"xpack.infra.sourceConfiguration.nameDescription",defaultMessage:"A descriptive name for the source configuration"})},r.a.createElement(g.EuiFormRow,{error:a.error,fullWidth:!0,isInvalid:a.isInvalid,label:r.a.createElement(I.FormattedMessage,{id:"xpack.infra.sourceConfiguration.nameLabel",defaultMessage:"Name"})},r.a.createElement(g.EuiFieldText,m()({"data-test-subj":"nameInput",fullWidth:!0,disabled:e,readOnly:t,isLoading:e},a))))),$o=({shouldAllowEdit:e})=>{F([{text:L.h}]);const{createSourceConfiguration:t,source:a,sourceExists:i,isLoading:s,isUninitialized:l,updateSourceConfiguration:o}=Object(n.useContext)(j.a.Context),{indicesConfigurationProps:c,errors:u,resetForm:d,isFormDirty:m,isFormValid:f,formState:h,formStateChanges:y}=qe(a&&a.configuration),E=Object(n.useCallback)((async()=>{i?await o(y):await t(h),d()}),[i,o,t,d,h,y]),v=Object(n.useMemo)((()=>e&&a&&"internal"!==a.origin),[e,a]),{hasInfraMLCapabilities:x}=hr();return!s&&!l||a?null!=a&&a.configuration?r.a.createElement(Ze,{pageHeader:{pageTitle:L.h},"data-test-subj":"sourceConfigurationContent",restrictWidth:!0},r.a.createElement(b.Prompt,{prompt:m?p.i18n.translate("xpack.infra.sourceConfiguration.unsavedFormPrompt",{defaultMessage:"Are you sure you want to leave? Changes will be lost"}):void 0}),r.a.createElement(g.EuiPanel,{paddingSize:"l",hasShadow:!1,hasBorder:!0},r.a.createElement(zo,{isLoading:s,nameFieldProps:c.name,readOnly:!v})),r.a.createElement(g.EuiSpacer,null),r.a.createElement(g.EuiPanel,{paddingSize:"l",hasShadow:!1,hasBorder:!0},r.a.createElement(No,{isLoading:s,metricAliasFieldProps:c.metricAlias,readOnly:!v})),r.a.createElement(g.EuiSpacer,null),x&&r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiPanel,{paddingSize:"l",hasShadow:!1,hasBorder:!0},r.a.createElement(Vo,{isLoading:s,readOnly:!v,anomalyThresholdFieldProps:c.anomalyThreshold})),r.a.createElement(g.EuiSpacer,null)),u.length>0?r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiCallOut,{color:"danger"},r.a.createElement("ul",null,u.map(((e,t)=>r.a.createElement("li",{key:t},e))))),r.a.createElement(g.EuiSpacer,{size:"m"})):null,r.a.createElement(g.EuiSpacer,{size:"m"}),r.a.createElement(g.EuiFlexGroup,null,v&&r.a.createElement(g.EuiFlexItem,null,s?r.a.createElement(g.EuiFlexGroup,{justifyContent:"flexEnd"},r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiButton,{color:"primary",isLoading:!0,fill:!0},"Loading"))):r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiFlexGroup,{justifyContent:"flexEnd"},r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiButton,{"data-test-subj":"discardSettingsButton",color:"danger",iconType:"cross",isDisabled:s||!m,onClick:()=>{d()}},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.sourceConfiguration.discardSettingsButtonLabel",defaultMessage:"Discard"}))),r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiButton,{"data-test-subj":"applySettingsButton",color:"primary",isDisabled:!m||!f,fill:!0,onClick:E},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.sourceConfiguration.applySettingsButtonLabel",defaultMessage:"Apply"})))))))):null:r.a.createElement(At.a,null)},Uo=()=>{var e,t;const a=null===(e=Object(f.useKibana)().services.application)||void 0===e?void 0:e.capabilities;return r.a.createElement(g.EuiErrorBoundary,null,r.a.createElement($o,{shouldAllowEdit:null==a||null===(t=a.infrastructure)||void 0===t?void 0:t.configureSource}))},qo=()=>{var e;const[t,a]=Object(n.useState)(!1),[i,s]=Object(n.useState)(null),l=null===(e=Object(f.useKibana)().services.application)||void 0===e?void 0:e.capabilities,{services:{observability:o}}=Object(f.useKibana)(),c=Object(n.useMemo)((()=>{var e;return Boolean(null==l||null===(e=l.infrastructure)||void 0===e?void 0:e.save)}),[l]),u=Object(n.useCallback)((()=>s(null)),[s]),d=Object(n.useCallback)((()=>{a(!1)}),[a]),m=Object(n.useCallback)((()=>{a(!t)}),[a,t]),b=Object(n.useMemo)((()=>({id:1,title:p.i18n.translate("xpack.infra.alerting.infrastructureDropdownTitle",{defaultMessage:"Infrastructure rules"}),items:[{"data-test-subj":"inventory-alerts-create-rule",name:p.i18n.translate("xpack.infra.alerting.createInventoryRuleButton",{defaultMessage:"Create inventory rule"}),onClick:()=>{d(),s("inventory")}}]})),[s,d]),h=Object(n.useMemo)((()=>({id:2,title:p.i18n.translate("xpack.infra.alerting.metricsDropdownTitle",{defaultMessage:"Metrics rules"}),items:[{"data-test-subj":"metrics-threshold-alerts-create-rule",name:p.i18n.translate("xpack.infra.alerting.createThresholdRuleButton",{defaultMessage:"Create threshold rule"}),onClick:()=>{d(),s("threshold")}}]})),[s,d]),y=o.useRulesLink(),E=Object(n.useMemo)((()=>({name:p.i18n.translate("xpack.infra.alerting.manageRules",{defaultMessage:"Manage rules"}),icon:"tableOfContents",onClick:y.onClick})),[y]),v=Object(n.useMemo)((()=>c?[{"data-test-subj":"inventory-alerts-menu-option",name:p.i18n.translate("xpack.infra.alerting.infrastructureDropdownMenu",{defaultMessage:"Infrastructure"}),panel:1},{"data-test-subj":"metrics-threshold-alerts-menu-option",name:p.i18n.translate("xpack.infra.alerting.metricsDropdownMenu",{defaultMessage:"Metrics"}),panel:2},E]:[E]),[c,E]),x=Object(n.useMemo)((()=>[{id:0,title:p.i18n.translate("xpack.infra.alerting.alertDropdownTitle",{defaultMessage:"Alerts and rules"}),items:v}].concat(c?[b,h]:[])),[b,h,v,c]);return r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiPopover,{panelPaddingSize:"none",anchorPosition:"downLeft",button:r.a.createElement(g.EuiHeaderLink,{color:"text",iconSide:"right",iconType:"arrowDown",onClick:m,"data-test-subj":"infrastructure-alerts-and-rules"},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.alerting.alertsButton",defaultMessage:"Alerts and rules"})),isOpen:t,closePopover:d},r.a.createElement(g.EuiContextMenu,{initialPanelId:0,panels:x,"data-test-subj":"metrics-alert-menu"})),r.a.createElement(Ho,{visibleFlyoutType:i,onClose:u}))},Ho=({visibleFlyoutType:e,onClose:t})=>{switch(e){case"inventory":return r.a.createElement(Zi,{onClose:t});case"threshold":return r.a.createElement(K,{onClose:t});default:return null}};var Go=a(108),Jo=a(210);const Wo=e=>{const[t]=Object(n.useState)((()=>N()())),{goHome:a}=e,[i,s]=Object(n.useState)(t.clone().subtract(4,"weeks")),[l,o]=Object(n.useState)(null),c=Ei(),u=Di(),[d,m]=Object(n.useState)(""),[f,h]=Object(n.useState)(""),y=Object(b.useUiTracker)({app:"infra_metrics"}),{createDerivedIndexPattern:E}=Object(Go.a)({sourceId:"default"}),v=c.sourceConfiguration.indices,x=Object(n.useMemo)((()=>"kubernetes"===e.jobType?u.setupStatus:c.setupStatus),[e.jobType,u.setupStatus,c.setupStatus]),k=Object(n.useMemo)((()=>"kubernetes"===e.jobType?u.cleanUpAndSetUpModule:c.cleanUpAndSetUpModule),[e.jobType,u.cleanUpAndSetUpModule,c.cleanUpAndSetUpModule]),M=Object(n.useMemo)((()=>"kubernetes"===e.jobType?u.setUpModule:c.setUpModule),[e.jobType,u.setUpModule,c.setUpModule]),O=Object(n.useMemo)((()=>"kubernetes"===e.jobType?u.jobSummaries.length>0:c.jobSummaries.length>0),[e.jobType,u.jobSummaries,c.jobSummaries]),w=Object(n.useMemo)((()=>E()),[E]),j=Object(n.useCallback)((e=>{s(e)}),[]),S=Object(n.useCallback)((()=>{O?k(v,N()(i).toDate().getTime(),void 0,f,l?l[0]:void 0):M(v,N()(i).toDate().getTime(),void 0,f,l?l[0]:void 0)}),[k,f,M,O,v,l,i]),C=Object(n.useCallback)((e=>{m(e||""),h(Object(wt.a)(e,w)||"")}),[w]),T=Object(n.useCallback)(Object(R.debounce)(C,500),[C]),L=Object(n.useCallback)((e=>{o(e.map((e=>e.label)))}),[]);return Object(n.useEffect)((()=>{"kubernetes"===e.jobType&&o([ji])}),[e.jobType]),Object(n.useEffect)((()=>{"succeeded"===x.type&&("kubernetes"===e.jobType?(y({metric:"metrics_ml_anomaly_detection_k8s_enabled"}),!l||1===l.length&&l[0]===ji||y({metric:"metrics_ml_anomaly_detection_k8s_partition_changed"})):(y({metric:"metrics_ml_anomaly_detection_hosts_enabled"}),l&&y({metric:"metrics_ml_anomaly_detection_hosts_partition_changed"}),y({metric:"metrics_ml_anomaly_detection_hosts_enabled"})),a())}),[x,e.jobType,l,y,a]),r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiFlyoutHeader,null,r.a.createElement(g.EuiTitle,{size:"m"},r.a.createElement("h2",null,r.a.createElement(I.FormattedMessage,{defaultMessage:"Enable machine learning for {nodeType}",id:"xpack.infra.ml.aomalyFlyout.jobSetup.flyoutHeader",values:{nodeType:e.jobType}})))),r.a.createElement(g.EuiFlyoutBody,null,"pending"===x.type?r.a.createElement(g.EuiFlexGroup,{alignItems:"center"},r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiLoadingSpinner,{size:"xl"})),r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.steps.setupProcess.loadingText",defaultMessage:"Creating ML job..."}))):"failed"===x.type?r.a.createElement(r.a.Fragment,null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.steps.setupProcess.failureText",defaultMessage:"Something went wrong creating the necessary ML jobs."}),r.a.createElement(g.EuiSpacer,null),r.a.createElement(g.EuiButton,{fill:!0,onClick:S},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.steps.setupProcess.tryAgainButton",defaultMessage:"Try again"}))):r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiText,null,r.a.createElement("p",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.steps.setupProcess.description",defaultMessage:"Settings can not be changed once the jobs are created. You can recreate jobs anytime, however, the previously detected anomalies are removed."}))),r.a.createElement(g.EuiSpacer,{size:"l"}),r.a.createElement(g.EuiForm,null,r.a.createElement(g.EuiDescribedFormGroup,{title:r.a.createElement("h3",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.steps.setupProcess.when.title",defaultMessage:"When does your model begin?"})),description:r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.steps.setupProcess.when.description",defaultMessage:"By default, machine learning jobs analyze the last 4 weeks of data and continue to run indefinitely."})},r.a.createElement(g.EuiFormRow,{label:r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.steps.setupProcess.when.timePicker.label",defaultMessage:"Start date"})},r.a.createElement(Jo.a,{showTimeSelect:!0,selected:i,onChange:j,maxDate:t}))),r.a.createElement(g.EuiDescribedFormGroup,{title:r.a.createElement("h3",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.steps.setupProcess.partition.title",defaultMessage:"How do you want to partition your data?"})),description:r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.steps.setupProcess.partition.description",defaultMessage:"Partitions enable you to build independent models for groups of data that share similar behavior. For example, you can partition by machine type or cloud availability zone."})},r.a.createElement(g.EuiFormRow,{label:r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.steps.setupProcess.partition.label",defaultMessage:"Partition field"}),display:"rowCompressed"},r.a.createElement(g.EuiComboBox,{placeholder:p.i18n.translate("xpack.infra.metricsExplorer.groupByLabel",{defaultMessage:"Everything"}),"aria-label":p.i18n.translate("xpack.infra.metricsExplorer.groupByAriaLabel",{defaultMessage:"Graph per"}),fullWidth:!0,singleSelection:!0,selectedOptions:l?l.map((e=>({label:e}))):void 0,options:w.fields.filter((e=>e.aggregatable&&"string"===e.type)).map((e=>({label:e.name}))),onChange:L,isClearable:!0}))),r.a.createElement(g.EuiDescribedFormGroup,{title:r.a.createElement("h3",null,r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.steps.setupProcess.filter.title",defaultMessage:"Filter"})),description:r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.steps.setupProcess.filter.description",defaultMessage:"By default, machine learning jobs analyze all of your metric data."})},r.a.createElement(g.EuiFormRow,{display:"rowCompressed",label:r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.steps.setupProcess.filter.label",defaultMessage:"Filter (optional)"})},r.a.createElement(we.a,{derivedIndexPattern:w,onSubmit:C,onChange:T,value:d})))))),r.a.createElement(g.EuiFlyoutFooter,null,r.a.createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween"},r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiButtonEmpty,{onClick:e.closeFlyout},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.steps.setupProcess.cancelButton",defaultMessage:"Cancel"}))),r.a.createElement(g.EuiFlexItem,{grow:!1},r.a.createElement(g.EuiButton,{fill:!0,fullWidth:!1,onClick:S},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.steps.setupProcess.enableButton",defaultMessage:"Enable jobs"}))))))};var Ko=a(172);const Qo=()=>{var e,t;const{hasInfraMLSetupCapabilities:a}=fr(),[i,s]=Object(n.useState)(!1),[l,o]=Object(n.useState)("home"),[c,u]=Object(n.useState)(null),{source:d}=Object(Go.a)({sourceId:"default"}),{space:m}=Object(Ko.a)(),p=Object(n.useCallback)((()=>{o("home"),s(!0)}),[]),f=Object(n.useCallback)((e=>{o("setup"),u({jobType:e})}),[o]),b=Object(n.useCallback)((()=>{s(!1)}),[]);return null==(null==d?void 0:d.configuration.metricAlias)||null==m?null:r.a.createElement(r.a.Fragment,null,r.a.createElement(g.EuiHeaderLink,{color:"text",iconSide:"left",iconType:"inspect",onClick:p,"data-test-subj":"openAnomalyFlyoutButton"},r.a.createElement(I.FormattedMessage,{id:"xpack.infra.ml.anomalyDetectionButton",defaultMessage:"Anomaly detection"})),i&&r.a.createElement(yi,{indexPattern:null!==(e=null==d?void 0:d.configuration.metricAlias)&&void 0!==e?e:"",sourceId:"default",spaceId:m.id},r.a.createElement(Ii,{indexPattern:null!==(t=null==d?void 0:d.configuration.metricAlias)&&void 0!==t?t:"",sourceId:"default",spaceId:m.id},r.a.createElement(g.EuiFlyout,{onClose:b,"data-test-subj":"loadMLFlyout"},"home"===l&&r.a.createElement(Bi,{hasSetupCapabilities:a,goToSetup:f,closeFlyout:b}),"setup"===l&&r.a.createElement(Wo,{goHome:p,closeFlyout:b,jobType:c.jobType})))))};var Xo=a(36);const Yo=p.i18n.translate("xpack.infra.metricsHeaderAddDataButtonLabel",{defaultMessage:"Add data"}),Zo=({match:e})=>{var t,a,i,s;const o=null===(t=Object(f.useKibana)().services.application)||void 0===t?void 0:t.capabilities,{setHeaderActionMenu:c,theme$:u}=Object(n.useContext)(Xo.a),d=p.i18n.translate("xpack.infra.metrics.settingsTabTitle",{defaultMessage:"Settings"}),x=Object(f.useKibana)();Object(E.a)(!(null!=o&&null!==(a=o.infrastructure)&&void 0!==a&&a.save));const k=Object(b.useLinkProps)({app:"metrics",pathname:"settings"});return r.a.createElement(g.EuiErrorBoundary,null,r.a.createElement(j.a.Provider,{sourceId:"default"},r.a.createElement(J.a,null,r.a.createElement(oa.c,null,r.a.createElement(Et,null,r.a.createElement(Ft,null,r.a.createElement(br,null,r.a.createElement(h.a,{title:p.i18n.translate("xpack.infra.homePage.documentTitle",{defaultMessage:"Metrics"})}),r.a.createElement(y.a,{feedbackLink:"https://discuss.elastic.co/c/metrics",appName:p.i18n.translate("xpack.infra.header.infrastructureHelpAppName",{defaultMessage:"Metrics"})}),c&&u&&r.a.createElement(b.HeaderMenuPortal,{setHeaderActionMenu:c,theme$:u},r.a.createElement(g.EuiHeaderLinks,{gutterSize:"xs"},r.a.createElement(g.EuiHeaderLink,m()({color:"text"},k),d),r.a.createElement(l.Route,{path:"/inventory",component:Qo}),r.a.createElement(qo,null),r.a.createElement(g.EuiHeaderLink,{href:null===(i=x.services)||void 0===i||null===(s=i.application)||void 0===s?void 0:s.getUrlForApp("/integrations/browse"),color:"primary",iconType:"indexOpen"},Yo))),r.a.createElement(l.Switch,null,r.a.createElement(l.Route,{path:"/inventory",component:Gl}),r.a.createElement(l.Route,{path:"/explorer",render:e=>r.a.createElement(S,null,(({configuration:e,createDerivedIndexPattern:t})=>r.a.createElement(v.c.Provider,null,r.a.createElement(O,null),e?r.a.createElement(ec,{configuration:e,createDerivedIndexPattern:t}):r.a.createElement(At.a,null))))}),r.a.createElement(l.Route,{path:"/detail/:type/:node",component:Ro}),r.a.createElement(l.Route,{path:"/settings",component:Uo})))))))))},ec=e=>{const{createDerivedIndexPattern:t,configuration:a}=e,{options:i}=Object(n.useContext)(v.c.Context);return r.a.createElement(We,{shouldLoadDefault:"default"===i.source,viewType:"metrics-explorer-view",defaultViewState:v.a},r.a.createElement(lt,m()({derivedIndexPattern:t(),source:a},e)))};var tc=a(207),ac=a(35);const nc=(e,t,a,{element:n,history:i,setHeaderActionMenu:l,theme$:c})=>{const u=new o.Storage(window.localStorage);return Object(ws.b)(n,"infraMetricsPage"),s.a.render(r.a.createElement(rc,{core:e,history:i,plugins:t,pluginStart:a,setHeaderActionMenu:l,storage:u,theme$:c}),n),()=>{s.a.unmountComponentAtNode(n)}},rc=({core:e,history:t,pluginStart:a,plugins:n,setHeaderActionMenu:i,storage:s,theme$:o})=>{var d,m,p,g;const f=e.application.capabilities;return r.a.createElement(ac.b,{core:e,pluginStart:a,plugins:n,theme$:o},r.a.createElement(ac.a,{appName:"Metrics UI",setHeaderActionMenu:i,storage:s,theme$:o,triggersActionsUI:n.triggersActionsUi},r.a.createElement(l.Router,{history:t},r.a.createElement(l.Switch,null,r.a.createElement(l.Route,{path:"/link-to",component:u.a}),(null==f||null===(d=f.infrastructure)||void 0===d?void 0:d.show)&&r.a.createElement(tc.a,{from:"/",exact:!0,to:"/inventory"}),(null==f||null===(m=f.infrastructure)||void 0===m?void 0:m.show)&&r.a.createElement(tc.a,{from:"/snapshot",exact:!0,to:"/inventory"}),(null==f||null===(p=f.infrastructure)||void 0===p?void 0:p.show)&&r.a.createElement(tc.a,{from:"/metrics-explorer",exact:!0,to:"/explorer"}),(null==f||null===(g=f.infrastructure)||void 0===g?void 0:g.show)&&r.a.createElement(l.Route,{path:"/",component:Zo}),r.a.createElement(l.Route,{component:c.a})))))}},76:function(e,t,a){"use strict";a.d(t,"a",(function(){return f})),a.d(t,"b",(function(){return b})),a.d(t,"c",(function(){return M})),a.d(t,"d",(function(){return O}));var n=a(2),r=a(0),i=a(24),s=a(18),l=a(19),o=a(67),c=a.n(o),u=a(109),d=a(31),m=a(72),p=a(81),g=a(75);const f={palette:"cool",steps:10,reverseColors:!1},b={metric:{type:"cpu"},groupBy:[],nodeType:"host",view:"map",customOptions:[],boundsOverride:{max:1,min:0},autoBounds:!0,accountId:"",region:"",customMetrics:[],legend:f,source:"default",sort:{by:"name",direction:"desc"},timelineOpen:!1},h=r.type({palette:d.d,steps:r.number,reverseColors:r.boolean}),y=r.type({by:r.keyof({name:null,value:null}),direction:r.keyof({asc:null,desc:null})}),E=r.intersection([r.type({metric:m.f,groupBy:m.e,nodeType:g.c,view:r.string,customOptions:r.array(r.type({text:r.string,field:r.string})),boundsOverride:r.type({min:r.number,max:r.number}),autoBounds:r.boolean,accountId:r.string,region:r.string,customMetrics:r.array(m.d),sort:y}),r.partial({source:r.string,legend:h,timelineOpen:r.boolean})]),v=e=>E.encode(e),x=e=>{const t=Object(i.pipe)(E.decode(e),Object(s.fold)(Object(l.constant)(void 0),l.identity));return t&&(t.source="url"),t},k=c()((()=>{const[e,t]=Object(p.b)({defaultState:b,decodeUrlState:x,encodeUrlState:v,urlStateKey:"waffleOptions"}),[a,r]=Object(n.useState)(e);Object(n.useEffect)((()=>t(a)),[t,a]);const i=Object(n.useCallback)((e=>r((t=>({...t,metric:e})))),[r]),s=Object(n.useCallback)((e=>r((t=>({...t,groupBy:e})))),[r]),l=Object(n.useCallback)((e=>r((t=>({...t,nodeType:e})))),[r]),o=Object(n.useCallback)((e=>r((t=>({...t,view:e})))),[r]),c=Object(n.useCallback)((e=>r((t=>({...t,customOptions:e})))),[r]),d=Object(n.useCallback)((e=>r((t=>({...t,autoBounds:e})))),[r]),m=Object(n.useCallback)((e=>r((t=>({...t,boundsOverride:e})))),[r]),g=Object(n.useCallback)((e=>r((t=>({...t,accountId:e})))),[r]),f=Object(n.useCallback)((e=>r((t=>({...t,region:e})))),[r]),h=Object(n.useCallback)((e=>{r((t=>({...t,customMetrics:e})))}),[r]),y=Object(n.useCallback)((e=>{r((t=>({...t,legend:e})))}),[r]),E=Object(n.useCallback)((e=>{r((t=>({...t,sort:e})))}),[r]),{inventoryPrefill:k}=Object(u.b)();Object(n.useEffect)((()=>{const{setNodeType:e,setMetric:t,setCustomMetrics:n}=k;e(a.nodeType),t(a.metric),n(a.customMetrics)}),[a,k]);const M=Object(n.useCallback)((e=>r((t=>({...t,timelineOpen:e})))),[r]);return{...b,...a,changeMetric:i,changeGroupBy:s,changeNodeType:l,changeView:o,changeCustomOptions:c,changeAutoBounds:d,changeBoundsOverride:m,changeAccount:g,changeRegion:f,changeCustomMetrics:h,changeLegend:y,changeSort:E,changeTimelineOpen:M,setWaffleOptionsState:r}})),[M,O]=k},77:function(e,t,a){"use strict";a.d(t,"a",(function(){return F}));var n=a(2),r=a.n(n),i=a(12),s=a(119),l=a(1),o=a(15),c=a(80);const u={name:l.i18n.translate("xpack.infra.waffle.sortNameLabel",{defaultMessage:"Name"}),value:l.i18n.translate("xpack.infra.waffle.sort.valueLabel",{defaultMessage:"Metric value"})},d=({sort:e,onChange:t})=>{const[a,s]=Object(n.useState)(!1),o=Object(n.useCallback)((()=>{s(!0)}),[s]),d=Object(n.useCallback)((()=>{s(!1)}),[s]),p=u[e.by],g=r.a.createElement(c.a,{label:l.i18n.translate("xpack.infra.waffle.sortLabel",{defaultMessage:"Sort by"}),onClick:o,"data-test-subj":"waffleSortByDropdown"},p),f=Object(n.useCallback)((()=>{t({...e,by:"name"}),d()}),[d,t,e]),b=Object(n.useCallback)((()=>{t({...e,by:"value"}),d()}),[d,t,e]),h=Object(n.useCallback)((()=>{t({...e,direction:"asc"===e.direction?"desc":"asc"}),d()}),[d,e,t]),y=Object(n.useMemo)((()=>[{id:0,title:"",items:[{name:u.name,icon:"name"===e.by?"check":"empty",onClick:f,"data-test-subj":"waffleSortByName"},{name:u.value,icon:"value"===e.by?"check":"empty",onClick:b,"data-test-subj":"waffleSortByValue"}]}]),[e.by,f,b]);return r.a.createElement(i.EuiPopover,{isOpen:a,id:"sortPopover",button:g,anchorPosition:"downLeft",panelPaddingSize:"none",closePopover:d},r.a.createElement(i.EuiContextMenu,{initialPanelId:0,panels:y}),r.a.createElement(m,null,r.a.createElement(i.EuiSwitch,{compressed:!0,label:l.i18n.translate("xpack.infra.waffle.sortDirectionLabel",{defaultMessage:"Reverse direction"}),checked:"desc"===e.direction,onChange:h,"data-test-subj":"waffleSortByDirection"})))},m=Object(o.withTheme)((({children:e,theme:t})=>r.a.createElement("div",{style:{padding:null==t?void 0:t.eui.euiSizeM,borderTop:`1px solid ${null==t?void 0:t.eui.euiBorderColor}`}},e)));var p=a(87),g=a(72),f=a(112),b=a.n(f),h=a(16);const y={avg:l.i18n.translate("xpack.infra.waffle.customMetrics.aggregationLables.avg",{defaultMessage:"Average"}),max:l.i18n.translate("xpack.infra.waffle.customMetrics.aggregationLables.max",{defaultMessage:"Max"}),min:l.i18n.translate("xpack.infra.waffle.customMetrics.aggregationLables.min",{defaultMessage:"Min"}),rate:l.i18n.translate("xpack.infra.waffle.customMetrics.aggregationLables.rate",{defaultMessage:"Rate"})},E=Object(o.withTheme)((({theme:e,onCancel:t,fields:a,onChange:s,metric:o})=>{const[c,u]=Object(n.useState)(o?o.label:void 0),[d,m]=Object(n.useState)(o?o.aggregation:"avg"),[p,f]=Object(n.useState)(o?o.field:void 0),E=Object(n.useCallback)((()=>{if(o&&d&&p)s({...o,label:c,aggregation:d,field:p});else if(d&&p){const e={type:"custom",id:b.a.v1(),label:c,aggregation:d,field:p};s(e)}}),[o,d,p,s,c]),v=Object(n.useCallback)((e=>{u(e.target.value)}),[u]),x=Object(n.useCallback)((e=>{f(e[0].label)}),[f]),k=Object(n.useCallback)((e=>{const t=e.target.value,a=g.c.is(t)?t:"avg";m(a)}),[m]),M=a.filter((e=>e.aggregatable&&"number"===e.type&&!(p&&p===e.name))).map((e=>({label:e.name}))),O=g.b.map((e=>({text:y[e],value:e}))),w=!p||!d,j=o?l.i18n.translate("xpack.infra.waffle.customMetricPanelLabel.edit",{defaultMessage:"Edit custom metric"}):l.i18n.translate("xpack.infra.waffle.customMetricPanelLabel.add",{defaultMessage:"Add custom metric"}),S=o?l.i18n.translate("xpack.infra.waffle.customMetricPanelLabel.editAriaLabel",{defaultMessage:"Back to custom metrics edit mode"}):l.i18n.translate("xpack.infra.waffle.customMetricPanelLabel.addAriaLabel",{defaultMessage:"Back to metric picker"});return r.a.createElement("div",{style:{width:685}},r.a.createElement(i.EuiForm,null,r.a.createElement(i.EuiPopoverTitle,null,r.a.createElement(i.EuiButtonEmpty,{iconType:"arrowLeft",onClick:t,color:"text",size:"xs",flush:"left",style:{fontWeight:700,textTransform:"uppercase"},"aria-label":S},j)),r.a.createElement("div",{style:{padding:null==e?void 0:e.eui.euiSizeM,borderBottom:`${null==e?void 0:e.eui.euiBorderWidthThin} solid ${null==e?void 0:e.eui.euiBorderColor}`}},r.a.createElement(i.EuiFormRow,{label:l.i18n.translate("xpack.infra.waffle.customMetrics.metricLabel",{defaultMessage:"Metric"}),display:"rowCompressed",fullWidth:!0},r.a.createElement(i.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},r.a.createElement(i.EuiFlexItem,{grow:!1},r.a.createElement(i.EuiSelect,{onChange:k,value:d,options:O,fullWidth:!0})),r.a.createElement(i.EuiFlexItem,{grow:!1},r.a.createElement(i.EuiText,{color:"subdued"},r.a.createElement("span",null,"of"))),r.a.createElement(i.EuiFlexItem,null,r.a.createElement(i.EuiComboBox,{fullWidth:!0,placeholder:l.i18n.translate("xpack.infra.waffle.customMetrics.fieldPlaceholder",{defaultMessage:"Select a field"}),singleSelection:{asPlainText:!0},selectedOptions:p?[{label:p}]:[],options:M,onChange:x,isClearable:!1})))),r.a.createElement(i.EuiFormRow,{label:l.i18n.translate("xpack.infra.waffle.customMetrics.labelLabel",{defaultMessage:"Label (optional)"}),display:"rowCompressed",fullWidth:!0},r.a.createElement(i.EuiFieldText,{name:"label",placeholder:l.i18n.translate("xpack.infra.waffle.customMetrics.labelPlaceholder",{defaultMessage:'Choose a name to appear in the "Metric" dropdown'}),value:c,fullWidth:!0,onChange:v}))),r.a.createElement("div",{style:{padding:null==e?void 0:e.eui.euiSizeM,textAlign:"right"}},r.a.createElement(i.EuiButtonEmpty,{onClick:t,size:"s",style:{paddingRight:null==e?void 0:e.eui.euiSizeXL}},r.a.createElement(h.FormattedMessage,{id:"xpack.infra.waffle.customMetrics.cancelLabel",defaultMessage:"Cancel"})),r.a.createElement(i.EuiButton,{type:"submit",size:"s",fill:!0,onClick:E,disabled:w},r.a.createElement(h.FormattedMessage,{id:"xpack.infra.waffle.customMetrics.submitLabel",defaultMessage:"Save"})))))}));var v=a(75);const x=({onClose:e,onChange:t,metric:a,options:s,customMetrics:l})=>{const o=g.d.is(a)&&a.id?a.id:a.type,c=Object(n.useCallback)((a=>{if(v.f.is(a))t({type:a});else{const e=l.find((e=>e.id===a));e&&t(e)}e()}),[l,t,e]),u=[{id:0,title:"",items:[...s.map((e=>{const t=e.value===o?"check":"empty";return{name:e.text,onClick:()=>c(e.value),icon:t}})),...l.map((e=>{const t=e.id===o?"check":"empty";return{name:Object(p.a)(e),onClick:()=>c(e.id),icon:t}}))]}];return r.a.createElement(i.EuiContextMenu,{initialPanelId:0,panels:u})},k=Object(o.withTheme)((({onSave:e,onEditCancel:t,onEdit:a,onAdd:n,mode:s,customMetrics:o,theme:c})=>["editMetric","addMetric"].includes(s)?null:r.a.createElement("div",{style:{borderTop:`${null==c?void 0:c.eui.euiBorderWidthThin} solid ${null==c?void 0:c.eui.euiBorderColor}`,padding:12}},r.a.createElement(i.EuiFlexGroup,{justifyContent:"spaceBetween"},"edit"===s?r.a.createElement(r.a.Fragment,null,r.a.createElement(i.EuiFlexItem,{grow:!1},r.a.createElement(i.EuiButtonEmpty,{size:"s",flush:"left",onClick:t,"aria-label":l.i18n.translate("xpack.infra.waffle.customMetrics.modeSwitcher.cancelAriaLabel",{defaultMessage:"Cancel edit mode"})},r.a.createElement(h.FormattedMessage,{id:"xpack.infra.waffle.customMetrics.modeSwitcher.cancel",defaultMessage:"Cancel"}))),r.a.createElement(i.EuiFlexItem,{grow:!1},r.a.createElement(i.EuiButton,{onClick:e,size:"s",fill:!0,"aria-label":l.i18n.translate("xpack.infra.waffle.customMetrics.modeSwitcher.saveButtonAriaLabel",{defaultMessage:"Save changes to custom metrics"})},r.a.createElement(h.FormattedMessage,{id:"xpack.infra.waffle.customMetrics.modeSwitcher.saveButton",defaultMessage:"Save"})))):r.a.createElement(r.a.Fragment,null,r.a.createElement(i.EuiFlexItem,{grow:!1},r.a.createElement(i.EuiButtonEmpty,{size:"s",flush:"left",onClick:a,disabled:0===o.length,"aria-label":l.i18n.translate("xpack.infra.waffle.customMetrics.modeSwitcher.editAriaLabel",{defaultMessage:"Edit custom metrics"})},r.a.createElement(h.FormattedMessage,{id:"xpack.infra.waffle.customMetrics.modeSwitcher.edit",defaultMessage:"Edit"}))),r.a.createElement(i.EuiFlexItem,{grow:!1},r.a.createElement(i.EuiButtonEmpty,{onClick:n,size:"s",flush:"right","aria-label":l.i18n.translate("xpack.infra.waffle.customMetrics.modeSwitcher.addMetricAriaLabel",{defaultMessage:"Add custom metric"})},r.a.createElement(h.FormattedMessage,{id:"xpack.infra.waffle.customMetrics.modeSwitcher.addMetric",defaultMessage:"Add metric"})))))))),M=Object(o.withTheme)((({theme:e,customMetrics:t,options:a,onEdit:n,onDelete:s})=>r.a.createElement("div",{style:{width:256}},a.map((t=>r.a.createElement("div",{key:t.value,style:{padding:"14px 14px 13px 36px"}},r.a.createElement("span",{style:{color:null==e?void 0:e.eui.euiButtonColorDisabled}},t.text)))),t.map((e=>r.a.createElement(i.EuiFlexGroup,{key:e.id,alignItems:"center",gutterSize:"none",style:{padding:"10px 0px 9px"}},r.a.createElement(i.EuiFlexItem,{grow:!1,style:{width:36}},r.a.createElement(i.EuiButtonIcon,{iconType:"pencil",onClick:()=>n(e),"aria-label":l.i18n.translate("xpack.infra.waffle.customMetrics.editMode.editButtonAriaLabel",{defaultMessage:"Edit custom metric for {name}",values:{name:Object(p.a)(e)}})})),r.a.createElement(i.EuiFlexItem,{grow:1,style:{overflow:"hidden"}},Object(p.a)(e)),r.a.createElement(i.EuiFlexItem,{grow:!1,style:{width:36,textAlign:"right"}},r.a.createElement(i.EuiButtonIcon,{iconType:"trash",color:"danger",onClick:()=>s(e),"aria-label":l.i18n.translate("xpack.infra.waffle.customMetrics.editMode.deleteAriaLabel",{defaultMessage:"Delete custom metric for {name}",values:{name:Object(p.a)(e)}})})))))))),O=({fields:e,onChange:t,onChangeCustomMetrics:a,metric:s,options:o,customMetrics:u})=>{var d;const[m,f]=Object(n.useState)(!1),[b,h]=Object(n.useState)("pick"),[y,v]=Object(n.useState)([]),[O,w]=Object(n.useState)(),j=Object(n.useCallback)((()=>{f(!1)}),[f]),S=Object(n.useCallback)((()=>{f(!m)}),[m]),C=Object(n.useCallback)((e=>{a([...u,e]),t(e),h("pick")}),[u,t,a,h]),T=Object(n.useCallback)((()=>{h("edit"),v(u)}),[u]),L=Object(n.useCallback)((()=>{h("addMetric")}),[h]),F=Object(n.useCallback)((()=>{h("pick"),v([])}),[h]),P=Object(n.useCallback)((e=>{g.d.is(s)&&e.id===s.id&&t({type:o[0].value});const a=y.filter((t=>t.id!==e.id));v(a)}),[y,s,t,o]),I=Object(n.useCallback)((e=>{const t=u.map((t=>t.id===e.id&&e||t));a(t),F(),w(void 0),v([])}),[u,a,F]),D=Object(n.useCallback)((e=>{w(e),h("editMetric")}),[h,w]),_=Object(n.useCallback)((()=>{a(y),h("pick")}),[y,a]);if(!o.length||!s.type)throw Error(l.i18n.translate("xpack.infra.waffle.unableToSelectMetricErrorTitle",{defaultMessage:"Unable to select options or value for metric."}));const B=g.d.is(s)&&s.id?s.id:s.type,R=g.d.is(s)?Object(p.a)(s):null===(d=o.find((e=>e.value===B)))||void 0===d?void 0:d.text;if(!R)return null;const A=r.a.createElement(c.a,{onClick:S,label:l.i18n.translate("xpack.infra.waffle.metriclabel",{defaultMessage:"Metric"})},R);return r.a.createElement(r.a.Fragment,null,r.a.createElement(i.EuiPopover,{isOpen:m,id:"metricsPanel",button:A,anchorPosition:"downLeft",panelPaddingSize:"none",closePopover:j},"pick"===b?r.a.createElement(x,{onChange:t,onClose:j,metric:s,customMetrics:u,options:o}):null,"addMetric"===b?r.a.createElement(E,{fields:e,customMetrics:u,onChange:C,onCancel:F}):null,"editMetric"===b?r.a.createElement(E,{metric:O,fields:e,customMetrics:u,onChange:I,onCancel:T}):null,"edit"===b?r.a.createElement(M,{customMetrics:y,options:o,onEdit:D,onDelete:P}):null,r.a.createElement(k,{onEditCancel:F,onEdit:T,onAdd:L,mode:b,onSave:_,customMetrics:u})))};var w=a(6),j=a.n(w);const S={selectedOptions:[]};class custom_field_panel_CustomFieldPanel extends r.a.PureComponent{constructor(...e){super(...e),j()(this,"state",S),j()(this,"handleSubmit",(()=>{this.props.onSubmit(this.state.selectedOptions[0].label)})),j()(this,"handleFieldSelection",(e=>{this.setState({selectedOptions:e})}))}render(){const{fields:e,currentOptions:t}=this.props,a=e.filter((e=>e.aggregatable&&"string"===e.type&&!(t&&t.some((t=>t.field===e.name))))).map((e=>({label:e.name}))),n=!this.state.selectedOptions.length;return r.a.createElement("div",{style:{padding:16}},r.a.createElement(i.EuiForm,null,r.a.createElement(i.EuiFormRow,{label:l.i18n.translate("xpack.infra.waffle.customGroupByFieldLabel",{defaultMessage:"Field"}),helpText:l.i18n.translate("xpack.infra.waffle.customGroupByHelpText",{defaultMessage:"This is the field used for the terms aggregation"}),display:"rowCompressed",fullWidth:!0},r.a.createElement(i.EuiComboBox,{"data-test-subj":"groupByCustomField",placeholder:l.i18n.translate("xpack.infra.waffle.customGroupByDropdownPlacehoder",{defaultMessage:"Select one"}),singleSelection:{asPlainText:!0},selectedOptions:this.state.selectedOptions,options:a,onChange:this.handleFieldSelection,fullWidth:!0,isClearable:!1})),r.a.createElement(i.EuiButton,{"data-test-subj":"groupByCustomFieldAddButton",disabled:n,type:"submit",size:"s",fill:!0,onClick:this.handleSubmit},"Add")))}}j()(custom_field_panel_CustomFieldPanel,"displayName","CustomFieldPanel");const C={isPopoverOpen:!1};class waffle_group_by_controls_WaffleGroupByControls extends r.a.PureComponent{constructor(...e){super(...e),j()(this,"state",C),j()(this,"handleRemove",(e=>()=>{const{groupBy:t}=this.props;this.props.onChange(t.filter((t=>t.field!==e)));const a=this.props.customOptions.filter((t=>t.field!==e));this.props.onChangeCustomOptions(a),setTimeout((()=>this.handleClose()))})),j()(this,"handleClose",(()=>{this.setState({isPopoverOpen:!1})})),j()(this,"handleToggle",(()=>{this.setState((e=>({isPopoverOpen:!e.isPopoverOpen})))})),j()(this,"handleCustomField",(e=>{const t=[...this.props.customOptions,{text:e,field:e}];this.props.onChangeCustomOptions(t),this.handleClick(e)()})),j()(this,"handleClick",(e=>()=>{const{groupBy:t}=this.props;t.some((t=>t.field===e))?this.handleRemove(e)():this.props.groupBy.length<2&&this.props.onChange([...t,{field:e}]),this.handleClose()}))}render(){const{nodeType:e,groupBy:t}=this.props,a=this.props.customOptions.map((e=>({...e,toolTipContent:e.text}))),n=this.props.options.concat(a);if(!n.length)throw Error(l.i18n.translate("xpack.infra.waffle.unableToSelectGroupErrorMessage",{defaultMessage:"Unable to select group by options for {nodeType}",values:{nodeType:e}}));const s=t.length>=2,o=l.i18n.translate("xpack.infra.waffle.maxGroupByTooltip",{defaultMessage:"Only two groupings can be selected at a time"}),u=[{id:"firstPanel",title:l.i18n.translate("xpack.infra.waffle.selectTwoGroupingsTitle",{defaultMessage:"Select up to two groupings"}),items:[{name:l.i18n.translate("xpack.infra.waffle.customGroupByOptionName",{defaultMessage:"Custom field"}),disabled:s,toolTipContent:s?o:null,icon:"empty",panel:"customPanel"},...n.map((e=>{const a=t.some((t=>t.field===e.field))?"check":"empty",n={name:e.text,onClick:this.handleClick(e.field),icon:a};return e.toolTipContent&&(n.toolTipContent=e.toolTipContent),s&&"empty"===a&&(n.toolTipContent=o,n.disabled=!0),n}))]},{id:"customPanel",title:l.i18n.translate("xpack.infra.waffle.customGroupByPanelTitle",{defaultMessage:"Group By Custom Field"}),width:685,content:r.a.createElement(custom_field_panel_CustomFieldPanel,{currentOptions:this.props.customOptions,onSubmit:this.handleCustomField,fields:this.props.fields})}],d=t.length>0?t.map((e=>n.find((t=>t.field===e.field)))).filter((e=>null!=e)).map((e=>r.a.createElement(i.EuiBadge,{color:"hollow",key:e&&e.field},e&&e.text))):r.a.createElement(h.FormattedMessage,{id:"xpack.infra.waffle.groupByAllTitle",defaultMessage:"All"}),m=r.a.createElement(c.a,{label:l.i18n.translate("xpack.infra.waffle.groupByLabel",{defaultMessage:"Group by"}),onClick:this.handleToggle,"data-test-subj":"waffleGroupByDropdown"},d);return r.a.createElement(i.EuiPopover,{isOpen:this.state.isPopoverOpen,id:"groupByPanel",button:m,panelPaddingSize:"none",closePopover:this.handleClose},r.a.createElement(T,{initialPanelId:"firstPanel",panels:u,"data-test-subj":"groupByContextMenu"}))}}j()(waffle_group_by_controls_WaffleGroupByControls,"displayName","WaffleGroupByControls");const T=Object(o.euiStyled)(i.EuiContextMenu)`
  width: 320px;
  & .euiContextMenuItem__text {
    overflow: hidden;
    text-overflow: ellipsis;
  }
`;var L=a(158);const F=e=>{const t=Object(n.useMemo)((()=>e.metricTypes.map(s.a).filter((e=>e))),[e.metricTypes]),a=Object(n.useMemo)((()=>e.groupByFields.map(L.b)),[e.groupByFields]);return r.a.createElement(r.a.Fragment,null,r.a.createElement(i.EuiFlexItem,{grow:!1},r.a.createElement(O,{fields:e.createDerivedIndexPattern().fields,options:t,metric:e.metric,onChange:e.changeMetric,onChangeCustomMetrics:e.changeCustomMetrics,customMetrics:e.customMetrics})),r.a.createElement(i.EuiFlexItem,{grow:!1},r.a.createElement(waffle_group_by_controls_WaffleGroupByControls,{options:a,groupBy:e.groupBy,nodeType:e.nodeType,onChange:e.changeGroupBy,fields:e.createDerivedIndexPattern().fields,onChangeCustomOptions:e.changeCustomOptions,customOptions:e.customOptions})),"map"===e.view&&r.a.createElement(i.EuiFlexItem,{grow:!1},r.a.createElement(d,{sort:e.sort,onChange:e.changeSort})))}},80:function(e,t,a){"use strict";a.d(t,"a",(function(){return l}));var n=a(12),r=a(2),i=a.n(r),s=a(15);const l=Object(s.withTheme)((e=>{const{onClick:t,label:a,theme:r,children:s}=e;return i.a.createElement(n.EuiFlexGroup,{alignItems:"center",gutterSize:"none",style:{border:null==r?void 0:r.eui.euiFormInputGroupBorder,boxShadow:`0px 3px 2px ${null==r?void 0:r.eui.euiTableActionsBorderColor}, 0px 1px 1px ${null==r?void 0:r.eui.euiTableActionsBorderColor}`}},i.a.createElement(n.EuiFlexItem,{grow:!1,style:{padding:12,background:null==r?void 0:r.eui.euiFormInputGroupLabelBackground,fontSize:"0.75em",fontWeight:600,color:null==r?void 0:r.eui.euiTitleColor}},a),i.a.createElement(n.EuiFlexItem,{grow:!1},i.a.createElement(n.EuiButtonEmpty,{"data-test-subj":e["data-test-subj"],color:"text",iconType:"arrowDown",onClick:t,iconSide:"right",size:"xs"},s)))}))},87:function(e,t,a){"use strict";a.d(t,"a",(function(){return r}));var n=a(1);const r=e=>{const t={avg:n.i18n.translate("xpack.infra.waffle.aggregationNames.avg",{defaultMessage:"Avg of {field}",values:{field:e.field}}),max:n.i18n.translate("xpack.infra.waffle.aggregationNames.max",{defaultMessage:"Max of {field}",values:{field:e.field}}),min:n.i18n.translate("xpack.infra.waffle.aggregationNames.min",{defaultMessage:"Min of {field}",values:{field:e.field}}),rate:n.i18n.translate("xpack.infra.waffle.aggregationNames.rate",{defaultMessage:"Rate of {field}",values:{field:e.field}})};return e.label?e.label:t[e.aggregation]}},93:function(e,t,a){"use strict";a.d(t,"a",(function(){return u}));var n=a(2),r=a.n(n),i=a(12),s=a(1),l=a(80);const o=e=>{const{accountId:t,options:a}=e,[o,c]=Object(n.useState)(!1),u=Object(n.useCallback)((()=>{c(!0)}),[c]),d=Object(n.useCallback)((()=>{c(!1)}),[c]),m=a.find((e=>e.value===t)),p=Object(n.useCallback)((a=>{t===a?e.changeAccount(""):e.changeAccount(a),d()}),[t,d,e]),g=Object(n.useMemo)((()=>[{id:0,title:"",items:a.map((e=>{const a=e.value===t?"check":"empty";return{name:e.name,onClick:()=>p(e.value),icon:a}}))}]),[a,t,p]),f=r.a.createElement(l.a,{label:s.i18n.translate("xpack.infra.waffle.accountLabel",{defaultMessage:"Account"}),onClick:u},m?m.name:s.i18n.translate("xpack.infra.waffle.accountAllTitle",{defaultMessage:"All"}));return r.a.createElement(i.EuiPopover,{isOpen:o,id:"accontPopOver",button:f,anchorPosition:"downLeft",panelPaddingSize:"none",closePopover:d},r.a.createElement(i.EuiContextMenu,{initialPanelId:0,panels:g}))},c=e=>{const{region:t,options:a}=e,[o,c]=Object(n.useState)(!1),u=Object(n.useCallback)((()=>{c(!0)}),[c]),d=Object(n.useCallback)((()=>{c(!1)}),[c]),m=a.find((e=>t===e)),p=Object(n.useCallback)((a=>{t===a?e.changeRegion(""):e.changeRegion(a),d()}),[t,d,e]),g=Object(n.useMemo)((()=>[{id:0,title:"",items:a.map((e=>({name:e,onClick:()=>p(e),icon:e===t?"check":"empty"})))}]),[p,a,t]),f=r.a.createElement(l.a,{onClick:u,label:s.i18n.translate("xpack.infra.waffle.regionLabel",{defaultMessage:"Region"})},m||s.i18n.translate("xpack.infra.waffle.region",{defaultMessage:"All"}));return r.a.createElement(i.EuiPopover,{isOpen:o,id:"regionPanel",button:f,anchorPosition:"downLeft",panelPaddingSize:"none",closePopover:d},r.a.createElement(i.EuiContextMenu,{initialPanelId:0,panels:g}))},u=e=>r.a.createElement(r.a.Fragment,null,e.accounts.length>0&&r.a.createElement(i.EuiFlexItem,{grow:!1},r.a.createElement(o,{changeAccount:e.changeAccount,accountId:e.accountId,options:e.accounts})),e.regions.length>0&&r.a.createElement(i.EuiFlexItem,{grow:!1},r.a.createElement(c,{changeRegion:e.changeRegion,region:e.region,options:e.regions})))}}]);