"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isLatestFindingsIndexExists = void 0;

var _constants = require("../../common/constants");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const isLatestFindingsIndexExists = async (esClient, logger) => {
  try {
    const queryResult = await esClient.search({
      index: _constants.LATEST_FINDINGS_INDEX_DEFAULT_NS,
      query: {
        match_all: {}
      },
      size: 1
    });
    return !!queryResult.hits.hits.length;
  } catch (e) {
    logger.error(e.message);
    return false;
  }
};

exports.isLatestFindingsIndexExists = isLatestFindingsIndexExists;